/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestScopeSuperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.AuthZGroupBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.AuthZGroupCollectionBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ErrorBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.RoleBean;

public class MultiRealmEditBean {
    String pageName = null;
    String localSpace = null;
    HttpServletRequest request = null;
    private RequestScopeSuperBean rsac = null;
    private static final String[] permissionNames = new String[]{"Create", "Read", "Edit", "Delete", "Admin", "Super Admin"};
    private static final int PERM_CREATE = 0;
    private static final int PERM_ADMIN = 4;
    private static final int PERM_DELETE = 3;
    private static final int PERM_READ = 1;
    private static final int PERM_SUPERADMIN = 5;
    private static final int PERM_UPDATE = 2;

    public String getLocalSpace() {
        return this.localSpace;
    }

    public String getSakaiHTMLHead() {
        return (String)this.request.getAttribute("sakai.html.head");
    }

    public String getBodyOnLoad() {
        return "onload=\"" + this.request.getAttribute("sakai.html.body.onload") + "; parent.updCourier(doubleDeep,ignoreCourier); callAllLoaders(); \"";
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getErrors(String wrapperFormat, String itemFormat) {
        ErrorBean eb = this.rsac.getErrorBean();
        List errors = eb.getErrors();
        StringBuffer sb = new StringBuffer();
        if (errors.size() > 0) {
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                sb.append(MessageFormat.format(itemFormat, i.next()));
            }
            return MessageFormat.format(wrapperFormat, sb.toString());
        }
        return "";
    }

    public String getPermissionNames(String nameFormat) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < permissionNames.length; ++i) {
            sb.append(MessageFormat.format(nameFormat, permissionNames[i]));
        }
        return sb.toString();
    }

    public String getPermissionsControl(AuthZGroupBean azbg, RoleBean rb, int perm, String permissionEditOnFormat, String permissionEditOffFormat) {
        String fieldName = null;
        String format = null;
        switch (perm) {
            case 0: {
                fieldName = "create_" + azbg.getEscapedId() + "_" + rb.getId();
                format = rb.isSecureCreate() ? permissionEditOffFormat : permissionEditOnFormat;
                break;
            }
            case 4: {
                fieldName = "create_" + azbg.getEscapedId() + "_" + rb.getId();
                format = rb.isSecureAdmin() ? permissionEditOffFormat : permissionEditOnFormat;
                break;
            }
            case 3: {
                fieldName = "create_" + azbg.getEscapedId() + "_" + rb.getId();
                format = rb.isSecureDelete() ? permissionEditOffFormat : permissionEditOnFormat;
                break;
            }
            case 1: {
                fieldName = "create_" + azbg.getEscapedId() + "_" + rb.getId();
                format = rb.isSecureRead() ? permissionEditOffFormat : permissionEditOnFormat;
                break;
            }
            case 5: {
                fieldName = "create_" + azbg.getEscapedId() + "_" + rb.getId();
                format = rb.isSecureSuperAdmin() ? permissionEditOffFormat : permissionEditOnFormat;
                break;
            }
            case 2: {
                fieldName = "create_" + azbg.getEscapedId() + "_" + rb.getId();
                format = rb.isSecureUpdate() ? permissionEditOffFormat : permissionEditOnFormat;
                break;
            }
            default: {
                fieldName = String.valueOf(perm);
                format = "Undefiend field with index {0} ";
            }
        }
        return MessageFormat.format(format, fieldName);
    }

    public String getPermissionsGroupRoles(String permissionsRealmWrapperFormat, String permissionNamesFormat, String groupWrapperFormat, String permissionEditOnFormat, String permissionEditOffFormat) {
        String permissionNamesHtml = this.getPermissionNames(permissionNamesFormat);
        AuthZGroupCollectionBean realmCollectionBean = this.rsac.getAuthZGroupCollectionBean();
        List realms = realmCollectionBean.getRealms();
        StringBuffer output = new StringBuffer();
        for (AuthZGroupBean azgb : realms) {
            List roles = azgb.getRoles();
            if (roles.size() <= 0) continue;
            StringBuffer rolesOutput = new StringBuffer();
            for (RoleBean rb : roles) {
                StringBuffer permissionsOutput = new StringBuffer();
                for (int j = 0; j < permissionNames.length; ++j) {
                    permissionsOutput.append(this.getPermissionsControl(azgb, rb, j, permissionEditOnFormat, permissionEditOffFormat));
                }
                rolesOutput.append(MessageFormat.format(groupWrapperFormat, rb.getId(), permissionsOutput.toString()));
            }
            output.append(MessageFormat.format(permissionsRealmWrapperFormat, azgb.getRealmId(), permissionNamesHtml, rolesOutput.toString()));
            break;
        }
        return output.toString();
    }

    public String getAvailableRealms(String rolesFormat) {
        AuthZGroupBean azgb;
        List roles;
        AuthZGroupCollectionBean realmCollectionBean = this.rsac.getAuthZGroupCollectionBean();
        List realms = realmCollectionBean.getRealms();
        StringBuffer output = new StringBuffer();
        Iterator i = realms.iterator();
        while (i.hasNext() && (roles = (azgb = (AuthZGroupBean)i.next()).getRoles()).size() == 0) {
            output.append(MessageFormat.format(rolesFormat, azgb.getRealmId()));
        }
        return output.toString();
    }

    public String getFooterScript() {
        return "<script type=\"text/javascript\" >" + this.request.getAttribute("footerScript") + "</script>";
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public RequestScopeSuperBean getRsac() {
        return this.rsac;
    }

    public void setRequestScopeSuperBean(RequestScopeSuperBean rsac) {
        this.rsac = rsac;
    }

    public void setLocalSpace(String localSpace) {
        this.localSpace = localSpace;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }
}

