/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import uk.ac.cam.caret.sakai.rwiki.tool.util.WikiPageAction;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewBean {
    public static final String PANEL_PARAM = "panel";
    public static final String MAIN_PANEL = "Main";
    public static final String ACTION_PARAM = "action";
    public static final String PAGE_NAME_PARAM = "pageName";
    public static final String PARAM_BREADCRUMB_NAME = "breadcrumb";
    protected static final String PAGENAME_URL_ENCODED = ViewBean.urlEncode((String)"pageName");
    protected static final String DISBLE_BREADCRUMBS_ENCODED = ViewBean.urlEncode((String)"breadcrumb") + "=0";
    protected static final String ACTION_URL_ENCODED = ViewBean.urlEncode((String)"action");
    protected static final String PANEL_URL_ENCODED = ViewBean.urlEncode((String)"panel");
    protected static final String MAIN_URL_ENCODED = ViewBean.urlEncode((String)"Main");
    protected static final String SEARCH_URL_ENCODED = ViewBean.urlEncode((String)"search");
    protected static final String PAGE_URL_ENCODED = ViewBean.urlEncode((String)"page");
    protected static final String REALM_URL_ENCODED = ViewBean.urlEncode((String)"realm");
    private String pageName;
    private String localSpace;
    private String anchor;
    private String search;

    public ViewBean() {
    }

    public ViewBean(String name, String defaultSpace) {
        this.pageName = NameHelper.globaliseName((String)name, (String)defaultSpace);
        this.localSpace = defaultSpace;
    }

    private String getAnchorString() {
        if (this.anchor != null) {
            return "#" + ViewBean.urlEncode((String)this.anchor);
        }
        return "";
    }

    public String getExportUrl() {
        return this.getPageUrl(this.pageName, WikiPageAction.EXPORT_ACTION.getName());
    }

    public String getPublicViewUrl() {
        return this.getPublicViewUrl(false);
    }

    public String getPublicViewUrl(boolean withBreadcrumbs) {
        return this.getPageUrl(this.pageName, WikiPageAction.PUBLICVIEW_ACTION.getName(), withBreadcrumbs);
    }

    public String getViewUrl() {
        return this.getPageUrl(this.pageName, WikiPageAction.VIEW_ACTION.getName());
    }

    public String getViewUrl(String name) {
        return this.getPageUrl(NameHelper.globaliseName((String)name, (String)this.localSpace), WikiPageAction.VIEW_ACTION.getName());
    }

    public String getEditUrl() {
        return this.getPageUrl(this.pageName, WikiPageAction.EDIT_ACTION.getName());
    }

    public String getEditUrl(String name) {
        return this.getPageUrl(NameHelper.globaliseName((String)name, (String)this.localSpace), WikiPageAction.EDIT_ACTION.getName());
    }

    public String getInfoUrl() {
        return this.getPageUrl(this.pageName, WikiPageAction.INFO_ACTION.getName());
    }

    public String getInfoUrl(String name) {
        return this.getPageUrl(NameHelper.globaliseName((String)name, (String)this.localSpace), WikiPageAction.INFO_ACTION.getName());
    }

    public String getHistoryUrl() {
        return this.getHistoryUrl(this.pageName);
    }

    public String getHistoryUrl(String name) {
        return this.getPageUrl(NameHelper.globaliseName((String)name, (String)this.localSpace), WikiPageAction.HISTORY_ACTION.getName());
    }

    public String getActionUrl(WikiPageAction action) {
        return this.getActionUrl(action, true);
    }

    public String getActionUrl(WikiPageAction action, boolean breadcrumbs) {
        return this.getPageUrl(this.pageName, action.getName(), breadcrumbs);
    }

    public String getActionUrl(String pageName, WikiPageAction action, boolean breadcrumbs) {
        return this.getPageUrl(pageName, action.getName(), breadcrumbs);
    }

    public String getActionUrl(WikiPageAction action, Map parameters) {
        return this.getPageUrl(this.pageName, action.getName(), parameters);
    }

    public String getActionUrl(String pageName, WikiPageAction action, Map parameters) {
        return this.getPageUrl(pageName, action.getName(), parameters);
    }

    protected String getPageUrl(String pageName, String action) {
        return this.getPageUrl(pageName, action, true);
    }

    protected String getPageUrl(String pageName, String action, boolean withBreadcrumbs) {
        if (withBreadcrumbs) {
            return "?" + PAGENAME_URL_ENCODED + "=" + ViewBean.urlEncode((String)pageName) + "&" + ACTION_URL_ENCODED + "=" + ViewBean.urlEncode((String)action) + "&" + PANEL_URL_ENCODED + "=" + MAIN_URL_ENCODED + "&" + REALM_URL_ENCODED + "=" + ViewBean.urlEncode((String)this.localSpace) + this.getAnchorString();
        }
        return "?" + PAGENAME_URL_ENCODED + "=" + ViewBean.urlEncode((String)pageName) + "&" + ACTION_URL_ENCODED + "=" + ViewBean.urlEncode((String)action) + "&" + PANEL_URL_ENCODED + "=" + MAIN_URL_ENCODED + "&" + DISBLE_BREADCRUMBS_ENCODED + "&" + REALM_URL_ENCODED + "=" + ViewBean.urlEncode((String)this.localSpace) + this.getAnchorString();
    }

    protected String getPageUrl(String pageName, String action, Map params) {
        StringBuffer url = new StringBuffer();
        url.append("?").append(PAGENAME_URL_ENCODED).append('=').append(ViewBean.urlEncode((String)pageName));
        url.append('&').append(ACTION_URL_ENCODED).append('=').append(ViewBean.urlEncode((String)action));
        url.append('&').append(PANEL_URL_ENCODED).append('=').append(MAIN_URL_ENCODED);
        url.append('&').append(REALM_URL_ENCODED).append('=').append(ViewBean.urlEncode((String)this.localSpace));
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("pageName".equals(key) || "action".equals(key) || "panel".equals(key) || "realm".equals(key)) continue;
            url.append('&').append(ViewBean.urlEncode((String)key)).append('=').append(ViewBean.urlEncode((String)value));
        }
        return url.append(this.getAnchorString()).toString();
    }

    protected String getSearchUrl() {
        return "?" + ACTION_URL_ENCODED + "=" + SEARCH_URL_ENCODED + "&" + SEARCH_URL_ENCODED + "=" + ViewBean.urlEncode((String)this.search) + "&" + REALM_URL_ENCODED + "=" + ViewBean.urlEncode((String)this.localSpace) + "&" + PANEL_URL_ENCODED + "=" + MAIN_URL_ENCODED;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getLocalName() {
        return NameHelper.localizeName((String)this.pageName, (String)this.localSpace);
    }

    public String getLocalSpace() {
        return this.localSpace;
    }

    public void setLocalSpace(String localSpace) {
        this.localSpace = localSpace;
    }

    public String getPageSpace() {
        return NameHelper.localizeSpace((String)this.pageName, (String)this.localSpace);
    }

    public static String urlEncode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not entirely sure how this happened but UTF-8 doesn't represent a valid encoding anymore! Weird!", e);
        }
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getNewCommentURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.NEWCOMMENT_ACTION.getName());
    }

    public String getEditCommentURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.EDITCOMMENT_ACTION.getName());
    }

    public String getListCommentsURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.LISTCOMMENT_ACTION.getName());
    }

    public String getListPresenceURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.LISTPRESENCE_ACTION.getName());
    }

    public String getOpenPageChatURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.OPENPAGECHAT_ACTION.getName());
    }

    public String getOpenSpaceChatURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.OPENSPACECHAT_ACTION.getName());
    }

    public String getListPageChatURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.LISTPAGECHAT_ACTION.getName());
    }

    public String getListSpaceChatURL() {
        return this.getPageUrl(this.pageName, WikiPageAction.LISTSPACECHAT_ACTION.getName());
    }

    public String getBaseAccessUrl() {
        return "/wiki" + this.pageName + ".";
    }

    public String getRssAccessUrl() {
        return "/wiki" + this.getPageSpace() + "/.20.rss";
    }

    public String getPreferencesUrl() {
        return this.getPageUrl(this.getPageName(), WikiPageAction.PREFERENCES_ACTION.getName());
    }

    public String getPrintViewUrl() {
        return this.getPrintViewUrl(false);
    }

    public String getPrintViewUrl(boolean withBreadcrumbs) {
        return this.getPageUrl(this.pageName, WikiPageAction.PRINTVIEW_ACTION.getName(), withBreadcrumbs);
    }
}

