/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean.helper;

import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.site.api.SiteService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.AuthZGroupBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ErrorBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ResourceLoaderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ResourceLoaderHelperBean;

public class AuthZGroupBeanHelper {
    public static AuthZGroupBean createRealmBean(AuthzGroupService realmService, SiteService siteService, RWikiObject rwikiObject, ErrorBean errorBean, ViewBean vb, String siteId) {
        AuthZGroupBean rb = new AuthZGroupBean(vb.getPageName(), vb.getLocalSpace());
        String realmId = rwikiObject.getRealm();
        rb.setRealmId(realmId);
        try {
            AuthzGroup realm = realmService.getAuthzGroup(realmId);
            rb.setCurrentRealm(realm);
        }
        catch (GroupNotDefinedException e) {
            ResourceLoaderBean rlb = ResourceLoaderHelperBean.getResourceLoaderBean();
            errorBean.addError(rlb.getString("auzgroup.groupnotdef1", "Realm") + ": " + realmId + rlb.getString("auzgroup.groupnotdef2", " is not recognised in the system."));
        }
        boolean update = realmService.allowUpdate(realmId);
        boolean siteUpdate = siteService.allowUpdateSite(siteId);
        rb.setSiteUpdateAllowed(update && siteUpdate);
        return rb;
    }
}

