/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.bean.helper;

import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import uk.ac.cam.caret.sakai.rwiki.service.api.RWikiSecurityService;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ToolConfigBean;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class ViewParamsHelperBean {
    private static final String SMALL_CHANGE_PARAM = "smallchange";
    private static final Object SMALL_CHANGE = "smallchange";
    public static final String SAVE_OK = "save-ok";
    public static final String SAVE_VERSION_EXCEPTION = "save-versionexcep";
    public static final String SAVE_CANCEL = "save-cancel";
    public static final String SAVE_PREVIEW = "save-preview";
    private static final String[] AUTOSAVE_REMOVE = new String[]{"save-ok", "save-cancel"};
    private static final String[] AUTOSAVE_NORECOVER = new String[]{"save-versionexcep", "save-preview"};
    private String globalName;
    private String localSpace;
    private String search;
    private String searchPage = "0";
    private ServletRequest request;
    private RWikiSecurityService securityService;
    private ToolConfigBean toolConfigBean;
    private String defaultRealm;
    private String content;
    private String submittedContent;
    private String submittedVersion;
    private String saveType;
    private String withBreadcrumbs;
    private String saveState = "";

    public void init() {
        String pageName = this.request.getParameter("pageName");
        this.localSpace = this.request.getParameter("realm");
        this.defaultRealm = this.securityService.getSiteReference();
        if (this.localSpace == null || "".equals(this.localSpace)) {
            this.localSpace = this.defaultRealm;
        }
        if (pageName == null || "".equals(pageName)) {
            pageName = this.toolConfigBean.getHomePage();
        }
        this.globalName = NameHelper.globaliseName((String)pageName, (String)this.localSpace);
        this.search = this.request.getParameter("search");
        this.searchPage = this.request.getParameter("page");
        this.content = this.request.getParameter("content");
        this.submittedContent = this.request.getParameter("submittedContent");
        this.submittedVersion = this.request.getParameter("version");
        this.saveType = this.getSaveTypeFromParameters(this.request.getParameterMap());
        String smallChange = this.request.getParameter(SMALL_CHANGE_PARAM);
        if (smallChange != null && smallChange.equals(SMALL_CHANGE)) {
            ThreadLocalManager.set((String)"wiki.smallchange.request", (Object)"wiki.smallchange.request");
        }
        if (this.saveType != null) {
            this.saveType = this.saveType.toLowerCase();
        }
        this.withBreadcrumbs = "0".equals(this.request.getParameter("breadcrumb")) ? "0" : "1";
    }

    public String getSaveTypeFromParameters(Map parameterMap) {
        Set entrySet = parameterMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Object value;
            Object key = entry.getKey();
            if (!String.valueOf(key).startsWith("command_") || (value = entry.getValue()) == null || String.valueOf(parameterMap.get(key)).trim().length() <= 0) continue;
            return String.valueOf(key).substring("command_".length());
        }
        return null;
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public void setGlobalName(String globalName) {
        this.globalName = globalName;
    }

    public String getLocalSpace() {
        return this.localSpace;
    }

    public void setLocalSpace(String localSpace) {
        this.localSpace = localSpace;
    }

    public String getPageSpace() {
        return NameHelper.localizeSpace((String)this.globalName, (String)this.localSpace);
    }

    public String getLocalName() {
        return NameHelper.localizeName((String)this.globalName, (String)this.localSpace);
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public ServletRequest getServletRequest() {
        return this.request;
    }

    public void setServletRequest(ServletRequest request) {
        this.request = request;
    }

    public RWikiSecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(RWikiSecurityService securityService) {
        this.securityService = securityService;
    }

    public String getDefaultRealm() {
        return this.defaultRealm;
    }

    public void setDefaultRealm(String defaultRealm) {
        this.defaultRealm = defaultRealm;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSubmittedContent() {
        return this.submittedContent;
    }

    public void setSubmittedContent(String submittedContent) {
        this.submittedContent = submittedContent;
    }

    public String getSubmittedVersion() {
        return this.submittedVersion;
    }

    public void setSubmittedVersion(String submittedVersion) {
        this.submittedVersion = submittedVersion;
    }

    public String getSaveType() {
        return this.saveType;
    }

    public void setSaveType(String saveType) {
        this.saveType = saveType != null ? saveType.toLowerCase() : null;
    }

    public String getWithBreadcrumbs() {
        return this.withBreadcrumbs;
    }

    public void setWithBreadcrumbs(String withBreadcrumbs) {
        this.withBreadcrumbs = withBreadcrumbs;
    }

    public String getSearchPage() {
        return this.searchPage;
    }

    public void setSearchPage(String searchPage) {
        this.searchPage = searchPage;
    }

    public ToolConfigBean getToolConfigBean() {
        return this.toolConfigBean;
    }

    public void setToolConfigBean(ToolConfigBean toolConfigBean) {
        this.toolConfigBean = toolConfigBean;
    }

    public boolean isRemoveAutoSave() {
        for (int i = 0; i < AUTOSAVE_REMOVE.length; ++i) {
            if (!AUTOSAVE_REMOVE[i].equals(this.saveState)) continue;
            return true;
        }
        return false;
    }

    public boolean isLoadAutoSave() {
        for (int i = 0; i < AUTOSAVE_NORECOVER.length; ++i) {
            if (!AUTOSAVE_NORECOVER[i].equals(this.saveState)) continue;
            return false;
        }
        return true;
    }

    public String getSaveState() {
        return this.saveState;
    }

    public void setSaveState(String saveState) {
        this.saveState = saveState;
    }
}

