/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.command;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ToolManager;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestScopeSuperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ErrorBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ResourceLoaderBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.helper.ViewParamsHelperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.command.Dispatcher;

public class AddAttachmentReturnCommand
implements HttpCommand {
    private static Log log = LogFactory.getLog(AddAttachmentReturnCommand.class);
    private static final String MULTIPLE_ATTACHMENT_HEADER_START = "";
    private static final String MULTIPLE_ATTACHMENT_HEADER_BODY = "";
    private static final String MULTIPLE_ATTACHMENT_HEADER_END = "";
    private static final String MULTIPLE_ATTACHMENT_ITEM = "\n ";
    private static final String MULTIPLE_ATTACHMENT_ITEMS_END = "\n";
    private SessionManager sessionManager;
    private Map wikiMarkupTemplates;
    private String editPath;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.sessionManager = (SessionManager)this.load(cm, SessionManager.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public void execute(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestScopeSuperBean rssb = RequestScopeSuperBean.getFromRequest((HttpServletRequest)request);
        ToolSession session = this.sessionManager.getCurrentToolSession();
        Map storedParameters = (Map)session.getAttribute("STORED_PARAMETERS");
        String content = this.retrieveString(storedParameters.get("content"));
        content = content.replaceAll("\r\n?", MULTIPLE_ATTACHMENT_ITEMS_END);
        String caretPosition = this.retrieveString(storedParameters.get("caretPosition"));
        String pageName = this.retrieveString(storedParameters.get("pageName"));
        List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
        if (session.getAttribute("sakaiproject.filepicker.cancel") == null && refs != null && refs.size() > 0) {
            content = this.generateNewContent(refs, content, caretPosition);
        } else {
            ErrorBean errorBean = rssb.getErrorBean();
            ResourceLoaderBean rlb = rssb.getResourceLoaderBean();
            errorBean.addError(rlb.getString("addattacheret.cancel_add_attach", "Cancelled add attachment"));
        }
        ViewParamsHelperBean vphb = rssb.getNameHelperBean();
        vphb.setContent(content);
        vphb.setGlobalName(pageName);
        vphb.setLocalSpace(this.retrieveString(storedParameters.get("realm")));
        vphb.setSaveType(vphb.getSaveTypeFromParameters(storedParameters));
        vphb.setWithBreadcrumbs(this.retrieveString(storedParameters.get("breadcrumb")));
        vphb.setSubmittedVersion(this.retrieveString(storedParameters.get("version")));
        vphb.setSubmittedContent(this.retrieveString(storedParameters.get("submittedContent")));
        session.removeAttribute("sakai.tool.helper.done.url");
        session.removeAttribute("sakaiproject.filepicker.cancel");
        session.removeAttribute("sakaiproject.filepicker.attachments");
        dispatcher.dispatch(this.editPath, request, response);
    }

    private String generateNewContent(List refs, String content, String caretPosition) {
        String[] caretPositions;
        char[] charContent = content.toCharArray();
        int startPos = charContent.length;
        int endPos = charContent.length;
        if (caretPosition == null) {
            caretPosition = "";
        }
        if ((caretPositions = caretPosition.split(":")).length > 0) {
            try {
                startPos = Integer.parseInt(caretPositions[0]);
            }
            catch (NumberFormatException e) {
                startPos = charContent.length;
            }
        }
        if (caretPositions.length > 1) {
            try {
                endPos = Integer.parseInt(caretPositions[1]);
            }
            catch (NumberFormatException e) {
                endPos = startPos;
            }
        } else {
            endPos = startPos;
        }
        if (startPos > charContent.length || startPos < 0) {
            startPos = charContent.length;
        }
        if (endPos > charContent.length || endPos < 0) {
            endPos = charContent.length;
        }
        if (endPos < startPos) {
            int temp = startPos;
            startPos = endPos;
            endPos = temp;
        }
        if (refs.size() > 1) {
            return this.multipleRefsContent(charContent, startPos, endPos, refs);
        }
        return this.singleRefContent(charContent, startPos, endPos, (Reference)refs.get(0));
    }

    private String retrieveString(Object fromMap) {
        if (fromMap == null) {
            return null;
        }
        if (fromMap instanceof String[]) {
            String[] array = (String[])fromMap;
            return array[0];
        }
        return fromMap.toString();
    }

    private String singleRefContent(char[] charContent, int startPos, int endPos, Reference ref) {
        ResourceProperties refProps = ref.getProperties();
        String contentType = refProps.getProperty(refProps.getNamePropContentType());
        String template = this.getTemplate(contentType);
        Object[] args = this.getTemplateArgs(ref);
        if (startPos != endPos) {
            args[2] = new String(charContent, startPos, endPos - startPos);
        }
        StringBuffer newContent = new StringBuffer(charContent.length + template.length());
        newContent.append(charContent, 0, startPos);
        new MessageFormat(template).format(args, newContent, (FieldPosition)null);
        if (endPos < charContent.length) {
            newContent.append(charContent, endPos, charContent.length - endPos);
        }
        return newContent.toString();
    }

    private String multipleRefsContent(char[] charContent, int startPos, int endPos, List refs) {
        StringBuffer newContent = new StringBuffer(charContent.length);
        newContent.append(charContent, 0, startPos);
        newContent.append("");
        if (startPos != endPos) {
            newContent.append(charContent, startPos, endPos - startPos);
        } else {
            newContent.append("");
        }
        newContent.append("");
        for (Reference ref : refs) {
            ResourceProperties refProps = ref.getProperties();
            String contentType = refProps.getProperty(refProps.getNamePropContentType());
            String template = this.getTemplate(contentType);
            Object[] args = this.getTemplateArgs(ref);
            newContent.append(MULTIPLE_ATTACHMENT_ITEM);
            new MessageFormat(template).format(args, newContent, (FieldPosition)null);
        }
        newContent.append(MULTIPLE_ATTACHMENT_ITEMS_END);
        if (endPos < charContent.length) {
            newContent.append(charContent, endPos, charContent.length - endPos);
        }
        return newContent.toString();
    }

    private Object[] getTemplateArgs(Reference ref) {
        ResourceProperties refProps = ref.getProperties();
        String name = refProps.getProperty(refProps.getNamePropDisplayName());
        String contentType = refProps.getProperty(refProps.getNamePropContentType());
        String referenceString = ref.getReference();
        String url = ref.getUrl();
        Object[] templateArguments = new Object[5];
        templateArguments[0] = url;
        templateArguments[2] = name;
        templateArguments[3] = contentType;
        templateArguments[4] = referenceString;
        String currentSiteId = ToolManager.getCurrentPlacement().getContext();
        if (referenceString.startsWith("/content/group/")) {
            url = referenceString.substring("/content/group/".length());
            url = url.startsWith(currentSiteId) ? "worksite:/" + url.substring(currentSiteId.length() + 1) : "sakai:/" + url;
        } else if (referenceString.startsWith("/content/group-user/")) {
            url = referenceString.substring("/content/group-user/".length());
            url = url.startsWith(currentSiteId) ? "dropbox:/" + url.substring(currentSiteId.length() + 1) : "sakai-dropbox:/" + url;
        } else if (referenceString.startsWith("/content/user/")) {
            url = referenceString.substring("/content/user/".length());
            if (url.startsWith("~")) {
                url = url.substring(1);
            }
            if (currentSiteId.startsWith("~")) {
                currentSiteId = currentSiteId.substring(1);
            }
            url = url.startsWith(currentSiteId) ? "worksite:/" + url.substring(currentSiteId.length() + 1) : "sakai:/~" + url;
        }
        templateArguments[1] = url;
        return templateArguments;
    }

    public String getTemplate(String contentType) {
        String key;
        if (this.wikiMarkupTemplates.containsKey(contentType)) {
            return (String)this.wikiMarkupTemplates.get(contentType);
        }
        int slash = contentType.indexOf(47);
        if (slash > -1 && this.wikiMarkupTemplates.containsKey(key = contentType.substring(0, slash) + "/*")) {
            return (String)this.wikiMarkupTemplates.get(key);
        }
        return (String)this.wikiMarkupTemplates.get("*/*");
    }

    public Map getWikiMarkupTemplates() {
        return this.wikiMarkupTemplates;
    }

    public void setWikiMarkupTemplates(Map wikiMarkupTemplates) {
        this.wikiMarkupTemplates = wikiMarkupTemplates;
    }

    public String getEditPath() {
        return this.editPath;
    }

    public void setEditPath(String editPath) {
        this.editPath = editPath;
    }
}

