/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.command;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.tool.cover.SessionManager;
import uk.ac.cam.caret.sakai.rwiki.service.message.api.PreferenceService;
import uk.ac.cam.caret.sakai.rwiki.tool.RequestScopeSuperBean;
import uk.ac.cam.caret.sakai.rwiki.tool.api.HttpCommand;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.EditBean;
import uk.ac.cam.caret.sakai.rwiki.tool.bean.ViewBean;
import uk.ac.cam.caret.sakai.rwiki.tool.command.Dispatcher;

public class UpdatePreferencesCommand
implements HttpCommand {
    private static Log log = LogFactory.getLog(UpdatePreferencesCommand.class);
    private PreferenceService preferenceService;
    private String successfulPath;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.preferenceService = (PreferenceService)this.load(cm, PreferenceService.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public void execute(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestScopeSuperBean rssb = RequestScopeSuperBean.getFromRequest((HttpServletRequest)request);
        ViewBean vb = rssb.getViewBean();
        EditBean eb = rssb.getEditBean();
        String userId = rssb.getCurrentUserId();
        String localSpace = vb.getLocalSpace();
        String notificationLevel = request.getParameter("notificationLevel");
        if (!("separate".equals(notificationLevel) || "digest".equals(notificationLevel) || "none".equals(notificationLevel))) {
            notificationLevel = "nopreference";
        }
        if ("save".equals(eb.getSaveType())) {
            if ("nopreference".equals(notificationLevel)) {
                this.preferenceService.deletePreference(userId, localSpace, "mail.notify");
            } else {
                this.preferenceService.updatePreference(userId, localSpace, "mail.notify", notificationLevel);
            }
        }
        this.successfulUpdateDispatch(dispatcher, request, response);
        String requestURL = request.getRequestURL().toString();
        SessionManager.getCurrentToolSession().setAttribute("uk.ac.cam.caret.sakai.rwiki.tool.RWikiServlet.last-request-url", (Object)(requestURL + vb.getInfoUrl()));
    }

    private void successfulUpdateDispatch(Dispatcher dispatcher, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        dispatcher.dispatch(this.successfulPath, request, response);
    }

    public String getSuccessfulPath() {
        return this.successfulPath;
    }

    public void setSuccessfulPath(String successfulPath) {
        this.successfulPath = successfulPath;
    }
}

