/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ResourceLoader;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.dao.RWikiCurrentObjectDao;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiCurrentObject;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.service.exception.PermissionException;
import uk.ac.cam.caret.sakai.rwiki.tool.api.PopulateService;
import uk.ac.cam.caret.sakai.rwiki.tool.service.impl.PopulateServiceImpl;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class PopulateServiceImpl
implements PopulateService {
    private static Log log = LogFactory.getLog(PopulateServiceImpl.class);
    private List seedPages;
    private RWikiCurrentObjectDao dao;
    private RenderService renderService = null;
    private SiteService siteService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.renderService = (RenderService)this.load(cm, RenderService.class.getName());
        this.siteService = (SiteService)this.load(cm, SiteService.class.getName());
        for (RWikiCurrentObject seed : this.seedPages) {
            if (seed.getSource().startsWith("bundle:")) {
                String[] source = seed.getSource().split(":");
                ResourceLoader rl = new ResourceLoader(source[1]);
                seed.setContent(rl.getString(source[2]));
                continue;
            }
            BufferedReader br = null;
            StringBuffer sb = new StringBuffer();
            try {
                br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(seed.getSource()), "UTF-8"));
                char[] c = new char[2048];
                int ic = br.read(c);
                while (ic >= 0) {
                    if (ic == 0) {
                        Thread.yield();
                    } else {
                        sb.append(c, 0, ic);
                    }
                    ic = br.read(c);
                }
            }
            finally {
                br.close();
            }
            seed.setContent(sb.toString());
        }
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public void populateRealm(String user, String space, String group) throws PermissionException {
        String owner = user;
        Site s = null;
        try {
            s = this.siteService.getSite(ToolManager.getCurrentPlacement().getContext());
            owner = s.getCreatedBy().getId();
        }
        catch (Exception e) {
            log.warn((Object)("Cant find who created this site, defaulting to current user for prepopulate ownership :" + owner));
        }
        if (s == null) {
            log.error((Object)"Cant Locate current site, will populate only global pages with no restrictions");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Populating space: " + space));
        }
        for (RWikiCurrentObject seed : this.seedPages) {
            List targetTypes = seed.getTargetSiteTypes();
            if (this.ignoreSeedPage(s, targetTypes)) {
                log.debug((Object)("Ignoring Seed page " + seed.getName()));
                continue;
            }
            String name = NameHelper.globaliseName((String)seed.getName(), (String)space);
            log.debug((Object)("Populating Space with " + seed.getName()));
            if (this.dao.findByGlobalName(name) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating Page: " + name));
                }
                log.debug((Object)("Creating Page :" + name));
                RWikiCurrentObject rwo = this.dao.createRWikiObject(name, space);
                seed.copyTo((RWikiObject)rwo);
                log.debug((Object)("Populate with Owner " + owner));
                rwo.setUser(owner);
                rwo.setOwner(owner);
                this.updateReferences(rwo, space);
                rwo.setName(name);
                rwo.setRealm(group);
                this.dao.update(rwo, null);
                log.debug((Object)"Page Created ");
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"wiki.new", (String)("/wiki" + rwo.getName() + "."), (boolean)true));
                continue;
            }
            log.debug((Object)"Page Already exists ");
            break;
        }
    }

    private boolean ignoreSeedPage(Site s, List targetTypes) {
        if (targetTypes == null || targetTypes.size() == 0) {
            return false;
        }
        if (s == null) {
            for (String ttype : targetTypes) {
                String[] ttypeGroup = ttype.split(",");
                for (int j = 0; j < ttypeGroup.length; ++j) {
                    if (ttypeGroup[j].startsWith("!")) continue;
                    return true;
                }
            }
            return false;
        }
        String type = s.getType();
        if (type == null) {
            type = "";
        }
        type = type.toLowerCase();
        log.debug((Object)("Checking Site " + type));
        for (String ttype : targetTypes) {
            String[] ttypeGroup = ttype.split(",");
            boolean bline = true;
            for (int j = 0; j < ttypeGroup.length; ++j) {
                if (ttypeGroup[j].startsWith("!")) {
                    log.debug((Object)("Checking not " + ttypeGroup[j] + " was " + (bline &= !type.startsWith(ttype.substring(1).toLowerCase()))));
                    continue;
                }
                log.debug((Object)("Checking " + ttypeGroup[j] + " was " + (bline &= type.startsWith(ttype.toLowerCase()))));
            }
            if (!bline) continue;
            return false;
        }
        return true;
    }

    private void updateReferences(RWikiCurrentObject rwo, String space) {
        HashSet referenced = new HashSet();
        String currentRealm = rwo.getRealm();
        1 plr = new /* Unavailable Anonymous Inner Class!! */;
        this.renderService.renderPage((RWikiObject)rwo, space, (PageLinkRenderer)plr);
        StringBuffer sb = new StringBuffer();
        Iterator i = referenced.iterator();
        while (i.hasNext()) {
            sb.append("::").append(i.next());
        }
        sb.append("::");
        rwo.setReferenced(sb.toString());
    }

    public List getSeedPages() {
        return this.seedPages;
    }

    public void setSeedPages(List seedPages) {
        this.seedPages = seedPages;
    }

    public RWikiCurrentObjectDao getRWikiCurrentObjectDao() {
        return this.dao;
    }

    public void setRWikiCurrentObjectDao(RWikiCurrentObjectDao dao) {
        this.dao = dao;
    }
}

