/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.caret.sakai.rwiki.tool.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ComponentManager;
import uk.ac.cam.caret.sakai.rwiki.service.api.PageLinkRenderer;
import uk.ac.cam.caret.sakai.rwiki.service.api.RenderService;
import uk.ac.cam.caret.sakai.rwiki.service.api.model.RWikiObject;
import uk.ac.cam.caret.sakai.rwiki.tool.api.ToolRenderService;
import uk.ac.cam.caret.sakai.rwiki.tool.service.impl.PageLinkRendererImpl;
import uk.ac.cam.caret.sakai.rwiki.tool.service.impl.PrintPageLinkRendererImpl;
import uk.ac.cam.caret.sakai.rwiki.tool.service.impl.PublicPageLinkRendererImpl;
import uk.ac.cam.caret.sakai.rwiki.utils.NameHelper;

public class ToolRenderServiceImpl
implements ToolRenderService {
    private static Log log = LogFactory.getLog(ToolRenderServiceImpl.class);
    private RenderService renderService = null;

    public void init() {
        ComponentManager cm = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.renderService = (RenderService)this.load(cm, RenderService.class.getName());
    }

    private Object load(ComponentManager cm, String name) {
        Object o = cm.get(name);
        if (o == null) {
            log.error((Object)("Cant find Spring component named " + name));
        }
        return o;
    }

    public String renderPublicPage(RWikiObject rwo, boolean withBreadCrumbs) {
        return this.renderPublicPage(rwo, rwo.getRealm(), withBreadCrumbs);
    }

    public String renderPublicPage(RWikiObject rwo, String defaultRealm, boolean withBreadCrumbs) {
        String localSpace = NameHelper.localizeSpace((String)rwo.getName(), (String)defaultRealm);
        PublicPageLinkRendererImpl plr = new PublicPageLinkRendererImpl(localSpace, defaultRealm, withBreadCrumbs);
        return this.renderService.renderPage(rwo, localSpace, (PageLinkRenderer)plr);
    }

    public String renderPrintPage(RWikiObject rwo, boolean withBreadCrumbs) {
        return this.renderPrintPage(rwo, rwo.getRealm(), withBreadCrumbs);
    }

    public String renderPrintPage(RWikiObject rwo, String defaultRealm, boolean withBreadCrumbs) {
        String localSpace = NameHelper.localizeSpace((String)rwo.getName(), (String)defaultRealm);
        PrintPageLinkRendererImpl plr = new PrintPageLinkRendererImpl(localSpace, defaultRealm, withBreadCrumbs);
        return this.renderService.renderPage(rwo, localSpace, (PageLinkRenderer)plr);
    }

    public String renderPage(RWikiObject rwo) {
        return this.renderPage(rwo, true);
    }

    public String renderPage(RWikiObject rwo, String defaultRealm) {
        String localSpace = NameHelper.localizeSpace((String)rwo.getName(), (String)defaultRealm);
        PageLinkRendererImpl plr = new PageLinkRendererImpl(localSpace, defaultRealm);
        return this.renderService.renderPage(rwo, localSpace, (PageLinkRenderer)plr);
    }

    public String renderPage(RWikiObject rwo, boolean cachable) {
        String localSpace = NameHelper.localizeSpace((String)rwo.getName(), (String)rwo.getRealm());
        PageLinkRendererImpl plr = new PageLinkRendererImpl(localSpace, rwo.getRealm());
        plr.setUseCache(cachable);
        plr.setCachable(cachable);
        return this.renderService.renderPage(rwo, localSpace, (PageLinkRenderer)plr);
    }
}

