/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.grading;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;

public class MediaData
implements Serializable {
    private static final long serialVersionUID = -437737678404198607L;
    private Long mediaId;
    private ItemGradingData itemGradingData;
    private byte[] media;
    private Long fileSize;
    private String mimeType;
    private String description;
    private String location;
    private String filename;
    private boolean isLink;
    private boolean isHtmlInline;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private String duration;
    private boolean durationIsOver;
    private String timeAllowed;

    public MediaData() {
    }

    public MediaData(ItemGradingData itemGradingData, byte[] media, Long fileSize, String mimeType, String description, String location, String filename, boolean isLink, boolean isHtmlInline, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String duration) {
        this.itemGradingData = itemGradingData;
        this.media = media;
        this.fileSize = fileSize;
        this.mimeType = mimeType;
        this.description = description;
        this.location = location;
        this.filename = filename;
        this.isLink = isLink;
        this.isHtmlInline = isHtmlInline;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.duration = duration;
    }

    public MediaData(Long mediaId, ItemGradingData itemGradingData, Long fileSize, String mimeType, String description, String location, String filename, boolean isLink, boolean isHtmlInline, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String duration) {
        this.mediaId = mediaId;
        this.itemGradingData = itemGradingData;
        this.fileSize = fileSize;
        this.mimeType = mimeType;
        this.description = description;
        this.location = location;
        this.filename = filename;
        this.isLink = isLink;
        this.isHtmlInline = isHtmlInline;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.duration = duration;
    }

    public MediaData(byte[] media, String mimeType) {
        this.setMimeType(mimeType);
        this.setMedia(media);
        this.setFileSize(Long.valueOf(media.length));
    }

    public MediaData(Long mediaId, String filename, Long fileSize, String duration, Date createdDate) {
        this.mediaId = mediaId;
        this.filename = filename;
        this.fileSize = fileSize;
        this.duration = duration;
        this.createdDate = createdDate;
    }

    public Long getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public ItemGradingData getItemGradingData() {
        return this.itemGradingData;
    }

    public void setItemGradingData(ItemGradingData itemGradingData) {
        this.itemGradingData = itemGradingData;
    }

    public byte[] getMedia() {
        return this.media;
    }

    public void setMedia(byte[] media) {
        this.media = media;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public String getFileSizeKBFormat() {
        String fileSizeKBStr = "";
        if (this.fileSize != null) {
            double fileSizeKB = this.fileSize.doubleValue() / 1000.0;
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(2);
            nf.setDecimalSeparatorAlwaysShown(true);
            fileSizeKBStr = nf.format(fileSizeKB);
        }
        return fileSizeKBStr;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pdescription) {
        this.description = pdescription;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean getIsLink() {
        return this.isLink;
    }

    public void setIsLink(boolean isLink) {
        this.isLink = isLink;
    }

    public boolean getIsHtmlInline() {
        return this.isHtmlInline;
    }

    public void setIsHtmlInline(boolean isHtmlInline) {
        this.isHtmlInline = isHtmlInline;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public boolean getDurationIsOver() {
        return this.durationIsOver;
    }

    public void setDurationIsOver(boolean durationIsOver) {
        this.durationIsOver = durationIsOver;
    }

    public String getTimeAllowed() {
        return this.timeAllowed;
    }

    public void setTimeAllowed(String timeAllowed) {
        this.timeAllowed = timeAllowed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.createdDate == null ? 0 : this.createdDate.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        result = 31 * result + (this.durationIsOver ? 1231 : 1237);
        result = 31 * result + (this.fileSize == null ? 0 : this.fileSize.hashCode());
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.isHtmlInline ? 1231 : 1237);
        result = 31 * result + (this.isLink ? 1231 : 1237);
        result = 31 * result + (this.itemGradingData == null ? 0 : this.itemGradingData.hashCode());
        result = 31 * result + (this.lastModifiedBy == null ? 0 : this.lastModifiedBy.hashCode());
        result = 31 * result + (this.lastModifiedDate == null ? 0 : this.lastModifiedDate.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + Arrays.hashCode(this.media);
        result = 31 * result + (this.mediaId == null ? 0 : this.mediaId.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.timeAllowed == null ? 0 : this.timeAllowed.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaData other = (MediaData)obj;
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.createdDate == null ? other.createdDate != null : !this.createdDate.equals(other.createdDate)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.duration == null ? other.duration != null : !this.duration.equals(other.duration)) {
            return false;
        }
        if (this.durationIsOver != other.durationIsOver) {
            return false;
        }
        if (this.fileSize == null ? other.fileSize != null : !this.fileSize.equals(other.fileSize)) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.isHtmlInline != other.isHtmlInline) {
            return false;
        }
        if (this.isLink != other.isLink) {
            return false;
        }
        if (this.itemGradingData == null ? other.itemGradingData != null : !this.itemGradingData.equals(other.itemGradingData)) {
            return false;
        }
        if (this.lastModifiedBy == null ? other.lastModifiedBy != null : !this.lastModifiedBy.equals(other.lastModifiedBy)) {
            return false;
        }
        if (this.lastModifiedDate == null ? other.lastModifiedDate != null : !this.lastModifiedDate.equals(other.lastModifiedDate)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (!Arrays.equals(this.media, other.media)) {
            return false;
        }
        if (this.mediaId == null ? other.mediaId != null : !this.mediaId.equals(other.mediaId)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        return !(this.timeAllowed == null ? other.timeAllowed != null : !this.timeAllowed.equals(other.timeAllowed));
    }
}

