/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.grading;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingAttachment;

public class ItemGradingData
implements Serializable {
    private static Log log = LogFactory.getLog(ItemGradingData.class);
    private static final long serialVersionUID = 7526471155622776147L;
    private Long itemGradingId;
    private Long assessmentGradingId;
    private Long publishedItemId;
    private Long publishedItemTextId;
    private String agentId;
    private Long publishedAnswerId;
    private String rationale;
    private String answerText;
    private Date submittedDate;
    private Double autoScore;
    private Double overrideScore;
    private String comments;
    private String gradedBy;
    private Date gradedDate;
    private Boolean review;
    private Integer attemptsRemaining;
    private String lastDuration;
    private Boolean isCorrect;
    private List mediaArray;
    private Set<ItemGradingAttachment> itemGradingAttachmentSet = new HashSet<ItemGradingAttachment>();

    public ItemGradingData() {
    }

    public ItemGradingData(Long itemGradingId, Long assessmentGradingId) {
        this.itemGradingId = itemGradingId;
        this.assessmentGradingId = assessmentGradingId;
    }

    public Long getItemGradingId() {
        return this.itemGradingId;
    }

    public void setItemGradingId(Long itemGradingId) {
        this.itemGradingId = itemGradingId;
    }

    public Long getPublishedItemId() {
        return this.publishedItemId;
    }

    public void setPublishedItemId(Long publishedItemId) {
        this.publishedItemId = publishedItemId;
    }

    public Long getPublishedItemTextId() {
        return this.publishedItemTextId;
    }

    public void setPublishedItemTextId(Long publishedItemTextId) {
        this.publishedItemTextId = publishedItemTextId;
    }

    public Long getAssessmentGradingId() {
        return this.assessmentGradingId;
    }

    public void setAssessmentGradingId(Long assessmentGradingId) {
        this.assessmentGradingId = assessmentGradingId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public Long getPublishedAnswerId() {
        return this.publishedAnswerId;
    }

    public void setPublishedAnswerId(Long publishedAnswerId) {
        this.publishedAnswerId = publishedAnswerId;
    }

    public String getRationale() {
        return this.rationale;
    }

    public void setRationale(String rationale) {
        this.rationale = rationale;
    }

    public String getAnswerText() {
        return this.answerText;
    }

    public void setAnswerText(String answerText) {
        this.answerText = answerText;
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    public Double getAutoScore() {
        return this.autoScore;
    }

    public void setAutoScore(Double autoScore) {
        this.autoScore = autoScore;
    }

    public Double getOverrideScore() {
        return this.overrideScore;
    }

    public void setOverrideScore(Double overrideScore) {
        this.overrideScore = overrideScore;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getGradedBy() {
        return this.gradedBy;
    }

    public void setGradedBy(String gradedBy) {
        this.gradedBy = gradedBy;
    }

    public Date getGradedDate() {
        return this.gradedDate;
    }

    public void setGradedDate(Date gradedDate) {
        this.gradedDate = gradedDate;
    }

    public Boolean getReview() {
        return this.review;
    }

    public void setReview(Boolean newReview) {
        this.review = newReview;
    }

    public Integer getAttemptsRemaining() {
        return this.attemptsRemaining;
    }

    public void setAttemptsRemaining(Integer attemptsRemaining) {
        this.attemptsRemaining = attemptsRemaining;
    }

    public String getLastDuration() {
        return this.lastDuration;
    }

    public void setLastDuration(String lastDuration) {
        this.lastDuration = lastDuration;
    }

    public Boolean getIsCorrect() {
        return this.isCorrect;
    }

    public void setIsCorrect(Boolean isCorrect) {
        this.isCorrect = isCorrect;
    }

    public List getMediaArray() {
        return this.mediaArray;
    }

    public void setMediaArray(List mediaArray) {
        this.mediaArray = mediaArray;
    }

    public int getMediaSize() {
        return this.mediaArray.size();
    }

    public Set<ItemGradingAttachment> getItemGradingAttachmentSet() {
        return this.itemGradingAttachmentSet;
    }

    public void setItemGradingAttachmentSet(Set<ItemGradingAttachment> itemGradingAttachmentSet) {
        this.itemGradingAttachmentSet = itemGradingAttachmentSet;
    }

    public List<ItemGradingAttachment> getItemGradingAttachmentList() {
        ArrayList<ItemGradingAttachment> list = new ArrayList<ItemGradingAttachment>();
        if (this.itemGradingAttachmentSet != null) {
            for (ItemGradingAttachment a : this.itemGradingAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }

    public void setItemGradingAttachmentList(List<ItemGradingAttachment> itemGradingAttachmentList) {
        HashSet<ItemGradingAttachment> itemGradingAttachmentSet = new HashSet<ItemGradingAttachment>(itemGradingAttachmentList);
        this.itemGradingAttachmentSet = itemGradingAttachmentSet;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(1, 31);
        builder.append((Object)this.agentId);
        builder.append((Object)this.answerText);
        builder.append((Object)this.assessmentGradingId);
        builder.append((Object)this.attemptsRemaining);
        builder.append((Object)this.autoScore);
        builder.append((Object)this.comments);
        builder.append((Object)this.gradedBy);
        builder.append((Object)this.gradedDate);
        builder.append((Object)this.itemGradingId);
        builder.append((Object)this.isCorrect);
        builder.append((Object)this.lastDuration);
        builder.append((Object)this.mediaArray);
        builder.append((Object)this.overrideScore);
        builder.append((Object)this.publishedAnswerId);
        builder.append((Object)this.publishedItemId);
        builder.append((Object)this.publishedItemTextId);
        builder.append((Object)this.rationale);
        builder.append((Object)this.review);
        builder.append((Object)this.submittedDate);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Hashcode for Published Answer " + this.publishedAnswerId + " is " + builder.toHashCode()));
        }
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemGradingData other = (ItemGradingData)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.appendSuper(super.equals(obj));
        builder.append((Object)this.agentId, (Object)other.agentId);
        builder.append((Object)this.answerText, (Object)other.answerText);
        builder.append((Object)this.assessmentGradingId, (Object)other.assessmentGradingId);
        builder.append((Object)this.attemptsRemaining, (Object)other.attemptsRemaining);
        builder.append((Object)this.autoScore, (Object)other.autoScore);
        builder.append((Object)this.comments, (Object)other.comments);
        builder.append((Object)this.gradedBy, (Object)other.gradedBy);
        builder.append((Object)this.gradedDate, (Object)other.gradedDate);
        builder.append((Object)this.itemGradingId, (Object)other.itemGradingId);
        builder.append((Object)this.isCorrect, (Object)other.isCorrect);
        builder.append((Object)this.lastDuration, (Object)other.lastDuration);
        builder.append((Object)this.mediaArray, (Object)other.mediaArray);
        builder.append((Object)this.overrideScore, (Object)other.overrideScore);
        builder.append((Object)this.publishedAnswerId, (Object)other.publishedAnswerId);
        builder.append((Object)this.publishedItemId, (Object)other.publishedItemId);
        builder.append((Object)this.publishedItemTextId, (Object)other.publishedItemTextId);
        builder.append((Object)this.rationale, (Object)other.rationale);
        builder.append((Object)this.review, (Object)other.review);
        builder.append((Object)this.submittedDate, (Object)other.submittedDate);
        return builder.isEquals();
    }
}

