/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.samlite.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.sakaiproject.tool.assessment.samlite.api.Answer;

public class Question {
    public static final int UNDEFINED_QUESTION = 0;
    public static final int MULTIPLE_CHOICE_QUESTION = 10;
    public static final int MULTIPLE_CHOICE_MULTIPLE_ANSWER_QUESTION = 15;
    public static final int FILL_IN_THE_BLANK_QUESTION = 20;
    public static final int TRUE_FALSE_QUESTION = 30;
    public static final int SHORT_ESSAY_QUESTION = 40;
    public static final int EXTENDED_MATCHING_ITEMS_QUESTION = 50;
    public static final int FILL_IN_NUMERIC_QUESTION = 60;
    private String themeText;
    private String leadInText;
    private ArrayList emiAnswerOptions;
    private ArrayList emiQuestionAnswerCombinations;
    private int questionNumber = 0;
    private String questionPoints = "";
    private String questionDiscount = "";
    private List questionLines = new LinkedList();
    private int questionType = 0;
    private String correctAnswer = "";
    private List answers = new LinkedList();
    private boolean hasPoints = false;
    private boolean hasDiscount = false;
    private String questionTypeAsString = "";
    private String feedbackOK;
    private String feedbackNOK;
    private boolean randomize = false;
    private boolean rationale;

    public void addAnswer(String id, String text, boolean isCorrect) {
        this.answers.add(new Answer(id, text, isCorrect));
    }

    public List getAnswers() {
        return this.answers;
    }

    public void setAnswers(List answers) {
        this.answers = answers;
    }

    public String getCorrectAnswer() {
        return this.correctAnswer;
    }

    public void setCorrectAnswer(String correctAnswer) {
        this.correctAnswer = correctAnswer;
    }

    public String getQuestion() {
        StringBuilder buffer = new StringBuilder();
        for (String line : this.questionLines) {
            if (null == line || "".equals(line)) continue;
            buffer.append(line.trim()).append(" ");
        }
        return buffer.toString();
    }

    public void append(String questionSegment) {
        this.questionLines.add(questionSegment);
    }

    public int getQuestionNumber() {
        return this.questionNumber;
    }

    public void setQuestionNumber(int questionNumber) {
        this.questionNumber = questionNumber;
    }

    public String getQuestionPoints() {
        return this.questionPoints;
    }

    public void setQuestionPoints(String questionPoints) {
        if (null != questionPoints && !"".equals(questionPoints)) {
            this.hasPoints = true;
        }
        this.questionPoints = questionPoints;
    }

    public String getQuestionDiscount() {
        return this.questionDiscount;
    }

    public void setQuestionDiscount(String questionDiscount) {
        if (null != questionDiscount && !"".equals(questionDiscount)) {
            this.hasDiscount = true;
        }
        this.questionDiscount = questionDiscount;
    }

    public boolean hasPoints() {
        return this.hasPoints;
    }

    public boolean hasDiscount() {
        return this.hasDiscount;
    }

    public int getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(int questionType) {
        this.questionType = questionType;
    }

    public boolean isRationale() {
        return this.rationale;
    }

    public void setRationale(boolean rationale) {
        this.rationale = rationale;
    }

    public void postProcessing() {
        if (this.getQuestionType() == 50) {
            Answer answer;
            int themeLineIndex = 1;
            int optionLine = 2;
            this.questionLines.set(themeLineIndex, this.questionLines.get(themeLineIndex).toString() + "<br /><br />");
            Iterator answerLines = this.answers.iterator();
            String textToAdd = "Options: ";
            this.questionLines.add(optionLine++, textToAdd + "<br />");
            while (answerLines.hasNext()) {
                answer = (Answer)answerLines.next();
                textToAdd = answer.getId() + ". " + answer.getText();
                if (!answer.isCorrect()) {
                    this.questionLines.add(optionLine++, textToAdd + "<br />");
                    continue;
                }
                this.questionLines.add(textToAdd);
            }
            answerLines = this.answers.iterator();
            while (answerLines.hasNext()) {
                answer = (Answer)answerLines.next();
                if (!answer.isCorrect()) {
                    answerLines.remove();
                    continue;
                }
                answer.postProcessing(this.questionType);
            }
        }
    }

    public String getQuestionTypeAsString() {
        return this.questionTypeAsString;
    }

    public void setQuestionTypeAsString(String questionTypeAsString) {
        this.questionTypeAsString = questionTypeAsString;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public String getFeedbackOK() {
        return this.feedbackOK;
    }

    public void setFeedbackOK(String feedbackOK) {
        this.feedbackOK = feedbackOK;
    }

    public String getFeedbackNOK() {
        return this.feedbackNOK;
    }

    public void setFeedbackNOK(String feedbackNOK) {
        this.feedbackNOK = feedbackNOK;
    }

    public String getLeadInText() {
        if (this.leadInText == null) {
            this.setThemeAndLeadInText();
        }
        return this.leadInText;
    }

    public String getThemeText() {
        if (this.themeText == null) {
            this.setThemeAndLeadInText();
        }
        return this.themeText;
    }

    public void setThemeAndLeadInText() {
        this.themeText = (String)this.questionLines.get(1);
        this.leadInText = (String)this.questionLines.get(2);
    }

    public ArrayList getEmiAnswerOptions() {
        if (this.emiAnswerOptions == null) {
            this.setEmiOptionsAndQACombinations();
        }
        return this.emiAnswerOptions;
    }

    public ArrayList getEmiQuestionAnswerCombinations() {
        if (this.emiQuestionAnswerCombinations == null) {
            this.setEmiOptionsAndQACombinations();
        }
        return this.emiQuestionAnswerCombinations;
    }

    private void setEmiOptionsAndQACombinations() {
        this.emiAnswerOptions = new ArrayList();
        this.emiQuestionAnswerCombinations = new ArrayList();
        for (Answer answer : this.answers) {
            if (answer.getId().matches("[0-9]+")) {
                this.emiQuestionAnswerCombinations.add(answer);
                continue;
            }
            this.emiAnswerOptions.add(answer);
        }
    }
}

