/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.grading;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;

public class MediaData
implements Serializable {
    private static final long serialVersionUID = -437737678404198607L;
    private Long mediaId;
    private ItemGradingData itemGradingData;
    private byte[] media;
    private Long fileSize;
    private String mimeType;
    private String description;
    private String location;
    private String filename;
    private boolean isLink;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private String duration;
    private ContentResource contentResource;
    private boolean durationIsOver;
    private String timeAllowed;

    public MediaData() {
    }

    public MediaData(ItemGradingData itemGradingData, byte[] media, Long fileSize, String mimeType, String description, String location, String filename, boolean isLink, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String duration) {
        this.itemGradingData = itemGradingData;
        this.media = media;
        this.fileSize = fileSize;
        this.mimeType = mimeType;
        this.description = description;
        this.location = location;
        this.filename = filename;
        this.isLink = isLink;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.duration = duration;
    }

    public MediaData(Long mediaId, ItemGradingData itemGradingData, Long fileSize, String mimeType, String description, String location, String filename, boolean isLink, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String duration) {
        this.mediaId = mediaId;
        this.itemGradingData = itemGradingData;
        this.fileSize = fileSize;
        this.mimeType = mimeType;
        this.description = description;
        this.location = location;
        this.filename = filename;
        this.isLink = isLink;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.duration = duration;
    }

    public MediaData(byte[] media, String mimeType) {
        this.setMimeType(mimeType);
        this.setMedia(media);
        this.setFileSize(Long.valueOf(media.length));
    }

    public MediaData(Long mediaId, String filename, Long fileSize, String duration, Date createdDate) {
        this.mediaId = mediaId;
        this.filename = filename;
        this.fileSize = fileSize;
        this.duration = duration;
        this.createdDate = createdDate;
    }

    public Long getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public ItemGradingData getItemGradingData() {
        return this.itemGradingData;
    }

    public void setItemGradingData(ItemGradingData itemGradingData) {
        this.itemGradingData = itemGradingData;
    }

    public byte[] getMedia() {
        if (this.media == null && this.contentResource != null) {
            try {
                return this.contentResource.getContent();
            }
            catch (ServerOverloadException e) {
                return null;
            }
        }
        return this.media;
    }

    public void setMedia(byte[] media) {
        this.media = media;
    }

    public ContentResource getContentResource() {
        return this.contentResource;
    }

    public void setContentResource(ContentResource contentResource) {
        this.contentResource = contentResource;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public String getFileSizeKBFormat() {
        String fileSizeKBStr = "";
        if (this.fileSize != null) {
            double fileSizeKB = this.fileSize.doubleValue() / 1000.0;
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(2);
            nf.setDecimalSeparatorAlwaysShown(true);
            fileSizeKBStr = nf.format(fileSizeKB);
        }
        return fileSizeKBStr;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pdescription) {
        this.description = pdescription;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean getIsLink() {
        return this.isLink;
    }

    public void setIsLink(boolean isLink) {
        this.isLink = isLink;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public boolean getDurationIsOver() {
        return this.durationIsOver;
    }

    public void setDurationIsOver(boolean durationIsOver) {
        this.durationIsOver = durationIsOver;
    }

    public String getTimeAllowed() {
        return this.timeAllowed;
    }

    public void setTimeAllowed(String timeAllowed) {
        this.timeAllowed = timeAllowed;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(1, 31);
        builder.append((Object)this.createdBy);
        builder.append((Object)this.createdDate);
        builder.append((Object)this.description);
        builder.append((Object)this.duration);
        builder.append(this.durationIsOver);
        builder.append((Object)this.fileSize);
        builder.append((Object)this.filename);
        builder.append(this.isLink);
        builder.append((Object)this.itemGradingData);
        builder.append((Object)this.lastModifiedBy);
        builder.append((Object)this.lastModifiedDate);
        builder.append((Object)this.location);
        builder.append(this.media);
        builder.append((Object)this.mediaId);
        builder.append((Object)this.mimeType);
        builder.append((Object)this.status);
        builder.append((Object)this.timeAllowed);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaData other = (MediaData)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.appendSuper(super.equals(obj));
        builder.append((Object)this.createdBy, (Object)other.createdBy);
        builder.append((Object)this.createdDate, (Object)other.createdDate);
        builder.append((Object)this.description, (Object)other.description);
        builder.append((Object)this.duration, (Object)other.duration);
        builder.append(this.durationIsOver, other.durationIsOver);
        builder.append((Object)this.fileSize, (Object)other.fileSize);
        builder.append((Object)this.filename, (Object)other.filename);
        builder.append(this.isLink, other.isLink);
        builder.append((Object)this.itemGradingData, (Object)other.itemGradingData);
        builder.append((Object)this.lastModifiedBy, (Object)other.lastModifiedBy);
        builder.append((Object)this.lastModifiedDate, (Object)other.lastModifiedDate);
        builder.append((Object)this.location, (Object)other.location);
        builder.append(this.media, other.media);
        builder.append((Object)this.mediaId, (Object)other.mediaId);
        builder.append((Object)this.mimeType, (Object)other.mimeType);
        builder.append((Object)this.status, (Object)other.status);
        builder.append((Object)this.timeAllowed, (Object)other.timeAllowed);
        return builder.isEquals();
    }
}

