/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.samigo.api;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamigoReferenceReckoner {
    private static final Logger log = LoggerFactory.getLogger(SamigoReferenceReckoner.class);

    public static SamigoReference newSamigoReferenceReckoner(String site, String subtype, String id, String reference) {
        if (StringUtils.startsWith((CharSequence)reference, (CharSequence)"/samigo")) {
            String[] parts = StringUtils.splitPreserveAllTokens((String)reference, (String)"/");
            System.out.println(parts.length);
            if (parts.length > 3) {
                if (site == null) {
                    site = parts[3];
                }
                if (parts.length > 4) {
                    if (subtype == null) {
                        subtype = parts[4];
                    }
                    if ("p".equals(subtype) && parts.length > 5 && id == null) {
                        id = parts[5];
                    }
                }
            }
        }
        return new SamigoReference(site == null ? "" : site, subtype == null ? "" : subtype, id == null ? "" : id, reference == null ? "" : reference);
    }

    public static SamigoReferenceBuilder reckoner() {
        return new SamigoReferenceBuilder();
    }

    public static class SamigoReferenceBuilder {
        private String site;
        private String subtype;
        private String id;
        private String reference;

        SamigoReferenceBuilder() {
        }

        public SamigoReferenceBuilder site(String site) {
            this.site = site;
            return this;
        }

        public SamigoReferenceBuilder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public SamigoReferenceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SamigoReferenceBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public SamigoReference reckon() {
            return SamigoReferenceReckoner.newSamigoReferenceReckoner(this.site, this.subtype, this.id, this.reference);
        }

        public String toString() {
            return "SamigoReferenceReckoner.SamigoReferenceBuilder(site=" + this.site + ", subtype=" + this.subtype + ", id=" + this.id + ", reference=" + this.reference + ")";
        }
    }

    public static final class SamigoReference {
        private final String type = "samigo";
        private final String site;
        private final String subtype;
        private final String id;
        private final String reference;

        public String toString() {
            Object reference = "/samigo";
            if (StringUtils.isNotBlank((CharSequence)this.site)) {
                reference = (String)reference + "/s/" + this.site;
            }
            switch (this.subtype) {
                default: 
            }
            reference = (String)reference + "/p";
            if (StringUtils.isNotBlank((CharSequence)this.id)) {
                reference = (String)reference + "/" + this.id;
            }
            return reference;
        }

        public String getReference() {
            return this.toString();
        }

        public SamigoReference(String site, String subtype, String id, String reference) {
            this.site = site;
            this.subtype = subtype;
            this.id = id;
            this.reference = reference;
        }

        public String getType() {
            return this.type;
        }

        public String getSite() {
            return this.site;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SamigoReference)) {
                return false;
            }
            SamigoReference other = (SamigoReference)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$site = this.getSite();
            String other$site = other.getSite();
            if (this$site == null ? other$site != null : !this$site.equals(other$site)) {
                return false;
            }
            String this$subtype = this.getSubtype();
            String other$subtype = other.getSubtype();
            if (this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$reference = this.getReference();
            String other$reference = other.getReference();
            return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $site = this.getSite();
            result = result * 59 + ($site == null ? 43 : $site.hashCode());
            String $subtype = this.getSubtype();
            result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            return result;
        }
    }
}

