/*
 * Decompiled with CFR 0.152.
 */
package com.corejsf;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;

public class UploadFilter
implements Filter {
    private static Log log = LogFactory.getLog(UploadFilter.class);
    private int sizeThreshold = -1;
    private long sizeMax = -1L;
    private String repositoryPath;
    private String saveMediaToDb = "false";

    public void init(FilterConfig config) throws ServletException {
        this.repositoryPath = ServerConfigurationService.getString((String)"samigo.answerUploadRepositoryPath", (String)config.getInitParameter("com.corejsf.UploadFilter.repositoryPath"));
        try {
            String paramValue = ServerConfigurationService.getString((String)"samigo.sizeThreshold", (String)config.getInitParameter("com.corejsf.UploadFilter.sizeThreshold"));
            if (paramValue != null) {
                this.sizeThreshold = Integer.parseInt(paramValue);
            }
            if ((paramValue = ServerConfigurationService.getString((String)"samigo.sizeMax", (String)config.getInitParameter("com.corejsf.UploadFilter.sizeMax"))) != null) {
                this.sizeMax = Long.parseLong(paramValue);
            }
            if ((paramValue = ServerConfigurationService.getString((String)"samigo.saveMediaToDb", (String)config.getInitParameter("com.corejsf.UploadFilter.saveMediaToDb"))) != null) {
                this.saveMediaToDb = paramValue;
            }
        }
        catch (NumberFormatException ex) {
            ServletException servletEx = new ServletException();
            servletEx.initCause((Throwable)ex);
            throw servletEx;
        }
        ServletContext context = config.getServletContext();
        context.setAttribute("FILEUPLOAD_REPOSITORY_PATH", (Object)this.repositoryPath);
        context.setAttribute("FILEUPLOAD_SIZE_THRESHOLD", (Object)new Integer(this.sizeThreshold));
        context.setAttribute("FILEUPLOAD_SIZE_MAX", (Object)new Long(this.sizeMax));
        context.setAttribute("FILEUPLOAD_SAVE_MEDIA_TO_DB", (Object)this.saveMediaToDb);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean isMultipartContent = FileUpload.isMultipartContent((HttpServletRequest)httpRequest);
        if (!isMultipartContent) {
            chain.doFilter(request, response);
            return;
        }
        DiskFileUpload upload = new DiskFileUpload();
        if (this.repositoryPath != null) {
            upload.setRepositoryPath(this.repositoryPath);
        }
        try {
            List list = upload.parseRequest(httpRequest);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (int i = 0; i < list.size(); ++i) {
                FileItem item = (FileItem)list.get(i);
                if (item.isFormField()) {
                    String str = item.getString("UTF-8");
                    map.put(item.getFieldName(), new String[]{str});
                    continue;
                }
                httpRequest.setAttribute(item.getFieldName(), (Object)item);
            }
            chain.doFilter((ServletRequest)new /* Unavailable Anonymous Inner Class!! */, response);
        }
        catch (FileUploadException ex) {
            log.error((Object)ex.getMessage());
            ServletException servletEx = new ServletException();
            servletEx.initCause((Throwable)ex);
            throw servletEx;
        }
    }
}

