/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.business.questionpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osid.shared.SharedException;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolData;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.util.BeanSort;

public class QuestionPoolTreeImpl
implements Tree {
    private static final long serialVersionUID = 2173986944623441011L;
    private static Log log = LogFactory.getLog(QuestionPoolTreeImpl.class);
    private HashMap poolMap = new HashMap();
    private HashMap poolFamilies = new HashMap();
    private Long currentPoolId;
    private String currentObjectHTMLId;
    private String currentLevel;
    private String sortString = "lastModified";

    public QuestionPoolTreeImpl() {
    }

    public QuestionPoolTreeImpl(QuestionPoolIteratorFacade iter) {
        try {
            while (iter.hasNext()) {
                QuestionPoolFacade pool = iter.next();
                Long parentId = pool.getParentPoolId();
                Long poolId = pool.getQuestionPoolId();
                this.poolMap.put(poolId.toString(), pool);
                ArrayList childList = new ArrayList();
                if (this.poolFamilies.containsKey(parentId.toString())) {
                    childList = (ArrayList)this.poolFamilies.get(parentId.toString());
                }
                childList.add(poolId);
                this.poolFamilies.put(parentId.toString(), childList);
            }
            for (String key : this.poolFamilies.keySet()) {
                Iterator children = ((ArrayList)this.poolFamilies.get(key)).iterator();
                Collection sortedList = new ArrayList<QuestionPoolDataIfc>();
                while (children.hasNext()) {
                    QuestionPoolFacade pool = (QuestionPoolFacade)this.poolMap.get(children.next().toString());
                    sortedList.add(pool.getData());
                }
                BeanSort sort = new BeanSort(sortedList, this.sortString);
                sortedList = sort.sort();
                ArrayList<Long> ids = new ArrayList<Long>();
                Iterator siblings = sortedList.iterator();
                while (siblings.hasNext()) {
                    QuestionPoolData next = null;
                    try {
                        next = (QuestionPoolData)siblings.next();
                        if (this.poolMap != null) {
                            if ("lastModified".equals(this.sortString)) {
                                ids.add(0, ((QuestionPoolFacade)this.poolMap.get(next.getQuestionPoolId().toString())).getQuestionPoolId());
                                continue;
                            }
                            ids.add(((QuestionPoolFacade)this.poolMap.get(next.getQuestionPoolId().toString())).getQuestionPoolId());
                            continue;
                        }
                        log.error((Object)"poolMap is null");
                    }
                    catch (RuntimeException e) {
                        log.error((Object)("Couldn't get ID " + next.getQuestionPoolId()));
                    }
                }
                this.poolFamilies.put(key, ids);
            }
        }
        catch (SharedException se) {
            se.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public List getChildList(Long parentId) {
        if (!this.poolFamilies.containsKey(parentId.toString())) {
            return new ArrayList();
        }
        return (ArrayList)this.poolFamilies.get(parentId.toString());
    }

    public List getRootNodeList() {
        try {
            return this.getChildList(new Long("0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getCurrentObject() {
        return this.poolMap.get(this.currentPoolId.toString());
    }

    public Object getParent() {
        if (this.currentPoolId == null) {
            return null;
        }
        QuestionPoolFacade current = (QuestionPoolFacade)this.getCurrentObject();
        try {
            return this.poolMap.get(current.getParentPoolId().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCurrentObjectHTMLId(String param) {
        this.currentObjectHTMLId = param;
    }

    public String getCurrentObjectHTMLId() {
        QuestionPoolFacade current = (QuestionPoolFacade)this.getCurrentObject();
        try {
            QuestionPoolFacade parent = (QuestionPoolFacade)this.getParent();
            if (parent == null) {
                List childList = this.getChildList(new Long("0"));
                return Integer.toString(((ArrayList)childList).indexOf(((QuestionPoolFacade)this.getCurrentObject()).getQuestionPoolId()) + 1);
            }
            this.setCurrentId(current.getParentPoolId());
            String result = this.getCurrentObjectHTMLId();
            List childList = this.getChildList(parent.getQuestionPoolId());
            this.setCurrentId(current.getQuestionPoolId());
            return result + "-" + (((ArrayList)childList).indexOf(((QuestionPoolFacade)this.getCurrentObject()).getQuestionPoolId()) + 1);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return "0";
        }
    }

    public String getCurrentLevel() {
        int index1 = 1;
        QuestionPoolFacade current = (QuestionPoolFacade)this.getCurrentObject();
        try {
            while (!current.getParentPoolId().toString().equals("0")) {
                current = (QuestionPoolFacade)this.poolMap.get(current.getParentPoolId().toString());
                ++index1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
        return Integer.toString(index1);
    }

    public Collection getCurrentObjectProperties() {
        ArrayList properties = new ArrayList();
        return properties;
    }

    public void setPropertyMethods(String[] methods) {
    }

    public Map getAllObjects() {
        return this.poolMap;
    }

    public Collection getSortedObjects() {
        ArrayList total = new ArrayList();
        try {
            this.addChildren(total, new Long("0"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return total;
    }

    public Collection getSortedObjects(Long poolId) {
        ArrayList total = new ArrayList();
        try {
            this.addChildren(total, poolId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return total;
    }

    private void addChildren(Collection total, Long parentId) {
        List childList = this.getChildList(parentId);
        if (childList.isEmpty()) {
            return;
        }
        for (Long nextId : childList) {
            total.add(this.poolMap.get(nextId.toString()));
            this.addChildren(total, nextId);
        }
    }

    public Map getChildren(Long parentId) {
        HashMap childPool = new HashMap();
        List childList = this.getChildList(parentId);
        for (Long poolId : childList) {
            childPool.put(poolId.toString(), this.poolMap.get(poolId.toString()));
        }
        return childPool;
    }

    public Map getChildren() {
        return this.getChildren(this.getCurrentId());
    }

    public Long getCurrentId() {
        return this.currentPoolId;
    }

    public void setCurrentId(Long poolId) {
        this.currentPoolId = poolId;
    }

    public boolean currentObjectIsParent() {
        return this.poolFamilies.containsKey(this.getCurrentId().toString());
    }

    public List getChildList() {
        return this.getChildList(this.getCurrentId());
    }

    public boolean getHasChildList() {
        return !this.getChildList().isEmpty();
    }

    public boolean getHasNoChildList() {
        return this.getChildList().isEmpty();
    }

    public String getSortProperty() {
        return this.sortString;
    }

    public void setSortProperty(String newProperty) {
        this.sortString = newProperty;
    }

    public void sortByProperty(String sortProperty, boolean sortAscending) {
        for (String key : this.poolFamilies.keySet()) {
            Iterator children = ((ArrayList)this.poolFamilies.get(key)).iterator();
            ArrayList<QuestionPoolDataIfc> sortedList = new ArrayList<QuestionPoolDataIfc>();
            while (children.hasNext()) {
                QuestionPoolFacade pool = (QuestionPoolFacade)this.poolMap.get(children.next().toString());
                sortedList.add(pool.getData());
            }
            BeanSort sort = new BeanSort(sortedList, sortProperty);
            if ("lastModified".equals(sortProperty)) {
                sort.toDateSort();
            } else {
                sort.toStringSort();
            }
            sort.sort();
            if (!sortAscending) {
                Collections.reverse(sortedList);
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator siblings = sortedList.iterator();
            while (siblings.hasNext()) {
                QuestionPoolData next = null;
                try {
                    next = (QuestionPoolData)siblings.next();
                    if (next != null) {
                        if ("lastModified".equals(sortProperty)) {
                            ids.add(0, ((QuestionPoolFacade)this.poolMap.get(next.getQuestionPoolId().toString())).getQuestionPoolId());
                            continue;
                        }
                        ids.add(((QuestionPoolFacade)this.poolMap.get(next.getQuestionPoolId().toString())).getQuestionPoolId());
                        continue;
                    }
                    log.error((Object)"next is null");
                }
                catch (RuntimeException e) {
                    log.error((Object)("Couldn't get ID " + next.getQuestionPoolId()));
                }
            }
            this.poolFamilies.put(key, ids);
        }
    }

    public boolean haveCommonRoot(Long poolIdA, Long poolIdB) {
        try {
            Long rootA = poolIdA;
            Long rootB = poolIdB;
            QuestionPoolFacade tempPool = (QuestionPoolFacade)this.poolMap.get(rootA.toString());
            while (tempPool != null) {
                if (tempPool.getParentPoolId() == null || tempPool.getParentPoolId().toString().equals("0")) {
                    tempPool = null;
                    continue;
                }
                rootA = tempPool.getParentPoolId();
                tempPool = (QuestionPoolFacade)this.poolMap.get(rootA.toString());
            }
            tempPool = (QuestionPoolFacade)this.poolMap.get(rootB.toString());
            while (tempPool != null) {
                if (tempPool.getParentPoolId() == null || tempPool.getParentPoolId().toString().equals("0")) {
                    tempPool = null;
                    continue;
                }
                rootB = tempPool.getParentPoolId();
                tempPool = (QuestionPoolFacade)this.poolMap.get(rootB.toString());
            }
            return rootA.equals(rootB);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isDescendantOf(Long poolA, Long poolB) {
        try {
            Long tempPoolId = poolA;
            while (tempPoolId != null && tempPoolId.toString().compareTo("0") > 0) {
                QuestionPoolFacade tempPool = (QuestionPoolFacade)this.poolMap.get(tempPoolId.toString());
                if (tempPool.getParentPoolId().toString().compareTo(poolB.toString()) == 0) {
                    return true;
                }
                tempPoolId = tempPool.getParentPoolId();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int poolLevel(Long poolId) {
        try {
            Long rootId = poolId;
            int level = 0;
            QuestionPoolFacade tempPool = (QuestionPoolFacade)this.poolMap.get(rootId.toString());
            while (tempPool != null) {
                if (tempPool.getParentPoolId() == null || tempPool.getParentPoolId().toString().equals("0")) {
                    tempPool = null;
                    continue;
                }
                ++level;
                rootId = tempPool.getParentPoolId();
                tempPool = (QuestionPoolFacade)this.poolMap.get(rootId.toString());
            }
            return level;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

