/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.qti;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.services.qti.QTIService;
import org.sakaiproject.tool.assessment.shared.api.qti.QTIServiceAPI;
import org.w3c.dom.Document;

public class QTIServiceImpl
implements QTIServiceAPI {
    private static Log log = LogFactory.getLog(QTIServiceImpl.class);

    public AssessmentIfc createImportedAssessment(Document document, int qtiVersion) {
        try {
            QTIService nativeQTIService = new QTIService();
            return nativeQTIService.createImportedAssessment(document, qtiVersion, null);
        }
        catch (Exception ex) {
            log.warn((Object)"createImportedAssessment() returning null");
            log.error((Object)"createImportedAssessment() returning null");
            return null;
        }
    }

    public ItemDataIfc createImportedItem(Document document, int qtiVersion) {
        try {
            QTIService nativeQTIService = new QTIService();
            return nativeQTIService.createImportedItem(document, qtiVersion);
        }
        catch (Exception ex) {
            log.warn((Object)"createImportedItem() returning null");
            log.error((Object)"createImportedItem() returning null");
            return null;
        }
    }

    public Document getExportedAssessment(String assessmentId, int qtiVersion) {
        try {
            QTIService nativeQTIService = new QTIService();
            return nativeQTIService.getExportedAssessment(assessmentId, qtiVersion);
        }
        catch (Exception ex) {
            log.warn((Object)"getExportedAssessment() returning null");
            log.error((Object)"getExportedAssessment() returning null");
            return null;
        }
    }

    public Document getExportedItem(String itemId, int qtiVersion) {
        try {
            QTIService nativeQTIService = new QTIService();
            return nativeQTIService.getExportedAssessment(itemId, qtiVersion);
        }
        catch (Exception ex) {
            log.warn((Object)"getExportedItem() returning null");
            log.error((Object)"getExportedItem() returning null");
            return null;
        }
    }

    public Document getExportedItemBank(String[] itemIds, int qtiVersion) {
        try {
            QTIService nativeQTIService = new QTIService();
            return nativeQTIService.getExportedItemBank(itemIds, qtiVersion);
        }
        catch (Exception ex) {
            log.warn((Object)"getExportedItemBank() returning null");
            log.error((Object)"getExportedItemBank() returning null");
            return null;
        }
    }
}

