/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.RegisteredSecureDeliveryModuleIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SecuredIPAddressIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.PublishingTargetHelper;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.listener.author.SaveAssessmentAttachmentListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.ui.listener.util.TimeUtil;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ResourceLoader;

public class AssessmentSettingsBean
implements Serializable {
    private static Log log;
    private static final IntegrationContextFactory integrationContextFactory;
    private static final GradebookServiceHelper gbsHelper;
    private static final PublishingTargetHelper ptHelper;
    private static final boolean integrated;
    private static final long serialVersionUID = -630950053380808339L;
    private String outcomeSave;
    private String outcomePublish;
    private AssessmentFacade assessment;
    private AssessmentTemplateFacade template;
    private Long assessmentId;
    private String title;
    private String creator;
    private String description;
    private boolean hasQuestions;
    private String templateTitle;
    private String templateDescription;
    private String objectives;
    private String keywords;
    private String rubrics;
    private String authors;
    private String templateAuthors;
    private Date startDate;
    private Date dueDate;
    private Date retractDate;
    private Date feedbackDate;
    private Integer timeLimit = 0;
    private Integer timedHours = 0;
    private Integer timedMinutes = 0;
    private Integer timedSeconds = 0;
    private boolean timedAssessment = false;
    private boolean autoSubmit = false;
    private String assessmentFormat;
    private String itemNavigation;
    private String itemNumbering;
    private String unlimitedSubmissions;
    private String submissionsAllowed;
    private String submissionsSaved;
    private String lateHandling;
    private String submissionMessage;
    private String releaseTo;
    private SelectItem[] publishingTargets;
    private String[] targetSelected;
    private String firstTargetSelected;
    private String username;
    private String password;
    private String finalPageUrl;
    private String ipAddresses;
    private boolean secureDeliveryAvailable;
    private SelectItem[] secureDeliveryModuleSelections;
    private String secureDeliveryModule;
    private String secureDeliveryModuleExitPassword;
    private String feedbackDelivery;
    private String feedbackComponentOption;
    private boolean showQuestionText = true;
    private boolean showStudentResponse = false;
    private boolean showCorrectResponse = false;
    private boolean showStudentScore = false;
    private boolean showStudentQuestionScore = false;
    private boolean showQuestionLevelFeedback = false;
    private boolean showSelectionLevelFeedback = false;
    private boolean showGraderComments = false;
    private boolean showStatistics = false;
    private String anonymousGrading;
    private boolean gradebookExists;
    private String toDefaultGradebook;
    private String scoringType;
    private String bgColor;
    private String bgImage;
    private HashMap values = new HashMap();
    private String bgColorSelect;
    private String bgImageSelect;
    private boolean noTemplate;
    private String publishedUrl;
    private String alias;
    private static boolean error;
    private List attachmentList;
    private boolean isValidDate = true;
    private boolean isValidStartDate = true;
    private boolean isValidDueDate = true;
    private boolean isValidRetractDate = true;
    private boolean isValidFeedbackDate = true;
    private String originalStartDateString;
    private String originalDueDateString;
    private String originalRetractDateString;
    private String originalFeedbackDateString;
    private boolean isMarkForReview;
    private String releaseToGroupsAsString;
    private String blockDivs;
    private String displayDateFormat;
    private SimpleDateFormat displayFormat;
    private static List months;
    private static List days;
    private static SelectItem[] mins;
    private static SelectItem[] hours;
    private String feedbackAuthoring;
    private boolean hasAttachment = false;
    private HashMap resourceHash = new HashMap();
    private String[] groupsAuthorized;
    private boolean noGroupSelectedError;

    public AssessmentFacade getAssessment() {
        return this.assessment;
    }

    public void setAssessment(AssessmentFacade assessment) {
        try {
            EvaluationModelIfc evaluation;
            AssessmentFeedbackIfc feedback;
            AssessmentService service = new AssessmentService();
            AssessmentTemplateFacade template = null;
            if (assessment.getAssessmentTemplateId() != null) {
                template = service.getAssessmentTemplate(assessment.getAssessmentTemplateId().toString());
            }
            if (template != null) {
                this.setNoTemplate(false);
                this.templateTitle = template.getTitle();
                this.templateDescription = template.getDescription();
                this.templateAuthors = template.getAssessmentMetaDataByLabel("author");
            } else {
                this.setNoTemplate(true);
            }
            this.assessment = assessment;
            this.setValueMap(assessment.getAssessmentMetaDataMap());
            this.assessmentId = assessment.getAssessmentId();
            this.title = assessment.getTitle();
            this.creator = AgentFacade.getDisplayName((String)assessment.getCreatedBy());
            this.description = assessment.getDescription();
            this.authors = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_AUTHORS");
            this.objectives = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_OBJECTIVES");
            this.keywords = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_KEYWORDS");
            this.rubrics = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_RUBRICS");
            this.bgColor = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGCOLOR");
            this.bgImage = assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGIMAGE");
            if (assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGIMAGE") != null && !assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGIMAGE").equals("")) {
                this.bgImageSelect = "1";
                this.bgColorSelect = null;
            } else {
                this.bgImageSelect = null;
                this.bgColorSelect = "1";
            }
            AssessmentAccessControlIfc accessControl = null;
            accessControl = assessment.getAssessmentAccessControl();
            if (accessControl != null) {
                this.startDate = accessControl.getStartDate();
                this.dueDate = accessControl.getDueDate();
                this.retractDate = accessControl.getRetractDate();
                this.feedbackDate = accessControl.getFeedbackDate();
                this.releaseTo = accessControl.getReleaseTo();
                this.publishingTargets = this.getPublishingTargets();
                this.targetSelected = this.getTargetSelected(this.releaseTo);
                this.firstTargetSelected = this.getFirstTargetSelected(this.releaseTo);
                if (!this.validateTarget(this.firstTargetSelected)) {
                    this.releaseTo = AgentFacade.getCurrentSiteName();
                    this.firstTargetSelected = AgentFacade.getCurrentSiteName();
                    this.targetSelected = this.getTargetSelected(this.releaseTo);
                }
                this.timeLimit = accessControl.getTimeLimit();
                if (this.timeLimit != null && this.timeLimit > 0) {
                    this.setTimeLimitDisplay(this.timeLimit.intValue());
                } else {
                    this.resetTimeLimitDisplay();
                }
                if (Integer.valueOf(1).equals(accessControl.getTimedAssessment())) {
                    this.timedAssessment = true;
                }
                this.autoSubmit = Integer.valueOf(1).equals(accessControl.getAutoSubmit());
                if (accessControl.getAssessmentFormat() != null) {
                    this.assessmentFormat = accessControl.getAssessmentFormat().toString();
                }
                if (accessControl.getItemNavigation() != null) {
                    this.itemNavigation = accessControl.getItemNavigation().toString();
                }
                if (accessControl.getItemNumbering() != null) {
                    this.itemNumbering = accessControl.getItemNumbering().toString();
                }
                if (accessControl.getSubmissionsSaved() != null) {
                    this.submissionsSaved = accessControl.getSubmissionsSaved().toString();
                }
                this.isMarkForReview = accessControl.getMarkForReview() != null && Integer.valueOf(1).equals(accessControl.getMarkForReview());
                if (accessControl.getUnlimitedSubmissions() != null && !accessControl.getUnlimitedSubmissions().booleanValue()) {
                    this.unlimitedSubmissions = AssessmentAccessControlIfc.LIMITED_SUBMISSIONS.toString();
                    this.submissionsAllowed = accessControl.getSubmissionsAllowed().toString();
                } else {
                    this.unlimitedSubmissions = AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS.toString();
                    this.submissionsAllowed = "";
                }
                if (accessControl.getLateHandling() != null) {
                    this.lateHandling = accessControl.getLateHandling().toString();
                }
                if (accessControl.getSubmissionsSaved() != null) {
                    this.submissionsSaved = accessControl.getSubmissionsSaved().toString();
                }
                this.submissionMessage = accessControl.getSubmissionMessage();
                this.username = accessControl.getUsername();
                this.password = accessControl.getPassword();
                this.finalPageUrl = accessControl.getFinalPageUrl();
            }
            if ((feedback = assessment.getAssessmentFeedback()) != null) {
                if (feedback.getFeedbackDelivery() != null) {
                    this.feedbackDelivery = feedback.getFeedbackDelivery().toString();
                }
                if (feedback.getFeedbackComponentOption() != null) {
                    this.feedbackComponentOption = feedback.getFeedbackComponentOption().toString();
                }
                if (feedback.getFeedbackAuthoring() != null) {
                    this.feedbackAuthoring = feedback.getFeedbackAuthoring().toString();
                }
                this.showQuestionText = Boolean.TRUE.equals(feedback.getShowQuestionText());
                this.showStudentResponse = Boolean.TRUE.equals(feedback.getShowStudentResponse());
                this.showCorrectResponse = Boolean.TRUE.equals(feedback.getShowCorrectResponse());
                this.showStudentScore = Boolean.TRUE.equals(feedback.getShowStudentScore());
                this.showStudentQuestionScore = Boolean.TRUE.equals(feedback.getShowStudentQuestionScore());
                this.showQuestionLevelFeedback = Boolean.TRUE.equals(feedback.getShowQuestionLevelFeedback());
                this.showSelectionLevelFeedback = Boolean.TRUE.equals(feedback.getShowSelectionLevelFeedback());
                this.showGraderComments = Boolean.TRUE.equals(feedback.getShowGraderComments());
                this.showStatistics = Boolean.TRUE.equals(feedback.getShowStatistics());
            }
            if ((evaluation = assessment.getEvaluationModel()) != null) {
                if (evaluation.getAnonymousGrading() != null) {
                    this.anonymousGrading = evaluation.getAnonymousGrading().toString();
                }
                if (evaluation.getToGradeBook() != null) {
                    this.toDefaultGradebook = evaluation.getToGradeBook();
                }
                if (evaluation.getScoringType() != null) {
                    this.scoringType = evaluation.getScoringType().toString();
                }
                String currentSiteId = AgentFacade.getCurrentSiteId();
                this.gradebookExists = gbsHelper.isGradebookExist(currentSiteId);
            }
            this.ipAddresses = "";
            Set ipAddressSet = assessment.getSecuredIPAddressSet();
            if (ipAddressSet != null) {
                for (SecuredIPAddressIfc ip : ipAddressSet) {
                    if (ip.getIpAddress() == null) continue;
                    this.ipAddresses = ip.getIpAddress() + "\n" + this.ipAddresses;
                }
            }
            this.attachmentList = assessment.getAssessmentAttachmentList();
            SecureDeliveryServiceAPI secureDeliveryService = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
            this.secureDeliveryAvailable = secureDeliveryService.isSecureDeliveryAvaliable();
            this.secureDeliveryModuleSelections = this.getSecureDeliverModuleSelections();
            this.secureDeliveryModule = assessment.getAssessmentMetaDataByLabel("SECURE_DELIVERY_MODULE_KEY");
            this.secureDeliveryModuleExitPassword = secureDeliveryService.decryptPassword(this.secureDeliveryModule, assessment.getAssessmentMetaDataByLabel("SECURE_DELIVERY_EXITPWD_KEY"));
            if (this.secureDeliveryModule == null) {
                this.secureDeliveryModule = "SECURE_DELIVERY_NONE_ID";
            } else if (!secureDeliveryService.isSecureDeliveryModuleAvailable(this.secureDeliveryModule)) {
                log.warn((Object)("Assessment " + this.assessmentId + " requires secure delivery module " + this.secureDeliveryModule + " but the module is no longer available. Secure delivery module will revert to NONE"));
                this.secureDeliveryModule = "SECURE_DELIVERY_NONE_ID";
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public String getBgColorSelect() {
        return this.bgColorSelect;
    }

    public void setBgColorSelect(String bgColorSelect) {
        this.bgColorSelect = bgColorSelect;
    }

    public String getBgImageSelect() {
        return this.bgImageSelect;
    }

    public void setBgImageSelect(String bgImageSelect) {
        this.bgImageSelect = bgImageSelect;
    }

    public String getOutcomeSave() {
        return this.outcomeSave;
    }

    public void setOutcomeSave(String outcomeSave) {
        this.outcomeSave = outcomeSave;
    }

    public String getOutcomePublish() {
        return this.outcomePublish;
    }

    public void setOutcomePublish(String outcomePublish) {
        this.outcomePublish = outcomePublish;
    }

    public Long getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(Long assessmentId) {
        this.assessmentId = assessmentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getObjectives() {
        return this.objectives;
    }

    public void setObjectives(String objectives) {
        this.objectives = objectives;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getRubrics() {
        return this.rubrics;
    }

    public void setRubrics(String rubrics) {
        this.rubrics = rubrics;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getBgColor() {
        if (this.getBgColorSelect() != null && this.getBgColorSelect().equals("1")) {
            return this.bgColor;
        }
        return "";
    }

    public void setBgColor(String bgColor) {
        this.bgColor = this.getBgColorSelect() != null && this.getBgColorSelect().equals("1") ? bgColor : "";
    }

    public String getBgImage() {
        if (this.getBgImageSelect() != null && this.getBgImageSelect().equals("1")) {
            return this.bgImage;
        }
        return "";
    }

    public void setBgImage(String bgImage) {
        this.bgImage = this.getBgImageSelect() != null && this.getBgImageSelect().equals("1") ? bgImage : "";
    }

    public boolean getHasQuestions() {
        return this.hasQuestions;
    }

    public void setHasQuestions(boolean hasQuestions) {
        this.hasQuestions = hasQuestions;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getFeedbackDate() {
        return this.feedbackDate;
    }

    public void setFeedbackDate(Date feedbackDate) {
        this.feedbackDate = feedbackDate;
    }

    public Date getRetractDate() {
        return this.retractDate;
    }

    public void setRetractDate(Date retractDate) {
        this.retractDate = retractDate;
    }

    public String getReleaseTo() {
        this.releaseTo = "";
        if (this.targetSelected != null) {
            for (int i = 0; i < this.targetSelected.length; ++i) {
                String user = this.targetSelected[i];
                this.releaseTo = !"".equals(this.releaseTo) ? this.releaseTo + ", " + user : user;
            }
        }
        return this.releaseTo;
    }

    public void setReleaseTo(String releaseTo) {
        this.releaseTo = releaseTo;
    }

    public Integer getTimeLimit() {
        return this.timedHours * 3600 + this.timedMinutes * 60 + this.timedSeconds;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void setTimedHours(Integer timedHours) {
        this.timedHours = timedHours;
    }

    public Integer getTimedHours() {
        return this.timedHours;
    }

    public void setTimedMinutes(Integer timedMinutes) {
        this.timedMinutes = timedMinutes;
    }

    public Integer getTimedMinutes() {
        return this.timedMinutes;
    }

    public void setTimedSeconds(Integer timedSeconds) {
        this.timedSeconds = timedSeconds;
    }

    public Integer getTimedSeconds() {
        return this.timedSeconds;
    }

    public boolean getTimedAssessment() {
        return this.timedAssessment;
    }

    public void setTimedAssessment(boolean timedAssessment) {
        this.timedAssessment = timedAssessment;
    }

    public boolean getAutoSubmit() {
        return this.autoSubmit;
    }

    public void setAutoSubmit(boolean autoSubmit) {
        this.autoSubmit = autoSubmit;
    }

    public String getAssessmentFormat() {
        return this.assessmentFormat;
    }

    public void setAssessmentFormat(String assessmentFormat) {
        this.assessmentFormat = assessmentFormat;
    }

    public String getItemNavigation() {
        return this.itemNavigation;
    }

    public void setItemNavigation(String itemNavigation) {
        this.itemNavigation = itemNavigation;
    }

    public String getItemNumbering() {
        return this.itemNumbering;
    }

    public void setItemNumbering(String itemNumbering) {
        this.itemNumbering = itemNumbering;
    }

    public String getUnlimitedSubmissions() {
        return this.unlimitedSubmissions;
    }

    public void setUnlimitedSubmissions(String unlimitedSubmissions) {
        String itemNavigationUpdated = ContextUtil.lookupParam((String)"itemNavigationUpdated");
        this.unlimitedSubmissions = itemNavigationUpdated != null && Boolean.parseBoolean(itemNavigationUpdated) ? (this.itemNavigation != null && "1".equals(this.itemNavigation) ? AssessmentAccessControlIfc.LIMITED_SUBMISSIONS.toString() : unlimitedSubmissions) : unlimitedSubmissions;
    }

    public String getSubmissionsAllowed() {
        return this.submissionsAllowed;
    }

    public void setSubmissionsAllowed(String submissionsAllowed) {
        String itemNavigationUpdated = ContextUtil.lookupParam((String)"itemNavigationUpdated");
        this.submissionsAllowed = itemNavigationUpdated != null && Boolean.parseBoolean(itemNavigationUpdated) ? (this.itemNavigation != null && "1".equals(this.itemNavigation) ? "1" : submissionsAllowed) : submissionsAllowed;
    }

    public void setLateHandling(String lateHandling) {
        this.lateHandling = lateHandling;
    }

    public String getLateHandling() {
        return this.lateHandling;
    }

    public void setSubmissionsSaved(String submissionSaved) {
        this.submissionsSaved = submissionSaved;
    }

    public String getSubmissionsSaved() {
        return this.submissionsSaved;
    }

    public void setSubmissionMessage(String submissionMessage) {
        this.submissionMessage = submissionMessage;
    }

    public String getSubmissionMessage() {
        return this.submissionMessage;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFinalPageUrl(String finalPageUrl) {
        this.finalPageUrl = finalPageUrl;
    }

    public String getFinalPageUrl() {
        return this.finalPageUrl;
    }

    public String getFeedbackDelivery() {
        return this.feedbackDelivery;
    }

    public void setFeedbackDelivery(String feedbackDelivery) {
        this.feedbackDelivery = feedbackDelivery;
    }

    public String getFeedbackComponentOption() {
        return this.feedbackComponentOption;
    }

    public void setFeedbackComponentOption(String feedbackComponentOption) {
        this.feedbackComponentOption = feedbackComponentOption;
    }

    public boolean getShowQuestionText() {
        return this.showQuestionText;
    }

    public void setShowQuestionText(boolean showQuestionText) {
        this.showQuestionText = showQuestionText;
    }

    public boolean getShowStudentResponse() {
        return this.showStudentResponse;
    }

    public void setShowStudentResponse(boolean showStudentResponse) {
        this.showStudentResponse = showStudentResponse;
    }

    public boolean getShowCorrectResponse() {
        return this.showCorrectResponse;
    }

    public void setShowCorrectResponse(boolean showCorrectResponse) {
        this.showCorrectResponse = showCorrectResponse;
    }

    public boolean getShowStudentScore() {
        return this.showStudentScore;
    }

    public void setShowStudentScore(boolean showStudentScore) {
        this.showStudentScore = showStudentScore;
    }

    public boolean getShowStudentQuestionScore() {
        return this.showStudentQuestionScore;
    }

    public void setShowStudentQuestionScore(boolean showStudentQuestionScore) {
        this.showStudentQuestionScore = showStudentQuestionScore;
    }

    public boolean getShowQuestionLevelFeedback() {
        return this.showQuestionLevelFeedback;
    }

    public void setShowQuestionLevelFeedback(boolean showQuestionLevelFeedback) {
        this.showQuestionLevelFeedback = showQuestionLevelFeedback;
    }

    public boolean getShowSelectionLevelFeedback() {
        return this.showSelectionLevelFeedback;
    }

    public void setShowSelectionLevelFeedback(boolean showSelectionLevelFeedback) {
        this.showSelectionLevelFeedback = showSelectionLevelFeedback;
    }

    public boolean getShowGraderComments() {
        return this.showGraderComments;
    }

    public void setShowGraderComments(boolean showGraderComments) {
        this.showGraderComments = showGraderComments;
    }

    public boolean getShowStatistics() {
        return this.showStatistics;
    }

    public void setShowStatistics(boolean showStatistics) {
        this.showStatistics = showStatistics;
    }

    public String getAnonymousGrading() {
        return this.anonymousGrading;
    }

    public void setAnonymousGrading(String anonymousGrading) {
        this.anonymousGrading = anonymousGrading;
    }

    public String getToDefaultGradebook() {
        return this.toDefaultGradebook;
    }

    public void setToDefaultGradebook(String toDefaultGradebook) {
        this.toDefaultGradebook = toDefaultGradebook;
    }

    public boolean getGradebookExists() {
        return this.gradebookExists;
    }

    public void setGradebookExists(boolean gradebookExists) {
        this.gradebookExists = gradebookExists;
    }

    public String getScoringType() {
        return this.scoringType;
    }

    public void setScoringType(String scoringType) {
        this.scoringType = scoringType;
    }

    public void setValue(String key, Object value) {
        this.values.put(key, value);
    }

    public Boolean getValue(String key) {
        Boolean returnValue = Boolean.FALSE;
        Object o = this.values.get(key);
        if ("true".equals((String)o)) {
            returnValue = Boolean.TRUE;
        }
        return returnValue;
    }

    public String getSecureDeliveryModule() {
        return this.secureDeliveryModule;
    }

    public void setSecureDeliveryModule(String secureDeliveryModule) {
        this.secureDeliveryModule = secureDeliveryModule;
    }

    public String getSecureDeliveryModuleExitPassword() {
        return this.secureDeliveryModuleExitPassword;
    }

    public void setSecureDeliveryModuleExitPassword(String secureDeliveryModuleExitPassword) {
        this.secureDeliveryModuleExitPassword = secureDeliveryModuleExitPassword;
    }

    public void setSecureDeliveryModuleSelections(SelectItem[] secureDeliveryModuleSelections) {
        this.secureDeliveryModuleSelections = secureDeliveryModuleSelections;
    }

    public SelectItem[] getSecureDeliveryModuleSelections() {
        return this.secureDeliveryModuleSelections;
    }

    public boolean isSecureDeliveryAvailable() {
        return this.secureDeliveryAvailable;
    }

    public void setSecureDeliveryAvailable(boolean secureDeliveryAvailable) {
        this.secureDeliveryAvailable = secureDeliveryAvailable;
    }

    public void setValueMap(HashMap newMap) {
        HashMap h = new HashMap();
        for (Map.Entry entry : newMap.entrySet()) {
            String key = (String)entry.getKey();
            Object o = entry.getValue();
            if ("ASSESSMENT_AUTHORS".equals(key) || "ASSESSMENT_KEYWORDS".equals(key) || "ASSESSMENT_OBJECTIVES".equals(key) || "ASSESSMENT_RUBRICS".equals(key) || "ASSESSMENT_BGCOLOR".equals(key) || "ASSESSMENT_BGIMAGE".equals(key) || "SECURE_DELIVERY_MODULE_KEY".equals(key) || "SECURE_DELIVERY_EXITPWD_KEY".equals(key)) continue;
            h.put(key, o);
        }
        this.values = h;
    }

    public HashMap getValueMap() {
        return this.values;
    }

    public String getDateString(Date date) {
        if (date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            int mon = c.get(2);
            int day = c.get(5);
            int year = c.get(1);
            String dateString = mon + "/" + day + "/" + year;
            return dateString;
        }
        return "";
    }

    public void setTimeLimitDisplay(int time) {
        this.timedHours = time / 60 / 60;
        this.timedMinutes = time / 60 % 60;
        this.timedSeconds = time % 60;
    }

    public void resetTimeLimitDisplay() {
        this.timedHours = 0;
        this.timedMinutes = 0;
        this.timedSeconds = 0;
    }

    public SelectItem[] getHours() {
        return hours;
    }

    public static void setHours(SelectItem[] hours) {
        AssessmentSettingsBean.hours = hours;
    }

    public SelectItem[] getMins() {
        return mins;
    }

    public static void setMins(SelectItem[] mins) {
        AssessmentSettingsBean.mins = mins;
    }

    public String getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(String ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    private String getDisplayFormatFromDate(Date date) {
        String dateString = "";
        if (date == null) {
            return dateString;
        }
        try {
            TimeUtil tu = new TimeUtil();
            dateString = tu.getDisplayDateTime(this.displayFormat, date);
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to format date.");
            ex.printStackTrace();
        }
        return dateString;
    }

    private Date getDateFromDisplayFormat(String dateString) {
        Date date = null;
        this.isValidDate = true;
        if (dateString == null || dateString.trim().equals("")) {
            return date;
        }
        if (this.displayDateFormat == null || this.displayFormat == null) {
            this.setDisplayFormat(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"output_data_picker_w_sec"));
        }
        try {
            if (!this.dateValidation(dateString)) {
                this.isValidDate = false;
                return null;
            }
            TimeUtil tu = new TimeUtil();
            date = tu.getServerDateTime(this.displayFormat, dateString);
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to format date.");
            FacesContext context = FacesContext.getCurrentInstance();
            ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
            String err = rb.getString("deliveryDate_error");
            context.addMessage(null, new FacesMessage(err));
            error = true;
        }
        return date;
    }

    private boolean dateValidation(String dateString) {
        int date = 0;
        int month = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        String amPM = "";
        String[] splittedDateString = dateString.split(" ");
        if (splittedDateString.length != 3) {
            return false;
        }
        String[] dateArray = splittedDateString[0].split("/");
        if (dateArray.length != 3) {
            return false;
        }
        try {
            if (this.displayDateFormat.toLowerCase().startsWith("dd")) {
                date = Integer.parseInt(dateArray[0]);
                month = Integer.parseInt(dateArray[1]);
                year = Integer.parseInt(dateArray[2].substring(0, 4));
            } else {
                date = Integer.parseInt(dateArray[1]);
                month = Integer.parseInt(dateArray[0]);
                year = Integer.parseInt(dateArray[2].substring(0, 4));
            }
        }
        catch (NumberFormatException ne) {
            log.error((Object)("NumberFormatException: " + ne.getMessage()));
            return false;
        }
        catch (IndexOutOfBoundsException ie) {
            log.error((Object)("IndexOutOfBoundsException: " + ie.getMessage()));
            return false;
        }
        if (month > 12 || month < 1) {
            return false;
        }
        if (!(month != 1 && month != 3 && month != 5 && month != 7 && month != 8 && month != 10 && month != 12 || date <= 31 && date >= 1)) {
            return false;
        }
        if (!(month != 4 && month != 6 && month != 9 && month != 11 || date <= 30 && date >= 1)) {
            return false;
        }
        if (month == 2) {
            if (date < 1) {
                return false;
            }
            if (this.isLeapYear(year) ? date > 29 : date > 28) {
                return false;
            }
        }
        String[] time = splittedDateString[1].split(":");
        if (splittedDateString.length != 3) {
            return false;
        }
        hour = Integer.parseInt(time[0]);
        minute = Integer.parseInt(time[1]);
        second = Integer.parseInt(time[2]);
        if (hour < 0 || hour > 24) {
            return false;
        }
        if (minute < 0 || minute > 60) {
            return false;
        }
        if (second < 0 || second > 60) {
            return false;
        }
        amPM = splittedDateString[2];
        return amPM.toUpperCase().equals("AM") || amPM.toUpperCase().equals("PM");
    }

    private boolean isLeapYear(int year) {
        return year % 100 == 0 ? year % 400 == 0 : year % 4 == 0;
    }

    public String getStartDateString() {
        if (!this.isValidStartDate) {
            return this.originalStartDateString;
        }
        return this.getDisplayFormatFromDate(this.startDate);
    }

    public void setStartDateString(String startDateString) {
        this.isValidStartDate = true;
        Date tempDate = this.getDateFromDisplayFormat(startDateString);
        if (!this.isValidDate) {
            this.isValidStartDate = false;
            this.originalStartDateString = startDateString;
        } else {
            this.startDate = tempDate;
        }
    }

    public String getDueDateString() {
        if (!this.isValidDueDate) {
            return this.originalDueDateString;
        }
        return this.getDisplayFormatFromDate(this.dueDate);
    }

    public void setDueDateString(String dueDateString) {
        this.isValidDueDate = true;
        Date tempDate = this.getDateFromDisplayFormat(dueDateString);
        if (!this.isValidDate) {
            this.isValidDueDate = false;
            this.originalDueDateString = dueDateString;
        } else {
            this.dueDate = tempDate;
        }
    }

    public String getRetractDateString() {
        if (!this.isValidRetractDate) {
            return this.originalRetractDateString;
        }
        return this.getDisplayFormatFromDate(this.retractDate);
    }

    public void setRetractDateString(String retractDateString) {
        this.isValidRetractDate = true;
        Date tempDate = this.getDateFromDisplayFormat(retractDateString);
        if (!this.isValidDate) {
            this.isValidRetractDate = false;
            this.originalRetractDateString = retractDateString;
        } else {
            this.retractDate = tempDate;
        }
    }

    public String getFeedbackDateString() {
        if (!this.isValidFeedbackDate) {
            return this.originalFeedbackDateString;
        }
        return this.getDisplayFormatFromDate(this.feedbackDate);
    }

    public void setFeedbackDateString(String feedbackDateString) {
        this.isValidFeedbackDate = true;
        Date tempDate = this.getDateFromDisplayFormat(feedbackDateString);
        if (!this.isValidDate) {
            this.isValidFeedbackDate = false;
            this.originalFeedbackDateString = feedbackDateString;
        } else {
            this.feedbackDate = tempDate;
        }
    }

    public String getTemplateTitle() {
        return this.templateTitle;
    }

    public void setTemplateTitle(String title) {
        this.templateTitle = title;
    }

    public String getTemplateAuthors() {
        return this.templateAuthors;
    }

    public void setTemplateAuthors(String templateAuthors) {
        this.templateAuthors = templateAuthors;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    public boolean getNoTemplate() {
        return this.noTemplate;
    }

    public void setNoTemplate(boolean noTemplate) {
        this.noTemplate = noTemplate;
    }

    public boolean validateTarget(String firstTarget) {
        HashMap targets = ptHelper.getTargets();
        return targets.get(firstTarget) != null;
    }

    public SelectItem[] getPublishingTargets() {
        HashMap targets = ptHelper.getTargets();
        Set e = targets.keySet();
        Iterator iter = e.iterator();
        int numSelections = this.getNumberOfGroupsForSite() > 0 ? 3 : 2;
        SelectItem[] target = new SelectItem[numSelections];
        while (iter.hasNext()) {
            ResourceLoader rb;
            String t = (String)iter.next();
            if ("Anonymous Users".equals(t)) {
                rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages");
                target[0] = new SelectItem((Object)t, rb.getString("anonymous_users"));
                continue;
            }
            if (numSelections == 3 && t.equals("Selected Groups")) {
                rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages");
                target[2] = new SelectItem((Object)t, rb.getString("selected_groups"));
                continue;
            }
            if (!t.equals(AgentFacade.getCurrentSiteName())) continue;
            target[1] = new SelectItem((Object)t, t);
        }
        return target;
    }

    public void setTargetSelected(String[] targetSelected) {
        this.targetSelected = targetSelected;
    }

    public String[] getTargetSelected() {
        return this.targetSelected;
    }

    public String[] getTargetSelected(String releaseTo) {
        if (releaseTo != null) {
            String[] releaseToArray = new String[]{releaseTo};
            this.targetSelected = releaseToArray;
        }
        return this.targetSelected;
    }

    public void setFirstTargetSelected(String firstTargetSelected) {
        this.firstTargetSelected = firstTargetSelected.trim();
        this.targetSelected[0] = firstTargetSelected.trim();
    }

    public String getFirstTargetSelected() {
        return this.firstTargetSelected;
    }

    public String getFirstTargetSelected(String releaseTo) {
        if (releaseTo != null) {
            String[] releaseToArray = new String[]{releaseTo};
            this.targetSelected = releaseToArray;
            this.firstTargetSelected = this.targetSelected[0].trim();
        }
        return this.firstTargetSelected;
    }

    public String getPublishedUrl() {
        return this.publishedUrl;
    }

    public void setPublishedUrl(String publishedUrl) {
        this.publishedUrl = publishedUrl;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String checkDate() {
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
        if (error) {
            String err = rb.getString("deliveryDate_error");
            context.addMessage(null, new FacesMessage(err));
            log.error((Object)"START DATE ADD MESSAGE");
            return "deliveryDate_error";
        }
        return "saveSettings";
    }

    public String getFeedbackAuthoring() {
        return this.feedbackAuthoring;
    }

    public void setFeedbackAuthoring(String feedbackAuthoring) {
        this.feedbackAuthoring = feedbackAuthoring;
    }

    public List getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List attachmentList) {
        this.attachmentList = attachmentList;
    }

    public boolean getHasAttachment() {
        if (this.attachmentList != null && this.attachmentList.size() > 0) {
            this.hasAttachment = true;
        }
        return this.hasAttachment;
    }

    public String addAttachmentsRedirect() {
        try {
            List filePickerList = new ArrayList();
            if (this.attachmentList != null) {
                filePickerList = this.prepareReferenceList(this.attachmentList);
            }
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("sakaiproject.filepicker.attachments", filePickerList);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.filepicker.helper/tool");
        }
        catch (Exception e) {
            log.error((Object)("fail to redirect to attachment page: " + e.getMessage()));
        }
        return "editAssessmentSettings";
    }

    public void setAssessmentAttachment() {
        SaveAssessmentAttachmentListener lis = new SaveAssessmentAttachmentListener(true);
        lis.processAction(null);
    }

    private List prepareReferenceList(List attachmentList) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        for (int i = 0; i < attachmentList.size(); ++i) {
            Reference ref;
            ContentResource cr = null;
            AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
            try {
                cr = AssessmentService.getContentHostingService().getResource(attach.getResourceId());
            }
            catch (PermissionException e) {
                log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
            }
            catch (IdUnusedException e) {
                log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
                AssessmentService assessmentService = new AssessmentService();
                assessmentService.removeAssessmentAttachment(attach.getAttachmentId().toString());
            }
            catch (TypeException e) {
                log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
            }
            if (cr == null || (ref = EntityManager.newReference((String)cr.getReference())) == null) continue;
            list.add(ref);
        }
        return list;
    }

    public HashMap getResourceHash() {
        return this.resourceHash;
    }

    public void setResourceHash(HashMap resourceHash) {
        this.resourceHash = resourceHash;
    }

    public void setDisplayFormat(String displayDateFormat) {
        this.displayDateFormat = displayDateFormat;
        this.displayFormat = new SimpleDateFormat(displayDateFormat);
    }

    public boolean getIsValidStartDate() {
        return this.isValidStartDate;
    }

    public boolean getIsValidDueDate() {
        return this.isValidDueDate;
    }

    public boolean getIsValidRetractDate() {
        return this.isValidRetractDate;
    }

    public boolean getIsValidFeedbackDate() {
        return this.isValidFeedbackDate;
    }

    public void resetIsValidDate() {
        this.isValidStartDate = true;
        this.isValidDueDate = true;
        this.isValidRetractDate = true;
        this.isValidFeedbackDate = true;
    }

    public void resetOriginalDateString() {
        this.originalStartDateString = "";
        this.originalDueDateString = "";
        this.originalRetractDateString = "";
        this.originalFeedbackDateString = "";
    }

    private String createUniqueKey(String key, Map map) {
        if (!map.containsKey(key)) {
            return key;
        }
        int index = 1;
        String ukey = key + " (" + index + ")";
        while (map.containsKey(ukey)) {
            ukey = key + " (" + ++index + ")";
        }
        return ukey;
    }

    public SelectItem[] getGroupsForSite() {
        SelectItem[] groupSelectItems = new SelectItem[]{};
        TreeMap<String, SelectItem> sortedSelectItems = new TreeMap<String, SelectItem>();
        Site site = null;
        try {
            site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
            Collection groups = site.getGroups();
            if (groups != null && groups.size() > 0) {
                groupSelectItems = new SelectItem[groups.size()];
                for (Group group : groups) {
                    String groupDescription = group.getDescription() == null || group.getDescription().equals("") ? "" : " : " + group.getDescription();
                    String selectDescription = this.createUniqueKey(groupDescription.toUpperCase(), sortedSelectItems);
                    String displayDescription = group.getTitle() + groupDescription;
                    sortedSelectItems.put(selectDescription, new SelectItem((Object)group.getId(), displayDescription));
                }
                Set keySet = sortedSelectItems.keySet();
                Iterator<Object> groupIter = keySet.iterator();
                int i = 0;
                while (groupIter.hasNext()) {
                    groupSelectItems[i++] = (SelectItem)sortedSelectItems.get(groupIter.next());
                }
            }
        }
        catch (IdUnusedException ex) {
            // empty catch block
        }
        return groupSelectItems;
    }

    public int getNumberOfGroupsForSite() {
        int numGroups = 0;
        try {
            Site site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
            Collection groups = site.getGroups();
            if (groups != null) {
                numGroups = groups.size();
            }
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        return numGroups;
    }

    public String[] getGroupsAuthorized() {
        List authorizations;
        this.groupsAuthorized = null;
        if (this.noGroupSelectedError) {
            return this.groupsAuthorized;
        }
        AuthzQueriesFacadeAPI authz = PersistenceService.getInstance().getAuthzQueriesFacade();
        if (authz != null && (authorizations = authz.getAuthorizationByFunctionAndQualifier("TAKE_ASSESSMENT", this.getAssessmentId().toString())) != null && authorizations.size() > 0) {
            this.groupsAuthorized = new String[authorizations.size()];
            Iterator authsIter = authorizations.iterator();
            int i = 0;
            while (authsIter.hasNext()) {
                AuthorizationData ad = (AuthorizationData)authsIter.next();
                this.groupsAuthorized[i++] = ad.getAgentIdString();
            }
        }
        return this.groupsAuthorized;
    }

    public void setGroupsAuthorized(String[] groupsAuthorized) {
        this.groupsAuthorized = groupsAuthorized;
    }

    public void setNoGroupSelectedError(boolean noGroupSelectedError) {
        this.noGroupSelectedError = noGroupSelectedError;
    }

    public String[] getGroupsAuthorizedToSave() {
        return this.groupsAuthorized;
    }

    public boolean getIsMarkForReview() {
        return this.isMarkForReview;
    }

    public void setIsMarkForReview(boolean isMarkForReview) {
        this.isMarkForReview = isMarkForReview;
    }

    public void setReleaseToGroupsAsString(String releaseToGroupsAsString) {
        this.releaseToGroupsAsString = releaseToGroupsAsString;
    }

    public String getReleaseToGroupsAsString() {
        return this.releaseToGroupsAsString;
    }

    public void setBlockDivs(String blockDivs) {
        this.blockDivs = blockDivs;
    }

    public String getBlockDivs() {
        return this.blockDivs;
    }

    public SelectItem[] getSecureDeliverModuleSelections() {
        SecureDeliveryServiceAPI secureDeliveryService = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
        SortedSet modules = secureDeliveryService.getSecureDeliveryModules(new ResourceLoader().getLocale());
        SelectItem[] selections = new SelectItem[modules.size()];
        int index = 0;
        for (RegisteredSecureDeliveryModuleIfc module : modules) {
            selections[index] = new SelectItem((Object)module.getId(), module.getName());
            ++index;
        }
        return selections;
    }

    static {
        int i;
        log = LogFactory.getLog(AssessmentSettingsBean.class);
        integrationContextFactory = IntegrationContextFactory.getInstance();
        gbsHelper = integrationContextFactory.getGradebookServiceHelper();
        ptHelper = integrationContextFactory.getPublishingTargetHelper();
        integrated = integrationContextFactory.isIntegrated();
        months = new ArrayList();
        for (i = 1; i <= 12; ++i) {
            months.add(new SelectItem((Object)i));
        }
        days = new ArrayList();
        for (i = 1; i < 32; ++i) {
            days.add(new SelectItem((Object)i));
        }
        hours = new SelectItem[24];
        for (i = 0; i < 24; ++i) {
            AssessmentSettingsBean.hours[i] = i < 10 ? new SelectItem((Object)i, "0" + i) : new SelectItem((Object)i, i + "");
        }
        mins = new SelectItem[60];
        for (i = 0; i < 60; ++i) {
            AssessmentSettingsBean.mins[i] = i < 10 ? new SelectItem((Object)i, "0" + i) : new SelectItem((Object)i, i + "");
        }
    }
}

