/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.shared.TypeService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;

public class PublishedAssessmentBeanie
implements Serializable {
    private static Log log = LogFactory.getLog(PublishedAssessmentBeanie.class);
    private static final long serialVersionUID = -630950053380808339L;
    private PublishedAssessmentFacade assessment;
    private String assessmentId;
    private String title;
    private ArrayList sections = new ArrayList();
    private ArrayList partNumbers = new ArrayList();
    private int questionSize = 0;
    private float totalScore = 0.0f;
    private String newQuestionTypeId;

    public PublishedAssessmentFacade getAssessment() {
        return this.assessment;
    }

    public void setAssessment(PublishedAssessmentFacade assessment) {
        try {
            this.assessment = assessment;
            this.assessmentId = assessment.getAssessmentId().toString();
            this.title = assessment.getTitle();
            this.sections = new ArrayList();
            ArrayList sectionArray = assessment.getSectionArraySorted();
            for (int i = 0; i < sectionArray.size(); ++i) {
                SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
                SectionContentsBean sectionBean = new SectionContentsBean(section);
                this.sections.add(sectionBean);
            }
            this.setPartNumbers();
            this.setQuestionSizeAndTotalScore();
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
        }
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(String assessmentId) {
        this.assessmentId = assessmentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ArrayList getSections() {
        return this.sections;
    }

    public void setSections(ArrayList sections) {
        this.sections = sections;
    }

    public ArrayList getPartNumbers() {
        return this.partNumbers;
    }

    public void setPartNumbers() {
        this.partNumbers = new ArrayList();
        for (int i = 1; i <= this.sections.size(); ++i) {
            this.partNumbers.add(new SelectItem((Object)(i + "")));
        }
    }

    public int getQuestionSize() {
        return this.questionSize;
    }

    public void setQuestionSizeAndTotalScore() {
        this.questionSize = 0;
        this.totalScore = 0.0f;
        for (int i = 0; i < this.sections.size(); ++i) {
            SectionContentsBean sectionBean = (SectionContentsBean)this.sections.get(i);
            ArrayList items = sectionBean.getItemContents();
            this.questionSize += items.size();
            for (int j = 0; j < items.size(); ++j) {
                ItemContentsBean item = (ItemContentsBean)items.get(j);
                if (item.getItemData().getScore() == null) continue;
                this.totalScore += item.getItemData().getScore().floatValue();
            }
        }
    }

    public float getTotalScore() {
        return this.totalScore;
    }

    public String getNewQuestionTypeId() {
        return this.newQuestionTypeId;
    }

    public void setNewQuestionTypeId(String newQuestionTypeId) {
        this.newQuestionTypeId = newQuestionTypeId;
    }

    public SelectItem[] getItemTypes() {
        TypeService service = new TypeService();
        List list = service.getFacadeItemTypes();
        SelectItem[] itemTypes = new SelectItem[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            TypeIfc t = (TypeIfc)list.get(i);
            itemTypes[i] = new SelectItem((Object)t.getTypeId().toString(), t.getKeyword());
        }
        return itemTypes;
    }
}

