/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.SectionBean;
import org.sakaiproject.tool.assessment.ui.listener.author.SavePartAttachmentListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

public class SectionBean
implements Serializable {
    private static Log log = LogFactory.getLog(SectionBean.class);
    private static final long serialVersionUID = 4216587136245498157L;
    private String assessmentTitle;
    private String assessmentId;
    private String showMetadata;
    private String sectionId;
    private String noOfItems;
    private String sectionTitle;
    private String sectionDescription;
    private ArrayList assessmentSectionIdents;
    private ArrayList poolsAvailable;
    private ArrayList items;
    private boolean random;
    private String randomPartScore;
    private String randomPartDiscount;
    private String removeAllQuestions;
    private SectionFacade section;
    private AssessmentIfc assessment;
    private String destSectionId;
    private String randomizationType;
    private boolean pointValueHasOverrided;
    private boolean discountValueHasOverrided;
    private String numberSelected;
    private String selectedPool;
    private String objective;
    private String keyword;
    private String rubric;
    private String type;
    private String questionOrdering;
    private boolean hideRandom = false;
    private boolean hideOneByOne = false;
    private String outcome;
    private List attachmentList;
    private boolean hasAttachment = false;
    private HashMap resourceHash = new HashMap();

    public void setSection(SectionFacade section) {
        try {
            if (section == null) {
                this.section = null;
            } else {
                this.section = section;
                this.assessment = section.getAssessment();
                this.assessmentId = this.assessment.getAssessmentId().toString();
                this.assessmentTitle = this.assessment.getTitle();
                this.sectionId = section.getSectionId().toString();
                this.sectionTitle = section.getTitle();
                this.sectionDescription = section.getDescription();
                this.attachmentList = section.getSectionAttachmentList();
                if (this.attachmentList != null && this.attachmentList.size() > 0) {
                    this.hasAttachment = true;
                }
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Unable to set section. Exception thrown from setSection(): " + ex.getMessage()));
        }
    }

    public SectionFacade getSection() {
        return this.section;
    }

    public boolean getHideRandom() {
        return this.hideRandom;
    }

    public void setHideRandom(boolean param) {
        this.hideRandom = param;
    }

    public boolean getHideOneByOne() {
        return this.hideOneByOne;
    }

    public void setHideOneByOne(boolean param) {
        this.hideOneByOne = param;
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public String getAssessmentTitle() {
        return this.assessmentTitle;
    }

    public void setAssessmentId(String string) {
        this.assessmentId = string;
    }

    public void setAssessmentTitle(String string) {
        this.assessmentTitle = string;
    }

    public String getShowMetadata() {
        return this.showMetadata;
    }

    public void setShowMetadata(String string) {
        this.showMetadata = string;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getSectionIdent() {
        return this.getSectionId();
    }

    public void setSectionId(String string) {
        this.sectionId = string;
    }

    public void setSectionIdent(String string) {
        this.setSectionId(string);
    }

    public ArrayList getAssessmentSectionIdents() {
        return this.assessmentSectionIdents;
    }

    public void setAssessmentSectionIdents(ArrayList list) {
        this.assessmentSectionIdents = list;
    }

    public ArrayList getSectionNumberList() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        if (this.assessmentSectionIdents == null) {
            return list;
        }
        for (int i = 0; i < this.assessmentSectionIdents.toArray().length; ++i) {
            SelectItem selection = new SelectItem();
            selection.setLabel("" + i);
            selection.setValue((Object)("" + i));
            list.add(selection);
        }
        return list;
    }

    public ArrayList getAuthorTypeList() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
        if (this.hideRandom) {
            SelectItem selection = new SelectItem();
            selection.setLabel(rb.getString("type_onebyone"));
            selection.setValue((Object)"1");
            list.add(selection);
        } else {
            SelectItem selection = new SelectItem();
            selection.setLabel(rb.getString("type_onebyone"));
            selection.setValue((Object)"1");
            list.add(selection);
            SelectItem selection1 = new SelectItem();
            selection1.setLabel(rb.getString("random_draw_from_que"));
            selection1.setValue((Object)"2");
            list.add(selection1);
        }
        return list;
    }

    public String getSelectedSection() {
        return "" + this.assessmentSectionIdents.indexOf(this.sectionId);
    }

    public int getTotalSections() {
        return this.assessmentSectionIdents.size();
    }

    public ArrayList getPoolsAvailable() {
        int currItems;
        QuestionPoolFacade currPool;
        ArrayList<SelectItem> resultPoolList = new ArrayList<SelectItem>();
        if (this.getType() != null && this.getType().equals(SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString())) {
            this.setSelectedPool("");
            this.setNumberSelected("");
            return resultPoolList;
        }
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        QuestionPoolService delegate = new QuestionPoolService();
        ArrayList allpoollist = delegate.getBasicInfoOfAllPools(AgentFacade.getAgentString());
        HashMap<String, QuestionPoolFacade> allPoolsMap = new HashMap<String, QuestionPoolFacade>();
        for (int i = 0; i < allpoollist.size(); ++i) {
            QuestionPoolFacade apool = (QuestionPoolFacade)allpoollist.get(i);
            allPoolsMap.put(apool.getQuestionPoolId().toString(), apool);
        }
        Object assessdelegate = null;
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        assessdelegate = isEditPendingAssessmentFlow ? new AssessmentService() : new PublishedAssessmentService();
        ArrayList sectionList = assessmentBean.getSectionList();
        for (int i = 0; i < sectionList.size(); ++i) {
            String poolid;
            SelectItem s = (SelectItem)sectionList.get(i);
            SectionFacade section = assessdelegate.getSection(s.getValue().toString());
            if (section == null || section.getSectionMetaDataByLabel("AUTHOR_TYPE") == null || !section.getSectionMetaDataByLabel("AUTHOR_TYPE").equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString()) || !allPoolsMap.containsKey(poolid = section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW"))) continue;
            allPoolsMap.remove(poolid);
        }
        Iterator pooliter = allPoolsMap.keySet().iterator();
        while (pooliter.hasNext()) {
            QuestionPoolFacade pool = (QuestionPoolFacade)allPoolsMap.get(pooliter.next());
            int items = delegate.getCountItems(pool.getQuestionPoolId());
            if (items <= 0) continue;
            String resultListName = FormattedText.convertFormattedTextToPlaintext((String)pool.getDisplayName()) + "(" + items + ")";
            resultPoolList.add(new SelectItem((Object)pool.getQuestionPoolId().toString(), resultListName));
        }
        if (!"".equals(this.getSelectedPool()) && this.getSelectedPool() != null && (currPool = delegate.getPool(new Long(this.getSelectedPool()), AgentFacade.getAgentString())) != null && (currItems = delegate.getCountItems(currPool.getQuestionPoolId())) > 0) {
            String currPoolName = FormattedText.convertFormattedTextToPlaintext((String)currPool.getDisplayName()) + "(" + currItems + ")";
            resultPoolList.add(new SelectItem((Object)currPool.getQuestionPoolId().toString(), currPoolName));
        }
        Collections.sort(resultPoolList, new ItemComparator(this));
        return resultPoolList;
    }

    public void setPoolsAvailable(ArrayList list) {
        this.poolsAvailable = list;
    }

    public String getNoOfItems() {
        return this.noOfItems;
    }

    public void setNoOfItems(String string) {
        this.noOfItems = string;
    }

    public ArrayList getItemNumberList() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (int i = 0; i < this.items.toArray().length; ++i) {
            SelectItem selection = new SelectItem();
            selection.setLabel("" + i);
            selection.setValue((Object)("" + i));
            list.add(selection);
        }
        return list;
    }

    public String getSectionTitle() {
        return this.sectionTitle;
    }

    public void setSectionTitle(String string) {
        this.sectionTitle = string;
    }

    public String getSectionDescription() {
        return this.sectionDescription;
    }

    public void setSectionDescription(String string) {
        this.sectionDescription = string;
    }

    public String getNumberSelected() {
        return this.numberSelected;
    }

    public void setNumberSelected(String string) {
        this.numberSelected = string;
    }

    public boolean getRandom() {
        return this.random;
    }

    public ArrayList getItems() {
        return this.items;
    }

    public void setRandom(boolean bool) {
        this.random = bool;
    }

    public void setItems(ArrayList items) {
        this.items = items;
    }

    public String getRandomPartScore() {
        if (this.randomPartScore != null) {
            return this.randomPartScore;
        }
        if (this.section == null) {
            return "";
        }
        if (this.section.getSectionMetaDataByLabel("POINT_VALUE_FOR_QUESTION") != null) {
            return this.section.getSectionMetaDataByLabel("POINT_VALUE_FOR_QUESTION");
        }
        return "";
    }

    public void setRandomPartScore(String score) {
        this.randomPartScore = score;
    }

    public String getRandomPartDiscount() {
        if (this.randomPartDiscount != null) {
            return this.randomPartDiscount;
        }
        if (this.section == null) {
            return "";
        }
        if (this.section.getSectionMetaDataByLabel("DISCOUNT_VALUE_FOR_QUESTION") != null) {
            return this.section.getSectionMetaDataByLabel("DISCOUNT_VALUE_FOR_QUESTION");
        }
        return "";
    }

    public void setRandomPartDiscount(String discount) {
        this.randomPartDiscount = discount;
    }

    public String getRemoveAllQuestions() {
        return this.removeAllQuestions;
    }

    public void setRemoveAllQuestions(String removeAllQuestions) {
        this.removeAllQuestions = removeAllQuestions;
    }

    public String getDestSectionId() {
        return this.destSectionId;
    }

    public void setDestSectionId(String destSectionId) {
        this.destSectionId = destSectionId;
    }

    public String getSelectedPool() {
        return this.selectedPool;
    }

    public void setSelectedPool(String selectedPool) {
        this.selectedPool = selectedPool;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String param) {
        this.keyword = param;
    }

    public String getObjective() {
        return this.objective;
    }

    public void setObjective(String param) {
        this.objective = param;
    }

    public String getRubric() {
        return this.rubric;
    }

    public void setRubric(String param) {
        this.rubric = param;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String param) {
        this.type = param;
    }

    public String getQuestionOrdering() {
        return this.questionOrdering;
    }

    public void setQuestionOrdering(String param) {
        this.questionOrdering = param;
    }

    public void toggleAuthorType(ValueChangeEvent event) {
        String type = (String)event.getNewValue();
        if (type == null || type.equals(SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString())) {
            this.setType(SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
        } else if (type.equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
            this.setType(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString());
        }
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String param) {
        this.outcome = param;
    }

    public List getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List attachmentList) {
        this.attachmentList = attachmentList;
    }

    public boolean getHasAttachment() {
        return this.hasAttachment;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.hasAttachment = hasAttachment;
    }

    public String addAttachmentsRedirect() {
        try {
            List filePickerList = new ArrayList();
            if (this.attachmentList != null) {
                filePickerList = this.prepareReferenceList(this.attachmentList);
            }
            log.debug((Object)("**filePicker list=" + filePickerList.size()));
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("sakaiproject.filepicker.attachments", filePickerList);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.filepicker.helper/tool");
        }
        catch (Exception e) {
            log.error((Object)("fail to redirect to attachment page: " + e.getMessage()));
        }
        return this.getOutcome();
    }

    public void setPartAttachment() {
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        SavePartAttachmentListener lis = null;
        lis = isEditPendingAssessmentFlow ? new SavePartAttachmentListener(true) : new SavePartAttachmentListener(false);
        lis.processAction(null);
    }

    private List prepareReferenceList(List attachmentList) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        for (int i = 0; i < attachmentList.size(); ++i) {
            ContentResource cr = null;
            AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
            try {
                cr = AssessmentService.getContentHostingService().getResource(attach.getResourceId());
            }
            catch (PermissionException e) {
                log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
            }
            catch (IdUnusedException e) {
                log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
                AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
                boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
                Object assessmentService = null;
                assessmentService = isEditPendingAssessmentFlow ? new AssessmentService() : new PublishedAssessmentService();
                assessmentService.removeSectionAttachment(attach.getAttachmentId().toString());
            }
            catch (TypeException e) {
                log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
            }
            if (cr == null) continue;
            if (this.resourceHash == null) {
                this.resourceHash = new HashMap();
            }
            this.resourceHash.put(attach.getResourceId(), cr);
            Reference ref = EntityManager.newReference((String)cr.getReference());
            if (ref == null) continue;
            list.add(ref);
        }
        return list;
    }

    public HashMap getResourceHash() {
        return this.resourceHash;
    }

    public void setResourceHash(HashMap resourceHash) {
        this.resourceHash = resourceHash;
    }

    public ArrayList getRandomizationTypeList() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
        SelectItem selection = new SelectItem();
        selection.setLabel(rb.getString("randomized_per_submission"));
        selection.setValue((Object)"1");
        list.add(selection);
        selection = new SelectItem();
        selection.setLabel(rb.getString("randomized_per_student"));
        selection.setValue((Object)"2");
        list.add(selection);
        return list;
    }

    public String getRandomizationType() {
        return this.randomizationType;
    }

    public void setRandomizationType(String randomizationType) {
        this.randomizationType = randomizationType;
    }

    public boolean getPointValueHasOverrided() {
        return this.pointValueHasOverrided;
    }

    public void setPointValueHasOverrided(boolean pointValueHasOverrided) {
        this.pointValueHasOverrided = pointValueHasOverrided;
    }

    public boolean getDiscountValueHasOverrided() {
        return this.discountValueHasOverrided;
    }

    public void setDiscountValueHasOverrided(boolean discountValueHasOverrided) {
        this.discountValueHasOverrided = discountValueHasOverrided;
    }
}

