/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.delivery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.MediaIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PublishedItemService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SelectionBean;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.AttachmentUtil;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemContentsBean
implements Serializable {
    private static final long serialVersionUID = 6270034338280029897L;
    private static Log log = LogFactory.getLog(ItemContentsBean.class);
    private static ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.DeliveryMessages");
    private boolean review;
    private boolean unanswered;
    private ItemDataIfc itemData;
    private String gradingComment;
    private String feedback;
    private String responseId = "2";
    private String responseText = "";
    private String[] responseIds = null;
    private float points;
    private float discount;
    private float maxPoints;
    private int number;
    private ArrayList itemGradingDataArray;
    private ArrayList answers;
    private String instruction;
    private String rationale;
    private ArrayList matchingArray;
    private ArrayList fibArray;
    private ArrayList finArray;
    private ArrayList<SelectionBean> selectionArray;
    private String key;
    private String sequence;
    private ArrayList shuffledAnswers;
    private ArrayList mediaArray;
    private Integer duration;
    private Integer triesAllowed;
    private Integer attemptsRemaining;
    private boolean showStudentScore;
    private boolean showStudentQuestionScore;
    private boolean isInvalidFinInput;
    private boolean isInvalidSALengthInput;
    private String saCharCount;
    private String pointsDisplayString;
    private List itemGradingAttachmentList;
    private Long itemGradingIdForFilePicker;
    private boolean forceRanking;
    private int relativeWidth;
    private ArrayList matrixArray;
    private List<Integer> columnIndexList;
    private String[] columnArray;
    private String commentField;
    private boolean addComment;
    private String studentComment;
    private boolean hasItemGradingAttachment = false;

    public ItemContentsBean() {
    }

    public ItemContentsBean(ItemDataIfc itemData) {
        this.itemData = itemData;
        this.setInstruction(this.itemData.getInstruction());
        Integer sequence = this.itemData.getSequence();
        if (sequence != null) {
            this.setNumber(sequence.intValue());
        } else {
            this.setNumber(1);
        }
    }

    public String getText() {
        String text = "";
        if (this.itemData != null) {
            text = this.itemData.getText();
        }
        return text;
    }

    public String getStrippedText() {
        return this.strip(this.getText());
    }

    public boolean getModelAnswerIsNotEmpty() {
        String k = this.getKey();
        if (k != null) {
            return this.isNotEmpty(this.strip(ContextUtil.stringWYSIWYG((String)k)));
        }
        return false;
    }

    public boolean getFeedbackIsNotEmpty() {
        return this.isNotEmpty(this.strip(ContextUtil.stringWYSIWYG((String)this.getFeedback())));
    }

    public boolean getGradingCommentIsNotEmpty() {
        return this.isNotEmpty(this.strip(this.getGradingComment()));
    }

    public String getStrippedKey() {
        return this.strip(this.getKey());
    }

    public float getPoints() {
        return SectionContentsBean.roundTo2Decimals((float)this.points);
    }

    public float getExactPoints() {
        return this.points;
    }

    public void setPoints(float points) {
        this.points = points;
    }

    public String getPointsForEdit() {
        return Float.toString(this.getPoints());
    }

    public void setPointsForEdit(String pointsForEdit) {
        if (pointsForEdit == null || pointsForEdit.equals("")) {
            pointsForEdit = "0";
        }
        this.setPoints(Float.parseFloat(pointsForEdit));
    }

    public float getDiscount() {
        return SectionContentsBean.roundTo2Decimals((float)this.discount);
    }

    public float getExactDiscount() {
        return this.discount;
    }

    public void setDiscount(float discount) {
        this.discount = discount;
    }

    public String getDiscountForEdit() {
        return Float.toString(this.getDiscount());
    }

    public void setDiscountForEdit(String discountForEdit) {
        if (discountForEdit == null || discountForEdit.equals("")) {
            discountForEdit = "0";
        }
        this.setDiscount(Float.parseFloat(discountForEdit));
    }

    public boolean getReview() {
        if (this.getItemGradingDataArray().isEmpty()) {
            return false;
        }
        ItemGradingData data = (ItemGradingData)this.getItemGradingDataArray().toArray()[0];
        if (data.getReview() == null) {
            return false;
        }
        return data.getReview();
    }

    public void setReview(boolean preview) {
        log.debug((Object)("setReview():  preview = " + preview));
        if (this.getItemGradingDataArray().isEmpty()) {
            log.debug((Object)("setReview():  isEmpty = " + preview));
            ItemGradingData data = new ItemGradingData();
            data.setPublishedItemId(this.itemData.getItemId());
            if (this.itemData.getItemTextSet().size() > 0) {
                ItemTextIfc itemText = (ItemTextIfc)this.itemData.getItemTextSet().toArray()[0];
                data.setPublishedItemTextId(itemText.getId());
            }
            ArrayList<ItemGradingData> items = new ArrayList<ItemGradingData>();
            items.add(data);
            this.setItemGradingDataArray(items);
        }
        Iterator iter = this.getItemGradingDataArray().iterator();
        log.debug((Object)("setReview():  getItemGradingDataArray size = " + this.getItemGradingDataArray().size()));
        while (iter.hasNext()) {
            ItemGradingData data = (ItemGradingData)iter.next();
            log.debug((Object)("setReview():  setreview at the end = " + preview));
            data.setReview(Boolean.valueOf(preview));
        }
    }

    public boolean isUnanswered() {
        ArrayList itemgradingdataArray = this.getItemGradingDataArray();
        if (itemgradingdataArray.isEmpty()) {
            return true;
        }
        Iterator iter = itemgradingdataArray.iterator();
        int itemgradingsize = itemgradingdataArray.size();
        int publishedanswer_notnull = 0;
        if (this.getItemData().getTypeId().equals(TypeIfc.MATCHING)) {
            while (iter.hasNext()) {
                ItemGradingData data = (ItemGradingData)iter.next();
                if (data.getPublishedAnswerId() == null) continue;
                ++publishedanswer_notnull;
            }
            return publishedanswer_notnull != itemgradingsize;
        }
        while (iter.hasNext()) {
            ItemGradingData data = (ItemGradingData)iter.next();
            if (!(this.getItemData().getTypeId().equals(TypeIfc.ESSAY_QUESTION) || this.getItemData().getTypeId().equals(TypeIfc.FILL_IN_BLANK) || this.getItemData().getTypeId().equals(TypeIfc.FILL_IN_NUMERIC) ? data.getAnswerText() != null && !data.getAnswerText().equals("") : data.getPublishedAnswerId() != null || data.getAnswerText() != null)) continue;
            return false;
        }
        return true;
    }

    public void setUnanswered(boolean unanswered) {
        this.unanswered = unanswered;
    }

    public boolean getUnanswered() {
        return this.unanswered;
    }

    public float getMaxPoints() {
        return this.maxPoints;
    }

    public float getRoundedMaxPoints() {
        return SectionContentsBean.roundTo2Decimals((float)this.maxPoints);
    }

    public void setMaxPoints(float maxPoints) {
        this.maxPoints = maxPoints;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        this.itemData.setSequence(Integer.valueOf(number));
    }

    public ItemDataIfc getItemData() {
        return this.itemData;
    }

    public void setItemData(ItemDataIfc itemData) {
        this.itemData = itemData;
    }

    public String getGradingComment() {
        if (this.gradingComment == null) {
            return "";
        }
        return this.gradingComment;
    }

    public void setGradingComment(String gradingComment) {
        this.gradingComment = gradingComment;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public boolean getIsTrue() {
        if (this.itemData != null) {
            return this.itemData.getIsTrue();
        }
        return false;
    }

    public ArrayList getItemGradingDataArray() {
        if (this.itemGradingDataArray == null) {
            return new ArrayList();
        }
        return this.itemGradingDataArray;
    }

    public void setItemGradingDataArray(ArrayList newArray) {
        this.itemGradingDataArray = newArray;
    }

    public String getResponseId() {
        try {
            if (this.selectionArray != null) {
                for (SelectionBean bean : this.selectionArray) {
                    if (!bean.getResponse()) continue;
                    return bean.getAnswer().getId().toString();
                }
                return "";
            }
        }
        catch (Exception e) {
            log.debug((Object)("get ResponseId(), okay with t/f. " + e.getMessage()));
        }
        try {
            ItemGradingData data;
            String response = "";
            Iterator iter = this.getItemGradingDataArray().iterator();
            if (iter.hasNext() && (data = (ItemGradingData)iter.next()).getPublishedAnswerId() != null) {
                response = data.getPublishedAnswerId().toString();
            }
            return response;
        }
        catch (Exception e) {
            log.debug((Object)("get ResponseId() , okay with t/f. " + e.getMessage()));
            return this.responseId;
        }
    }

    public void setResponseId(String presponseId) {
        try {
            this.responseId = presponseId;
            if (this.selectionArray != null && presponseId != null && !presponseId.trim().equals("")) {
                for (SelectionBean bean : this.selectionArray) {
                    if (bean.getAnswer().getId().toString().equals(presponseId)) {
                        bean.setResponse(true);
                        continue;
                    }
                    bean.setResponse(false);
                }
            }
            return;
        }
        catch (RuntimeException e) {
            log.debug((Object)"ClassCastException is okay, the question might be true/false. ");
            try {
                Iterator iter = this.getItemGradingDataArray().iterator();
                if (!iter.hasNext() && (presponseId == null || presponseId.equals(""))) {
                    return;
                }
                ItemGradingData data = null;
                if (iter.hasNext()) {
                    data = (ItemGradingData)iter.next();
                } else {
                    data = new ItemGradingData();
                    data.setPublishedItemId(this.itemData.getItemId());
                    ItemTextIfc itemText = (ItemTextIfc)this.itemData.getItemTextSet().toArray()[0];
                    data.setPublishedItemTextId(itemText.getId());
                    ArrayList<ItemGradingData> items = new ArrayList<ItemGradingData>();
                    items.add(data);
                    this.setItemGradingDataArray(items);
                }
                for (AnswerIfc answer : ((ItemTextIfc)this.itemData.getItemTextSet().toArray()[0]).getAnswerSet()) {
                    if (!answer.getId().toString().equals(this.responseId)) continue;
                    data.setPublishedAnswerId(answer.getId());
                    break;
                }
            }
            catch (RuntimeException e2) {
                e2.printStackTrace();
            }
            return;
        }
    }

    public String[] getResponseIds() {
        try {
            String[] response = new String[this.getItemGradingDataArray().size()];
            Iterator iter = this.getItemGradingDataArray().iterator();
            int i = 0;
            while (iter.hasNext()) {
                ItemGradingData data = (ItemGradingData)iter.next();
                if (data.getPublishedAnswerId() != null) {
                    response[i++] = data.getPublishedAnswerId().toString();
                    continue;
                }
                response[i++] = null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public void setResponseIds(String[] presponseIds) {
        try {
            ArrayList<ItemGradingData> newItems = new ArrayList<ItemGradingData>();
            this.responseIds = presponseIds;
            if (this.getItemGradingDataArray().isEmpty() && (presponseIds == null || presponseIds.length == 0)) {
                return;
            }
            for (int i = 0; i < presponseIds.length; ++i) {
                ItemGradingData data = null;
                for (ItemGradingData temp : this.getItemGradingDataArray()) {
                    if (temp.getPublishedAnswerId() == null || !temp.getPublishedAnswerId().toString().equals(presponseIds[i])) continue;
                    data = temp;
                }
                if (data == null) {
                    data = new ItemGradingData();
                    data.setPublishedItemId(this.itemData.getItemId());
                    ItemTextIfc itemText = (ItemTextIfc)this.itemData.getItemTextSet().toArray()[0];
                    data.setPublishedItemTextId(itemText.getId());
                    for (AnswerIfc answer : itemText.getAnswerSet()) {
                        if (!answer.getId().toString().equals(presponseIds[i])) continue;
                        data.setPublishedAnswerId(answer.getId());
                    }
                }
                newItems.add(data);
            }
            this.setItemGradingDataArray(newItems);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getResponseText() {
        log.debug((Object)"itemcontentbean.getResponseText");
        try {
            String response = this.responseText;
            Iterator iter = this.getItemGradingDataArray().iterator();
            if (iter.hasNext()) {
                ItemGradingData data = (ItemGradingData)iter.next();
                response = data.getAnswerText();
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.responseText;
        }
    }

    public String getResponseTextPlain() {
        return FormattedText.convertFormattedTextToPlaintext((String)this.getResponseText());
    }

    public String getResponseTextForDisplay() {
        log.debug((Object)"itemcontentbean.getResponseText");
        try {
            String response = this.responseText;
            Iterator iter = this.getItemGradingDataArray().iterator();
            if (iter.hasNext()) {
                ItemGradingData data = (ItemGradingData)iter.next();
                response = data.getAnswerText();
            }
            if (response != null) {
                response = response.replaceAll("(\r\n|\r)", "<br/>");
                return response;
            }
            return this.responseText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.responseText;
        }
    }

    public void setResponseTextPlain(String presponseId) {
        this.setResponseText(presponseId);
    }

    public void setResponseText(String presponseId) {
        log.debug((Object)"itemcontentbean.setResponseText");
        try {
            this.responseText = presponseId;
            Iterator iter = this.getItemGradingDataArray().iterator();
            if (!iter.hasNext() && (presponseId == null || presponseId.equals(""))) {
                return;
            }
            ItemGradingData data = null;
            if (iter.hasNext()) {
                data = (ItemGradingData)iter.next();
            } else {
                data = new ItemGradingData();
                data.setPublishedItemId(this.itemData.getItemId());
                ItemTextIfc itemText = (ItemTextIfc)this.itemData.getItemTextSet().toArray()[0];
                data.setPublishedItemTextId(itemText.getId());
                ArrayList<ItemGradingData> items = new ArrayList<ItemGradingData>();
                items.add(data);
                this.setItemGradingDataArray(items);
            }
            data.setAnswerText(presponseId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getMatchingArray() {
        return this.matchingArray;
    }

    public void setMatchingArray(ArrayList newArray) {
        this.matchingArray = newArray;
    }

    public ArrayList getFibArray() {
        return this.fibArray;
    }

    public void setFibArray(ArrayList newArray) {
        this.fibArray = newArray;
    }

    public ArrayList getFinArray() {
        return this.finArray;
    }

    public void setFinArray(ArrayList newArray) {
        this.finArray = newArray;
    }

    public ArrayList getSelectionArray() {
        return this.selectionArray;
    }

    public void setSelectionArray(ArrayList newArray) {
        this.selectionArray = newArray;
    }

    public ArrayList getMatrixArray() {
        return this.matrixArray;
    }

    public void setMatrixArray(ArrayList newArray) {
        this.matrixArray = newArray;
    }

    public List<Integer> getColumnIndexList() {
        return this.columnIndexList;
    }

    public void setColumnIndexList(List<Integer> columnIndexList) {
        this.columnIndexList = columnIndexList;
    }

    public String[] getColumnArray() {
        return this.columnArray;
    }

    public void setColumnArray(String[] columnArray) {
        this.columnArray = columnArray;
    }

    public boolean getForceRanking() {
        return this.forceRanking;
    }

    public void setForceRanking(boolean forceRanking) {
        this.forceRanking = forceRanking;
    }

    public int getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(int param) {
        this.relativeWidth = param;
    }

    public boolean getAddComment() {
        return this.addComment;
    }

    public void setAddComment(boolean param) {
        this.addComment = param;
    }

    public String getCommentField() {
        return this.commentField;
    }

    public void setCommentField(String param) {
        this.commentField = param;
    }

    public String getStudentComment() {
        try {
            String comment = this.studentComment;
            Iterator iter = this.getItemGradingDataArray().iterator();
            if (iter.hasNext()) {
                ItemGradingData data = (ItemGradingData)iter.next();
                comment = data.getAnswerText();
            }
            return comment;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.studentComment;
        }
    }

    public void setStudentComment(String param) {
        try {
            this.studentComment = param;
            Iterator iter = this.getItemGradingDataArray().iterator();
            if (!iter.hasNext() && (param == null || param.equals(""))) {
                return;
            }
            ItemGradingData data = null;
            if (iter.hasNext()) {
                data = (ItemGradingData)iter.next();
            } else {
                data = new ItemGradingData();
                data.setPublishedItemId(this.itemData.getItemId());
                ItemTextIfc itemText = (ItemTextIfc)this.itemData.getItemTextSet().toArray()[0];
                data.setPublishedItemTextId(itemText.getId());
                ArrayList<ItemGradingData> items = new ArrayList<ItemGradingData>();
                items.add(data);
                this.setItemGradingDataArray(items);
            }
            data.setAnswerText(param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getAnswers() {
        return this.answers;
    }

    public void setAnswers(ArrayList list) {
        this.answers = list;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setRationale(String newRationale) {
        ArrayList items;
        int count = this.getItemGradingDataArray().size();
        ItemGradingData data = null;
        if (count <= 0) {
            data = new ItemGradingData();
            data.setPublishedItemId(this.itemData.getItemId());
            ItemTextIfc itemText = (ItemTextIfc)this.itemData.getItemTextSet().toArray()[0];
            data.setPublishedItemTextId(itemText.getId());
            items = new ArrayList();
            items.add(data);
            this.setItemGradingDataArray(items);
            data = (ItemGradingData)this.getItemGradingDataArray().toArray()[0];
        } else {
            data = (ItemGradingData)this.getItemGradingDataArray().toArray()[count - 1];
        }
        if (this.getItemData().getTypeId().toString().equals(TypeIfc.TRUE_FALSE.toString())) {
            data.setRationale(newRationale);
        } else if (this.getItemData().getTypeId().toString().equals(TypeIfc.MULTIPLE_CORRECT.toString())) {
            for (ItemGradingData mcmcdata : this.getItemGradingDataArray()) {
                mcmcdata.setRationale(newRationale);
            }
        } else if (data.getItemGradingId() == null) {
            data.setRationale(newRationale);
        } else {
            ItemGradingData newdata = new ItemGradingData();
            newdata.setPublishedItemId(data.getPublishedItemId());
            newdata.setPublishedItemTextId(data.getPublishedItemTextId());
            newdata.setRationale(newRationale);
            newdata.setPublishedAnswerId(data.getPublishedAnswerId());
            items = this.getItemGradingDataArray();
            items.add(newdata);
            this.setItemGradingDataArray(items);
        }
    }

    public String getRationale() {
        int count = this.getItemGradingDataArray().size();
        if (count > 0) {
            ItemGradingData data = (ItemGradingData)this.getItemGradingDataArray().toArray()[count - 1];
            this.rationale = FormattedText.convertFormattedTextToPlaintext((String)data.getRationale());
        }
        return Validator.check((String)this.rationale, (String)"");
    }

    public String getRationaleForDisplay() {
        ItemGradingData data;
        int count = this.getItemGradingDataArray().size();
        if (count > 0 && (data = (ItemGradingData)this.getItemGradingDataArray().toArray()[count - 1]).getRationale() != null) {
            this.rationale = FormattedText.convertFormattedTextToPlaintext((String)data.getRationale()).replaceAll("(\r\n|\r)", "<br/>");
        }
        return Validator.check((String)this.rationale, (String)"");
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String newSequence) {
        this.sequence = newSequence;
    }

    public ArrayList getShuffledAnswers() {
        return this.shuffledAnswers;
    }

    public void setShuffledAnswers(ArrayList newAnswers) {
        this.shuffledAnswers = newAnswers;
    }

    public Integer getTriesAllowed() {
        return this.triesAllowed;
    }

    public void setTriesAllowed(Integer param) {
        this.triesAllowed = param;
    }

    public Integer getAttemptsRemaining() {
        return this.attemptsRemaining;
    }

    public void setAttemptsRemaining(Integer param) {
        this.attemptsRemaining = param;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer param) {
        this.duration = param;
    }

    public ArrayList getMediaArray() {
        ArrayList mediaArray = new ArrayList();
        ItemGradingData itemGradingData = null;
        try {
            Iterator iter = this.getItemGradingDataArray().iterator();
            if (iter.hasNext()) {
                itemGradingData = (ItemGradingData)iter.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (itemGradingData != null && itemGradingData.getItemGradingId() != null) {
            GradingService service = new GradingService();
            mediaArray = service.getMediaArray(itemGradingData.getItemGradingId().toString());
            ItemDataIfc item = this.getItemData();
            if (TypeIfc.AUDIO_RECORDING.equals(item.getTypeId())) {
                this.setDurationIsOver(item, mediaArray);
            }
        }
        return mediaArray;
    }

    private void setDurationIsOver(ItemDataIfc item, ArrayList mediaList) {
        int maxDurationAllowed = 60;
        try {
            maxDurationAllowed = item.getDuration();
        }
        catch (Exception e) {
            log.info((Object)("**duration recorded is not an integer value=" + e.getMessage()));
            maxDurationAllowed = 60;
        }
        for (int i = 0; i < mediaList.size(); ++i) {
            MediaIfc m = (MediaIfc)mediaList.get(i);
            float duration = new Float(m.getDuration()).floatValue();
            if (duration > (float)maxDurationAllowed) {
                m.setDurationIsOver(true);
                continue;
            }
            m.setDurationIsOver(false);
        }
    }

    public boolean isShowStudentScore() {
        return this.showStudentScore;
    }

    public void setShowStudentScore(boolean showStudentScore) {
        this.showStudentScore = showStudentScore;
    }

    public boolean isShowStudentQuestionScore() {
        return this.showStudentQuestionScore;
    }

    public void setShowStudentQuestionScore(boolean param) {
        this.showStudentQuestionScore = param;
    }

    public String getPointsDisplayString() {
        String pointsDisplayString = "";
        if (this.showStudentQuestionScore) {
            pointsDisplayString = SectionContentsBean.roundTo2Decimals((float)this.points) + "/";
        }
        return pointsDisplayString;
    }

    public String strip(String text) {
        if (text != null) {
            text = text.replaceAll("<.*?>", " ");
        }
        return text;
    }

    public boolean isNotEmpty(String wyzText) {
        if (wyzText != null && !wyzText.equals("null")) {
            String t = wyzText.trim();
            for (int index = 0; index < t.length(); ++index) {
                char c = t.charAt(index);
                if (!Character.isLetterOrDigit(c)) continue;
                return true;
            }
        }
        return false;
    }

    public String getKeyInUnicode() {
        return ContextUtil.getStringInUnicode((String)this.getKey());
    }

    public boolean getHasAttachment() {
        List l;
        boolean hasAttachment = false;
        if (this.itemData != null && (l = this.itemData.getItemAttachmentList()) != null && l.size() > 0) {
            hasAttachment = true;
        }
        return hasAttachment;
    }

    public Float getUpdatedScore() {
        return this.itemData.getScore();
    }

    public void setUpdatedScore(Float score) {
        if (!score.equals(this.itemData.getScore())) {
            AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
            Object itemService = null;
            itemService = author.getIsEditPendingAssessmentFlow() ? new ItemService() : new PublishedItemService();
            ItemFacade item = itemService.getItem(this.itemData.getItemId(), AgentFacade.getAgentString());
            item.setScore(score);
            ItemDataIfc data = item.getData();
            Set itemTextSet = data.getItemTextSet();
            for (ItemTextIfc itemText : itemTextSet) {
                Set answerSet = itemText.getAnswerSet();
                for (AnswerIfc answer : answerSet) {
                    log.debug((Object)("old value " + answer.getScore() + "new value " + score));
                    answer.setScore(score);
                }
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", itemId=" + this.itemData.getItemId()), (boolean)true));
            }
            itemService.saveItem(item);
            this.itemData.setScore(score);
        }
    }

    public boolean getHasNoMedia() {
        return this.getMediaArray().size() < 1;
    }

    public String getAnswerKeyTF() {
        String answerKey = this.itemData.getAnswerKey();
        if ("true".equals(answerKey)) {
            answerKey = rb.getString("true_msg");
        }
        if ("false".equals(answerKey)) {
            answerKey = rb.getString("false_msg");
        }
        return answerKey;
    }

    public void setAttachment(Long itemGradingId) {
        ItemContentsBean itemContentsBean;
        List itemGradingAttachmentList = new ArrayList();
        DeliveryBean dbean = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        HashMap itemContentsMap = dbean.getItemContentsMap();
        if (itemContentsMap != null && (itemContentsBean = (ItemContentsBean)itemContentsMap.get(itemGradingId)) != null) {
            ItemGradingData itemGradingData = (ItemGradingData)itemContentsBean.getItemGradingDataArray().get(0);
            AttachmentUtil attachmentUtil = new AttachmentUtil();
            HashSet itemGradingAttachmentSet = new HashSet();
            if (itemGradingAttachmentList != null) {
                itemGradingAttachmentSet = new HashSet(itemGradingAttachmentList);
            }
            itemGradingAttachmentList = attachmentUtil.prepareAssessmentAttachment(itemGradingData, itemGradingAttachmentSet);
            itemContentsBean.setItemGradingAttachmentList(itemGradingAttachmentList);
        }
    }

    public List getItemGradingAttachmentList() {
        return this.itemGradingAttachmentList;
    }

    public void setItemGradingAttachmentList(List itemGradingAttachmentList) {
        this.itemGradingAttachmentList = itemGradingAttachmentList;
    }

    public boolean getHasItemGradingAttachment() {
        if (this.itemGradingAttachmentList != null && this.itemGradingAttachmentList.size() > 0) {
            this.hasItemGradingAttachment = true;
        }
        return this.hasItemGradingAttachment;
    }

    public Long getItemGradingIdForFilePicker() {
        return this.itemGradingIdForFilePicker;
    }

    public void setItemGradingIdForFilePicker(Long itemGradingIdForFilePicker) {
        this.itemGradingIdForFilePicker = itemGradingIdForFilePicker;
    }

    public void setIsInvalidFinInput(boolean isInvalidFinInput) {
        this.isInvalidFinInput = isInvalidFinInput;
    }

    public boolean getIsInvalidFinInput() {
        return this.isInvalidFinInput;
    }

    public void setIsInvalidSALengthInput(boolean isInvalidSALengthInput) {
        this.isInvalidSALengthInput = isInvalidSALengthInput;
    }

    public boolean getIsInvalidSALengthInput() {
        return this.isInvalidSALengthInput;
    }

    public String getSaCharCount() {
        return this.saCharCount;
    }

    public void setSaCharCount(String saCharCount) {
        this.saCharCount = saCharCount;
    }
}

