/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.evaluation;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramBarBean;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;

public class HistogramQuestionScoresBean
implements Serializable {
    private String assessmentName;
    private String title;
    private static final long serialVersionUID = -584855389374044609L;
    private String assessmentId;
    private String agent;
    private String groupName;
    private String maxScore;
    private String totalScore;
    private String adjustedScore;
    private boolean allSubmissions;
    private String questionLabelFormat;
    private String questionNumber;
    private String questionText;
    private String questionType;
    private String poolName;
    private String percentCorrect;
    private String partNumber;
    private String mean;
    private String median;
    private String mode;
    private String highestRange;
    private String standDev;
    private String lowerQuartile;
    private String upperQuartile;
    private int interval;
    private Collection info;
    private int[] numStudentCollection = new int[0];
    private String[] rangeCollection = new String[0];
    private int[] columnHeight = new int[0];
    private int arrayLength;
    private String range;
    private int numResponses;
    private String q1;
    private String q2;
    private String q3;
    private String q4;
    String correctAnswer;
    private int totalResponses;
    private HistogramBarBean[] histogramBars;
    private boolean randomType;
    private static Log log = LogFactory.getLog(HistogramQuestionScoresBean.class);
    private Set studentsWithAllCorrect;
    private Set studentsResponded;
    private String percentCorrectFromUpperQuartileStudents;
    private String percentCorrectFromLowerQuartileStudents;
    private String discrimination;
    private String n;
    private int numberOfStudentsWithZeroAnswers = 0;
    private Long itemId;
    private int numberOfParts;

    public void setAgent(String pagent) {
        this.agent = pagent;
    }

    public String getAgent() {
        return Validator.check((String)this.agent, (String)"N/A");
    }

    public String getAssessmentName() {
        return Validator.check((String)this.assessmentName, (String)"N/A");
    }

    public void setAssessmentName(String passessmentName) {
        this.assessmentName = passessmentName;
    }

    public String getTitle() {
        return Validator.check((String)this.title, (String)"N/A");
    }

    public void setTitle(String ptitle) {
        this.title = ptitle;
    }

    public String getAssessmentId() {
        return Validator.check((String)this.assessmentId, (String)"0");
    }

    public void setAssessmentId(String passessmentId) {
        this.assessmentId = passessmentId;
    }

    public String getGroupName() {
        return Validator.check((String)this.groupName, (String)"N/A");
    }

    public boolean getAllSubmissions() {
        return this.allSubmissions;
    }

    public void setAllSubmissions(boolean pallSubmissions) {
        this.allSubmissions = pallSubmissions;
    }

    public void setGroupName(String pgroupName) {
        this.groupName = pgroupName;
    }

    public String[] getRangeCollection() {
        if (this.rangeCollection == null) {
            return new String[0];
        }
        return this.rangeCollection;
    }

    public void setRangeCollection(String[] prange) {
        this.rangeCollection = prange;
    }

    public int[] getNumStudentCollection() {
        if (this.numStudentCollection == null) {
            return new int[0];
        }
        return this.numStudentCollection;
    }

    public void setNumStudentCollection(int[] pnumStudent) {
        this.numStudentCollection = pnumStudent;
    }

    public int[] getColumnHeight() {
        if (this.columnHeight == null) {
            return new int[0];
        }
        return this.columnHeight;
    }

    public void setColumnHeight(int[] pcolumnHeight) {
        this.columnHeight = pcolumnHeight;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public void setArrayLength(int parrayLength) {
        this.arrayLength = parrayLength;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int pinterval) {
        this.interval = pinterval;
    }

    public Collection getInfo() {
        if (this.info == null) {
            return new ArrayList();
        }
        return this.info;
    }

    public void setInfo(Collection pinfo) {
        this.info = pinfo;
    }

    public String getMaxScore() {
        return Validator.check((String)this.maxScore, (String)"N/A");
    }

    public void setMaxScore(String pmaxScore) {
        this.maxScore = pmaxScore;
    }

    public String getTotalScore() {
        return Validator.check((String)this.totalScore, (String)"N/A");
    }

    public void setTotalScore(String ptotalScore) {
        this.totalScore = ptotalScore;
    }

    public String getAdjustedScore() {
        return Validator.check((String)this.adjustedScore, (String)"N/A");
    }

    public void setAdjustedScore(String padjustedScore) {
        this.adjustedScore = padjustedScore;
    }

    public String getQuestionNumber() {
        return Validator.check((String)this.questionNumber, (String)"N/A");
    }

    public void setQuestionNumber(String pquestionNumber) {
        this.questionNumber = pquestionNumber;
    }

    public String getQuestionText() {
        return Validator.check((String)this.questionText, (String)"N/A");
    }

    public void setQuestionText(String pquestionText) {
        this.questionText = pquestionText;
    }

    public String getCorrectAnswer() {
        return Validator.check((String)this.correctAnswer, (String)"N/A");
    }

    public void setCorrectAnswer(String pcorrectAnswer) {
        this.correctAnswer = pcorrectAnswer;
    }

    public String getQuestionType() {
        return Validator.check((String)this.questionType, (String)"0");
    }

    public void setQuestionType(String pquestionType) {
        this.questionType = pquestionType;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String qpoolName) {
        this.poolName = qpoolName;
    }

    public String getPercentCorrect() {
        return Validator.check((String)this.percentCorrect, (String)"N/A");
    }

    public void setPercentCorrect(String ppercentCorrect) {
        this.percentCorrect = ppercentCorrect;
    }

    public String getPartNumber() {
        return Validator.check((String)this.partNumber, (String)"N/A");
    }

    public void setPartNumber(String ppartNumber) {
        this.partNumber = ppartNumber;
    }

    public String getMean() {
        return Validator.check((String)this.mean, (String)"N/A");
    }

    public void setMean(String pmean) {
        this.mean = pmean;
    }

    public String getMedian() {
        return Validator.check((String)this.median, (String)"N/A");
    }

    public void setMedian(String pmedian) {
        this.median = pmedian;
    }

    public String getMode() {
        return Validator.check((String)this.mode, (String)"N/A");
    }

    public void setMode(String pmode) {
        this.mode = pmode;
    }

    public String getStandDev() {
        return Validator.check((String)this.standDev, (String)"N/A");
    }

    public void setStandDev(String pstandDev) {
        this.standDev = pstandDev;
    }

    public String getLowerQuartile() {
        return Validator.check((String)this.lowerQuartile, (String)"N/A");
    }

    public void setLowerQuartile(String plowerQuartile) {
        this.lowerQuartile = plowerQuartile;
    }

    public String getUpperQuartile() {
        return Validator.check((String)this.upperQuartile, (String)"N/A");
    }

    public void setUpperQuartile(String pupperQuartile) {
        this.upperQuartile = pupperQuartile;
    }

    public String getQ1() {
        return Validator.check((String)this.q1, (String)"N/A");
    }

    public void setQ1(String pq1) {
        this.q1 = pq1;
    }

    public String getQ2() {
        return Validator.check((String)this.q2, (String)"N/A");
    }

    public void setQ2(String pq2) {
        this.q2 = pq2;
    }

    public String getQ3() {
        return Validator.check((String)this.q3, (String)"N/A");
    }

    public void setQ3(String pq3) {
        this.q3 = pq3;
    }

    public String getQ4() {
        return Validator.check((String)this.q4, (String)"N/A");
    }

    public void setQ4(String pq4) {
        this.q4 = pq4;
    }

    public String getRange() {
        return Validator.check((String)this.range, (String)"N/A");
    }

    public void setRange(String prange) {
        this.range = prange;
    }

    public int getNumResponses() {
        return this.numResponses;
    }

    public void setNumResponses(int pnumResponses) {
        this.numResponses = pnumResponses;
    }

    public int getTotalResponses() {
        return this.totalResponses;
    }

    public void setTotalResponses(int ptotalResponses) {
        this.totalResponses = ptotalResponses;
    }

    public HistogramBarBean[] getHistogramBars() {
        if (this.histogramBars != null) {
            return this.histogramBars;
        }
        int length = this.getColumnHeight().length;
        int[] height = this.getColumnHeight();
        int[] nums = this.getNumStudentCollection();
        String[] range = this.getRangeCollection();
        this.histogramBars = new HistogramBarBean[length];
        for (int i = 0; i < length; ++i) {
            this.histogramBars[i] = new HistogramBarBean();
            this.histogramBars[i].setColumnHeight(Integer.toString(height[i]));
            this.histogramBars[i].setNumStudents(nums[i]);
            this.histogramBars[i].setRangeInfo(range[i]);
        }
        return this.histogramBars;
    }

    public void setHistogramBars(HistogramBarBean[] bars) {
        this.histogramBars = bars;
    }

    public boolean getDetailedStats() {
        return !"True False".equals(this.questionType) && !"Multiple Choice".equals(this.questionType) && !"Multiple Correct Answer".equals(this.questionType) && !"Multiple Correct Single Selection".equals(this.questionType);
    }

    public void setDetailedStats(boolean ignored) {
    }

    public boolean getRandomType() {
        return this.randomType;
    }

    public void setRandomType(boolean param) {
        this.randomType = param;
    }

    public String getQuestionLabel() {
        if (this.questionLabelFormat == null) {
            String label = "Q" + this.questionNumber;
            if (this.randomType && this.poolName != null) {
                label = label + "-Pool:" + this.poolName;
            }
            if (this.getNumberOfParts() > 1) {
                return "P" + this.partNumber + "-" + label;
            }
            return label;
        }
        return MessageFormat.format(this.questionLabelFormat, this.questionNumber, this.partNumber, this.poolName);
    }

    public void setQuestionLabelFormat(String questionLabelFormat) {
        this.questionLabelFormat = questionLabelFormat;
    }

    public void addStudentWithAllCorrect(String agentId) {
        if (this.studentsWithAllCorrect == null) {
            this.studentsWithAllCorrect = new TreeSet();
        }
        this.studentsWithAllCorrect.add(agentId);
    }

    public void addStudentResponded(String agentId) {
        if (this.studentsResponded == null) {
            this.studentsResponded = new TreeSet();
        }
        this.studentsResponded.add(agentId);
    }

    public void clearStudentsWithAllCorrect() {
        this.studentsWithAllCorrect = null;
    }

    public void clearStudentsResponded() {
        this.studentsResponded = null;
    }

    public Set getStudentsWithAllCorrect() {
        return this.studentsWithAllCorrect;
    }

    public Set getStudentsResponded() {
        return this.studentsResponded;
    }

    public String getDiscrimination() {
        return this.discrimination;
    }

    public void setDiscrimination(String discrimination) {
        this.discrimination = discrimination;
    }

    public String getPercentCorrectFromUpperQuartileStudents() {
        return this.percentCorrectFromUpperQuartileStudents;
    }

    public void setPercentCorrectFromUpperQuartileStudents(String percentCorrectFromUpperQuartileStudents) {
        this.percentCorrectFromUpperQuartileStudents = percentCorrectFromUpperQuartileStudents;
    }

    public String getPercentCorrectFromLowerQuartileStudents() {
        return this.percentCorrectFromLowerQuartileStudents;
    }

    public void setPercentCorrectFromLowerQuartileStudents(String percentCorrectFromLowerQuartileStudents) {
        this.percentCorrectFromLowerQuartileStudents = percentCorrectFromLowerQuartileStudents;
    }

    public String getN() {
        return this.n;
    }

    public void setN(String n) {
        this.n = n;
    }

    public int getNumberOfStudentsWithZeroAnswers() {
        return this.numberOfStudentsWithZeroAnswers;
    }

    public void setNumberOfStudentsWithZeroAnswers(int numberOfStudentsWithZeroAnswers) {
        this.numberOfStudentsWithZeroAnswers = numberOfStudentsWithZeroAnswers;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public int getNumberOfParts() {
        return this.numberOfParts;
    }

    public void setNumberOfParts(int numberOfParts) {
        this.numberOfParts = numberOfParts;
    }

    public boolean getShowPercentageCorrectAndDiscriminationFigures() {
        return !this.getQuestionType().equals("3");
    }

    public int getSumOfStudentResponsesInUndisplayedItemAnalysisColumns() {
        if (this.histogramBars == null || this.histogramBars.length < 13) {
            return 0;
        }
        int sum = 0;
        for (int i = 12; i < this.histogramBars.length; ++i) {
            sum += this.histogramBars[i].getNumStudents();
        }
        return sum;
    }

    public String getStudentResponsesInUndisplayedItemAnalysisColumns() {
        if (this.histogramBars == null || this.histogramBars.length < 13) {
            return "";
        }
        String sep = " | ";
        StringBuilder responsesbuf = new StringBuilder(sep);
        for (int i = 12; i < this.histogramBars.length; ++i) {
            if (this.histogramBars[i].getIsCorrect().booleanValue()) {
                responsesbuf.append("(" + this.histogramBars[i].getNumStudents() + ")" + sep);
                continue;
            }
            responsesbuf.append(this.histogramBars[i].getNumStudents() + sep);
        }
        String responses = responsesbuf.toString();
        return responses;
    }
}

