/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.evaluation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.jsf.model.PhaseAware;
import org.sakaiproject.tool.assessment.business.entity.RecordingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;
import org.sakaiproject.tool.assessment.ui.listener.evaluation.QuestionScoreListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.AttachmentUtil;
import org.sakaiproject.util.ResourceLoader;

public class QuestionScoresBean
implements Serializable,
PhaseAware {
    private String assessmentId;
    private String publishedId;
    private static final long serialVersionUID = 5517587781720762296L;
    public static final String SHOW_SA_RATIONALE_RESPONSES_INLINE = "2";
    public static final String SHOW_SA_RATIONALE_RESPONSES_POPUP = "1";
    private String assessmentName;
    private String itemName;
    private String partName;
    private String itemId;
    private String anonymous;
    private String groupName;
    private String maxScore;
    private Collection agents;
    private Collection sections;
    private Collection deliveryItem;
    private String score;
    private String discount;
    private String answer;
    private String questionScoreComments;
    private String lateHandling;
    private String dueDate;
    private String sortType;
    private boolean sortAscending = true;
    private String roleSelection;
    private String allSubmissions;
    private RecordingData recordingData;
    private String totalPeople;
    private String typeId;
    private HashMap scoresByItem;
    private static Log log = LogFactory.getLog(QuestionScoresBean.class);
    private String selectedSectionFilterValue = null;
    private String selectedSARationaleView = "1";
    private ArrayList allAgents;
    private boolean haveModelShortAnswer;
    private int firstScoreRow;
    private int maxDisplayedScoreRows;
    private int scoreDataRows;
    private int audioMaxDisplayedScoreRows;
    private int othersMaxDisplayedScoreRows;
    private boolean hasAudioMaxDisplayedScoreRowsChanged;
    private String searchString;
    private String defaultSearchString;
    private Map userIdMap;
    private HashMap agentResultsByItemGradingId;
    private boolean isAnyItemGradingAttachmentListModified;
    private Boolean releasedToGroups = null;
    private HashMap itemScoresMap;
    private PublishedAssessmentIfc publishedAssessment;

    public QuestionScoresBean() {
        log.debug((Object)"Creating a new QuestionScoresBean");
        this.resetFields();
    }

    protected void init() {
        this.defaultSearchString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"search_default_student_search_string");
        if (this.searchString == null) {
            this.searchString = this.defaultSearchString;
        }
        if (this.allAgents == null) {
            this.allAgents = this.getAllAgents();
        }
        ArrayList matchingAgents = this.isFilteredSearch() ? this.findMatchingAgents(this.searchString) : this.allAgents;
        this.scoreDataRows = matchingAgents.size();
        ArrayList newAgents = null;
        if (this.maxDisplayedScoreRows == 0) {
            newAgents = matchingAgents;
        } else {
            int nextPageRow = Math.min(this.firstScoreRow + this.maxDisplayedScoreRows, this.scoreDataRows);
            newAgents = new ArrayList(matchingAgents.subList(this.firstScoreRow, nextPageRow));
            log.debug((Object)("init(): subList " + this.firstScoreRow + ", " + nextPageRow));
        }
        this.agents = newAgents;
    }

    public void endProcessValidators() {
        log.debug((Object)"endProcessValidators");
    }

    public void endProcessUpdates() {
        log.debug((Object)"endProcessUpdates");
    }

    public void startRenderResponse() {
        log.debug((Object)"startRenderResponse");
        this.init();
    }

    public String getAssessmentName() {
        return Validator.check((String)this.assessmentName, (String)"N/A");
    }

    public void setAssessmentName(String passessmentName) {
        this.assessmentName = passessmentName;
    }

    public String getPartName() {
        return Validator.check((String)this.partName, (String)"N/A");
    }

    public void setPartName(String ppartName) {
        this.partName = ppartName;
    }

    public String getItemName() {
        return Validator.check((String)this.itemName, (String)"N/A");
    }

    public void setItemName(String pitemName) {
        this.itemName = pitemName;
    }

    public String getItemId() {
        return Validator.check((String)this.itemId, (String)SHOW_SA_RATIONALE_RESPONSES_POPUP);
    }

    public void setItemId(String pitemId) {
        this.itemId = pitemId;
    }

    public String getAssessmentId() {
        return Validator.check((String)this.assessmentId, (String)"0");
    }

    public void setAssessmentId(String passessmentId) {
        this.assessmentId = passessmentId;
    }

    public String getPublishedId() {
        return Validator.check((String)this.publishedId, (String)"0");
    }

    public void setPublishedId(String ppublishedId) {
        this.publishedId = ppublishedId;
    }

    public String getAnonymous() {
        return Validator.check((String)this.anonymous, (String)"false");
    }

    public void setAnonymous(String panonymous) {
        this.anonymous = panonymous;
    }

    public String getGroupName() {
        return Validator.check((String)this.groupName, (String)"N/A");
    }

    public void setGroupName(String pgroupName) {
        this.groupName = pgroupName;
    }

    public String getMaxScore() {
        return Validator.check((String)this.maxScore, (String)"N/A");
    }

    public void setMaxScore(String pmaxScore) {
        this.maxScore = pmaxScore;
    }

    public String getMaxPoint() {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        try {
            if (Double.parseDouble(this.getMaxScore()) == 1.0) {
                return this.getMaxScore() + " " + rb.getString("point");
            }
            return this.getMaxScore() + " " + rb.getString("points");
        }
        catch (NumberFormatException e) {
            return this.getMaxScore() + " " + rb.getString("point");
        }
    }

    public Collection getAgents() {
        if (this.agents == null) {
            return new ArrayList();
        }
        return this.agents;
    }

    public void setAgents(Collection pagents) {
        this.agents = pagents;
    }

    public Collection getSections() {
        if (this.sections == null) {
            return new ArrayList();
        }
        return this.sections;
    }

    public void setSections(Collection psections) {
        this.sections = psections;
    }

    public Collection getDeliveryItem() {
        if (this.deliveryItem == null) {
            return new ArrayList();
        }
        return this.deliveryItem;
    }

    public void setDeliveryItem(Collection pitem) {
        this.deliveryItem = pitem;
    }

    public String getAgentInitials() {
        Collection c = this.getAgents();
        StringBuilder initialsbuf = new StringBuilder();
        if (c.isEmpty()) {
            return "";
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            try {
                AgentResults ar = (AgentResults)it.next();
                String initial = ar.getLastInitial();
                initialsbuf.append(initial);
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
            }
        }
        String initials = initialsbuf.toString();
        return initials.toUpperCase();
    }

    public Object[] getAgentArray() {
        if (this.agents == null) {
            return new Object[0];
        }
        return this.agents.toArray();
    }

    public String getTotalPeople() {
        return Validator.check((String)this.totalPeople, (String)"N/A");
    }

    public void setTotalPeople(String ptotalPeople) {
        this.totalPeople = ptotalPeople;
    }

    public String getScore() {
        return Validator.check((String)this.score, (String)"N/A");
    }

    public void setScore(String pScore) {
        this.score = pScore;
    }

    public String getDiscount() {
        return Validator.check((String)this.discount, (String)"N/A");
    }

    public void setDiscount(String pDiscount) {
        this.discount = pDiscount;
    }

    public String getAnswer() {
        return Validator.check((String)this.answer, (String)"N/A");
    }

    public void setAnswer(String pAnswertext) {
        this.answer = pAnswertext;
    }

    public String getQuestionScoreComments() {
        return Validator.check((String)this.questionScoreComments, (String)"");
    }

    public void setQuestionScoreComments(String pQuestionScoreComments) {
        log.debug((Object)("setting question score comments to " + pQuestionScoreComments));
        this.questionScoreComments = pQuestionScoreComments;
    }

    public String getLateHandling() {
        return Validator.check((String)this.lateHandling, (String)SHOW_SA_RATIONALE_RESPONSES_POPUP);
    }

    public void setLateHandling(String plateHandling) {
        this.lateHandling = plateHandling;
    }

    public String getDueDate() {
        return Validator.check((String)this.dueDate, (String)"N/A");
    }

    public void setDueDate(String dateString) {
        this.dueDate = dateString;
    }

    public String getSortType() {
        if (!Boolean.parseBoolean(this.getAnonymous())) {
            return Validator.check((String)this.sortType, (String)"lastName");
        }
        return Validator.check((String)this.sortType, (String)"assessmentGradingId");
    }

    public void setSortType(String psortType) {
        this.sortType = psortType;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String getAllSubmissions() {
        return this.allSubmissions;
    }

    public void setAllSubmissions(String pallSubmissions) {
        if (!pallSubmissions.equals(this.allSubmissions)) {
            this.allSubmissions = pallSubmissions;
            this.setFirstRow(0);
        }
    }

    public String getRoleSelection() {
        return Validator.check((String)this.roleSelection, (String)"N/A");
    }

    public void setRoleSelection(String proleSelection) {
        this.roleSelection = proleSelection;
    }

    public String getTypeId() {
        return Validator.check((String)this.typeId, (String)SHOW_SA_RATIONALE_RESPONSES_POPUP);
    }

    public void setTypeId(String ptypeId) {
        this.typeId = ptypeId;
    }

    public void resetFields() {
    }

    public RecordingData getRecordingData() {
        return this.recordingData;
    }

    public void setRecordingData(RecordingData rd) {
        this.recordingData = rd;
    }

    public HashMap getScoresByItem() {
        return this.scoresByItem;
    }

    public void setScoresByItem(HashMap newScores) {
        this.scoresByItem = newScores;
    }

    public String getSelectedSectionFilterValue() {
        if (this.selectedSectionFilterValue == null) {
            if (this.isReleasedToGroups()) {
                this.setSelectedSectionFilterValue("-2");
            } else {
                this.setSelectedSectionFilterValue("-1");
            }
        }
        return this.selectedSectionFilterValue;
    }

    public void setSelectedSectionFilterValue(String param) {
        if (!param.equals(this.selectedSectionFilterValue)) {
            this.selectedSectionFilterValue = param;
            this.setFirstRow(0);
        }
    }

    public void setItemScoresMap(HashMap itemScoresMap) {
        this.itemScoresMap = itemScoresMap;
    }

    public HashMap getItemScoresMap() {
        return this.itemScoresMap;
    }

    public void setPublishedAssessment(PublishedAssessmentIfc publishedAssessment) {
        this.publishedAssessment = publishedAssessment;
    }

    public PublishedAssessmentIfc getPublishedAssessment() {
        return this.publishedAssessment;
    }

    public String getSelectedSARationaleView() {
        return this.selectedSARationaleView;
    }

    public void setSelectedSARationaleView(String selectedSARationaleView) {
        this.selectedSARationaleView = selectedSARationaleView;
    }

    public int getFirstRow() {
        return this.firstScoreRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstScoreRow = firstRow;
    }

    public int getMaxDisplayedRows() {
        return this.maxDisplayedScoreRows;
    }

    public void setMaxDisplayedRows(int maxDisplayedRows) {
        this.maxDisplayedScoreRows = maxDisplayedRows;
    }

    public int getAudioMaxDisplayedScoreRows() {
        return this.audioMaxDisplayedScoreRows;
    }

    public void setAudioMaxDisplayedScoreRows(int audioMaxDisplayedRows) {
        this.audioMaxDisplayedScoreRows = audioMaxDisplayedRows;
    }

    public int getOtherMaxDisplayedScoreRows() {
        return this.othersMaxDisplayedScoreRows;
    }

    public void setOtherMaxDisplayedScoreRows(int otherMaxDisplayedRows) {
        this.othersMaxDisplayedScoreRows = otherMaxDisplayedRows;
    }

    public boolean getHasAudioMaxDisplayedScoreRowsChanged() {
        return this.hasAudioMaxDisplayedScoreRowsChanged;
    }

    public void setHasAudioMaxDisplayedScoreRowsChanged(boolean hasAudioMaxDisplayedRowsChanged) {
        this.hasAudioMaxDisplayedScoreRowsChanged = hasAudioMaxDisplayedRowsChanged;
    }

    public int getDataRows() {
        return this.scoreDataRows;
    }

    public void setAllAgents(ArrayList allAgents) {
        this.allAgents = allAgents;
    }

    public ArrayList getAllAgents() {
        QuestionScoreListener questionScoreListener = new QuestionScoreListener();
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        if (!questionScoreListener.questionScores(publishedId, this, false)) {
            throw new RuntimeException("failed to call questionScores.");
        }
        return this.allAgents;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        if (StringUtils.trimToNull((String)searchString) == null) {
            searchString = this.defaultSearchString;
        }
        if (!StringUtils.equals((String)searchString, (String)this.searchString)) {
            log.debug((Object)("setSearchString " + searchString));
            this.searchString = searchString;
            this.setFirstRow(0);
        }
    }

    public void search(ActionEvent event) {
        log.debug((Object)"search");
    }

    public void clear(ActionEvent event) {
        log.debug((Object)"clear");
        this.setSearchString(null);
    }

    private boolean isFilteredSearch() {
        return !StringUtils.equals((String)this.searchString, (String)this.defaultSearchString);
    }

    public ArrayList findMatchingAgents(String pattern) {
        ArrayList<AgentResults> filteredList = new ArrayList<AgentResults>();
        for (AgentResults result : this.allAgents) {
            StringBuilder name1 = new StringBuilder(result.getFirstName());
            name1.append(" ");
            name1.append(result.getLastName());
            StringBuilder name2 = new StringBuilder(result.getLastName());
            name2.append(", ");
            name2.append(result.getFirstName());
            if (!result.getFirstName().toLowerCase().startsWith(pattern.toLowerCase()) && !result.getLastName().toLowerCase().startsWith(pattern.toLowerCase()) && !result.getAgentEid().toLowerCase().startsWith(pattern.toLowerCase()) && !name1.toString().toLowerCase().startsWith(pattern.toLowerCase()) && !name2.toString().toLowerCase().startsWith(pattern.toLowerCase())) continue;
            filteredList.add(result);
        }
        return filteredList;
    }

    public boolean getHaveModelShortAnswer() {
        return this.haveModelShortAnswer;
    }

    public void setHaveModelShortAnswer(boolean haveModelShortAnswer) {
        this.haveModelShortAnswer = haveModelShortAnswer;
    }

    public boolean isReleasedToGroups() {
        return this.getPublishedAssessment().getAssessmentAccessControl().getReleaseTo().equals("Selected Groups");
    }

    public Map getUserIdMap() {
        return this.userIdMap;
    }

    public void setUserIdMap(Map userIdMap) {
        this.userIdMap = userIdMap;
    }

    public void setAttachment(Long itemGradingId) {
        List itemGradingAttachmentList = new ArrayList();
        AgentResults agentResults = (AgentResults)this.agentResultsByItemGradingId.get(itemGradingId);
        if (agentResults != null) {
            AttachmentUtil attachmentUtil = new AttachmentUtil();
            HashSet attachmentSet = new HashSet();
            if (agentResults.getItemGradingAttachmentList() != null) {
                attachmentSet = new HashSet(agentResults.getItemGradingAttachmentList());
            }
            itemGradingAttachmentList = attachmentUtil.prepareAssessmentAttachment(agentResults.getItemGrading(), attachmentSet);
            agentResults.setItemGradingAttachmentList(itemGradingAttachmentList);
        }
    }

    public HashMap getAgentResultsByItemGradingId() {
        return this.agentResultsByItemGradingId;
    }

    public void setAgentResultsByItemGradingId(HashMap agentResultsByItemGradingId) {
        this.agentResultsByItemGradingId = agentResultsByItemGradingId;
    }

    public boolean getIsAnyItemGradingAttachmentListModified() {
        return this.isAnyItemGradingAttachmentListModified;
    }

    public void setIsAnyItemGradingAttachmentListModified(boolean isAnyItemGradingAttachmentListModified) {
        this.isAnyItemGradingAttachmentListModified = isAnyItemGradingAttachmentListModified;
    }
}

