/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.evaluation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.jsf.model.PhaseAware;
import org.sakaiproject.section.api.coursemanagement.CourseSection;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;
import org.sakaiproject.tool.assessment.business.entity.RecordingData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedEvaluationModel;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.impl.grading.GradingSectionAwareServiceImpl;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;
import org.sakaiproject.tool.assessment.ui.listener.evaluation.TotalScoreListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class TotalScoresBean
implements Serializable,
PhaseAware {
    private String assessmentId;
    private String publishedId;
    public static final String RELEASED_SECTIONS_GROUPS_SELECT_VALUE = "-2";
    public static final String ALL_SECTIONS_SELECT_VALUE = "-1";
    public static final String ALL_SUBMISSIONS = "3";
    public static final String LAST_SUBMISSION = "2";
    public static final String HIGHEST_SUBMISSION = "1";
    public static final int CALLED_FROM_SUBMISSION_STATUS_LISTENER = 1;
    public static final int CALLED_FROM_QUESTION_SCORE_LISTENER = 2;
    public static final int CALLED_FROM_TOTAL_SCORE_LISTENER = 3;
    public static final int CALLED_FROM_HISTOGRAM_LISTENER = 4;
    public static final int CALLED_FROM_HISTOGRAM_LISTENER_STUDENT = 5;
    public static final int CALLED_FROM_EXPORT_LISTENER = 6;
    public static final int CALLED_FROM_NOTIFICATION_LISTENER = 7;
    private static final long serialVersionUID = 5517587781720762296L;
    private String assessmentName;
    private String anonymous;
    private String groupName;
    private String maxScore;
    private Collection agents;
    private Collection sortedAgents;
    private String totalScore;
    private String adjustmentTotalScore;
    private String totalScoreComments;
    private String sortProperty;
    private String lateHandling;
    private String dueDate;
    private String sortType;
    private boolean sortAscending = true;
    private String roleSelection;
    private String allSubmissions = "3";
    private RecordingData recordingData;
    private String totalPeople;
    private String firstItem;
    private HashMap answeredItems;
    private boolean hasRandomDrawPart;
    private String scoringOption;
    private String selectedSectionFilterValue = null;
    private List sectionFilterSelectItems;
    private List availableSections;
    private boolean releaseToAnonymous = false;
    private PublishedAssessmentData publishedAssessment;
    private ArrayList allAgents;
    private String graderName;
    private String graderEmailInfo;
    private int firstScoreRow;
    private int maxDisplayedScoreRows;
    private int scoreDataRows;
    private String searchString;
    private String defaultSearchString;
    private String applyToUngraded = "";
    private boolean multipleSubmissionsAllowed = false;
    private boolean isTimedAssessment = false;
    private boolean acceptLateSubmission = false;
    private Boolean releasedToGroups = null;
    private Map userIdMap;
    private boolean isAutoScored = false;
    private static Log log = LogFactory.getLog(TotalScoresBean.class);
    private HashMap assessmentGradingHash = new HashMap();
    private ArrayList assessmentGradingList;

    public TotalScoresBean() {
        log.debug((Object)"Creating a new TotalScoresBean");
        this.resetFields();
    }

    protected void init() {
        ArrayList newAgents;
        this.defaultSearchString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"search_default_student_search_string");
        if (this.searchString == null) {
            this.searchString = this.defaultSearchString;
        }
        if (this.allAgents == null) {
            this.allAgents = this.getAllAgents();
        }
        if ("true".equalsIgnoreCase(this.anonymous)) {
            Iterator iter = this.allAgents.iterator();
            ArrayList<AgentResults> anonymousAgents = new ArrayList<AgentResults>();
            while (iter.hasNext()) {
                AgentResults agentResult = (AgentResults)iter.next();
                if (agentResult.getSubmittedDate() == null || agentResult.getAssessmentGradingId().intValue() == -1) continue;
                anonymousAgents.add(agentResult);
            }
            this.allAgents = anonymousAgents;
        }
        ArrayList matchingAgents = this.isFilteredSearch() ? this.findMatchingAgents(this.searchString) : this.allAgents;
        this.scoreDataRows = matchingAgents.size();
        if (this.maxDisplayedScoreRows == 0) {
            newAgents = matchingAgents;
        } else {
            int nextPageRow = Math.min(this.firstScoreRow + this.maxDisplayedScoreRows, this.scoreDataRows);
            newAgents = new ArrayList(matchingAgents.subList(this.firstScoreRow, nextPageRow));
            log.debug((Object)("init(): subList " + this.firstScoreRow + ", " + nextPageRow));
        }
        this.agents = newAgents;
    }

    public void endProcessValidators() {
        log.debug((Object)"endProcessValidators");
    }

    public void endProcessUpdates() {
        log.debug((Object)"endProcessUpdates");
    }

    public void startRenderResponse() {
        log.debug((Object)"startRenderResponse");
        this.init();
    }

    public String getAssessmentName() {
        return Validator.check((String)this.assessmentName, (String)"N/A");
    }

    public void setAssessmentName(String passessmentName) {
        this.assessmentName = passessmentName;
    }

    public String getAssessmentId() {
        return Validator.check((String)this.assessmentId, (String)"0");
    }

    public void setAssessmentId(String passessmentId) {
        this.assessmentId = passessmentId;
    }

    public String getPublishedId() {
        return Validator.check((String)this.publishedId, (String)"0");
    }

    public void setPublishedId(String ppublishedId) {
        this.publishedId = ppublishedId;
    }

    public String getAnonymous() {
        return Validator.check((String)this.anonymous, (String)"false");
    }

    public void setAnonymous(String panonymous) {
        this.anonymous = panonymous;
    }

    public String getGroupName() {
        return Validator.check((String)this.groupName, (String)"N/A");
    }

    public void setGroupName(String pgroupName) {
        this.groupName = pgroupName;
    }

    public String getMaxScore() {
        try {
            String newmax = ContextUtil.getRoundedValue((String)this.maxScore, (int)2);
            return Validator.check((String)newmax, (String)"N/A");
        }
        catch (Exception e) {
            return Validator.check((String)this.maxScore, (String)"N/A");
        }
    }

    public void setMaxScore(String pmaxScore) {
        this.maxScore = pmaxScore;
    }

    public Collection getAgents() {
        if (this.agents == null) {
            return new ArrayList();
        }
        return this.agents;
    }

    public void setAgents(Collection pagents) {
        this.agents = pagents;
    }

    public String getAgentInitials() {
        Collection c = this.getAgents();
        StringBuilder initialsbuf = new StringBuilder();
        if (c.isEmpty()) {
            return "";
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            try {
                AgentResults ar = (AgentResults)it.next();
                String initial = ar.getLastInitial();
                initialsbuf.append(initial);
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
            }
        }
        String initials = initialsbuf.toString();
        return initials.toUpperCase();
    }

    public Object[] getAgentArray() {
        if (this.agents == null) {
            return new Object[0];
        }
        return this.agents.toArray();
    }

    public String getTotalPeople() {
        return Validator.check((String)this.totalPeople, (String)"N/A");
    }

    public void setTotalPeople(String ptotalPeople) {
        this.totalPeople = ptotalPeople;
    }

    public String getTotalScore() {
        return Validator.check((String)this.totalScore, (String)"N/A");
    }

    public void setTotalScore(String pTotalScore) {
        this.totalScore = pTotalScore;
    }

    public String getAdjustmentTotalScore() {
        return Validator.check((String)this.adjustmentTotalScore, (String)"N/A");
    }

    public void setAdjustmentTotalScore(String pAdjustmentTotalScore) {
        this.adjustmentTotalScore = pAdjustmentTotalScore;
    }

    public String getTotalScoreComments() {
        return Validator.check((String)this.totalScoreComments, (String)"");
    }

    public void setTotalScoreComments(String pTotalScoreComments) {
        log.debug((Object)("setting total score comments to " + pTotalScoreComments));
        this.totalScoreComments = pTotalScoreComments;
    }

    public String getLateHandling() {
        return Validator.check((String)this.lateHandling, (String)HIGHEST_SUBMISSION);
    }

    public void setLateHandling(String plateHandling) {
        this.lateHandling = plateHandling;
    }

    public String getDueDate() {
        return Validator.check((String)this.dueDate, (String)"N/A");
    }

    public void setDueDate(String dateString) {
        this.dueDate = dateString;
    }

    public String getSortType() {
        if (!Boolean.parseBoolean(this.getAnonymous())) {
            return Validator.check((String)this.sortType, (String)"lastName");
        }
        return Validator.check((String)this.sortType, (String)"assessmentGradingId");
    }

    public void setSortType(String psortType) {
        this.sortType = psortType;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String getAllSubmissions() {
        return this.allSubmissions;
    }

    public void setAllSubmissions(String pallSubmissions) {
        if (!pallSubmissions.equals(this.allSubmissions)) {
            this.allSubmissions = pallSubmissions;
            this.setFirstRow(0);
        }
    }

    public String getRoleSelection() {
        return Validator.check((String)this.roleSelection, (String)"N/A");
    }

    public void setRoleSelection(String proleSelection) {
        this.roleSelection = proleSelection;
    }

    public String getFirstItem() {
        return Validator.check((String)this.firstItem, (String)"");
    }

    public void setFirstItem(String pfirstItem) {
        this.firstItem = pfirstItem;
    }

    public void resetFields() {
        this.agents = new ArrayList();
        this.setAgents(this.agents);
    }

    public RecordingData getRecordingData() {
        return this.recordingData;
    }

    public void setRecordingData(RecordingData rd) {
        this.recordingData = rd;
    }

    public HashMap getAnsweredItems() {
        return this.answeredItems;
    }

    public void setAnsweredItems(HashMap newItems) {
        this.answeredItems = newItems;
    }

    public boolean getHasRandomDrawPart() {
        return this.hasRandomDrawPart;
    }

    public void setHasRandomDrawPart(boolean param) {
        this.hasRandomDrawPart = param;
    }

    public String getSelectedSectionFilterValue() {
        if (this.selectedSectionFilterValue == null) {
            if (this.isReleasedToGroups()) {
                this.setSelectedSectionFilterValue(RELEASED_SECTIONS_GROUPS_SELECT_VALUE);
            } else {
                this.setSelectedSectionFilterValue(ALL_SECTIONS_SELECT_VALUE);
            }
        }
        return this.selectedSectionFilterValue;
    }

    public void setSelectedSectionFilterValue(String param) {
        if (!(param == null || this.selectedSectionFilterValue != null && param.equals(this.selectedSectionFilterValue))) {
            this.selectedSectionFilterValue = param;
            this.setFirstRow(0);
        }
    }

    public String getScoringOption() {
        return this.scoringOption;
    }

    public void setScoringOption(String param) {
        this.scoringOption = param;
    }

    public void setAvailableSections(List param) {
        this.availableSections = param;
    }

    public List getAvailableSections() {
        return this.availableSections;
    }

    public void setSectionFilterSelectItems(List param) {
        this.sectionFilterSelectItems = param;
    }

    public List getSectionFilterSelectItems() {
        this.availableSections = this.getAllAvailableSections();
        ArrayList<SelectItem> filterSelectItems = new ArrayList<SelectItem>();
        if (this.isReleasedToGroups()) {
            filterSelectItems.add(new SelectItem((Object)RELEASED_SECTIONS_GROUPS_SELECT_VALUE, ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"released_sections_groups")));
        }
        filterSelectItems.add(new SelectItem((Object)ALL_SECTIONS_SELECT_VALUE, ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"all_sections")));
        for (int i = 0; i < this.availableSections.size(); ++i) {
            CourseSection section = (CourseSection)this.availableSections.get(i);
            filterSelectItems.add(new SelectItem((Object)String.valueOf(i), section.getTitle()));
        }
        int selectedSectionVal = new Integer(this.selectedSectionFilterValue);
        if (selectedSectionVal >= 0 && selectedSectionVal >= this.availableSections.size()) {
            if (this.isReleasedToGroups()) {
                this.setSelectedSectionFilterValue(RELEASED_SECTIONS_GROUPS_SELECT_VALUE);
            } else {
                this.setSelectedSectionFilterValue(ALL_SECTIONS_SELECT_VALUE);
            }
        }
        return filterSelectItems;
    }

    private List getAllAvailableSections() {
        GradingSectionAwareServiceImpl service = new GradingSectionAwareServiceImpl();
        return service.getAvailableSections(AgentFacade.getCurrentSiteId(), AgentFacade.getAgentString());
    }

    private List getEnrollmentListForSelectedSections(int calledFrom) {
        List enrollments = calledFrom == 5 ? this.getAvailableEnrollments(true) : (this.getSelectedSectionFilterValue().trim().equals(ALL_SECTIONS_SELECT_VALUE) || calledFrom == 3 && "true".equalsIgnoreCase(this.anonymous) || calledFrom == 2 && "true".equalsIgnoreCase(this.anonymous) || calledFrom == 4 && "true".equalsIgnoreCase(this.anonymous) || calledFrom == 7 && "true".equalsIgnoreCase(this.anonymous) || calledFrom == 6 && "true".equalsIgnoreCase(this.anonymous) ? this.getAvailableEnrollments(false) : (this.getSelectedSectionFilterValue().trim().equals(RELEASED_SECTIONS_GROUPS_SELECT_VALUE) ? this.getGroupReleaseEnrollments() : this.getSectionEnrollments(this.getSelectedSectionUid(this.getSelectedSectionFilterValue()))));
        return enrollments;
    }

    private List getSectionEnrollments(String sectionid) {
        GradingSectionAwareServiceImpl service = new GradingSectionAwareServiceImpl();
        return service.getSectionEnrollments(AgentFacade.getCurrentSiteId(), sectionid, AgentFacade.getAgentString());
    }

    private List getAvailableEnrollments(boolean fromStudentStatistics) {
        GradingSectionAwareServiceImpl service = new GradingSectionAwareServiceImpl();
        List list = null;
        list = fromStudentStatistics ? service.getAvailableEnrollments(AgentFacade.getCurrentSiteId(), ALL_SECTIONS_SELECT_VALUE) : service.getAvailableEnrollments(AgentFacade.getCurrentSiteId(), AgentFacade.getAgentString());
        return list;
    }

    private List getGroupReleaseEnrollments() {
        GradingSectionAwareServiceImpl service = new GradingSectionAwareServiceImpl();
        return service.getGroupReleaseEnrollments(AgentFacade.getCurrentSiteId(), AgentFacade.getAgentString(), this.publishedId);
    }

    private String getSelectedSectionUid(String uid) {
        if (uid.equals(ALL_SECTIONS_SELECT_VALUE) || uid.equals(RELEASED_SECTIONS_GROUPS_SELECT_VALUE)) {
            return null;
        }
        CourseSection section = (CourseSection)this.availableSections.get(new Integer(uid));
        return section.getUuid();
    }

    public void setUserIdMap(Map userIdMap) {
        this.userIdMap = userIdMap;
    }

    public Map getUserIdMap(int calledFrom) {
        List enrollments = this.getEnrollmentListForSelectedSections(calledFrom);
        HashMap<String, EnrollmentRecord> enrollmentMap = new HashMap<String, EnrollmentRecord>();
        for (EnrollmentRecord enr : enrollments) {
            enrollmentMap.put(enr.getUser().getUserUid(), enr);
        }
        return enrollmentMap;
    }

    public boolean getReleaseToAnonymous() {
        return this.releaseToAnonymous;
    }

    public void setReleaseToAnonymous(boolean param) {
        this.releaseToAnonymous = param;
    }

    public PublishedAssessmentData getPublishedAssessment() {
        return this.publishedAssessment;
    }

    public void setPublishedAssessment(PublishedAssessmentData publishedAssessment) {
        if (publishedAssessment != null) {
            this.publishedAssessment = publishedAssessment;
            this.setPublishedId(publishedAssessment.getPublishedAssessmentId().toString());
            this.setAssessmentName(publishedAssessment.getTitle());
            PublishedAccessControl ac = (PublishedAccessControl)publishedAssessment.getAssessmentAccessControl();
            this.setAccessControlProperties(ac);
            PublishedEvaluationModel eval = (PublishedEvaluationModel)publishedAssessment.getEvaluationModel();
            this.setEvaluationModelProperties(eval);
        }
    }

    public void setAccessControlProperties(PublishedAccessControl ac) {
        if (ac != null) {
            String releaseTo;
            if (ac.getDueDate() != null) {
                this.setDueDate(ac.getDueDate().toString());
            }
            if (ac.getLateHandling() != null) {
                this.setLateHandling(ac.getLateHandling().toString());
            }
            if ((releaseTo = ac.getReleaseTo()) != null && releaseTo.indexOf("Anonymous Users") == -1) {
                this.setReleaseToAnonymous(false);
            } else {
                this.setReleaseToAnonymous(true);
            }
            if (ac.getSubmissionsAllowed() != null) {
                if (ac.getSubmissionsAllowed() > 1) {
                    this.setMultipleSubmissionsAllowed(true);
                } else {
                    this.setMultipleSubmissionsAllowed(false);
                }
            } else {
                this.setMultipleSubmissionsAllowed(true);
            }
        }
    }

    public void setEvaluationModelProperties(PublishedEvaluationModel eval) {
        if (eval != null && eval.getScoringType() != null) {
            this.setScoringOption(eval.getScoringType().toString());
        }
        if (eval != null) {
            String anon = eval.getAnonymousGrading().equals(EvaluationModelIfc.ANONYMOUS_GRADING) ? "true" : "false";
            this.setAnonymous(anon);
        }
        if (eval != null && eval.getFixedTotalScore() != null) {
            this.setMaxScore(eval.getFixedTotalScore().toString());
        } else if (this.publishedAssessment.getTotalScore() != null) {
            this.setMaxScore(this.publishedAssessment.getTotalScore().toString());
        }
    }

    public void setAssessmentGradingHash(Long publishedAssessmentId) {
        GradingService service = new GradingService();
        HashMap h = service.getAssessmentGradingByItemGradingId(publishedAssessmentId.toString());
        this.assessmentGradingHash.put(publishedAssessmentId, h);
    }

    public HashMap getAssessmentGradingHash(Long publishedAssessmentId) {
        return (HashMap)this.assessmentGradingHash.get(publishedAssessmentId);
    }

    public void setAssessmentGradingList(ArrayList assessmentGradingList) {
        this.assessmentGradingList = assessmentGradingList;
    }

    public ArrayList getAssessmentGradingList() {
        return this.assessmentGradingList;
    }

    public int getFirstRow() {
        return this.firstScoreRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstScoreRow = firstRow;
    }

    public int getMaxDisplayedRows() {
        return this.maxDisplayedScoreRows;
    }

    public void setMaxDisplayedRows(int maxDisplayedRows) {
        this.maxDisplayedScoreRows = maxDisplayedRows;
    }

    public int getDataRows() {
        return this.scoreDataRows;
    }

    public void setAllAgents(ArrayList allAgents) {
        this.allAgents = allAgents;
    }

    public ArrayList getAllAgents() {
        TotalScoreListener totalScoreListener = new TotalScoreListener();
        PublishedAssessmentService pubAssessmentService = new PublishedAssessmentService();
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        PublishedAssessmentFacade pubAssessment = pubAssessmentService.getPublishedAssessment(publishedId);
        if (!totalScoreListener.totalScores(pubAssessment, this, false)) {
            throw new RuntimeException("failed to call questionScores.");
        }
        return this.allAgents;
    }

    public ArrayList getAllAgentsDirect() {
        return this.allAgents;
    }

    public String getGraderName() {
        return Validator.check((String)this.graderName, (String)"");
    }

    public void setGraderName(String graderName) {
        this.graderName = graderName;
    }

    public String getGraderEmailInfo() {
        return Validator.check((String)this.graderEmailInfo, (String)"");
    }

    public void setGraderEmailInfo(String graderEmailInfo) {
        this.graderEmailInfo = graderEmailInfo;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        if (StringUtils.trimToNull((String)searchString) == null) {
            searchString = this.defaultSearchString;
        }
        if (!StringUtils.equals((String)searchString, (String)this.searchString)) {
            log.debug((Object)("setSearchString " + searchString));
            this.searchString = searchString;
            this.setFirstRow(0);
        }
    }

    public void search(ActionEvent event) {
        log.debug((Object)"search");
    }

    public void clear(ActionEvent event) {
        log.debug((Object)"clear");
        this.setSearchString(null);
        this.setApplyToUngraded("");
    }

    private boolean isFilteredSearch() {
        return !StringUtils.equals((String)this.searchString, (String)this.defaultSearchString);
    }

    public ArrayList findMatchingAgents(String pattern) {
        ArrayList<AgentResults> filteredList = new ArrayList<AgentResults>();
        for (AgentResults result : this.allAgents) {
            StringBuilder name1 = new StringBuilder(result.getFirstName());
            name1.append(" ");
            name1.append(result.getLastName());
            StringBuilder name2 = new StringBuilder(result.getLastName());
            name2.append(", ");
            name2.append(result.getFirstName());
            if (!result.getFirstName().toLowerCase().startsWith(pattern.toLowerCase()) && !result.getLastName().toLowerCase().startsWith(pattern.toLowerCase()) && !result.getAgentEid().toLowerCase().startsWith(pattern.toLowerCase()) && !name1.toString().toLowerCase().startsWith(pattern.toLowerCase()) && !name2.toString().toLowerCase().startsWith(pattern.toLowerCase())) continue;
            filteredList.add(result);
        }
        return filteredList;
    }

    public boolean isMultipleSubmissionsAllowed() {
        return this.multipleSubmissionsAllowed;
    }

    public void setMultipleSubmissionsAllowed(boolean multipleSubmissionsAllowed) {
        this.multipleSubmissionsAllowed = multipleSubmissionsAllowed;
    }

    public boolean getIsTimedAssessment() {
        return this.isTimedAssessment;
    }

    public void setIsTimedAssessment(boolean isTimedAssessment) {
        this.isTimedAssessment = isTimedAssessment;
    }

    public boolean getAcceptLateSubmission() {
        return this.acceptLateSubmission;
    }

    public void setAcceptLateSubmission(boolean acceptLateSubmission) {
        this.acceptLateSubmission = acceptLateSubmission;
    }

    public boolean isReleasedToGroups() {
        return this.getPublishedAssessment().getAssessmentAccessControl().getReleaseTo().equals("Selected Groups");
    }

    public boolean getIsAutoScored() {
        return this.isAutoScored;
    }

    public void setIsAutoScored(boolean isAutoScored) {
        this.isAutoScored = isAutoScored;
    }

    public String getApplyToUngraded() {
        return this.applyToUngraded;
    }

    public void setApplyToUngraded(String applyToUngraded) {
        this.applyToUngraded = applyToUngraded;
    }
}

