/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.qti;

import java.io.InputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringXml;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.sakaiproject.tool.assessment.services.qti.QTIService;
import org.sakaiproject.tool.assessment.ui.bean.qti.XMLDisplay;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLController
implements Serializable {
    private static final long serialVersionUID = 7064783681056628447L;
    private static Log log = LogFactory.getLog(XMLController.class);
    private static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    private XMLDisplay xmlBean;
    private String documentType;
    private String id;
    private int qtiVersion = 1;

    public XMLDisplay getXmlBean() {
        return this.xmlBean;
    }

    public void setXmlBean(XMLDisplay xmlBean) {
        this.xmlBean = xmlBean;
    }

    public String displayAssessmentXml() {
        log.debug((Object)("XMLController debug getQtiVersion(): " + this.getQtiVersion()));
        this.documentType = "assessmentTemplate.xml";
        return this.display();
    }

    public String displaySectionXmlTemplate() {
        this.documentType = "sectionTemplate.xml";
        return this.display();
    }

    public String displayItemXml() {
        this.documentType = "mcSCTemplate.xml";
        this.item();
        return "xmlDisplay";
    }

    public String displayItemBankXml() {
        this.itemBank();
        return "xmlDisplay";
    }

    public String display() {
        AuthoringXml ax = this.getAuthoringXml();
        try {
            if (ax.isAssessment(this.documentType)) {
                this.assessment();
            } else if (ax.isSection(this.documentType)) {
                this.section();
            } else if (ax.isItem(this.documentType)) {
                log.debug((Object)"item type detected");
                this.item();
            } else if (ax.isSurveyFragment(this.documentType)) {
                this.frag();
            }
        }
        catch (Exception ex) {
            this.setUpXmlNoDecl("<error-report>\n" + ex.toString() + "\n" + "</error-report>" + "\n");
            this.xmlBean.setDescription(ex.toString());
            this.xmlBean.setName("error");
            this.xmlBean.setId("");
            ex.printStackTrace();
        }
        return "xmlDisplay";
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private void assessment() {
        this.xmlBean.setId(this.id);
        this.xmlBean.setName(this.documentType);
        if (this.id != null && this.id.length() > 0) {
            QTIService qtiService = new QTIService();
            log.debug((Object)("XMLController.assessment() assessment qtiService.getExportedAssessment(id=" + this.id + ", qtiVersion=" + this.qtiVersion + ")"));
            Document doc = qtiService.getExportedAssessment(this.id, this.qtiVersion);
            this.xmlBean.setDescription("Exported QTI XML produced by Sakai's Tests and Quizzes tool (Samigo)");
            this.xmlBean.setName("assessment " + this.id);
            this.setUpXmlNoDecl(XmlUtil.getDOMString((Node)doc));
        } else {
            this.xmlBean.setDescription("assessment template");
            AuthoringXml ax = this.getAuthoringXml();
            String xml = ax.getTemplateAsString(ax.getTemplateInputStream("assessmentTemplate.xml"));
            this.setUpXmlNoDecl(xml);
        }
    }

    private void setUpXmlNoDecl(String xml) {
        this.setUpXml(xml, false);
    }

    private void setUpXml(String xml, boolean includeXmlDecl) {
        boolean hasXmlDecl = false;
        String startDecl = "<?xml version";
        String endDecl = "?>";
        int endDeclLength = endDecl.length();
        if (xml.startsWith(startDecl)) {
            hasXmlDecl = true;
        }
        if (includeXmlDecl) {
            if (!hasXmlDecl) {
                xml = XML_DECL + xml;
            }
        } else if (hasXmlDecl) {
            int declEndIndex = xml.indexOf(endDecl);
            xml = xml.substring(declEndIndex + endDeclLength);
        }
        this.xmlBean.setXml(xml);
    }

    private void section() {
        this.xmlBean.setId(this.id);
        AuthoringXml ax = this.getAuthoringXml();
        if (this.id != null && this.id.length() > 0) {
            this.xmlBean.setDescription("section fragment id=" + this.id);
            this.xmlBean.setName(this.documentType);
            InputStream is = ax.getTemplateInputStream("sectionTemplate.xml");
            this.setUpXmlNoDecl(ax.getTemplateAsString(is));
        } else {
            this.xmlBean.setDescription("section template");
            this.xmlBean.setName(this.documentType);
            InputStream is = ax.getTemplateInputStream("sectionTemplate.xml");
            this.setUpXmlNoDecl(ax.getTemplateAsString(is));
        }
    }

    private void item() {
        this.xmlBean.setId(this.id);
        if (this.id != null && this.id.length() > 0) {
            QTIService qtiService = new QTIService();
            Document doc = qtiService.getExportedItem(this.id, this.qtiVersion);
            this.xmlBean.setDescription("Exported QTI XML produced by Sakai's Tests and Quizzes tool (Samigo)");
            this.xmlBean.setName("item " + this.id);
            this.setUpXmlNoDecl(XmlUtil.getDOMString((Node)doc));
        } else {
            AuthoringXml ax = this.getAuthoringXml();
            this.xmlBean.setDescription("item template");
            this.xmlBean.setName(this.documentType);
            InputStream is = ax.getTemplateInputStream(this.documentType);
            this.setUpXmlNoDecl(ax.getTemplateAsString(is));
        }
    }

    private void itemBank() {
        this.xmlBean.setId(this.id);
        if (this.id != null && this.id.length() > 0) {
            QTIService qtiService = new QTIService();
            StringTokenizer st = new StringTokenizer(this.id, ",");
            int tokens = st.countTokens();
            String[] ids = new String[tokens];
            int i = 0;
            while (st.hasMoreTokens()) {
                ids[i] = st.nextToken();
                ++i;
            }
            Document doc = qtiService.getExportedItemBank(ids, this.qtiVersion);
            this.xmlBean.setDescription("Exported QTI XML produced by Sakai's Tests and Quizzes tool (Samigo)");
            this.xmlBean.setName("object bank for items " + this.id);
            this.setUpXmlNoDecl(XmlUtil.getDOMString((Node)doc));
        } else {
            log.debug((Object)"object bank empty");
        }
    }

    private void frag() {
        this.xmlBean.setDescription("survey item fragment template");
        this.xmlBean.setName(this.documentType);
        InputStream is = this.getAuthoringXml().getTemplateInputStream(this.documentType);
        this.setUpXmlNoDecl(this.getAuthoringXml().getTemplateAsString(is));
    }

    public int getQtiVersion() {
        if (!QTIVersion.isValid((int)this.qtiVersion)) {
            this.qtiVersion = 1;
        }
        log.debug((Object)("xml controller getQtiVersion()=" + this.qtiVersion));
        return this.qtiVersion;
    }

    public void setQtiVersion(int qtiVersion) {
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new IllegalArgumentException("NOT Legal Qti Version.");
        }
        this.qtiVersion = qtiVersion;
        log.debug((Object)("xml controller setQtiVersion()=" + qtiVersion));
    }

    public AuthoringXml getAuthoringXml() {
        return new AuthoringXml(this.getQtiVersion());
    }
}

