/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.qti;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.contentpackaging.ImportService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.qti.QTIService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;
import org.w3c.dom.Document;

public class XMLImportBean
implements Serializable {
    private static final long serialVersionUID = 418920360211039758L;
    private static Log log = LogFactory.getLog(XMLImportBean.class);
    private int qtiVersion = 1;
    private String uploadFileName;
    private String importType;
    private String pathToData;
    private AuthorBean authorBean;
    private AssessmentBean assessmentBean;
    private ItemAuthorBean itemAuthorBean;
    private QuestionPoolBean questionPoolBean;
    private boolean isCP;
    private String importType2;
    private static final GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();

    public static void main(String[] args) {
    }

    public void importAssessment(ValueChangeEvent e) {
        String sourceType = ContextUtil.lookupParam((String)"sourceType");
        String uploadFile = (String)e.getNewValue();
        if (uploadFile != null && uploadFile.startsWith("SizeTooBig:")) {
            String paramValue = ServerConfigurationService.getString((String)"samigo.sizeMax");
            Long sizeMax = null;
            float sizeMax_float = 0.0f;
            if (paramValue != null) {
                sizeMax = Long.parseLong(paramValue);
                sizeMax_float = sizeMax.floatValue() / 1024.0f;
            }
            int sizeMax_int = Math.round(sizeMax_float);
            ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorImportExport");
            String sizeTooBigMessage = MessageFormat.format(rb.getString("import_size_too_big"), uploadFile.substring(11), sizeMax_int);
            FacesMessage message = new FacesMessage(sizeTooBigMessage);
            FacesContext.getCurrentInstance().addMessage(null, message);
            log.debug((Object)("****Clean up file:" + uploadFile));
            File upload = new File(uploadFile);
            upload.delete();
            this.authorBean.setImportOutcome("importAssessment");
            return;
        }
        this.authorBean.setImportOutcome("author");
        if ("2".equals(sourceType)) {
            if (uploadFile.toLowerCase().endsWith(".zip")) {
                this.isCP = true;
                this.importAssessment(uploadFile, true, true);
            } else {
                this.isCP = false;
                this.importAssessment(uploadFile, false, true);
            }
        } else if (uploadFile.toLowerCase().endsWith(".zip")) {
            this.isCP = true;
            this.importAssessment(uploadFile, true, false);
        } else {
            this.isCP = false;
            this.importAssessment(uploadFile, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importAssessment(String uploadFile, boolean isCP, boolean isRespondus) {
        boolean success2222;
        String unzipLocation;
        block18: {
            String filename = uploadFile;
            unzipLocation = null;
            boolean fileNotFound = false;
            if (isCP) {
                ImportService importService = new ImportService();
                unzipLocation = importService.unzipImportFile(uploadFile);
                filename = unzipLocation + "/" + importService.getQTIFilename();
            }
            try {
                try {
                    this.processFile(filename, uploadFile, isRespondus);
                }
                catch (FileNotFoundException fnfex) {
                    fileNotFound = true;
                    ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorImportExport");
                    FacesMessage message = new FacesMessage(rb.getString("import_qti_not_found"));
                    FacesContext.getCurrentInstance().addMessage(null, message);
                    Object var11_11 = null;
                    boolean success2222 = false;
                    if (!fileNotFound) {
                        log.debug((Object)("****Clean up file: " + filename));
                        File f1 = new File(filename);
                        success2222 = f1.delete();
                        if (!success2222) {
                            log.error((Object)("Failed to delete file " + filename));
                        }
                    }
                    if (!isCP) return;
                    File f2 = new File(uploadFile);
                    success2222 = f2.delete();
                    if (!success2222) {
                        log.error((Object)("Failed to delete file " + uploadFile));
                    }
                    File f3 = new File(unzipLocation);
                    this.deleteDirectory(f3);
                    return;
                }
                catch (Exception ex) {
                    ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorImportExport");
                    FacesMessage message = new FacesMessage(rb.getString("import_err"));
                    FacesContext.getCurrentInstance().addMessage(null, message);
                    Object var11_12 = null;
                    boolean success2222 = false;
                    if (!fileNotFound) {
                        log.debug((Object)("****Clean up file: " + filename));
                        File f1 = new File(filename);
                        success2222 = f1.delete();
                        if (!success2222) {
                            log.error((Object)("Failed to delete file " + filename));
                        }
                    }
                    if (!isCP) return;
                    File f2 = new File(uploadFile);
                    success2222 = f2.delete();
                    if (!success2222) {
                        log.error((Object)("Failed to delete file " + uploadFile));
                    }
                    File f3 = new File(unzipLocation);
                    this.deleteDirectory(f3);
                    return;
                }
                Object var11_10 = null;
                success2222 = false;
                if (fileNotFound) break block18;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                boolean success2222 = false;
                if (!fileNotFound) {
                    log.debug((Object)("****Clean up file: " + filename));
                    File f1 = new File(filename);
                    success2222 = f1.delete();
                    if (!success2222) {
                        log.error((Object)("Failed to delete file " + filename));
                    }
                }
                if (!isCP) throw throwable;
                File f2 = new File(uploadFile);
                success2222 = f2.delete();
                if (!success2222) {
                    log.error((Object)("Failed to delete file " + uploadFile));
                }
                File f3 = new File(unzipLocation);
                this.deleteDirectory(f3);
                throw throwable;
            }
            log.debug((Object)("****Clean up file: " + filename));
            File f1 = new File(filename);
            success2222 = f1.delete();
            if (!success2222) {
                log.error((Object)("Failed to delete file " + filename));
            }
        }
        if (!isCP) return;
        File f2 = new File(uploadFile);
        success2222 = f2.delete();
        if (!success2222) {
            log.error((Object)("Failed to delete file " + uploadFile));
        }
        File f3 = new File(unzipLocation);
        this.deleteDirectory(f3);
    }

    public int getQtiVersion() {
        return this.qtiVersion;
    }

    public void setQtiVersion(int qtiVersion) {
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new IllegalArgumentException("NOT Legal Qti Version.");
        }
        this.qtiVersion = qtiVersion;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getImportType() {
        return this.importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }

    public String getImportType2() {
        return this.importType2;
    }

    public void setImportType2(String importType2) {
        this.importType2 = importType2;
    }

    private void processFile(String fileName, String uploadFile, boolean isRespondus) throws Exception {
        this.itemAuthorBean.setTarget("assessment");
        AssessmentService assessmentService = new AssessmentService();
        ArrayList failedMatchingQuestions = new ArrayList();
        AssessmentFacade assessment = this.createImportedAssessment(fileName, this.qtiVersion, isRespondus, failedMatchingQuestions);
        if (failedMatchingQuestions.size() > 0) {
            String importedFilename = this.getImportedFilename(uploadFile);
            ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorImportExport");
            StringBuffer sb = new StringBuffer("\"");
            sb.append(importedFilename);
            sb.append("\" ");
            sb.append(rb.getString("respondus_matching_err_1"));
            sb.append(" ");
            for (int i = 0; i < failedMatchingQuestions.size() - 1; ++i) {
                sb.append(" ");
                sb.append(failedMatchingQuestions.get(i));
                sb.append(", ");
            }
            sb.append(failedMatchingQuestions.get(failedMatchingQuestions.size() - 1));
            sb.append(". ");
            sb.append(rb.getString("respondus_matching_err_2"));
            FacesMessage message = new FacesMessage(sb.toString());
            FacesContext.getCurrentInstance().addMessage(null, message);
        }
        boolean hasGradebook = false;
        GradebookService g = null;
        if (integrated) {
            g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
        }
        try {
            if (gbsHelper.isAssignmentDefined(assessment.getTitle(), g)) {
                hasGradebook = true;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error calling gradebookHelper");
        }
        if (!hasGradebook && assessment != null) {
            assessment.getEvaluationModel().setToGradeBook(EvaluationModelIfc.NOT_TO_GRADEBOOK.toString());
        }
        assessmentService.saveAssessment(assessment);
        this.assessmentBean.setAssessment((AssessmentIfc)assessment);
        this.authorBean.setAssessTitle("");
        this.authorBean.setAssessmentDescription("");
        this.authorBean.setAssessmentTypeId("");
        this.authorBean.setAssessmentTemplateId(AssessmentTemplateFacade.DEFAULTTEMPLATE.toString());
        ArrayList list = assessmentService.getBasicInfoOfAllActiveAssessments("title", true);
        for (AssessmentFacade assessmentFacade : list) {
            assessmentFacade.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessmentFacade.getTitle()));
        }
        this.authorBean.setAssessments(list);
    }

    private String getImportedFilename(String filename) {
        String temp_filename_1 = filename.substring(filename.lastIndexOf("/") + 1);
        String temp_filename_2 = temp_filename_1.substring(temp_filename_1.indexOf("."));
        String temp_filename_3 = temp_filename_1.substring(0, temp_filename_1.substring(0, temp_filename_1.indexOf(".")).lastIndexOf("_"));
        String final_filename = temp_filename_3 + temp_filename_2;
        return final_filename;
    }

    private void deleteDirectory(File directory) {
        boolean success;
        if (directory.exists()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                boolean success2 = files[i].delete();
                if (success2) continue;
                log.error((Object)"Delete Failed.");
            }
        }
        if (!(success = directory.delete())) {
            log.error((Object)"Delete Failed.");
        }
    }

    private AssessmentFacade createImportedAssessment(String fullFileName, int qti, boolean isRespondus, ArrayList failedMatchingQuestions) throws Exception {
        Document document = null;
        document = XmlUtil.readDocument((String)fullFileName, (boolean)true);
        QTIService qtiService = new QTIService();
        if (this.isCP) {
            return qtiService.createImportedAssessment(document, qti, fullFileName.substring(0, fullFileName.lastIndexOf("/")), isRespondus, failedMatchingQuestions);
        }
        return qtiService.createImportedAssessment(document, qti, null, isRespondus, failedMatchingQuestions);
    }

    public AuthorBean getAuthorBean() {
        return this.authorBean;
    }

    public void setAuthorBean(AuthorBean authorBean) {
        this.authorBean = authorBean;
    }

    public AssessmentBean getAssessmentBean() {
        return this.assessmentBean;
    }

    public void setAssessmentBean(AssessmentBean assessmentBean) {
        this.assessmentBean = assessmentBean;
    }

    public ItemAuthorBean getItemAuthorBean() {
        return this.itemAuthorBean;
    }

    public void setItemAuthorBean(ItemAuthorBean itemAuthorBean) {
        this.itemAuthorBean = itemAuthorBean;
    }

    public void importPoolFromQti(ValueChangeEvent e) {
        String uploadFile = (String)e.getNewValue();
        try {
            this.processAsPoolFile(uploadFile);
        }
        catch (Exception ex) {
            ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorImportExport");
            FacesMessage message = new FacesMessage(rb.getString("import_err"));
            FacesContext.getCurrentInstance().addMessage(null, message);
        }
    }

    private void processAsPoolFile(String uploadFile) throws Exception {
        this.itemAuthorBean.setTarget("questionpool");
        String fileName = uploadFile;
        QuestionPoolFacade questionPool = this.createImportedQuestionPool(fileName, this.qtiVersion);
        try {
            File upload = new File(fileName);
            boolean success = upload.delete();
            if (!success) {
                log.error((Object)("Failed to delete file " + fileName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private QuestionPoolFacade createImportedQuestionPool(String fullFileName, int qti) throws Exception {
        Document document = XmlUtil.readDocument((String)fullFileName, (boolean)true);
        QTIService qtiService = new QTIService();
        return qtiService.createImportedQuestionPool(document, qti);
    }

    public QuestionPoolBean getQuestionPoolBean() {
        return this.questionPoolBean;
    }

    public void setQuestionPoolBean(QuestionPoolBean questionPoolBean) {
        this.questionPoolBean = questionPoolBean;
    }

    public String getPathToData() {
        return this.pathToData;
    }

    public void setPathToData(String pathToData) {
        this.pathToData = pathToData;
    }
}

