/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.questionpool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.upload.FormFile;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.business.questionpool.QuestionPoolTreeImpl;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.SectionService;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolDataBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolDataModel;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;
import org.sakaiproject.util.ResourceLoader;

public class QuestionPoolBean
implements Serializable {
    private static final long serialVersionUID = 418920360211039758L;
    private String name;
    private Collection pools;
    private QuestionPoolDataBean currentPool;
    private QuestionPoolDataBean parentPool;
    private ArrayList currentItemIds;
    private ArrayList currentItems;
    private boolean allPoolsSelected;
    private boolean allItemsSelected;
    private boolean rootPoolSelected;
    private List poolListSelectItems;
    private List poolsToDelete;
    private List itemsToDelete;
    private String[] selectedPools;
    private String[] selectedQuestions;
    private String[] destPools = new String[0];
    private String[] destItems = new String[0];
    private String sourcePart = null;
    private String destPool = "";
    private FormFile filename;
    private int htmlIdLevel;
    private String questionType;
    private int parentPoolSize = 0;
    private ArrayList allItems;
    private String[] searchByTypes = new String[0];
    private String searchQtext;
    private String searchQkeywords;
    private String searchQobj;
    private String searchQrubrics;
    private String assessmentID;
    private String selectedAssessment;
    private String selectedSection;
    private boolean importToAuthoring;
    private String actionType;
    private String sortProperty = "title";
    private boolean sortAscending = true;
    private String sortCopyPoolProperty = "title";
    private boolean sortCopyPoolAscending = true;
    private String sortMovePoolProperty = "title";
    private boolean sortMovePoolAscending = true;
    private String sortSubPoolProperty = "title";
    private boolean sortSubPoolAscending = true;
    private String sortQuestionProperty = "text";
    private boolean sortQuestionAscending = true;
    private ArrayList addedPools;
    private ArrayList addedQuestions;
    private ItemFacade itemToPreview;
    private static Log log = LogFactory.getLog(QuestionPoolBean.class);
    private Tree tree;
    private Collection qpools;
    private Collection copyQpools;
    private Collection moveQpools;
    private Collection sortedSubqpools;
    private QuestionPoolDataModel qpDataModel;
    private QuestionPoolDataModel qpDataModelCopy;
    private QuestionPoolDataModel subQpDataModel;
    private String addOrEdit;
    private String outcome;
    private String outcomeEdit;
    private String deletePoolSource;
    private String addPoolSource;
    private ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.QuestionPoolMessages");

    public QuestionPoolBean() {
        this.resetFields();
    }

    public QuestionPoolDataModel getQpools() {
        if (this.qpDataModel == null) {
            this.buildTree();
            this.setQpDataModelByLevel();
        }
        log.debug((Object)"getQpools");
        return this.qpDataModel;
    }

    public QuestionPoolDataModel getCopyQpools() {
        this.buildTreeCopy();
        this.setQpDataModelByLevelCopy();
        log.debug((Object)"getCopyQpools()");
        return this.qpDataModelCopy;
    }

    public QuestionPoolDataModel getMoveQpools() {
        this.buildTreeCopy();
        this.setQpDataModelByLevelCopy();
        log.debug((Object)"getMoveQpools()");
        return this.qpDataModelCopy;
    }

    public QuestionPoolDataModel getSortedSubqpools() {
        log.debug((Object)"getSortedSubqpools()");
        return this.subQpDataModel;
    }

    public void sortSubqpoolsByProperty(ArrayList sortedList, String sortProperty, boolean sortAscending) {
        BeanSort sort = new BeanSort((Collection)sortedList, sortProperty);
        if ("lastModified".equals(sortProperty)) {
            sort.toDateSort();
        } else {
            sort.toStringSort();
        }
        sort.sort();
        if (!sortAscending) {
            Collections.reverse(sortedList);
        }
    }

    public void sortQpoolsByProperty(ArrayList sortedList, String sortProperty, boolean sortAscending) {
        BeanSort sort = new BeanSort((Collection)sortedList, sortProperty);
        if ("title".equals(sortProperty)) {
            Collections.sort(sortedList, new TitleComparator(this));
        } else {
            if ("lastModified".equals(sortProperty)) {
                sort.toDateSort();
            } else {
                sort.toStringSort();
            }
            sortedList = (ArrayList)sort.sort();
        }
        if (!sortAscending) {
            Collections.reverse(sortedList);
        }
    }

    public void setAllItems(ArrayList list) {
        this.allItems = list;
    }

    public ArrayList getAllItems() {
        return this.allItems;
    }

    public void setSortedSubqpools(Collection spools) {
        this.sortedSubqpools = spools;
    }

    public void buildTree() {
        try {
            QuestionPoolService delegate = new QuestionPoolService();
            this.tree = new QuestionPoolTreeImpl(delegate.getAllPoolsWithAccess(AgentFacade.getAgentString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void buildTreeCopy() {
        try {
            QuestionPoolService delegate = new QuestionPoolService();
            this.tree = new QuestionPoolTreeImpl(delegate.getAllPools(AgentFacade.getAgentString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void printChildrenPool(Tree tree, QuestionPoolDataIfc pool, String stars) {
        List children = tree.getChildList(pool.getQuestionPoolId());
        Map childrenMap = tree.getChildren(pool.getQuestionPoolId());
        stars = stars + "**";
        for (int i = 0; i < children.size(); ++i) {
            QuestionPoolDataIfc child = (QuestionPoolDataIfc)childrenMap.get(children.get(i).toString());
            this.printChildrenPool(tree, child, stars);
        }
    }

    public List getPoolListSelectItems() {
        if (this.poolListSelectItems == null) {
            this.poolListSelectItems = new ArrayList();
            Collection objects = this.tree.getSortedObjects();
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                try {
                    QuestionPoolFacade pool = (QuestionPoolFacade)iter.next();
                    this.poolListSelectItems.add(new SelectItem((Object)pool.getQuestionPoolId().toString(), pool.getDisplayName()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.poolListSelectItems;
    }

    public void setItemsToDelete(List qpools) {
        this.itemsToDelete = qpools;
    }

    public List getItemsToDelete() {
        return this.itemsToDelete;
    }

    public void setPoolsToDelete(List qpools) {
        this.poolsToDelete = qpools;
    }

    public List getPoolsToDelete() {
        ArrayList<QuestionPoolFacade> poolsToDeleteList = new ArrayList<QuestionPoolFacade>();
        if (this.poolsToDelete != null) {
            Iterator iter = this.poolsToDelete.iterator();
            while (iter.hasNext()) {
                try {
                    QuestionPoolFacade pool = (QuestionPoolFacade)iter.next();
                    poolsToDeleteList.add(pool);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return poolsToDeleteList;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree newtree) {
        this.tree = newtree;
    }

    public Collection getPools() {
        return this.pools;
    }

    public Object[] getPoolArray() {
        return this.pools.toArray();
    }

    public void setPools(Collection newPools) {
        this.pools = newPools;
    }

    public void setQuestionType(String newtype) {
        this.questionType = newtype;
    }

    public String getQuestionType() {
        return this.questionType;
    }

    public void setSearchQtext(String pstr) {
        this.searchQtext = pstr;
    }

    public String getSearchQtext() {
        return this.searchQtext;
    }

    public void setSearchQkeywords(String pstr) {
        this.searchQkeywords = pstr;
    }

    public String getSearchQkeywords() {
        return this.searchQkeywords;
    }

    public void setSearchQobj(String pstr) {
        this.searchQobj = pstr;
    }

    public String getSearchQobj() {
        return this.searchQobj;
    }

    public void setSearchQrubrics(String pstr) {
        this.searchQrubrics = pstr;
    }

    public String getSearchQrubrics() {
        return this.searchQrubrics;
    }

    public String getSourcePart() {
        return this.sourcePart;
    }

    public void setSourcePart(String s) {
        this.sourcePart = s;
    }

    public ArrayList getCurrentItemIds() {
        return this.currentItemIds;
    }

    public void setCurrentItemIds(ArrayList pstr) {
        this.currentItemIds = pstr;
    }

    public ArrayList getCurrentItems() {
        return this.currentItems;
    }

    public void setCurrentItems(ArrayList param) {
        this.currentItems = param;
    }

    public ItemFacade getItemToPreview() {
        return this.itemToPreview;
    }

    public void setItemToPreview(ItemFacade param) {
        this.itemToPreview = param;
    }

    public QuestionPoolDataBean getCurrentPool() {
        return this.currentPool;
    }

    public void setCurrentPool(QuestionPoolDataBean newPool) {
        this.currentPool = newPool;
    }

    public QuestionPoolDataBean getParentPool() {
        return this.parentPool;
    }

    public void setParentPool(QuestionPoolDataBean newPool) {
        this.parentPool = newPool;
    }

    public void setParentPoolSize(int n) {
        this.parentPoolSize = n;
    }

    public int getParentPoolSize() {
        return this.parentPoolSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setRootPoolSelected(boolean pallpools) {
        this.rootPoolSelected = pallpools;
    }

    public boolean getRootPoolSelected() {
        return this.rootPoolSelected;
    }

    public void setAllPoolsSelected(boolean pallpools) {
        this.allPoolsSelected = pallpools;
    }

    public void setAllItemsSelected(boolean pallpools) {
        this.allItemsSelected = pallpools;
    }

    public boolean getAllItemsSelected() {
        return this.allItemsSelected;
    }

    public boolean getAllPoolsSelected() {
        return this.allPoolsSelected;
    }

    public void setDestPool(String pPool) {
        this.destPool = pPool;
    }

    public String getDestPool() {
        return this.destPool;
    }

    public void setDestPools(String[] pPool) {
        this.destPools = pPool;
    }

    public String[] getDestPools() {
        return this.destPools;
    }

    public void setDestItems(String[] pPool) {
        this.destItems = pPool;
    }

    public String[] getDestItems() {
        return this.destItems;
    }

    public void setSearchByTypes(String[] pstr) {
        this.searchByTypes = pstr;
    }

    public String[] getSearchByTypes() {
        return this.searchByTypes;
    }

    public String getAssessmentID() {
        return this.assessmentID;
    }

    public void setAssessmentID(String pstr) {
        this.assessmentID = pstr;
    }

    public String getSelectedAssessment() {
        return this.selectedAssessment;
    }

    public void setSelectedAssessment(String pstr) {
        this.selectedAssessment = pstr;
    }

    public String getSelectedSection() {
        return this.selectedSection;
    }

    public void setSelectedSection(String pstr) {
        this.selectedSection = pstr;
    }

    public boolean getImportToAuthoring() {
        return this.importToAuthoring;
    }

    public void setImportToAuthoring(boolean pstr) {
        this.importToAuthoring = pstr;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean pstr) {
        this.sortAscending = pstr;
    }

    public boolean getSortCopyPoolAscending() {
        return this.sortCopyPoolAscending;
    }

    public void setSortCopyPoolAscending(boolean pstr) {
        this.sortCopyPoolAscending = pstr;
    }

    public boolean getSortMovePoolAscending() {
        return this.sortMovePoolAscending;
    }

    public void setSortMovePoolAscending(boolean pstr) {
        this.sortMovePoolAscending = pstr;
    }

    public boolean getSortSubPoolAscending() {
        return this.sortSubPoolAscending;
    }

    public void setSortSubPoolAscending(boolean pstr) {
        this.sortSubPoolAscending = pstr;
    }

    public boolean getSortQuestionAscending() {
        return this.sortQuestionAscending;
    }

    public void setSortQuestionAscending(boolean pstr) {
        this.sortQuestionAscending = pstr;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String pstr) {
        this.actionType = pstr;
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String newProperty) {
        this.sortProperty = newProperty;
    }

    public String getSortCopyPoolProperty() {
        return this.sortCopyPoolProperty;
    }

    public void setSortCopyPoolProperty(String newProperty) {
        this.sortCopyPoolProperty = newProperty;
    }

    public String getSortMovePoolProperty() {
        return this.sortMovePoolProperty;
    }

    public void setSortMovePoolProperty(String newProperty) {
        this.sortMovePoolProperty = newProperty;
    }

    public String getSortSubPoolProperty() {
        return this.sortSubPoolProperty;
    }

    public void setSortSubPoolProperty(String newProperty) {
        this.sortSubPoolProperty = newProperty;
    }

    public String getSortQuestionProperty() {
        return this.sortQuestionProperty;
    }

    public void setSortQuestionProperty(String newProperty) {
        this.sortQuestionProperty = newProperty;
    }

    public String getAddOrEdit() {
        return this.addOrEdit;
    }

    public void setAddOrEdit(String param) {
        this.addOrEdit = param;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String param) {
        this.outcome = param;
    }

    public String getOutcomeEdit() {
        return this.outcomeEdit;
    }

    public void setOutcomeEdit(String param) {
        this.outcomeEdit = param;
    }

    public String getDeletePoolSource() {
        return this.deletePoolSource;
    }

    public void setDeletePoolSource(String param) {
        this.deletePoolSource = param;
    }

    public String getAddPoolSource() {
        return this.addPoolSource;
    }

    public void setAddPoolSource(String param) {
        this.addPoolSource = param;
    }

    public void setSelectedQuestions(String[] pPool) {
        this.selectedQuestions = pPool;
    }

    public void setSelectedPools(String[] pPool) {
        this.selectedPools = pPool;
    }

    public String[] getSelectedQuestions() {
        return this.selectedQuestions;
    }

    public String[] getSelectedPools() {
        return this.selectedPools;
    }

    public void setFilename(FormFile file) {
        this.filename = file;
    }

    public FormFile getFilename() {
        return this.filename;
    }

    public int getHtmlIdLevel() {
        return this.htmlIdLevel;
    }

    public void setHtmlIdLevel(int plevel) {
        this.htmlIdLevel = plevel;
    }

    public void resetFields() {
        this.pools = new ArrayList();
    }

    public String startCopyQuestion() {
        this.sourcePart = null;
        this.getCheckedQuestion();
        return "copyPool";
    }

    public String startMoveQuestion() {
        this.getCheckedQuestion();
        return "movePool";
    }

    public String startCopyQuestions() {
        this.sourcePart = null;
        this.getCheckedQuestions();
        return "copyPool";
    }

    public String startMoveQuestions() {
        this.getCheckedQuestions();
        return "movePool";
    }

    public String moveQuestion() {
        String sourceId = "";
        String destId = "";
        sourceId = this.getCurrentPool().getId().toString();
        ArrayList sourceItemIds = this.getCurrentItemIds();
        destId = ContextUtil.lookupParam((String)"movePool:selectedRadioBtn");
        if (sourceId != null && destId != null && sourceItemIds != null) {
            try {
                QuestionPoolService delegate = new QuestionPoolService();
                for (String sourceItemId : sourceItemIds) {
                    if (this.hasItemInDestPool(sourceItemId, destId)) continue;
                    delegate.moveItemToPool(sourceItemId, new Long(sourceId), new Long(destId));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.questionpool.questionmoved", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/sourceId=" + sourceId + " destId=" + destId), (boolean)true));
        this.buildTree();
        this.setQpDataModelByLevel();
        return "poolList";
    }

    public String startCopyFromAssessment() {
        QuestionPoolService delegate = new QuestionPoolService();
        ArrayList pools = delegate.getBasicInfoOfAllPools(AgentFacade.getAgentString());
        Iterator iter = pools.iterator();
        if (iter.hasNext()) {
            QuestionPoolFacade pool = (QuestionPoolFacade)iter.next();
            String poolId = pool.getQuestionPoolId().toString();
            this.buildTree();
            this.startEditPoolAgain(poolId);
            this.setActionType("item");
            this.sourcePart = ContextUtil.lookupParam((String)"sectionId");
            return "copyPool";
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String err = this.rb.getString("no_pools_error");
        context.addMessage(null, new FacesMessage(err));
        return "editAssessment";
    }

    public boolean hasItemInDestPool(String sourceItemId, String destId) {
        QuestionPoolService delegate = new QuestionPoolService();
        if (delegate.hasItem(sourceItemId, new Long(destId))) {
            FacesContext context = FacesContext.getCurrentInstance();
            String err = this.rb.getString("copy_duplicate_error");
            context.addMessage(null, new FacesMessage(err));
            return true;
        }
        return false;
    }

    public String copyQuestion() {
        if (this.getSourcePart() != null) {
            return this.copyQuestionsFromPart();
        }
        String destId2 = "";
        ArrayList sourceItems = this.getCurrentItems();
        ArrayList destpools = ContextUtil.paramArrayValueLike((String)"checkboxes");
        for (String destId2 : destpools) {
            if (sourceItems == null || destId2 == null) continue;
            try {
                QuestionPoolService questionPoolService = new QuestionPoolService();
                QuestionPoolService delegate = new QuestionPoolService();
                for (ItemFacade sourceItem : sourceItems) {
                    String sourceItemId = sourceItem.getItemIdString();
                    if (this.hasItemInDestPool(sourceItemId, destId2)) continue;
                    String copyItemFacadeId = questionPoolService.copyItemFacade(sourceItem.getData()).toString();
                    delegate.addItemToPool(copyItemFacadeId, new Long(destId2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.buildTree();
        this.setQpDataModelByLevel();
        return "poolList";
    }

    public String copyQuestionsFromPart() {
        SectionService sectiondelegate = new SectionService();
        SectionFacade section = sectiondelegate.getSection(new Long(this.getSourcePart()), AgentFacade.getAgentString());
        Set itemSet = section.getItemSet();
        ArrayList destpools = ContextUtil.paramArrayValueLike((String)"checkboxes");
        for (String destId : destpools) {
            if (itemSet == null || destId == null) continue;
            try {
                QuestionPoolService delegate = new QuestionPoolService();
                for (ItemDataIfc sourceItem : itemSet) {
                    String sourceItemId = delegate.copyItemFacade(sourceItem).toString();
                    delegate.addItemToPool(sourceItemId, new Long(destId));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return "editAssessment";
    }

    public String removeQuestionsFromPool() {
        String sourceId = this.getCurrentPool().getId().toString();
        List itemlist = this.getItemsToDelete() == null ? new ArrayList() : this.getItemsToDelete();
        for (ItemFacade itemfacade : itemlist) {
            ItemService itemdelegate;
            String itemid = itemfacade.getItemIdString();
            QuestionPoolService delegate = new QuestionPoolService();
            delegate.removeQuestionFromPool(itemid, new Long(sourceId));
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.questionpool.deleteitem", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/removed itemId=" + itemid), (boolean)true));
            List poollist = delegate.getPoolIdsByItem(itemfacade.getItemIdString());
            if (!poollist.isEmpty()) continue;
            if (itemfacade.getSection() == null) {
                itemdelegate = new ItemService();
                itemdelegate.deleteItem(itemfacade.getItemId(), AgentFacade.getAgentString());
                continue;
            }
            itemdelegate = new ItemService();
            itemdelegate.deleteItemMetaData(itemfacade.getItemId(), "POOLID", AgentFacade.getAgentString());
        }
        this.buildTree();
        this.startEditPoolAgain(sourceId);
        return "editPool";
    }

    public void getCheckedQuestion() {
        String itemId = ContextUtil.lookupParam((String)"itemid");
        ItemService delegate = new ItemService();
        ItemFacade itemfacade = delegate.getItem(new Long(itemId), AgentFacade.getAgentString());
        ArrayList<String> itemIds = new ArrayList<String>();
        itemIds.add(itemId);
        this.setCurrentItemIds(itemIds);
        ArrayList<ItemFacade> itemFacades = new ArrayList<ItemFacade>();
        itemFacades.add(itemfacade);
        this.setCurrentItems(itemFacades);
        this.setActionType("item");
    }

    public void getCheckedQuestions() {
        ArrayList destItems = ContextUtil.paramArrayValueLike((String)"removeCheckbox");
        ArrayList<String> itemIds = new ArrayList<String>();
        ArrayList<ItemFacade> itemFacades = new ArrayList<ItemFacade>();
        ItemService delegate = new ItemService();
        for (String itemId : destItems) {
            ItemFacade itemfacade = delegate.getItem(new Long(itemId), AgentFacade.getAgentString());
            itemFacades.add(itemfacade);
            itemIds.add(itemId);
        }
        this.setCurrentItemIds(itemIds);
        this.setCurrentItems(itemFacades);
        this.setActionType("item");
    }

    public String startCopyPool() {
        log.debug((Object)"inside startCopyPool()");
        this.getCheckedPool();
        this.buildTreeCopy();
        this.setActionType("pool");
        this.setQpDataModelByPropertyCopy();
        return "copyPool";
    }

    public String startMovePool() {
        log.debug((Object)"inside startMovePool()");
        this.getCheckedPool();
        this.buildTreeCopy();
        this.setActionType("pool");
        this.setQpDataModelByPropertyCopy();
        return "movePool";
    }

    public void getCheckedPool() {
        try {
            QuestionPoolDataBean pool = new QuestionPoolDataBean();
            String qpid = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("qpid");
            if (qpid == null || qpid.equals("null")) {
                return;
            }
            pool.setId(new Long(qpid));
            QuestionPoolService delegate = new QuestionPoolService();
            QuestionPoolFacade thepool = delegate.getPool(new Long(qpid), AgentFacade.getAgentString());
            this.tree.setCurrentId(thepool.getQuestionPoolId());
            pool.setDisplayName(thepool.getDisplayName());
            pool.setParentPoolId(thepool.getParentPoolId());
            pool.setDescription(thepool.getDescription());
            pool.setOwner(thepool.getOwnerDisplayName());
            pool.setObjectives(thepool.getObjectives());
            pool.setKeywords(thepool.getKeywords());
            pool.setOrganizationName(thepool.getOrganizationName());
            pool.setNumberOfSubpools(thepool.getSubPoolSize().toString());
            pool.setNumberOfQuestions(thepool.getQuestionSize().toString());
            pool.setLastModified(new Date());
            this.setCurrentPool(pool);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String copyPool() {
        Long sourceId = 0L;
        String destId2 = "";
        boolean isUnique = true;
        ArrayList destpools = ContextUtil.paramArrayValueLike((String)"checkboxes");
        sourceId = this.getCurrentPool().getId();
        String currentName = this.getCurrentPool().getDisplayName();
        for (String destId2 : destpools) {
            QuestionPoolService delegate = new QuestionPoolService();
            if (sourceId == 0L || destId2 == null) continue;
            try {
                QuestionPoolFacade oldPool = delegate.getPool(sourceId, AgentFacade.getAgentString());
                if (!destId2.equals(oldPool.getParentPoolId().toString()) && !(isUnique = delegate.poolIsUnique("0", currentName, destId2, AgentFacade.getAgentString()))) {
                    String err1 = this.rb.getString("copy_duplicateName_error");
                    FacesContext context = FacesContext.getCurrentInstance();
                    context.addMessage(null, new FacesMessage(err1));
                    return "copyPool";
                }
                ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.QuestionPoolMessages");
                String copy = rb.getString("prepend_copy");
                String of = rb.getString("prepend_of");
                delegate.copyPool(this.tree, AgentFacade.getAgentString(), sourceId, new Long(destId2), copy, of);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.buildTree();
        this.setQpDataModelByLevel();
        return "poolList";
    }

    public String movePool() {
        String sourceId = "";
        String destId = "";
        sourceId = this.getCurrentPool().getId().toString();
        String currentName = this.getCurrentPool().getDisplayName();
        boolean isUnique = true;
        destId = ContextUtil.lookupParam((String)"movePool:selectedRadioBtn");
        if (sourceId != null && destId != null && !"".equals(destId)) {
            try {
                QuestionPoolService delegate = new QuestionPoolService();
                isUnique = delegate.poolIsUnique("0", currentName, destId, AgentFacade.getAgentString());
                if (!isUnique) {
                    String err1 = this.rb.getString("move_duplicateName_error");
                    FacesContext context = FacesContext.getCurrentInstance();
                    context.addMessage(null, new FacesMessage(err1));
                    return "movePool";
                }
                delegate.movePool(AgentFacade.getAgentString(), new Long(sourceId), new Long(destId));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.buildTree();
        this.setQpDataModelByLevel();
        return "poolList";
    }

    public String addPool() {
        String addsource = "poollist";
        addsource = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("addsource");
        this.setAddPoolSource(addsource);
        this.startCreatePool();
        this.setAddOrEdit("add");
        QuestionPoolDataBean pool = new QuestionPoolDataBean();
        this.setPoolInfo(pool);
        this.setParentPool(pool);
        return "addPool";
    }

    public void startCreatePool() {
        try {
            QuestionPoolDataBean pool = new QuestionPoolDataBean();
            int htmlIdLevel = 0;
            pool.setOwner(AgentFacade.getDisplayName((String)AgentFacade.getAgentString()));
            String qpid = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("qpid");
            if (qpid != null && !qpid.equals("0")) {
                pool.setParentPoolId(new Long(qpid));
            }
            pool.setLastModified(new Date());
            this.setCurrentPool(pool);
            this.setHtmlIdLevel(htmlIdLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String confirmRemovePool() {
        this.setDeletePoolSource("editpool");
        String poolId = ContextUtil.lookupParam((String)"qpid");
        ArrayList<QuestionPoolFacade> qpools = new ArrayList<QuestionPoolFacade>();
        QuestionPoolService delegate = new QuestionPoolService();
        QuestionPoolFacade qPool = delegate.getPool(new Long(poolId), AgentFacade.getAgentString());
        qpools.add(qPool);
        this.setPoolsToDelete(qpools);
        return "removePool";
    }

    public String startRemovePool() {
        this.setDeletePoolSource("poollist");
        String poolId2 = "";
        ArrayList destpools = ContextUtil.paramArrayValueLike((String)"removeCheckbox");
        ArrayList<QuestionPoolFacade> qpools = new ArrayList<QuestionPoolFacade>();
        for (String poolId2 : destpools) {
            QuestionPoolService delegate = new QuestionPoolService();
            QuestionPoolFacade qPool = delegate.getPool(new Long(poolId2), AgentFacade.getAgentString());
            qpools.add(qPool);
        }
        this.setPoolsToDelete(qpools);
        return "removePool";
    }

    public String removePool() {
        QuestionPoolService delegate = new QuestionPoolService();
        List qpools = this.getPoolsToDelete();
        for (QuestionPoolFacade pool : qpools) {
            Long poolId = pool.getQuestionPoolId();
            delegate.deletePool(poolId, AgentFacade.getAgentString(), this.tree);
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.questionpool.delete", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/removed poolId=" + poolId), (boolean)true));
        }
        this.buildTree();
        if (this.getDeletePoolSource().equals("editpool")) {
            Collection objects = this.tree.getSortedObjects(this.getCurrentPool().getId());
            this.setSortedSubqpools(objects);
            QuestionPoolFacade thepool = delegate.getPool(this.getCurrentPool().getId(), AgentFacade.getAgentString());
            this.getCurrentPool().setNumberOfSubpools(thepool.getSubPoolSize().toString());
            this.setSubQpDataModelByLevel();
            return "editPool";
        }
        this.setQpDataModelByLevel();
        return "poolList";
    }

    public String cancelPool() {
        this.buildTree();
        this.setQpDataModelByLevel();
        return "poolList";
    }

    public String importPool() {
        return "importPool";
    }

    public String importQuestion() {
        return "importQuestion";
    }

    public String exportPool() {
        return "exportPool";
    }

    public String exportQuestion() {
        return "exportQuestion";
    }

    public String returnToAuthoring() {
        return "author";
    }

    public String editPool() {
        this.startEditPool();
        this.setAddOrEdit("edit");
        this.setSubQpDataModelByLevel();
        return "editPool";
    }

    public void startEditPool() {
        String qpid = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("qpid");
        this.startEditPoolAgain(qpid);
    }

    public void startEditPoolAgain(String qpid) {
        try {
            QuestionPoolDataBean pool = new QuestionPoolDataBean();
            int htmlIdLevel = 0;
            ArrayList<QuestionPoolFacade> allparentPools = new ArrayList<QuestionPoolFacade>();
            if (qpid == null) {
                return;
            }
            pool.setId(new Long(qpid));
            QuestionPoolService delegate = new QuestionPoolService();
            QuestionPoolFacade thepool = delegate.getPool(new Long(qpid), AgentFacade.getAgentString());
            this.tree.setCurrentId(thepool.getQuestionPoolId());
            Long ppoolid = thepool.getParentPoolId();
            pool.setParentPools(allparentPools);
            pool.setParentPoolsArray(allparentPools);
            while (!ppoolid.toString().equals("0")) {
                QuestionPoolFacade ppool = delegate.getPool(ppoolid, AgentFacade.getAgentString());
                if (ppool == null) continue;
                allparentPools.add(0, ppool);
                ppoolid = ppool.getParentPoolId();
            }
            if (allparentPools != null) {
                pool.setParentPools(allparentPools);
                pool.setParentPoolsArray(allparentPools);
            }
            this.setParentPoolSize(allparentPools.size());
            String htmlID = this.tree.getCurrentObjectHTMLId();
            String[] result = htmlID.split("-");
            htmlIdLevel = result.length + 1;
            pool.setDisplayName(thepool.getDisplayName());
            pool.setParentPoolId(thepool.getParentPoolId());
            pool.setDescription(thepool.getDescription());
            pool.setOwner(thepool.getOwnerDisplayName());
            pool.setObjectives(thepool.getObjectives());
            pool.setOrganizationName(thepool.getOrganizationName());
            pool.setKeywords(thepool.getKeywords());
            pool.setNumberOfSubpools(thepool.getSubPoolSize().toString());
            pool.setNumberOfQuestions(thepool.getQuestionSize().toString());
            pool.setDateCreated(thepool.getDateCreated());
            Collection objects = this.tree.getSortedObjects(thepool.getQuestionPoolId());
            this.setSortedSubqpools(objects);
            pool.setLastModified(new Date());
            this.setCurrentPool(pool);
            this.setHtmlIdLevel(htmlIdLevel);
            ArrayList list = delegate.getAllItemsSorted(this.getCurrentPool().getId(), this.getSortQuestionProperty(), String.valueOf(this.getSortQuestionAscending()));
            this.setAllItems(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String selectQuestionType() {
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        String poolid = ContextUtil.lookupParam((String)"poolId");
        if (poolid != null) {
            itemauthorbean.setQpoolId(poolid);
            itemauthorbean.setTarget("questionpool");
            itemauthorbean.setItemType("");
            itemauthorbean.setItemTypeString("");
            QuestionPoolDataBean pool = this.getCurrentPool();
            this.setPoolInfo(pool);
            this.setCurrentPool(pool);
            return "selectQuestionType";
        }
        return "editPool";
    }

    public String sortByColumnHeader() {
        String sortString = ContextUtil.lookupParam((String)"orderBy");
        String ascending = ContextUtil.lookupParam((String)"ascending");
        this.setSortProperty(sortString);
        this.setSortAscending(Boolean.valueOf(ascending).booleanValue());
        this.setQpDataModelByLevel();
        this.setQpDataModelByLevelCopy();
        return "poolList";
    }

    public String sortCopyPoolByColumnHeader() {
        String sortString = ContextUtil.lookupParam((String)"copyPoolOrderBy");
        String ascending = ContextUtil.lookupParam((String)"copyPoolAscending");
        this.setSortCopyPoolProperty(sortString);
        this.setSortCopyPoolAscending(Boolean.valueOf(ascending).booleanValue());
        this.setQpDataModelByLevel();
        this.setQpDataModelByLevelCopy();
        return "copyPool";
    }

    public String sortMovePoolByColumnHeader() {
        String sortString = ContextUtil.lookupParam((String)"movePoolOrderBy");
        String ascending = ContextUtil.lookupParam((String)"movePoolAscending");
        this.setSortMovePoolProperty(sortString);
        this.setSortMovePoolAscending(Boolean.valueOf(ascending).booleanValue());
        this.setQpDataModelByLevel();
        this.setQpDataModelByLevelCopy();
        return "movePool";
    }

    public String sortSubPoolByColumnHeader() {
        String sortString = ContextUtil.lookupParam((String)"subPoolOrderBy");
        String ascending = ContextUtil.lookupParam((String)"subPoolAscending");
        this.setSortSubPoolProperty(sortString);
        this.setSortSubPoolAscending(Boolean.valueOf(ascending).booleanValue());
        this.setSubQpDataModelByLevel();
        return "editPool";
    }

    public String doit() {
        return this.outcome;
    }

    public String cancelImport() {
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        this.setImportToAuthoring(false);
        itemauthorbean.setItemTypeString("");
        return "editAssessment";
    }

    public boolean getSelfOrDescendant() {
        boolean isDescendant = false;
        boolean isSelf = false;
        isDescendant = this.tree.isDescendantOf(this.tree.getCurrentId(), this.getCurrentPool().getId());
        if (this.tree.getCurrentId().equals(this.getCurrentPool().getId())) {
            isSelf = true;
        }
        return isSelf || isDescendant;
    }

    private HashMap buildHash(Collection objects) {
        HashMap<Long, ArrayList<QuestionPoolDataIfc>> map = new HashMap<Long, ArrayList<QuestionPoolDataIfc>>();
        for (QuestionPoolDataIfc pool : objects) {
            Long parentPoolId = pool.getParentPoolId();
            ArrayList<QuestionPoolDataIfc> poolList = (ArrayList<QuestionPoolDataIfc>)map.get(parentPoolId);
            if (poolList == null) {
                poolList = new ArrayList<QuestionPoolDataIfc>();
                map.put(parentPoolId, poolList);
            }
            poolList.add(pool);
        }
        return map;
    }

    public ArrayList sortPoolByLevel(Long level, Collection objects, String sortProperty, boolean sortAscending) {
        HashMap map = this.buildHash(objects);
        for (Map.Entry entry : map.entrySet()) {
            ArrayList poolList = (ArrayList)entry.getValue();
            this.sortQpoolsByProperty(poolList, sortProperty, sortAscending);
        }
        ArrayList sortedList = new ArrayList();
        ArrayList firstLevelPoolList = (ArrayList)map.get(level);
        if (firstLevelPoolList != null) {
            this.addPoolByLevel(sortedList, map, firstLevelPoolList);
        }
        return sortedList;
    }

    private void addPoolByLevel(ArrayList sortedList, HashMap map, ArrayList poolList) {
        for (int i = 0; i < poolList.size(); ++i) {
            QuestionPoolDataIfc pool = (QuestionPoolDataIfc)poolList.get(i);
            sortedList.add(pool);
            ArrayList nextLevelPoolList = (ArrayList)map.get(pool.getQuestionPoolId());
            if (nextLevelPoolList == null) continue;
            this.addPoolByLevel(sortedList, map, nextLevelPoolList);
        }
    }

    public ArrayList getAddedPools() {
        return this.addedPools;
    }

    public void setAddedPools(ArrayList addedPools) {
        this.addedPools = addedPools;
    }

    public ArrayList getAddedQuestions() {
        return this.addedQuestions;
    }

    public void setAddedQuestions(ArrayList addedQuestions) {
        this.addedQuestions = addedQuestions;
    }

    private void setPoolInfo(QuestionPoolDataBean pool) {
        String nameField = ContextUtil.lookupParam((String)"namefield");
        String orgField = ContextUtil.lookupParam((String)"orgfield");
        String descField = ContextUtil.lookupParam((String)"descfield");
        String objField = ContextUtil.lookupParam((String)"objfield");
        String keyField = ContextUtil.lookupParam((String)"keyfield");
        pool.setDisplayName(nameField);
        pool.setOrganizationName(orgField);
        pool.setDescription(descField);
        pool.setObjectives(objField);
        pool.setKeywords(keyField);
    }

    public void setQpDataModelByLevel() {
        Collection objects = this.tree.getSortedObjects();
        if (objects != null) {
            QuestionPoolDataModel qpDataModel;
            ArrayList sortedList = this.sortPoolByLevel(new Long("0"), objects, this.getSortProperty(), this.getSortAscending());
            ListDataModel model = new ListDataModel((List)sortedList);
            this.qpDataModel = qpDataModel = new QuestionPoolDataModel(this.tree, (DataModel)model);
        }
    }

    public void setQpDataModelByProperty() {
        QuestionPoolDataModel qpDataModel;
        this.tree.sortByProperty(this.getSortCopyPoolProperty(), this.getSortCopyPoolAscending());
        Collection objects = this.tree.getSortedObjects();
        ListDataModel model = new ListDataModel((List)objects);
        this.qpDataModel = qpDataModel = new QuestionPoolDataModel(this.tree, (DataModel)model);
    }

    public void setQpDataModelByLevelCopy() {
        Collection objects = this.tree.getSortedObjects();
        if (objects != null) {
            QuestionPoolDataModel qpDataModel;
            ArrayList sortedList = this.sortPoolByLevel(new Long("0"), objects, this.getSortProperty(), this.getSortAscending());
            ListDataModel model = new ListDataModel((List)sortedList);
            this.qpDataModelCopy = qpDataModel = new QuestionPoolDataModel(this.tree, (DataModel)model);
        }
    }

    public void setQpDataModelByPropertyCopy() {
        QuestionPoolDataModel qpDataModel;
        this.tree.sortByProperty(this.getSortCopyPoolProperty(), this.getSortCopyPoolAscending());
        Collection objects = this.tree.getSortedObjects();
        ListDataModel model = new ListDataModel((List)objects);
        this.qpDataModelCopy = qpDataModel = new QuestionPoolDataModel(this.tree, (DataModel)model);
    }

    public void setSubQpDataModelByLevel() {
        ArrayList subpools = (ArrayList)this.tree.getSortedObjects(this.getCurrentPool().getId());
        if (subpools != null) {
            QuestionPoolDataModel subQpDataModel;
            ArrayList sortedList = this.sortPoolByLevel(this.getCurrentPool().getId(), (Collection)subpools, this.getSortSubPoolProperty(), this.getSortSubPoolAscending());
            ListDataModel model = new ListDataModel((List)sortedList);
            this.subQpDataModel = subQpDataModel = new QuestionPoolDataModel(this.tree, (DataModel)model);
        }
    }

    public String getAgentId() {
        return AgentFacade.getAgentString();
    }

    public String getOwner() {
        String owner = AgentFacade.getDisplayName((String)this.getAgentId());
        return owner;
    }
}

