/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.samlite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.samlite.api.Question;
import org.sakaiproject.tool.assessment.samlite.api.QuestionGroup;
import org.sakaiproject.tool.assessment.samlite.api.SamLiteService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;
import org.w3c.dom.Document;

public class SamLiteBean
implements Serializable {
    private static Log log = LogFactory.getLog(SamLiteBean.class);
    private static final long serialVersionUID = -3122436861866172596L;
    public static final String DEFAULT_CHARSET = "ascii-us";
    private String name;
    private String description;
    private String data;
    private String assessmentTemplateId;
    private boolean isVisible = true;
    private AuthorBean authorBean;
    private ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.SamLite");
    private QuestionGroup questionGroup;
    private SamLiteService samLiteService;

    public void setAuthorBean(AuthorBean authorBean) {
        this.authorBean = authorBean;
    }

    public void setSamLiteService(SamLiteService samLiteService) {
        this.samLiteService = samLiteService;
    }

    public SamLiteBean() {
        String samliteProperty = ServerConfigurationService.getString((String)"samigo.samliteEnabled");
        if (null != samliteProperty && "false".equalsIgnoreCase(samliteProperty)) {
            this.isVisible = false;
        }
    }

    public void parse() {
        this.questionGroup = this.samLiteService.parse(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)this.name), TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)this.description), TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)this.data));
    }

    public Document createDocument() {
        return this.samLiteService.createDocument(this.questionGroup);
    }

    public void createAssessment(AssessmentFacade assessment) {
        this.authorBean.setAssessTitle("");
        this.authorBean.setAssessmentDescription("");
        this.authorBean.setAssessmentTypeId("");
        this.authorBean.setAssessmentTemplateId(AssessmentTemplateFacade.DEFAULTTEMPLATE.toString());
        AssessmentService assessmentService = new AssessmentService();
        ArrayList list = assessmentService.getBasicInfoOfAllActiveAssessments(this.authorBean.getCoreAssessmentOrderBy(), this.authorBean.isCoreAscending());
        for (AssessmentFacade assessmentFacade : list) {
            assessmentFacade.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessmentFacade.getTitle()));
        }
        this.authorBean.setAssessments(list);
    }

    public List getQuestions() {
        List list = this.questionGroup.getQuestions();
        for (Question question : list) {
            question.setQuestionTypeAsString(this.getQuestionTypeAsString(question));
        }
        return list;
    }

    public QuestionGroup getQuestionGroup() {
        return this.questionGroup;
    }

    public void setQuestionGroup(QuestionGroup questionGroup) {
        this.questionGroup = questionGroup;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAssessmentTemplateId(String assessmentTemplateId) {
        this.assessmentTemplateId = assessmentTemplateId;
    }

    public String getAssessmentTemplateId() {
        return this.assessmentTemplateId;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    private String getQuestionTypeAsString(Question question) {
        switch (question.getQuestionType()) {
            case 10: {
                return this.rb.getString("sam_lite_multiple_choice");
            }
            case 15: {
                return this.rb.getString("sam_lite_multiple_choice_multiple");
            }
            case 20: {
                return this.rb.getString("sam_lite_fill_in_the_blank");
            }
            case 30: {
                return this.rb.getString("sam_lite_true_false");
            }
            case 40: {
                return this.rb.getString("sam_lite_short_essay");
            }
        }
        return "Unrecognized Type";
    }
}

