/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.shared;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.ResourceLoader;

public class PersonBean
implements Serializable {
    private static final long serialVersionUID = 1884634498046475698L;
    private static Log log = LogFactory.getLog(PersonBean.class);
    private String anonymousId;
    private String previewFromPage;
    private boolean isMacNetscapeBrowser = false;
    private HashMap totalSubmissionPerAssessmentHash = new HashMap();
    private List resourceIdList;

    public String getAgentString() {
        return AgentFacade.getAgentString();
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public String getId() {
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        if (delivery.getAnonymousLogin()) {
            return this.getAnonymousId();
        }
        return this.getAgentString();
    }

    public String getEid() {
        return AgentFacade.getEid();
    }

    public void setAnonymousId(String anonymousId) {
        this.anonymousId = anonymousId;
    }

    public boolean getIsAdmin() {
        String context = "!admin";
        return SecurityService.unlock((String)"site.upd", (String)("/site/" + context));
    }

    public void setIsMacNetscapeBrowser(boolean isMacNetscapeBrowser) {
        this.isMacNetscapeBrowser = isMacNetscapeBrowser;
    }

    public boolean getIsMacNetscapeBrowser() {
        return this.isMacNetscapeBrowser;
    }

    public HashMap getTotalSubmissionPerAssessmentHash() {
        return this.totalSubmissionPerAssessmentHash;
    }

    public void setTotalSubmissionPerAssessmentHash(HashMap totalSubmissionPerAssessmentHash) {
        this.totalSubmissionPerAssessmentHash = totalSubmissionPerAssessmentHash;
    }

    public void setResourceIdListInPreview(List resourceIdList) {
        if (this.resourceIdList != null && this.resourceIdList.size() > 0) {
            AssessmentService service = new AssessmentService();
            service.deleteResources(this.resourceIdList);
        }
        this.resourceIdList = resourceIdList;
    }

    public List getResourceIdListInPreview() {
        return this.resourceIdList;
    }

    public String cleanResourceIdListInPreview() {
        AssessmentService service = new AssessmentService();
        service.deleteResources(this.resourceIdList);
        if (this.previewFromPage != null && this.previewFromPage.equals("author")) {
            this.previewFromPage = null;
            return "author";
        }
        return "editAssessment";
    }

    public String getLocaleLanguage() {
        ResourceLoader r = new ResourceLoader();
        Locale locale = r.getLocale();
        return locale.getLanguage();
    }

    public String getLocaleCountry() {
        ResourceLoader r = new ResourceLoader();
        Locale locale = r.getLocale();
        return locale.getCountry();
    }

    public void setPreviewFromPage(String previewFromPage) {
        this.previewFromPage = previewFromPage;
    }

    public String getPreviewFromPage() {
        return this.previewFromPage;
    }
}

