/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.SamigoEmailService;
import org.sakaiproject.tool.cover.SessionManager;

public class EmailBean
implements Serializable {
    private static Log log = LogFactory.getLog(EmailBean.class);
    private String fromName;
    private String fromEmailAddress;
    private String toName;
    private String toEmailAddress;
    private String toFirstName;
    private String assessmentName;
    private String subject;
    private String ccMe = "no";
    private String message;
    private List attachmentList;
    private boolean hasAttachment = false;
    private String outcome;
    private HashMap resourceHash = new HashMap();

    public EmailBean() {
        log.debug((Object)"Creating a new EmailBean");
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public void setFromEmailAddress(String fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public String getToEmailAddress() {
        return this.toEmailAddress;
    }

    public void setToEmailAddress(String toEmailAddress) {
        this.toEmailAddress = toEmailAddress;
    }

    public String getToFirstName() {
        return this.toFirstName;
    }

    public void setToFirstName(String toFirstName) {
        this.toFirstName = toFirstName;
    }

    public String getAssessmentName() {
        return this.assessmentName;
    }

    public void setAssessmentName(String assessmentName) {
        this.assessmentName = assessmentName;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCcMe() {
        return this.ccMe;
    }

    public void setCcMe(String ccMe) {
        this.ccMe = ccMe;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List attachmentList) {
        this.attachmentList = attachmentList;
    }

    public boolean getHasAttachment() {
        return this.hasAttachment;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.hasAttachment = hasAttachment;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public void prepareAttachment() {
        ToolSession session = SessionManager.getCurrentToolSession();
        ArrayList<AttachmentData> newAttachmentList = new ArrayList<AttachmentData>();
        if (session.getAttribute("sakaiproject.filepicker.attachments") != null) {
            List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
            if (refs.size() == 0) {
                this.hasAttachment = false;
            } else {
                HashMap map = this.getResourceIdHash(this.attachmentList);
                for (int i = 0; i < refs.size(); ++i) {
                    Reference ref = (Reference)refs.get(i);
                    String resourceId = ref.getId();
                    if (map.get(resourceId) == null) {
                        AssessmentService assessmentService = new AssessmentService();
                        AttachmentData attach = assessmentService.createEmailAttachment(resourceId, ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), ServerConfigurationService.getServerUrl());
                        newAttachmentList.add(attach);
                    } else {
                        newAttachmentList.add((AttachmentData)map.get(resourceId));
                        map.remove(resourceId);
                    }
                    this.hasAttachment = true;
                }
            }
            session.removeAttribute("sakaiproject.filepicker.attachments");
            session.removeAttribute("sakaiproject.filepicker.cancel");
        } else {
            this.hasAttachment = false;
        }
        this.attachmentList = newAttachmentList;
    }

    private HashMap getResourceIdHash(List attachmentList) {
        HashMap<String, AttachmentData> map = new HashMap<String, AttachmentData>();
        if (attachmentList != null) {
            for (AttachmentData attach : attachmentList) {
                map.put(attach.getResourceId(), attach);
            }
        }
        return map;
    }

    public String addAttachmentsRedirect() {
        try {
            List filePickerList = new ArrayList();
            if (this.attachmentList != null) {
                filePickerList = this.prepareReferenceList(this.attachmentList);
            }
            log.debug((Object)("**filePicker list=" + filePickerList.size()));
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("sakaiproject.filepicker.attachments", filePickerList);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.filepicker.helper/tool");
        }
        catch (Exception e) {
            log.error((Object)("fail to redirect to attachment page: " + e.getMessage()));
        }
        return "email";
    }

    private List prepareReferenceList(List attachmentList) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        for (int i = 0; i < attachmentList.size(); ++i) {
            ContentResource cr = null;
            AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
            try {
                cr = AssessmentService.getContentHostingService().getResource(attach.getResourceId());
            }
            catch (PermissionException e) {
                log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
            }
            catch (IdUnusedException e) {
                log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
            }
            catch (TypeException e) {
                log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
            }
            if (cr == null) continue;
            if (this.resourceHash == null) {
                this.resourceHash = new HashMap();
            }
            this.resourceHash.put(attach.getResourceId(), cr);
            Reference ref = EntityManager.newReference((String)cr.getReference());
            if (ref == null) continue;
            list.add(ref);
        }
        return list;
    }

    public HashMap getResourceHash() {
        return this.resourceHash;
    }

    public void setResourceHash(HashMap resourceHash) {
        this.resourceHash = resourceHash;
    }

    public String send() {
        log.debug((Object)"send()");
        log.debug((Object)("fromName: " + this.fromName));
        log.debug((Object)("fromEmailAddress: " + this.fromEmailAddress));
        log.debug((Object)("toName: " + this.toName));
        log.debug((Object)("toEmailAddress: " + this.toEmailAddress));
        log.debug((Object)("subject: " + this.subject));
        log.debug((Object)("ccMe: " + this.ccMe));
        log.debug((Object)("message: " + this.message));
        SamigoEmailService samigoEmailService = new SamigoEmailService(this.fromName, this.fromEmailAddress, this.toName, this.toEmailAddress, this.ccMe, this.subject, this.message);
        String result = samigoEmailService.send();
        if ("send".equals(result)) {
            String msgSent = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"sent_email_confirmation");
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(msgSent));
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.email", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", Email sent ok: toName=" + this.toName + ", toEmail=" + this.toEmailAddress), (boolean)true));
            return "confirmEmailSent";
        }
        String msgError = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"sent_email_error");
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(msgError));
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.email", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", Email sent error: toName=" + this.toName + ", toEmail=" + this.toEmailAddress), (boolean)true));
        return "emailError";
    }

    public void cancel() {
        log.debug((Object)"cancel");
        this.setMessage(null);
        this.setAttachmentList(null);
        this.setHasAttachment(false);
    }
}

