/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class ConfirmRemovePublishedAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ConfirmRemovePublishedAssessmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        String publishedAssessmentId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("publishedAssessmentId");
        log.debug((Object)("publishedAssessmentId = " + publishedAssessmentId));
        PublishedAssessmentBean publishedAssessmentBean = (PublishedAssessmentBean)ContextUtil.lookupBean((String)"publishedassessment");
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade publishedAssessment = publishedAssessmentService.getPublishedAssessmentInfoForRemove(Long.valueOf(publishedAssessmentId));
        if (publishedAssessment != null) {
            AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
            if (!this.passAuthz(context, publishedAssessment.getCreatedBy())) {
                author.setOutcome("author");
                return;
            }
            author.setOutcome("confirmRemovePublishedAssessment");
            publishedAssessmentBean.setAssessmentId(publishedAssessmentId);
            publishedAssessmentBean.setTitle(FormattedText.convertFormattedTextToPlaintext((String)publishedAssessment.getTitle()));
        } else {
            log.warn((Object)"publishedAssessment is null");
        }
    }

    public boolean passAuthz(FacesContext context, String ownerId) {
        boolean hasPrivilege;
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege_any = authzBean.getDeleteAnyAssessment();
        boolean hasPrivilege_own0 = authzBean.getDeleteOwnAssessment();
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(ownerId);
        boolean bl = hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_delete_other_members_assessment_error");
            context.addMessage(null, new FacesMessage(err));
        }
        return hasPrivilege;
    }

    public boolean isOwner(String ownerId) {
        boolean isOwner = false;
        String agentId = AgentFacade.getAgentString();
        isOwner = agentId.equals(ownerId);
        return isOwner;
    }
}

