/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishRepublishNotificationBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.listener.author.SavePublishedSettingsListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class ConfirmRepublishAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ConfirmRepublishAssessmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        PublishedAssessmentService assessmentService = new PublishedAssessmentService();
        SavePublishedSettingsListener savePublishedSettingsListener = new SavePublishedSettingsListener();
        PublishedAssessmentSettingsBean assessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
        assessmentSettings.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getTitle()));
        Long assessmentId = assessmentSettings.getAssessmentId();
        PublishedAssessmentFacade assessment = assessmentService.getPublishedAssessment(assessmentId.toString());
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubsetting.edit", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", publishedAssessmentId=" + assessmentId), (boolean)true));
        FacesContext context = FacesContext.getCurrentInstance();
        boolean gbError = savePublishedSettingsListener.checkScore(assessmentSettings, assessment, context);
        if (gbError) {
            author.setOutcome("editAssessment");
            return;
        }
        String actionCommand = ae.getComponent().getId();
        if (actionCommand.startsWith("republishRegrade")) {
            log.debug((Object)"republishRegrade");
            author.setIsRepublishAndRegrade(true);
        } else if (actionCommand.startsWith("republish")) {
            log.debug((Object)"republish");
            author.setIsRepublishAndRegrade(false);
        }
        PublishedAssessmentSettingsBean publishedAssessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
        Long publishedAssessmentId = publishedAssessmentSettings.getAssessmentId();
        GradingService gradingService = new GradingService();
        ArrayList al = gradingService.getHasGradingDataAndHasSubmission(publishedAssessmentId);
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        if (al.size() == 2) {
            assessmentBean.setHasGradingData(((Boolean)al.get(0)).booleanValue());
            assessmentBean.setHasSubmission(((Boolean)al.get(1)).booleanValue());
        } else {
            assessmentBean.setHasGradingData(false);
            assessmentBean.setHasSubmission(false);
        }
        publishedAssessmentSettings.setReleaseToGroupsAsString(assessment.getReleaseToGroups());
        publishedAssessmentSettings.setUpdateMostCurrentSubmission(false);
        PublishRepublishNotificationBean publishRepublishNotification = (PublishRepublishNotificationBean)ContextUtil.lookupBean((String)"publishRepublishNotification");
        publishRepublishNotification.setSendNotification(false);
        if (author.getIsRepublishAndRegrade()) {
            publishRepublishNotification.setPrePopulateText(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"pre_populate_text_regrade_republish"));
        } else {
            publishRepublishNotification.setPrePopulateText(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"pre_populate_text_republish"));
        }
        author.setOutcome("saveSettingsAndConfirmPublish");
    }
}

