/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.ToolManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class EditAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(EditAssessmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        String editType = ContextUtil.lookupParam((String)"editType");
        if (editType != null) {
            if ("pendingAssessment".equals(editType)) {
                this.setPropertiesForAssessment(author);
            } else if ("publishedAssessment".equals(editType)) {
                this.setPropertiesForPublishedAssessment(author);
            } else {
                log.debug((Object)"editType is not set - get from authorBean");
                if (author.getIsEditPendingAssessmentFlow()) {
                    this.setPropertiesForAssessment(author);
                } else {
                    this.setPropertiesForPublishedAssessment(author);
                }
            }
        } else {
            log.debug((Object)"editType is null - get from authorBean");
            if (author.getIsEditPendingAssessmentFlow()) {
                this.setPropertiesForAssessment(author);
            } else {
                this.setPropertiesForPublishedAssessment(author);
            }
        }
    }

    public void setPropertiesForAssessment(AuthorBean author) {
        FacesContext context = FacesContext.getCurrentInstance();
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        ItemAuthorBean itemauthorBean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        AssessmentService assessmentService = new AssessmentService();
        AssessmentSettingsBean assessmentSettings = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
        String assessmentId = ContextUtil.lookupParam((String)"assessmentId");
        if (assessmentId == null || assessmentId.equals("")) {
            assessmentId = assessmentSettings.getAssessmentId().toString();
        }
        AssessmentFacade assessment = assessmentService.getAssessment(assessmentId);
        author.setOutcome("editAssessment");
        if (!this.passAuthz(context, assessment.getCreatedBy())) {
            author.setOutcome("author");
            return;
        }
        author.setIsEditPendingAssessmentFlow(true);
        assessmentSettings.setAssessment(assessment);
        assessmentBean.setAssessment((AssessmentIfc)assessment);
        itemauthorBean.setTarget("assessment");
        itemauthorBean.setItemType("");
        itemauthorBean.setItemTypeString("");
        assessmentBean.setHasGradingData(false);
        EditAssessmentListener.showPrintLink((AssessmentBean)assessmentBean);
    }

    public void setPropertiesForPublishedAssessment(AuthorBean author) {
        FacesContext context = FacesContext.getCurrentInstance();
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        ItemAuthorBean itemauthorBean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        PublishedAssessmentSettingsBean publishedAssessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
        String publishedAssessmentId = assessmentBean.getAssessmentId();
        PublishedAssessmentFacade publishedAssessment = publishedAssessmentService.getPublishedAssessment(publishedAssessmentId);
        author.setOutcome("editAssessment");
        if (!this.passAuthz(context, publishedAssessment.getCreatedBy())) {
            author.setOutcome("author");
            return;
        }
        GradingService gradingService = new GradingService();
        boolean hasGradingData = gradingService.getHasGradingData(Long.valueOf(publishedAssessmentId));
        if (author.getEditPubAssessmentRestricted() && hasGradingData) {
            author.setOutcome("editPublishedAssessmentError");
            return;
        }
        assessmentBean.setHasGradingData(hasGradingData);
        author.setIsEditPendingAssessmentFlow(false);
        publishedAssessment.setStatus(AssessmentBaseIfc.RETRACT_FOR_EDIT_STATUS);
        publishedAssessmentService.saveAssessment(publishedAssessment);
        publishedAssessmentSettings.setAssessment(publishedAssessment);
        assessmentBean.setAssessment((AssessmentIfc)publishedAssessment);
        itemauthorBean.setTarget("assessment");
        itemauthorBean.setItemType("");
        itemauthorBean.setItemTypeString("");
        EditAssessmentListener.showPrintLink((AssessmentBean)assessmentBean);
    }

    public boolean passAuthz(FacesContext context, String ownerId) {
        boolean hasPrivilege;
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege_any = authzBean.getEditAnyAssessment();
        boolean hasPrivilege_own0 = authzBean.getEditOwnAssessment();
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(ownerId);
        boolean bl = hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_edit_assessment_error");
            context.addMessage(null, new FacesMessage(err));
        }
        return hasPrivilege;
    }

    public boolean isOwner(String ownerId) {
        boolean isOwner = false;
        String agentId = AgentFacade.getAgentString();
        isOwner = agentId.equals(ownerId);
        log.debug((Object)("***isOwner=" + isOwner));
        return isOwner;
    }

    public static void showPrintLink(AssessmentBean assessmentBean) {
        log.debug((Object)("first condition = " + (ToolManager.getTool((String)"sakai.questionbank.printout") != null)));
        log.debug((Object)("second conditon = " + !ServerConfigurationService.getString((String)"stealthTools@org.sakaiproject.tool.api.ActiveToolManager").contains("sakai.questionbank.printout")));
        log.debug((Object)("third condition = " + !ServerConfigurationService.getString((String)"hiddenTools@org.sakaiproject.tool.api.ActiveToolManager").contains("sakai.questionbank.printout")));
        String printAssessment = ServerConfigurationService.getString((String)"samigo.printAssessment");
        if (ToolManager.getTool((String)"sakai.questionbank.printout") != null && !ServerConfigurationService.getString((String)"stealthTools@org.sakaiproject.tool.api.ActiveToolManager").contains("sakai.questionbank.printout") && !ServerConfigurationService.getString((String)"hiddenTools@org.sakaiproject.tool.api.ActiveToolManager").contains("sakai.questionbank.printout") || Boolean.parseBoolean(printAssessment)) {
            assessmentBean.setShowPrintLink(true);
        } else {
            assessmentBean.setShowPrintLink(false);
        }
    }
}

