/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.Iterator;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionMetaDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.SectionBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class EditPartListener
implements ActionListener {
    private boolean isEditPendingAssessmentFlow = true;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        int itemsize;
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        SectionBean sectionBean = (SectionBean)ContextUtil.lookupBean((String)"sectionBean");
        String sectionId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("sectionId");
        if (sectionId != null) {
            sectionBean.setSectionId(sectionId);
        } else {
            sectionId = sectionBean.getSectionId();
        }
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        this.isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        AssessmentService assessmentService = null;
        SectionFacade section = null;
        if (this.isEditPendingAssessmentFlow) {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", sectionId=" + sectionId), (boolean)true));
            assessmentService = new AssessmentService();
        } else {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubassessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", sectionId=" + sectionId), (boolean)true));
            assessmentService = new PublishedAssessmentService();
        }
        section = assessmentService.getSection(sectionId);
        section.setAssessment(assessmentBean.getAssessment());
        sectionBean.setSection(section);
        sectionBean.setSectionTitle(FormattedText.convertFormattedTextToPlaintext((String)section.getTitle()));
        sectionBean.setSectionDescription(section.getDescription());
        sectionBean.setNoOfItems(String.valueOf(section.getItemSet().size()));
        this.populateMetaData(section, sectionBean);
        boolean hideRandom = false;
        if ((sectionBean.getType() == null || sectionBean.getType().equals(SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString())) && (itemsize = Integer.parseInt(sectionBean.getNoOfItems())) > 0) {
            hideRandom = true;
        }
        sectionBean.setHideRandom(hideRandom);
    }

    private void populateMetaData(SectionFacade section, SectionBean bean) {
        Set metaDataSet = section.getSectionMetaDataSet();
        Iterator iter = metaDataSet.iterator();
        bean.setKeyword(null);
        bean.setObjective(null);
        bean.setRubric(null);
        boolean isRandomizationTypeSet = false;
        boolean isPointValueHasOverrided = false;
        boolean isDiscountValueHasOverrided = false;
        while (iter.hasNext()) {
            SectionMetaDataIfc meta = (SectionMetaDataIfc)iter.next();
            if (meta.getLabel().equals("SECTION_OBJECTIVES")) {
                bean.setObjective(FormattedText.convertFormattedTextToPlaintext((String)meta.getEntry()));
            }
            if (meta.getLabel().equals("SECTION_KEYWORDS")) {
                bean.setKeyword(FormattedText.convertFormattedTextToPlaintext((String)meta.getEntry()));
            }
            if (meta.getLabel().equals("SECTION_RUBRICS")) {
                bean.setRubric(FormattedText.convertFormattedTextToPlaintext((String)meta.getEntry()));
            }
            if (meta.getLabel().equals("AUTHOR_TYPE")) {
                bean.setType(meta.getEntry());
            }
            if (meta.getLabel().equals("QUESTIONS_ORDERING")) {
                bean.setQuestionOrdering(meta.getEntry());
            }
            if (meta.getLabel().equals("POOLID_FOR_RANDOM_DRAW")) {
                bean.setSelectedPool(meta.getEntry());
            }
            if (meta.getLabel().equals("NUM_QUESTIONS_DRAWN")) {
                bean.setNumberSelected(meta.getEntry());
            }
            if (meta.getLabel().equals("RANDOMIZATION_TYPE")) {
                bean.setRandomizationType(meta.getEntry());
                isRandomizationTypeSet = true;
            }
            if (meta.getLabel().equals("POINT_VALUE_FOR_QUESTION")) {
                if (meta.getEntry() != null && !meta.getEntry().equals("")) {
                    bean.setPointValueHasOverrided(true);
                    isPointValueHasOverrided = true;
                }
                bean.setRandomPartScore(meta.getEntry());
            }
            if (!meta.getLabel().equals("DISCOUNT_VALUE_FOR_QUESTION")) continue;
            if (meta.getEntry() != null && !meta.getEntry().equals("")) {
                bean.setDiscountValueHasOverrided(true);
                isDiscountValueHasOverrided = true;
            }
            bean.setRandomPartDiscount(meta.getEntry());
        }
        if (!isRandomizationTypeSet) {
            bean.setRandomizationType("1");
        }
        if (!isPointValueHasOverrided) {
            bean.setPointValueHasOverrided(false);
            bean.setRandomPartScore(null);
        }
        if (!isDiscountValueHasOverrided) {
            bean.setDiscountValueHasOverrided(false);
            bean.setRandomPartDiscount(null);
        }
    }
}

