/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class EditPublishedSettingsListener
implements ActionListener {
    private static Log log = LogFactory.getLog(EditPublishedSettingsListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        PublishedAssessmentSettingsBean assessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        PublishedAssessmentService assessmentService = new PublishedAssessmentService();
        String assessmentId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("publishedAssessmentId");
        PublishedAssessmentFacade assessment = assessmentService.getSettingsOfPublishedAssessment(assessmentId);
        if (!this.passAuthz(context, assessment.getCreatedBy())) {
            author.setOutcome("author");
            return;
        }
        author.setOutcome("editPublishedAssessmentSettings");
        author.setIsEditPendingAssessmentFlow(false);
        assessmentSettings.setAssessment(assessment);
        assessmentSettings.setAttachmentList(assessment.getData().getAssessmentAttachmentList());
        assessmentSettings.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessment.getTitle()));
        assessmentSettings.setAuthors(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_AUTHORS")));
        assessmentSettings.setFinalPageUrl(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentAccessControl().getFinalPageUrl()));
        assessmentSettings.setBgColor(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGCOLOR")));
        assessmentSettings.setBgImage(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGIMAGE")));
        assessmentSettings.setKeywords(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_KEYWORDS")));
        assessmentSettings.setObjectives(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_OBJECTIVES")));
        assessmentSettings.setRubrics(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_RUBRICS")));
        assessmentSettings.setUsername(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentAccessControl().getUsername()));
        assessmentSettings.setPassword(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentAccessControl().getPassword()));
        assessmentSettings.setBlockDivs("");
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        assessmentBean.setAssessmentId(assessmentId);
        if (ae == null) {
            author.setFromPage("author");
        } else {
            String actionCommand = ae.getComponent().getId();
            if ("editPublishedAssessmentSettings_editAssessment".equals(actionCommand)) {
                log.debug((Object)"editPublishedAssessmentSettings_editAssessment");
                author.setFromPage("editAssessment");
            } else if ("editPublishedAssessmentSettings_saveSettingsAndConfirmPublish".equals(actionCommand)) {
                log.debug((Object)"editPublishedAssessmentSettings_saveSettingsAndConfirmPublish");
                author.setFromPage("saveSettingsAndConfirmPublish");
            }
        }
        boolean isRetractedForEdit = this.isRetractedForEdit(assessment);
        log.debug((Object)("isRetractedForEdit = " + isRetractedForEdit));
        author.setIsRetractedForEdit(isRetractedForEdit);
        String editPubAnonyGradingRestricted = ServerConfigurationService.getString((String)"samigo.editPubAnonyGrading.restricted");
        if (editPubAnonyGradingRestricted != null && editPubAnonyGradingRestricted.equals("true")) {
            assessmentSettings.setEditPubAnonyGradingRestricted(true);
        } else {
            assessmentSettings.setEditPubAnonyGradingRestricted(false);
        }
    }

    public boolean passAuthz(FacesContext context, String ownerId) {
        boolean hasPrivilege;
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege_any = authzBean.getPublishAnyAssessment();
        boolean hasPrivilege_own0 = authzBean.getPublishOwnAssessment();
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(ownerId);
        boolean bl = hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_edit_publish_assessment_settings_error");
            context.addMessage(null, new FacesMessage(err));
        }
        return hasPrivilege;
    }

    public boolean isOwner(String ownerId) {
        boolean isOwner = false;
        String agentId = AgentFacade.getAgentString();
        isOwner = agentId.equals(ownerId);
        return isOwner;
    }

    private boolean isRetractedForEdit(PublishedAssessmentFacade publishedAssessmentFacade) {
        return AssessmentBaseIfc.RETRACT_FOR_EDIT_STATUS.equals(publishedAssessmentFacade.getStatus());
    }
}

