/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.FavoriteColChoices;
import org.sakaiproject.tool.assessment.data.dao.assessment.FavoriteColChoicesItem;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswer;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.services.FinFormatException;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PublishedItemService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AnswerBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemBean;
import org.sakaiproject.tool.assessment.ui.bean.author.MatchItemBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolDataBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemAddListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ItemAddListener.class);
    private boolean error = false;
    private boolean isPendingOrPool = false;
    private boolean isEditPendingAssessmentFlow = true;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        String corrAnswer;
        String scaleName;
        ArrayList l;
        log.debug((Object)"ItemAdd LISTENER.");
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        ItemBean item = itemauthorbean.getCurrentItem();
        String iText = ContextUtil.stringWYSIWYG((String)item.getItemText());
        String iInstruction = ContextUtil.stringWYSIWYG((String)item.getInstruction());
        String iType = item.getItemType();
        String err = "";
        FacesContext context = FacesContext.getCurrentInstance();
        if (!iType.equals(TypeFacade.MATCHING.toString()) && (iText == null || iText.toLowerCase().replaceAll("<^[^(img)]*?>", "").trim().equals("")) || iType.equals(TypeFacade.MATCHING.toString()) && (iInstruction == null || iInstruction.toLowerCase().replaceAll("<^[^(img)]*?>", "").trim().equals(""))) {
            String emptyText_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"emptyText_error");
            context.addMessage(null, new FacesMessage(emptyText_err));
            return;
        }
        if (iType.equals(TypeFacade.MULTIPLE_CHOICE.toString())) {
            this.checkMC(true);
        }
        if (iType.equals(TypeFacade.MULTIPLE_CORRECT.toString())) {
            this.checkMC(false);
        }
        if (iType.equals(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION.toString())) {
            this.checkMC(false);
        }
        if (iType.equals(TypeFacade.MATCHING.toString()) && ((l = item.getMatchItemBeanList()) == null || l.size() == 0)) {
            String noPairMatching_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"noMatchingPair_error");
            context.addMessage(null, new FacesMessage(noPairMatching_err));
            this.error = true;
        }
        if (this.error) {
            return;
        }
        if (iType.equals(TypeFacade.MULTIPLE_CHOICE_SURVEY.toString()) && (scaleName = item.getScaleName()) == null) {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"corrAnswer");
            context.addMessage(null, new FacesMessage(err));
            item.setOutcome("surveyItem");
            item.setPoolOutcome("surveyItem");
            return;
        }
        if (iType.equals(TypeFacade.TRUE_FALSE.toString()) && (corrAnswer = item.getCorrAnswer()) == null) {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"corrAnswer");
            context.addMessage(null, new FacesMessage(err));
            item.setOutcome("trueFalseItem");
            item.setPoolOutcome("trueFalseItem");
            return;
        }
        if (iType.equals(TypeFacade.FILL_IN_BLANK.toString()) && this.isErrorFIB()) {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"pool_missingBracket_error");
            context.addMessage(null, new FacesMessage(err));
            item.setOutcome("fillInBlackItem");
            item.setPoolOutcome("fillInBlackItem");
            return;
        }
        if (iType.equals(TypeFacade.FILL_IN_NUMERIC.toString()) && this.isErrorFIN()) {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"pool_missingBracket_error");
            context.addMessage(null, new FacesMessage(err));
            item.setOutcome("fillInNumericItem");
            item.setPoolOutcome("fillInNumericItem");
            return;
        }
        if (iType.equals(TypeFacade.AUDIO_RECORDING.toString())) {
            try {
                String timeAllowed = item.getTimeAllowed().trim();
                int intTimeAllowed = Integer.parseInt(timeAllowed);
                if (intTimeAllowed < 1) {
                    throw new RuntimeException();
                }
            }
            catch (RuntimeException e) {
                err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"submissions_allowed_error");
                context.addMessage(null, new FacesMessage(err));
                item.setOutcome("audioRecItem");
                item.setPoolOutcome("audioRecItem");
                return;
            }
        }
        if (iType.equals(TypeFacade.MATRIX_CHOICES_SURVEY.toString())) {
            if (this.isRowEmpty()) {
                err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"row_field_empty");
                context.addMessage(null, new FacesMessage(err));
                item.setOutcome("matrixChoicesSurveyItem");
                item.setPoolOutcome("matrixChoicesSurveyItem");
                return;
            }
            if (this.isColumnslessthan2()) {
                err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"less_than_two_columns");
                context.addMessage(null, new FacesMessage(err));
                item.setOutcome("matrixChoicesSurveyItem");
                item.setPoolOutcome("matrixChoicesSurveyItem");
                return;
            }
        }
        try {
            this.saveItem(itemauthorbean);
        }
        catch (FinFormatException e) {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"fin_invalid_characters_error");
            context.addMessage(null, new FacesMessage(err));
            item.setOutcome("fillInNumericItem");
            item.setPoolOutcome("fillInNumericItem");
            return;
        }
        item.setOutcome("editAssessment");
        item.setPoolOutcome("editPool");
        itemauthorbean.setItemTypeString("");
    }

    public void checkMC(boolean isSingleSelect) {
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        ItemBean item = itemauthorbean.getCurrentItem();
        boolean correct = false;
        int countAnswerText = 0;
        int indexLabel = 0;
        Iterator iter = item.getMultipleChoiceAnswers().iterator();
        boolean missingchoices = false;
        StringBuilder missingLabelbuf = new StringBuilder();
        String txt = "";
        String label = "";
        FacesContext context = FacesContext.getCurrentInstance();
        int corrsize = item.getMultipleChoiceAnswers().size();
        String[] corrChoices = new String[corrsize];
        int counter = 0;
        boolean isCorrectChoice = false;
        if (item.getMultipleChoiceAnswers() != null) {
            while (iter.hasNext()) {
                AnswerBean answerbean = (AnswerBean)iter.next();
                String answerTxt = ContextUtil.stringWYSIWYG((String)answerbean.getText());
                if (answerTxt.toLowerCase().replaceAll("<^[^(img)]*?>", "").trim().equals("")) {
                    answerbean.setText("");
                }
                label = answerbean.getLabel();
                txt = answerbean.getText();
                corrChoices[counter] = label;
                isCorrectChoice = this.isCorrectChoice(item, label);
                if (isCorrectChoice && (txt == null || txt.equals(""))) {
                    this.error = true;
                    String empty_correct_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"empty_correct_error");
                    context.addMessage(null, new FacesMessage(empty_correct_err + label));
                }
                if (txt == null || txt.equals("")) continue;
                ++countAnswerText;
                if (isCorrectChoice) {
                    correct = true;
                    ++counter;
                }
                if (!label.equals(AnswerBean.getChoiceLabels()[indexLabel])) {
                    missingchoices = true;
                    if ("".equals(missingLabelbuf.toString())) {
                        missingLabelbuf.append(" " + AnswerBean.getChoiceLabels()[indexLabel]);
                    } else {
                        missingLabelbuf.append(", " + AnswerBean.getChoiceLabels()[indexLabel]);
                    }
                    ++indexLabel;
                }
                ++indexLabel;
            }
            String missingLabel = missingLabelbuf.toString();
            if (counter < corrChoices.length && !this.isCorrectChoice(item, corrChoices[counter])) {
                corrChoices[counter] = null;
            }
            item.setCorrAnswers(corrChoices);
            if (!this.error) {
                if (!correct) {
                    if (isSingleSelect) {
                        String singleCorrect_error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"singleCorrect_error");
                        context.addMessage(null, new FacesMessage(singleCorrect_error));
                    } else {
                        String multiCorrect_error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"multiCorrect_error");
                        context.addMessage(null, new FacesMessage(multiCorrect_error));
                    }
                    this.error = true;
                } else if (countAnswerText <= 1) {
                    String answerList_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"answerList_error");
                    context.addMessage(null, new FacesMessage(answerList_err));
                    this.error = true;
                } else if (missingchoices) {
                    String selectionError = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"missingChoices_error");
                    context.addMessage(null, new FacesMessage(selectionError + missingLabel));
                    this.error = true;
                }
            }
        }
        if (this.error) {
            item.setOutcome("multipleChoiceItem");
            item.setPoolOutcome("multipleChoiceItem");
        }
    }

    public boolean isErrorFIB() {
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        ItemBean item = itemauthorbean.getCurrentItem();
        boolean FIBerror = false;
        boolean hasOpen = false;
        int opencount = 0;
        int closecount = 0;
        boolean notEmpty = false;
        int indexOfOpen = -1;
        String text = item.getItemText();
        for (int index = 0; index < text.length(); ++index) {
            char c = text.charAt(index);
            if (c == '{') {
                ++opencount;
                if (hasOpen) {
                    FIBerror = true;
                    break;
                }
                hasOpen = true;
                indexOfOpen = index;
                continue;
            }
            if (c == '}') {
                ++closecount;
                if (!hasOpen) {
                    FIBerror = true;
                    break;
                }
                if (notEmpty && index + 1 != index && !text.substring(indexOfOpen + 1, index).equals("</p><p>")) {
                    hasOpen = false;
                    notEmpty = false;
                    continue;
                }
                FIBerror = true;
                break;
            }
            if (!hasOpen || Character.isWhitespace(c)) continue;
            notEmpty = true;
        }
        return hasOpen || opencount < 1 || opencount != closecount || FIBerror;
    }

    public boolean isErrorFIN() {
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        ItemBean item = itemauthorbean.getCurrentItem();
        boolean FINerror = false;
        boolean hasOpen = false;
        int opencount = 0;
        int closecount = 0;
        boolean notEmpty = false;
        int indexOfOpen = -1;
        String text = item.getItemText();
        for (int index = 0; index < text.length(); ++index) {
            char c = text.charAt(index);
            if (c == '{') {
                ++opencount;
                if (hasOpen) {
                    FINerror = true;
                    break;
                }
                hasOpen = true;
                indexOfOpen = index;
                continue;
            }
            if (c == '}') {
                ++closecount;
                if (!hasOpen) {
                    FINerror = true;
                    break;
                }
                if (notEmpty && index + 1 != index && !text.substring(indexOfOpen + 1, index).equals("</p><p>")) {
                    hasOpen = false;
                    notEmpty = false;
                    continue;
                }
                FINerror = true;
                break;
            }
            if (!hasOpen || Character.isWhitespace(c)) continue;
            notEmpty = true;
        }
        return hasOpen || opencount < 1 || opencount != closecount || FINerror;
    }

    public boolean isRowEmpty() {
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        ItemBean item = itemauthorbean.getCurrentItem();
        String text = item.getRowChoices();
        if (text != null && text.trim().length() == 0) {
            return true;
        }
        return text == null;
    }

    public boolean isColumnslessthan2() {
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        ItemBean item = itemauthorbean.getCurrentItem();
        String text = item.getColumnChoices();
        String[] columns = text.split(System.getProperty("line.separator"));
        return columns.length < 2;
    }

    public void saveItem(ItemAuthorBean itemauthor) throws FinFormatException {
        Object item;
        ItemService delegate;
        boolean update = false;
        ItemBean bean = itemauthor.getCurrentItem();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        this.isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        log.debug((Object)("**** isEditPendingAssessmentFlow : " + this.isEditPendingAssessmentFlow));
        String target = itemauthor.getTarget();
        boolean isFromQuestionPool = false;
        if (target != null && target.equals("questionpool")) {
            isFromQuestionPool = true;
        }
        log.debug((Object)("**** isFromQuestionPool : " + isFromQuestionPool));
        boolean bl = this.isPendingOrPool = this.isEditPendingAssessmentFlow || isFromQuestionPool;
        if (this.isPendingOrPool) {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", itemId=" + itemauthor.getItemId()), (boolean)true));
            delegate = new ItemService();
        } else {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubassessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", itemId=" + itemauthor.getItemId()), (boolean)true));
            delegate = new PublishedItemService();
        }
        if (bean.getItemId() != null && !bean.getItemId().equals("0")) {
            update = true;
            Long oldId = Long.valueOf(bean.getItemId());
            if (this.isPendingOrPool) {
                delegate.deleteItemContent(oldId, AgentFacade.getAgentString());
            }
            item = delegate.getItem(oldId, AgentFacade.getAgentString());
        } else {
            item = this.isPendingOrPool ? new ItemFacade() : new PublishedItemFacade();
        }
        item.setScore(Float.valueOf(bean.getItemScore()));
        item.setDiscount(Float.valueOf(bean.getItemDiscount()));
        item.setHint("");
        item.setStatus(ItemDataIfc.ACTIVE_STATUS);
        item.setTypeId(Long.valueOf(bean.getItemType()));
        item.setCreatedBy(AgentFacade.getAgentString());
        item.setCreatedDate(new Date());
        item.setLastModifiedBy(AgentFacade.getAgentString());
        item.setLastModifiedDate(new Date());
        if (bean.getInstruction() != null) {
            item.setInstruction(bean.getInstruction());
        }
        if (bean.getRationale() != null) {
            item.setHasRationale(Boolean.valueOf(bean.getRationale()));
        } else {
            item.setHasRationale(Boolean.FALSE);
        }
        item.setPartialCreditFlag(Boolean.valueOf(bean.getPartialCreditFlag()));
        if (bean.getNumAttempts() != null) {
            item.setTriesAllowed(Integer.valueOf(bean.getNumAttempts()));
        }
        if (bean.getTimeAllowed() != null) {
            item.setDuration(Integer.valueOf(bean.getTimeAllowed()));
        }
        if (update && !this.isPendingOrPool) {
            item.setItemTextSet(this.preparePublishedText(item, bean, delegate));
            item.setItemMetaDataSet(this.preparePublishedMetaData(item, bean));
            if (bean.getCorrFeedback() != null) {
                this.updateItemFeedback(item, "Correct Feedback", this.stripPtags(bean.getCorrFeedback()));
            }
            if (bean.getIncorrFeedback() != null) {
                this.updateItemFeedback(item, "InCorrect Feedback", this.stripPtags(bean.getIncorrFeedback()));
            }
            if (bean.getGeneralFeedback() != null) {
                this.updateItemFeedback(item, "General Feedback", this.stripPtags(bean.getGeneralFeedback()));
            }
        } else {
            if (item.getTypeId().equals(TypeFacade.MATCHING)) {
                item.setItemTextSet((Set)this.prepareTextForMatching(item, bean, itemauthor));
            } else if (item.getTypeId().equals(TypeFacade.MATRIX_CHOICES_SURVEY)) {
                item.setItemTextSet((Set)this.prepareTextForMatrixChoice(item, bean, itemauthor));
            } else {
                item.setItemTextSet((Set)this.prepareText(item, bean, itemauthor));
            }
            item.setItemMetaDataSet((Set)this.prepareMetaData(item, bean));
            if (bean.getCorrFeedback() != null && !bean.getCorrFeedback().equals("")) {
                item.setCorrectItemFeedback(this.stripPtags(bean.getCorrFeedback()));
            }
            if (bean.getIncorrFeedback() != null && !bean.getIncorrFeedback().equals("")) {
                item.setInCorrectItemFeedback(this.stripPtags(bean.getIncorrFeedback()));
            }
            if (bean.getGeneralFeedback() != null && !bean.getGeneralFeedback().equals("")) {
                item.setGeneralItemFeedback(this.stripPtags(bean.getGeneralFeedback()));
            }
        }
        if (isFromQuestionPool) {
            delegate.saveItem(item);
            this.updateAttachment(item.getItemAttachmentList(), itemauthor.getAttachmentList(), item.getData(), true);
            item = delegate.getItem(item.getItemId().toString());
            QuestionPoolService qpdelegate = new QuestionPoolService();
            if (!qpdelegate.hasItem(item.getItemIdString(), Long.valueOf(itemauthor.getQpoolId()))) {
                qpdelegate.addItemToPool(item.getItemIdString(), Long.valueOf(itemauthor.getQpoolId()));
            }
            QuestionPoolBean qpoolbean = (QuestionPoolBean)ContextUtil.lookupBean((String)"questionpool");
            QuestionPoolDataBean contextCurrentPool = qpoolbean.getCurrentPool();
            qpoolbean.buildTree();
            qpoolbean.startEditPoolAgain(itemauthor.getQpoolId());
            QuestionPoolDataBean currentPool = qpoolbean.getCurrentPool();
            currentPool.setDisplayName(contextCurrentPool.getDisplayName());
            currentPool.setOrganizationName(contextCurrentPool.getOrganizationName());
            currentPool.setDescription(contextCurrentPool.getDescription());
            currentPool.setObjectives(contextCurrentPool.getObjectives());
            currentPool.setKeywords(contextCurrentPool.getKeywords());
            ArrayList<Long> addedQuestions = qpoolbean.getAddedQuestions();
            if (addedQuestions == null) {
                addedQuestions = new ArrayList<Long>();
            }
            addedQuestions.add(item.getItemId());
            qpoolbean.setAddedPools(addedQuestions);
            itemauthor.setOutcome("editPool");
        } else if (itemauthor.getTarget() != null && itemauthor.getTarget().equals("sambank")) {
            delegate.saveItem(item);
            itemauthor.setItemNo(item.getItemId().toString());
        } else {
            AssessmentBean assessmentBean;
            Object assessdelegate = this.isEditPendingAssessmentFlow ? new AssessmentService() : new PublishedAssessmentService();
            if (bean.getSelectedSection() != null) {
                SectionFacade section;
                if ("-1".equals(bean.getSelectedSection())) {
                    assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
                    section = assessdelegate.addSection(assessmentBean.getAssessmentId());
                } else {
                    section = assessdelegate.getSection(bean.getSelectedSection());
                }
                item.setSection((SectionDataIfc)section);
                if (update && bean.getOrigSection() != null && !bean.getOrigSection().equals(bean.getSelectedSection())) {
                    Integer oldSeq = item.getSequence();
                    item.setSequence(Integer.valueOf(section.getItemSet().size() + 1));
                    SectionFacade origsect = assessdelegate.getSection(bean.getOrigSection());
                    this.shiftItemsInOrigSection(delegate, origsect, oldSeq);
                }
                if (!update) {
                    if (itemauthor.getInsertPosition() == null || "".equals(itemauthor.getInsertPosition()) || !section.getSequence().toString().equals(itemauthor.getInsertToSection())) {
                        if (section.getItemSet() != null) {
                            item.setSequence(Integer.valueOf(section.getItemSet().size() + 1));
                        } else {
                            item.setSequence(Integer.valueOf(1));
                        }
                    } else {
                        String insertPos = itemauthor.getInsertPosition();
                        this.shiftSequences(delegate, section, Integer.valueOf(insertPos));
                        int insertPosInt = Integer.valueOf(insertPos) + 1;
                        item.setSequence(Integer.valueOf(insertPosInt));
                        itemauthor.setInsertPosition("");
                    }
                }
                if (itemauthor.getInsertToSection() != null) {
                    itemauthor.setInsertToSection(null);
                }
                delegate.saveItem(item);
                this.updateAttachment(item.getItemAttachmentList(), itemauthor.getAttachmentList(), item.getData(), this.isEditPendingAssessmentFlow);
                item = delegate.getItem(item.getItemId().toString());
            }
            if (bean.getAddToFavorite()) {
                FavoriteColChoices favorite = new FavoriteColChoices();
                favorite.setFavoriteName(bean.getFavoriteName().trim());
                favorite.setOwnerStringId(AgentFacade.getAgentString());
                String[] temp = bean.getColumnChoices().split(System.getProperty("line.separator"));
                ArrayList<String> stringList = new ArrayList<String>();
                for (String string : temp) {
                    if (string == null || string.trim().length() <= 0) continue;
                    stringList.add(string);
                }
                temp = stringList.toArray(new String[stringList.size()]);
                for (int i = 0; i < temp.length; ++i) {
                    FavoriteColChoicesItem favoriteChoiceItem = new FavoriteColChoicesItem(StringUtils.chomp((String)temp[i]), new Integer(i));
                    favoriteChoiceItem.setFavoriteChoice(favorite);
                    favorite.getFavoriteItems().add(favoriteChoiceItem);
                }
                delegate.saveFavoriteColumnChoices(favorite);
            }
            QuestionPoolService qpdelegate = new QuestionPoolService();
            if (bean.getOrigPool() != null && !bean.getOrigPool().equals("")) {
                qpdelegate.removeQuestionFromPool(item.getItemIdString(), Long.valueOf(bean.getOrigPool()));
            }
            if (bean.getSelectedPool() != null && !bean.getSelectedPool().equals("") && !qpdelegate.hasItem(item.getItemIdString(), Long.valueOf(bean.getSelectedPool()))) {
                qpdelegate.addItemToPool(item.getItemIdString(), Long.valueOf(bean.getSelectedPool()));
            }
            assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
            AssessmentIfc assessment = assessdelegate.getAssessment(Long.valueOf(assessmentBean.getAssessmentId()));
            assessmentBean.setAssessment(assessment);
            itemauthor.setOutcome("editAssessment");
        }
        itemauthor.setItemId(item.getItemId().toString());
    }

    private HashSet prepareTextForMatching(ItemFacade item, ItemBean bean, ItemAuthorBean itemauthor) {
        ArrayList matchItemBeanList = bean.getMatchItemBeanList();
        HashSet<ItemText> textSet = new HashSet<ItemText>();
        for (MatchItemBean choicebean : matchItemBeanList) {
            ItemText choicetext = new ItemText();
            choicetext.setItem(item.getData());
            choicetext.setSequence(choicebean.getSequence());
            choicetext.setText(this.stripPtags(choicebean.getChoice()));
            Iterator answeriter = matchItemBeanList.iterator();
            HashSet<Answer> answerSet = new HashSet<Answer>();
            Answer answer = null;
            while (answeriter.hasNext()) {
                HashSet<AnswerFeedback> answerFeedbackSet;
                MatchItemBean answerbean = (MatchItemBean)answeriter.next();
                if (answerbean.getSequence().equals(choicebean.getSequence())) {
                    answer = new Answer((ItemTextIfc)choicetext, this.stripPtags(answerbean.getMatch()), answerbean.getSequence(), AnswerBean.getChoiceLabels()[answerbean.getSequence().intValue() - 1], Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                    answerFeedbackSet = new HashSet<AnswerFeedback>();
                    answerFeedbackSet.add(new AnswerFeedback((AnswerIfc)answer, "Correct Feedback", this.stripPtags(answerbean.getCorrMatchFeedback())));
                    answerFeedbackSet.add(new AnswerFeedback((AnswerIfc)answer, "InCorrect Feedback", this.stripPtags(answerbean.getIncorrMatchFeedback())));
                    answer.setAnswerFeedbackSet(answerFeedbackSet);
                } else {
                    answer = new Answer((ItemTextIfc)choicetext, this.stripPtags(answerbean.getMatch()), answerbean.getSequence(), AnswerBean.getChoiceLabels()[answerbean.getSequence().intValue() - 1], Boolean.FALSE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                }
                answerFeedbackSet = new HashSet();
                answerFeedbackSet.add(new AnswerFeedback((AnswerIfc)answer, "Correct Feedback", this.stripPtags(answerbean.getCorrMatchFeedback())));
                answerFeedbackSet.add(new AnswerFeedback((AnswerIfc)answer, "InCorrect Feedback", this.stripPtags(answerbean.getIncorrMatchFeedback())));
                answer.setAnswerFeedbackSet(answerFeedbackSet);
                answerSet.add(answer);
            }
            choicetext.setAnswerSet(answerSet);
            textSet.add(choicetext);
        }
        return textSet;
    }

    private String[] returnMatrixChoices(ItemBean bean, String str) {
        String[] result = null;
        String[] temp = null;
        temp = "row".equals(str) ? bean.getRowChoices().split(System.getProperty("line.separator")) : bean.getColumnChoices().split(System.getProperty("line.separator"));
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : temp) {
            if (string == null || string.trim().length() <= 0) continue;
            stringList.add(string);
        }
        temp = stringList.toArray(new String[stringList.size()]);
        result = new String[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            result[i] = StringUtils.chomp((String)temp[i]);
        }
        return result;
    }

    private HashSet prepareTextForMatrixChoice(ItemFacade item, ItemBean bean, ItemAuthorBean itemauthor) {
        String[] rowChoices = this.returnMatrixChoices(bean, "row");
        String[] columnChoices = this.returnMatrixChoices(bean, "column");
        bean.setInstruction(bean.getItemText());
        item.getData().setInstruction(bean.getItemText());
        HashSet<ItemText> textSet = new HashSet<ItemText>();
        for (int i = 0; i < rowChoices.length; ++i) {
            ItemText itemText = new ItemText();
            itemText.setItem(item.getData());
            itemText.setSequence(Long.valueOf(i));
            itemText.setText(rowChoices[i]);
            HashSet<Answer> answerSet = new HashSet<Answer>();
            Answer answer = null;
            for (int j = 0; j < columnChoices.length; ++j) {
                answer = new Answer((ItemTextIfc)itemText, columnChoices[j], Long.valueOf(j), null, null, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                answerSet.add(answer);
            }
            itemText.setAnswerSet(answerSet);
            textSet.add(itemText);
        }
        return textSet;
    }

    private HashSet prepareText(ItemFacade item, ItemBean bean, ItemAuthorBean itemauthor) throws FinFormatException {
        HashSet<ItemText> textSet = new HashSet<ItemText>();
        HashSet<Answer> answerSet1 = new HashSet<Answer>();
        ItemText text1 = new ItemText();
        text1.setItem(item.getData());
        text1.setSequence(Long.valueOf(1L));
        text1.setText(bean.getItemText());
        if (item.getTypeId().equals(TypeFacade.TRUE_FALSE)) {
            Answer newanswer = null;
            for (int i = 0; i < bean.getAnswers().length; ++i) {
                String theanswer = bean.getAnswers()[i];
                newanswer = theanswer.equals(bean.getCorrAnswer()) ? new Answer((ItemTextIfc)text1, theanswer, Long.valueOf(i + 1), "", Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount())) : new Answer((ItemTextIfc)text1, theanswer, Long.valueOf(i + 1), "", Boolean.FALSE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                answerSet1.add(newanswer);
            }
            text1.setAnswerSet(answerSet1);
            textSet.add(text1);
        } else if (item.getTypeId().equals(TypeFacade.ESSAY_QUESTION)) {
            String theanswer = bean.getCorrAnswer();
            if (theanswer == null) {
                theanswer = "";
            }
            Answer modelanswer = new Answer((ItemTextIfc)text1, theanswer, Long.valueOf(1L), null, Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
            HashSet<AnswerFeedback> answerFeedbackSet1 = new HashSet<AnswerFeedback>();
            answerFeedbackSet1.add(new AnswerFeedback((AnswerIfc)modelanswer, "modelanswer", this.stripPtags(bean.getCorrFeedback())));
            modelanswer.setAnswerFeedbackSet(answerFeedbackSet1);
            answerSet1.add(modelanswer);
            text1.setAnswerSet(answerSet1);
            textSet.add(text1);
        } else if (item.getTypeId().equals(TypeFacade.MULTIPLE_CHOICE_SURVEY)) {
            String scalename = bean.getScaleName();
            String[] choices = this.getSurveyChoices(scalename);
            for (int i = 0; i < choices.length; ++i) {
                Answer answer1 = new Answer((ItemTextIfc)text1, choices[i], Long.valueOf(i + 1), null, null, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                answerSet1.add(answer1);
            }
            text1.setAnswerSet(answerSet1);
            textSet.add(text1);
        } else if (item.getTypeId().equals(TypeFacade.FILL_IN_BLANK)) {
            String entiretext = bean.getItemText();
            String[] processedText = this.processFIBFINText(entiretext);
            text1.setText(processedText[0]);
            Object[] fibanswers = ItemAddListener.getFIBanswers((String)processedText[1]).toArray();
            for (int i = 0; i < fibanswers.length; ++i) {
                String oneanswer = (String)fibanswers[i];
                Answer answer1 = new Answer((ItemTextIfc)text1, oneanswer, Long.valueOf(i + 1), null, Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                answerSet1.add(answer1);
            }
            text1.setAnswerSet(answerSet1);
            textSet.add(text1);
        } else if (item.getTypeId().equals(TypeFacade.FILL_IN_NUMERIC)) {
            String entiretext = bean.getItemText();
            String[] processedText = this.processFIBFINText(entiretext);
            text1.setText(processedText[0]);
            Object[] finanswers = ItemAddListener.getFINanswers((String)processedText[1]).toArray();
            for (int i = 0; i < finanswers.length; ++i) {
                String oneanswer = (String)finanswers[i];
                Answer answer1 = new Answer((ItemTextIfc)text1, oneanswer, Long.valueOf(i + 1), null, Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                answerSet1.add(answer1);
            }
            text1.setAnswerSet(answerSet1);
            textSet.add(text1);
        } else if (item.getTypeId().equals(TypeFacade.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeFacade.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION)) {
            Iterator iter = bean.getMultipleChoiceAnswers().iterator();
            Answer answer = null;
            while (iter.hasNext()) {
                AnswerBean answerbean = (AnswerBean)iter.next();
                if (this.isCorrectChoice(bean, answerbean.getLabel().trim())) {
                    answer = new Answer((ItemTextIfc)text1, this.stripPtags(answerbean.getText()), answerbean.getSequence(), answerbean.getLabel(), Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(100.0f), Float.valueOf(bean.getItemDiscount()));
                } else if (item.getTypeId().equals(TypeFacade.MULTIPLE_CHOICE) && item.getPartialCreditFlag().booleanValue()) {
                    Float pc = Float.valueOf(answerbean.getPartialCredit());
                    if (pc == null) {
                        pc = Float.valueOf(0.0f);
                    }
                    answer = new Answer((ItemTextIfc)text1, this.stripPtags(answerbean.getText()), answerbean.getSequence(), answerbean.getLabel(), Boolean.FALSE, null, Float.valueOf(bean.getItemScore()), pc, Float.valueOf(bean.getItemDiscount()));
                } else {
                    answer = new Answer((ItemTextIfc)text1, this.stripPtags(answerbean.getText()), answerbean.getSequence(), answerbean.getLabel(), Boolean.FALSE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(0.0f), Float.valueOf(bean.getItemDiscount()));
                }
                HashSet<AnswerFeedback> answerFeedbackSet1 = new HashSet<AnswerFeedback>();
                answerFeedbackSet1.add(new AnswerFeedback((AnswerIfc)answer, "General Feedback", this.stripPtags(answerbean.getFeedback())));
                answer.setAnswerFeedbackSet(answerFeedbackSet1);
                answerSet1.add(answer);
            }
            text1.setAnswerSet(answerSet1);
            textSet.add(text1);
        } else {
            textSet.add(text1);
        }
        return textSet;
    }

    private Set preparePublishedText(ItemFacade item, ItemBean bean, ItemService delegate) throws FinFormatException {
        if (item.getTypeId().equals(TypeFacade.TRUE_FALSE)) {
            this.preparePublishedTextForTF(item, bean);
        } else if (item.getTypeId().equals(TypeFacade.ESSAY_QUESTION)) {
            this.preparePublishedTextForEssay(item, bean);
        } else if (item.getTypeId().equals(TypeFacade.MULTIPLE_CHOICE_SURVEY)) {
            this.preparePublishedTextForSurvey(item, bean, delegate);
        } else if (item.getTypeId().equals(TypeFacade.FILL_IN_BLANK)) {
            this.preparePublishedTextForFIBFIN(item, bean, delegate, true);
        } else if (item.getTypeId().equals(TypeFacade.FILL_IN_NUMERIC)) {
            this.preparePublishedTextForFIBFIN(item, bean, delegate, false);
        } else if (item.getTypeId().equals(TypeFacade.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeFacade.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION)) {
            this.preparePublishedTextForMC(item, bean, delegate);
        } else if (item.getTypeId().equals(TypeFacade.MATCHING)) {
            this.preparePublishedTextForMatching(item, bean, delegate);
        } else if (item.getTypeId().equals(TypeFacade.MATRIX_CHOICES_SURVEY)) {
            this.preparePublishedTextForMatrixSurvey(item, bean, delegate);
        } else {
            this.preparePublishedTextForOthers(item, bean);
        }
        Set textSet = item.getItemTextSet();
        return textSet;
    }

    private void preparePublishedTextForTF(ItemFacade item, ItemBean bean) {
        Set answerSet = null;
        AnswerIfc answer2 = null;
        ItemTextIfc text2 = null;
        Set textSet = item.getItemTextSet();
        for (ItemTextIfc text2 : textSet) {
            text2.setText(bean.getItemText());
            answerSet = text2.getAnswerSet();
            for (AnswerIfc answer2 : answerSet) {
                answer2.setScore(Float.valueOf(bean.getItemScore()));
                answer2.setDiscount(Float.valueOf(bean.getItemDiscount()));
                if (answer2.getText().equals(bean.getCorrAnswer())) {
                    answer2.setIsCorrect(Boolean.TRUE);
                    continue;
                }
                answer2.setIsCorrect(Boolean.FALSE);
            }
        }
    }

    private void preparePublishedTextForEssay(ItemFacade item, ItemBean bean) {
        Set answerSet = null;
        AnswerIfc answer2 = null;
        ItemTextIfc text2 = null;
        Set textSet = item.getItemTextSet();
        for (ItemTextIfc text2 : textSet) {
            text2.setText(bean.getItemText());
            answerSet = text2.getAnswerSet();
            for (AnswerIfc answer2 : answerSet) {
                answer2.setScore(Float.valueOf(bean.getItemScore()));
                String theanswer = bean.getCorrAnswer();
                if (theanswer == null) {
                    theanswer = "";
                }
                answer2.setText(theanswer);
                Set answerFeedbackSet = answer2.getAnswerFeedbackSet();
                for (AnswerFeedbackIfc answerFeedback : answerFeedbackSet) {
                    answerFeedback.setText(this.stripPtags(bean.getCorrFeedback()));
                }
            }
        }
    }

    private void preparePublishedTextForSurvey(ItemFacade item, ItemBean bean, ItemService delegate) {
        String scalename = bean.getScaleName();
        String[] choices = this.getSurveyChoices(scalename);
        Set<PublishedAnswer> answerSet = new HashSet();
        Set textSet = item.getItemTextSet();
        ItemTextIfc text2 = null;
        for (ItemTextIfc text2 : textSet) {
            text2.setText(bean.getItemText());
            answerSet = text2.getAnswerSet();
            delegate.deleteSet(answerSet);
            for (int i = 0; i < choices.length; ++i) {
                PublishedAnswer answer = new PublishedAnswer(text2, choices[i], Long.valueOf(i + 1), null, null, null, Float.valueOf(bean.getItemScore()), null, Float.valueOf(bean.getItemDiscount()));
                answerSet.add(answer);
            }
            text2.setAnswerSet(answerSet);
            textSet.add(text2);
        }
    }

    private void preparePublishedTextForFIBFIN(ItemFacade item, ItemBean bean, ItemService delegate, boolean isFIB) throws FinFormatException {
        Set answerSet = null;
        Set textSet = item.getItemTextSet();
        ItemTextIfc text2 = null;
        String entiretext = bean.getItemText();
        String[] processedText = this.processFIBFINText(entiretext);
        String updatedText = processedText[0];
        log.debug((Object)(" new text without answer is = " + updatedText));
        for (ItemTextIfc text2 : textSet) {
            String oneanswer;
            text2.setText(updatedText);
            Object[] answers = isFIB ? ItemAddListener.getFIBanswers((String)entiretext).toArray() : ItemAddListener.getFINanswers((String)entiretext).toArray();
            int newAnswersSize = answers.length;
            int i = 0;
            HashSet<AnswerIfc> toBeRemovedSet = new HashSet<AnswerIfc>();
            answerSet = text2.getAnswerSet();
            for (AnswerIfc answer : answerSet) {
                answer.setScore(Float.valueOf(bean.getItemScore()));
                i = answer.getSequence().intValue();
                if (i <= newAnswersSize) {
                    oneanswer = (String)answers[i - 1];
                    answer.setText(oneanswer);
                    continue;
                }
                toBeRemovedSet.add(answer);
            }
            if (answerSet.size() < newAnswersSize) {
                for (int j = answerSet.size(); j < newAnswersSize; ++j) {
                    oneanswer = (String)answers[j];
                    PublishedAnswer answer = new PublishedAnswer(text2, oneanswer, Long.valueOf(j + 1), null, Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), null, Float.valueOf(bean.getItemDiscount()));
                    answerSet.add(answer);
                }
            }
            answerSet.removeAll(toBeRemovedSet);
            delegate.deleteSet(toBeRemovedSet);
        }
    }

    private void preparePublishedTextForMC(ItemFacade item, ItemBean bean, ItemService delegate) {
        Set answerSet = null;
        Set textSet = item.getItemTextSet();
        ItemTextIfc text2 = null;
        for (ItemTextIfc text2 : textSet) {
            String oneLabel;
            String oneAnswer;
            text2.setText(bean.getItemText());
            ArrayList newAnswerList = bean.getMultipleChoiceAnswers();
            HashMap<Long, AnswerBean> newAnswerMap = new HashMap<Long, AnswerBean>();
            for (AnswerBean answerBean : newAnswerList) {
                newAnswerMap.put(answerBean.getSequence(), answerBean);
            }
            int newAnswersSize = newAnswerList.size();
            int i = 0;
            HashSet<AnswerIfc> toBeRemovedSet = new HashSet<AnswerIfc>();
            AnswerBean answerBean = null;
            answerSet = text2.getAnswerSet();
            for (AnswerIfc answer : answerSet) {
                answer.setDiscount(Float.valueOf(bean.getItemDiscount()));
                i = answer.getSequence().intValue();
                if (i <= newAnswersSize) {
                    answer.setScore(Float.valueOf(bean.getItemScore()));
                    answerBean = (AnswerBean)newAnswerMap.get(Long.valueOf(String.valueOf(i)));
                    oneAnswer = this.stripPtags(answerBean.getText());
                    answer.setPartialCredit(Float.valueOf(answerBean.getPartialCredit()));
                    oneLabel = answerBean.getLabel();
                    log.debug((Object)("oneAnswer = " + oneAnswer));
                    log.debug((Object)("oneLabel = " + oneLabel));
                    answer.setText(oneAnswer);
                    answer.setLabel(oneLabel);
                    if (this.isCorrectChoice(bean, oneLabel.trim())) {
                        answer.setIsCorrect(Boolean.TRUE);
                    } else {
                        answer.setIsCorrect(Boolean.FALSE);
                    }
                    Set answerFeedbackSet = answer.getAnswerFeedbackSet();
                    for (AnswerFeedbackIfc answerFeedback : answerFeedbackSet) {
                        answerFeedback.setText(this.stripPtags(answerBean.getFeedback()));
                    }
                    continue;
                }
                toBeRemovedSet.add(answer);
            }
            if (answerSet.size() < newAnswersSize) {
                for (int j = answerSet.size() + 1; j < newAnswersSize + 1; ++j) {
                    answerBean = (AnswerBean)newAnswerMap.get(Long.valueOf(String.valueOf(j)));
                    oneAnswer = this.stripPtags(answerBean.getText());
                    oneLabel = answerBean.getLabel();
                    PublishedAnswer answer = null;
                    answer = this.isCorrectChoice(bean, answerBean.getLabel().trim()) ? new PublishedAnswer(text2, oneAnswer, Long.valueOf(j), oneLabel, Boolean.TRUE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(100.0f), Float.valueOf(bean.getItemDiscount())) : new PublishedAnswer(text2, oneAnswer, Long.valueOf(j), oneLabel, Boolean.FALSE, null, Float.valueOf(bean.getItemScore()), Float.valueOf(answerBean.getPartialCredit()), Float.valueOf(bean.getItemDiscount()));
                    HashSet<PublishedAnswerFeedback> answerFeedbackSet = new HashSet<PublishedAnswerFeedback>();
                    answerFeedbackSet.add(new PublishedAnswerFeedback((AnswerIfc)answer, "General Feedback", this.stripPtags(answerBean.getFeedback())));
                    answer.setAnswerFeedbackSet(answerFeedbackSet);
                    answerSet.add(answer);
                }
            }
            answerSet.removeAll(toBeRemovedSet);
            delegate.deleteSet(toBeRemovedSet);
        }
    }

    private void preparePublishedTextForMatching(ItemFacade item, ItemBean bean, ItemService delegate) {
        int newSize;
        Set textSet = item.getItemTextSet();
        Iterator textIter = textSet.iterator();
        HashMap<Long, ItemTextIfc> itemTextMap = new HashMap<Long, ItemTextIfc>();
        while (textIter.hasNext()) {
            ItemTextIfc itemText = (ItemTextIfc)textIter.next();
            itemTextMap.put(itemText.getSequence(), itemText);
        }
        ArrayList matchItemBeanList = bean.getMatchItemBeanList();
        Iterator choiceIter = matchItemBeanList.iterator();
        HashMap newMatchItemMap = new HashMap();
        Set<AnswerIfc> answerSet = null;
        PublishedItemText itemText = null;
        AnswerIfc answer2 = null;
        MatchItemBean choiceBean = null;
        MatchItemBean matchBean2 = null;
        Long choiceSequence = null;
        Long matchSequence = null;
        while (choiceIter.hasNext()) {
            choiceBean = (MatchItemBean)choiceIter.next();
            choiceSequence = choiceBean.getSequence();
            if (itemTextMap.get(choiceSequence) == null) {
                itemText = new PublishedItemText();
                itemText.setItem(item.getData());
                itemText.setSequence(choiceBean.getSequence());
                itemText.setText(this.stripPtags(choiceBean.getChoice()));
            } else {
                itemText = (ItemTextIfc)itemTextMap.get(choiceSequence);
                itemText.setText(choiceBean.getChoice());
            }
            HashMap<Long, AnswerIfc> answerMap = new HashMap<Long, AnswerIfc>();
            answerSet = itemText.getAnswerSet();
            if (answerSet != null) {
                for (AnswerIfc answer2 : answerSet) {
                    answerMap.put(answer2.getSequence(), answer2);
                }
            } else {
                answerSet = new HashSet();
                itemText.setAnswerSet(answerSet);
                textSet.add(itemText);
            }
            for (MatchItemBean matchBean2 : matchItemBeanList) {
                matchSequence = matchBean2.getSequence();
                if (answerMap.get(matchSequence) == null) {
                    answer2 = matchBean2.getSequence().equals(choiceBean.getSequence()) ? new PublishedAnswer((ItemTextIfc)itemText, this.stripPtags(matchBean2.getMatch()), matchBean2.getSequence(), AnswerBean.getChoiceLabels()[matchBean2.getSequence().intValue() - 1], Boolean.TRUE, null, new Float(bean.getItemScore()), null, Float.valueOf(bean.getItemDiscount())) : new PublishedAnswer((ItemTextIfc)itemText, this.stripPtags(matchBean2.getMatch()), matchBean2.getSequence(), AnswerBean.getChoiceLabels()[matchBean2.getSequence().intValue() - 1], Boolean.FALSE, null, new Float(bean.getItemScore()), null, Float.valueOf(bean.getItemDiscount()));
                    HashSet<PublishedAnswerFeedback> answerFeedbackSet = new HashSet<PublishedAnswerFeedback>();
                    answerFeedbackSet.add(new PublishedAnswerFeedback(answer2, "Correct Feedback", this.stripPtags(matchBean2.getCorrMatchFeedback())));
                    answerFeedbackSet.add(new PublishedAnswerFeedback(answer2, "InCorrect Feedback", this.stripPtags(matchBean2.getIncorrMatchFeedback())));
                    answer2.setAnswerFeedbackSet(answerFeedbackSet);
                    answerSet.add(answer2);
                    continue;
                }
                answer2 = (AnswerIfc)answerMap.get(matchSequence);
                answer2.setScore(Float.valueOf(bean.getItemScore()));
                String oneAnswer = this.stripPtags(matchBean2.getMatch());
                String oneLabel = AnswerBean.getChoiceLabels()[matchSequence.intValue() - 1];
                log.debug((Object)("oneAnswer = " + oneAnswer));
                log.debug((Object)("oneLabel = " + oneLabel));
                answer2.setText(oneAnswer);
                answer2.setLabel(oneLabel);
                if (choiceSequence.longValue() == matchSequence.longValue()) {
                    answer2.setIsCorrect(Boolean.TRUE);
                } else {
                    answer2.setIsCorrect(Boolean.FALSE);
                }
                Set answerFeedbackSet = answer2.getAnswerFeedbackSet();
                Iterator answerFeedbackIter = answerFeedbackSet.iterator();
                String feedback = "";
                while (answerFeedbackIter.hasNext()) {
                    AnswerFeedbackIfc answerFeedback = (AnswerFeedbackIfc)answerFeedbackIter.next();
                    if (answerFeedback.getTypeId().equals("Correct Feedback")) {
                        answerFeedback.setText(this.stripPtags(matchBean2.getCorrMatchFeedback()));
                        continue;
                    }
                    if (!answerFeedback.getTypeId().equals("InCorrect Feedback")) continue;
                    answerFeedback.setText(this.stripPtags(matchBean2.getIncorrMatchFeedback()));
                }
            }
        }
        int oldSize = textSet.size();
        if (oldSize > (newSize = matchItemBeanList.size())) {
            ItemTextIfc text;
            int i;
            HashSet<ItemTextIfc> toBeRemovedTextSet = new HashSet<ItemTextIfc>();
            HashSet<AnswerIfc> toBeRemovedAnswerSet = new HashSet<AnswerIfc>();
            for (i = 1; i < newSize + 1; ++i) {
                text = (ItemTextIfc)itemTextMap.get(i);
                answerSet = text.getAnswerSet();
                if (answerSet == null) continue;
                for (AnswerIfc answer2 : answerSet) {
                    for (int j = newSize + 1; j < oldSize + 1; ++j) {
                        if (answer2.getSequence().intValue() != j) continue;
                        toBeRemovedAnswerSet.add(answer2);
                    }
                }
                answerSet.removeAll(toBeRemovedAnswerSet);
                delegate.deleteSet(toBeRemovedAnswerSet);
            }
            for (i = newSize + 1; i < oldSize + 1; ++i) {
                text = (ItemTextIfc)itemTextMap.get(i);
                toBeRemovedTextSet.add(text);
            }
            textSet.removeAll(toBeRemovedTextSet);
            delegate.deleteSet(toBeRemovedTextSet);
        }
    }

    private void preparePublishedTextForOthers(ItemFacade item, ItemBean bean) {
        ItemTextIfc text2 = null;
        Set textSet = item.getItemTextSet();
        for (ItemTextIfc text2 : textSet) {
            text2.setText(bean.getItemText());
        }
    }

    protected HashSet prepareMetaData(ItemFacade item, ItemBean bean) {
        HashSet<ItemMetaData> set = new HashSet<ItemMetaData>();
        if (bean.getKeyword() != null) {
            set.add(new ItemMetaData(item.getData(), "KEYWORD", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getKeyword())));
        }
        if (bean.getRubric() != null) {
            set.add(new ItemMetaData(item.getData(), "RUBRIC", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getRubric())));
        }
        if (bean.getObjective() != null) {
            set.add(new ItemMetaData(item.getData(), "OBJECTIVE", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getObjective())));
        }
        if (bean.getRandomized() != null) {
            set.add(new ItemMetaData(item.getData(), "RANDOMIZE", bean.getRandomized()));
        }
        if (bean.getScaleName() != null) {
            set.add(new ItemMetaData(item.getData(), "PREDEFINED_SCALE", bean.getScaleName()));
        }
        set.add(new ItemMetaData(item.getData(), "CASE_SENSITIVE", Boolean.toString(bean.getCaseSensitiveForFib())));
        boolean wellformatted = false;
        if (bean.getMutuallyExclusiveForFib()) {
            wellformatted = this.isValidMutualExclusiveFIB(bean);
        }
        set.add(new ItemMetaData(item.getData(), "MUTUALLY_EXCLUSIVE", Boolean.toString(wellformatted)));
        set.add(new ItemMetaData(item.getData(), "FORCE_RANKING", Boolean.toString(bean.getForceRanking())));
        set.add(new ItemMetaData(item.getData(), "ADD_COMMENT_MATRIX", Boolean.toString(bean.getAddComment())));
        set.add(new ItemMetaData(item.getData(), "MX_SURVEY_QUESTION_COMMENTFIELD", bean.getCommentField()));
        set.add(new ItemMetaData(item.getData(), "MX_SURVEY_RELATIVE_WIDTH", Integer.toString(bean.getRelativeWidth())));
        if (bean.getSelectedSection() != null) {
            set.add(new ItemMetaData(item.getData(), "PARTID", bean.getSelectedSection()));
        }
        if (bean.getSelectedPool() != null) {
            set.add(new ItemMetaData(item.getData(), "POOLID", bean.getSelectedPool()));
        }
        return set;
    }

    protected Set preparePublishedMetaData(ItemFacade item, ItemBean bean) {
        Set itemMetaDataSet = item.getItemMetaDataSet();
        for (ItemMetaDataIfc itemMetaData : itemMetaDataSet) {
            if (itemMetaData.getLabel().equals("KEYWORD")) {
                itemMetaData.setEntry(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getKeyword()));
                continue;
            }
            if (itemMetaData.getLabel().equals("RUBRIC")) {
                itemMetaData.setEntry(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getKeyword()));
                continue;
            }
            if (itemMetaData.getLabel().equals("OBJECTIVE")) {
                itemMetaData.setEntry(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getObjective()));
                continue;
            }
            if (itemMetaData.getLabel().equals("RANDOMIZE")) {
                itemMetaData.setEntry(bean.getRandomized());
                continue;
            }
            if (itemMetaData.getLabel().equals("PREDEFINED_SCALE")) {
                itemMetaData.setEntry(bean.getScaleName());
                continue;
            }
            if (itemMetaData.getLabel().equals("CASE_SENSITIVE")) {
                itemMetaData.setEntry(Boolean.toString(bean.getCaseSensitiveForFib()));
                continue;
            }
            if (itemMetaData.getLabel().equals("KEYWORD")) {
                itemMetaData.setEntry(bean.getKeyword());
                continue;
            }
            if (itemMetaData.getLabel().equals("MUTUALLY_EXCLUSIVE")) {
                boolean wellformatted = false;
                if (bean.getMutuallyExclusiveForFib()) {
                    wellformatted = this.isValidMutualExclusiveFIB(bean);
                }
                itemMetaData.setEntry(Boolean.toString(wellformatted));
                continue;
            }
            if (itemMetaData.getLabel().equals("PARTID")) {
                itemMetaData.setEntry(bean.getSelectedSection());
                continue;
            }
            if (itemMetaData.getLabel().equals("POOLID")) {
                itemMetaData.setEntry(bean.getSelectedPool());
                continue;
            }
            if (itemMetaData.getLabel().equals("FORCE_RANKING")) {
                itemMetaData.setEntry(Boolean.toString(bean.getForceRanking()));
                continue;
            }
            if (itemMetaData.getLabel().equals("MX_SURVEY_RELATIVE_WIDTH")) {
                itemMetaData.setEntry(Integer.toString(bean.getRelativeWidth()));
                continue;
            }
            if (itemMetaData.getLabel().equals("ADD_COMMENT_MATRIX")) {
                itemMetaData.setEntry(Boolean.toString(bean.getAddComment()));
                continue;
            }
            if (!itemMetaData.getLabel().equals("MX_SURVEY_QUESTION_COMMENTFIELD")) continue;
            itemMetaData.setEntry(bean.getCommentField());
        }
        return itemMetaDataSet;
    }

    private void preparePublishedTextForMatrixSurvey(ItemFacade item, ItemBean bean, ItemService delegate) {
        Set textSet = item.getItemTextSet();
        Iterator textIter = textSet.iterator();
        HashMap<Long, ItemTextIfc> itemTextMap = new HashMap<Long, ItemTextIfc>();
        while (textIter.hasNext()) {
            ItemTextIfc itemText = (ItemTextIfc)textIter.next();
            itemTextMap.put(itemText.getSequence(), itemText);
        }
    }

    private static ArrayList getFIBanswers(String entiretext) {
        String fixedText = entiretext.replaceAll("&nbsp;", " ");
        String[] tokens = fixedText.split("[\\}][^\\{]*[\\{]");
        ArrayList<String> list = new ArrayList<String>();
        if (tokens.length == 1) {
            String[] afteropen = tokens[0].split("\\{");
            if (afteropen.length > 1) {
                String[] lastpart = afteropen[1].split("\\}");
                list.add(lastpart[0]);
            }
        } else {
            for (int i = 0; i < tokens.length; ++i) {
                if (i == 0) {
                    String[] firstpart = tokens[i].split("\\{");
                    if (firstpart.length <= 1) continue;
                    list.add(firstpart[1]);
                    continue;
                }
                if (i == tokens.length - 1) {
                    String[] lastpart = tokens[i].split("\\}");
                    list.add(lastpart[0]);
                    continue;
                }
                list.add(tokens[i]);
            }
        }
        return list;
    }

    private static ArrayList getFINanswers(String entiretext) throws FinFormatException {
        String fixedText = entiretext.replaceAll("&nbsp;", " ");
        String[] tokens = fixedText.split("[\\}][^\\{]*[\\{]");
        ArrayList<String> list = new ArrayList<String>();
        if (tokens.length == 1) {
            String[] afteropen = tokens[0].split("\\{");
            if (afteropen.length > 1) {
                String[] lastpart = afteropen[1].split("\\}");
                list.add(lastpart[0]);
            }
        } else {
            for (int i = 0; i < tokens.length; ++i) {
                if (i == 0) {
                    String[] firstpart = tokens[i].split("\\{");
                    if (firstpart.length <= 1) continue;
                    list.add(firstpart[1]);
                    continue;
                }
                if (i == tokens.length - 1) {
                    String[] lastpart = tokens[i].split("\\}");
                    list.add(lastpart[0]);
                    continue;
                }
                list.add(tokens[i]);
            }
        }
        return list;
    }

    public boolean isCorrectChoice(ItemBean bean, String label) {
        boolean returnvalue = false;
        if (TypeFacade.MULTIPLE_CHOICE.toString().equals(bean.getItemType())) {
            String corranswer = ContextUtil.lookupParam((String)"itemForm:selectedRadioBtn");
            returnvalue = corranswer.equals(label);
        } else {
            ArrayList corranswersList = ContextUtil.paramArrayValueLike((String)"mccheckboxes");
            for (String currentcorrect : corranswersList) {
                if (currentcorrect.trim().equals(label)) {
                    returnvalue = true;
                    break;
                }
                returnvalue = false;
            }
        }
        return returnvalue;
    }

    public void shiftSequences(ItemService delegate, SectionFacade sectfacade, Integer currSeq) {
        Set itemset = sectfacade.getItemFacadeSet();
        for (ItemFacade itemfacade : itemset) {
            Integer itemfacadeseq = itemfacade.getSequence();
            if (itemfacadeseq.compareTo(currSeq) <= 0) continue;
            itemfacade.setSequence(Integer.valueOf(itemfacadeseq + 1));
            delegate.saveItem(itemfacade);
        }
    }

    private void shiftItemsInOrigSection(ItemService delegate, SectionFacade sectfacade, Integer currSeq) {
        Set itemset = sectfacade.getItemFacadeSet();
        for (ItemFacade itemfacade : itemset) {
            Integer itemfacadeseq = itemfacade.getSequence();
            if (itemfacadeseq.compareTo(currSeq) <= 0) continue;
            itemfacade.setSequence(Integer.valueOf(itemfacadeseq - 1));
            delegate.saveItem(itemfacade);
        }
    }

    private String stripPtags(String origtext) {
        String newanswer = origtext;
        if (origtext != null && origtext.startsWith("<p") && origtext.endsWith("</p>")) {
            newanswer = origtext.substring(origtext.indexOf(">") + 1, origtext.lastIndexOf("</p>"));
            return newanswer.trim();
        }
        return newanswer;
    }

    private boolean isValidMutualExclusiveFIB(ItemBean bean) {
        String entiretext = bean.getItemText();
        String[] processedText = this.processFIBFINText(entiretext);
        log.debug((Object)("processedText[1]=" + processedText[1]));
        Object[] fibanswers = ItemAddListener.getFIBanswers((String)processedText[1]).toArray();
        ArrayList blanklist = new ArrayList();
        for (int i = 0; i < fibanswers.length; ++i) {
            log.debug((Object)("fibanswers[" + i + "]=" + fibanswers[i]));
            String oneanswer = (String)fibanswers[i];
            String[] oneblank = oneanswer.split("\\|");
            HashSet<String> oneblankset = new HashSet<String>();
            for (int j = 0; j < oneblank.length; ++j) {
                oneblankset.add(oneblank[j].trim().toLowerCase());
            }
            blanklist.add(oneblankset);
        }
        boolean invalid = false;
        if (blanklist.size() <= 1) {
            invalid = true;
        } else {
            for (int i = 1; i < blanklist.size(); ++i) {
                if (blanklist.get(0).equals(blanklist.get(i))) continue;
                invalid = true;
                break;
            }
        }
        return !invalid;
    }

    private void updateAttachment(List oldList, List newList, ItemDataIfc item, boolean pendingOrPool) {
        if (!(oldList != null && oldList.size() != 0 || newList != null && newList.size() != 0)) {
            return;
        }
        ArrayList<ItemAttachmentIfc> list = new ArrayList<ItemAttachmentIfc>();
        HashMap map = this.getAttachmentIdHash(oldList);
        for (int i = 0; i < newList.size(); ++i) {
            ItemAttachmentIfc a = (ItemAttachmentIfc)newList.get(i);
            if (map.get(a.getAttachmentId()) != null) {
                map.remove(a.getAttachmentId());
                continue;
            }
            a.setItem(item);
            list.add(a);
        }
        Object service = pendingOrPool ? new AssessmentService() : new PublishedAssessmentService();
        service.saveOrUpdateAttachments(list);
        Set set = map.keySet();
        for (Long attachmentId : set) {
            service.removeItemAttachment(attachmentId.toString());
        }
    }

    private HashMap getAttachmentIdHash(List list) {
        HashMap<Long, ItemAttachmentIfc> map = new HashMap<Long, ItemAttachmentIfc>();
        for (int i = 0; i < list.size(); ++i) {
            ItemAttachmentIfc a = (ItemAttachmentIfc)list.get(i);
            map.put(a.getAttachmentId(), a);
        }
        return map;
    }

    private void updateItemFeedback(ItemFacade item, String feedbackTypeId, String feedbackText) {
        Set itemFeedbackSet = item.getItemFeedbackSet();
        if (itemFeedbackSet == null || itemFeedbackSet.size() == 0 || !item.getItemFeedbackMap(itemFeedbackSet).containsKey(feedbackTypeId)) {
            item.addItemFeedback(feedbackTypeId, feedbackText);
        } else {
            for (ItemFeedbackIfc itemFeedback : itemFeedbackSet) {
                if (!itemFeedback.getTypeId().equals(feedbackTypeId)) continue;
                itemFeedback.setText(feedbackText);
                item.getItemFeedbackMap(itemFeedbackSet).put(feedbackTypeId, feedbackText);
            }
        }
    }

    private String[] getSurveyChoices(String scalename) {
        String[] choices = new String[2];
        if ("YES".equals(scalename)) {
            choices = new String[]{ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"no"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"yes")};
        }
        if ("AGREE".equals(scalename)) {
            choices = new String[]{ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"disagree"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"agree")};
        }
        if ("UNDECIDED".equals(scalename)) {
            choices = new String[]{ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"disagree"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"undecided"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"agree")};
        }
        if ("AVERAGE".equals(scalename)) {
            choices = new String[]{ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"below_average"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"average"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"above_average")};
        }
        if ("STRONGLY_AGREE".equals(scalename)) {
            choices = new String[]{ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"strongly_disagree"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"disagree"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"undecided"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"agree"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"strongly_agree")};
        }
        if ("EXCELLENT".equals(scalename)) {
            choices = new String[]{ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"unacceptable"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"below_average"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"average"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"above_average"), ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"excellent")};
        }
        if ("5".equals(scalename)) {
            choices = new String[]{"1", "2", "3", "4", "5"};
        }
        if ("10".equals(scalename)) {
            choices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        }
        return choices;
    }

    private String[] processFIBFINText(String entiretext) {
        String[] processedText = new String[2];
        Pattern pattern1 = Pattern.compile("[\\{][^\\}]*[\\}]");
        Matcher matcher1 = pattern1.matcher(entiretext);
        StringBuilder textStringBuilder1 = new StringBuilder();
        String tmpString1 = null;
        int index1 = 0;
        while (matcher1.find()) {
            String group = matcher1.group();
            textStringBuilder1.append(entiretext.substring(index1, matcher1.start()));
            tmpString1 = group.replaceAll("<.*?>", "");
            textStringBuilder1.append(tmpString1);
            index1 = matcher1.end();
        }
        textStringBuilder1.append(entiretext.substring(index1));
        String modifiedText = textStringBuilder1.toString();
        Pattern pattern2 = Pattern.compile("(<([a-z]\\w*)\\b[^>]*>(.*?)</\\1\\s*>)|(<([a-z]\\w*)\\b[^>]*/>)", 34);
        Matcher matcher2 = pattern2.matcher(modifiedText);
        int index2 = 0;
        StringBuilder textStringBuilder2 = new StringBuilder();
        StringBuilder textStringBuilder3 = new StringBuilder();
        String tmpString2 = null;
        while (matcher2.find()) {
            String group = matcher2.group();
            log.debug((Object)("group" + group));
            tmpString2 = modifiedText.substring(index2, matcher2.start());
            log.debug((Object)("tmpString2" + tmpString2));
            if (tmpString2 != null) {
                textStringBuilder2.append(tmpString2.replaceAll("[\\{][^\\}]*[\\}]", "{}"));
                textStringBuilder3.append(tmpString2);
                log.debug((Object)("textStringBuilder2=" + textStringBuilder2));
                log.debug((Object)("textStringBuilder3=" + textStringBuilder3));
            }
            textStringBuilder2.append(group);
            index2 = matcher2.end();
            log.debug((Object)("index2=" + index2));
        }
        tmpString2 = modifiedText.substring(index2);
        if (tmpString2 != null) {
            textStringBuilder2.append(tmpString2.replaceAll("[\\{][^\\}]*[\\}]", "{}"));
            textStringBuilder3.append(tmpString2);
            log.debug((Object)("textStringBuilder2=" + textStringBuilder2));
            log.debug((Object)("textStringBuilder3=" + textStringBuilder3));
        }
        processedText[0] = textStringBuilder2.toString();
        processedText[1] = textStringBuilder3.toString();
        return processedText;
    }
}

