/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PublishedItemService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AnswerBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemBean;
import org.sakaiproject.tool.assessment.ui.bean.author.MatchItemBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class ItemModifyListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ItemModifyListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        String target;
        log.debug((Object)"ItemModify LISTENER.");
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        String itemId = ContextUtil.lookupParam((String)"itemid");
        if (itemId != null) {
            itemauthorbean.setItemId(itemId);
        } else {
            itemId = itemauthorbean.getItemId();
        }
        String poolid = ContextUtil.lookupParam((String)"poolId");
        if (poolid != null) {
            itemauthorbean.setQpoolId(poolid);
        }
        if ((target = ContextUtil.lookupParam((String)"target")) != null) {
            itemauthorbean.setTarget(target);
        }
        if (!this.populateItemBean(itemauthorbean, itemId)) {
            throw new RuntimeException("failed to populateItemBean.");
        }
    }

    public boolean populateItemBean(ItemAuthorBean itemauthorbean, String itemId) {
        String nextpage = null;
        ItemBean bean = new ItemBean();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        log.debug((Object)("**** isEditPendingAssessmentFlow : " + isEditPendingAssessmentFlow));
        ItemService delegate = null;
        AssessmentService assessdelegate = null;
        if (isEditPendingAssessmentFlow) {
            delegate = new ItemService();
            assessdelegate = new AssessmentService();
        } else {
            delegate = new PublishedItemService();
            assessdelegate = new PublishedAssessmentService();
        }
        try {
            Float points;
            ItemFacade itemfacade = delegate.getItem(new Long(itemId), AgentFacade.getAgentString());
            bean.setItemId(itemfacade.getItemId().toString());
            bean.setItemType(itemfacade.getTypeId().toString());
            itemauthorbean.setItemType(itemfacade.getTypeId().toString());
            if (itemfacade.getSequence() != null) {
                itemauthorbean.setItemNo(String.valueOf(itemfacade.getSequence()));
            }
            String score = (points = itemfacade.getScore()) != null ? points.toString() : "0.0";
            bean.setItemScore(score);
            Float discountpoints = itemfacade.getDiscount();
            String discount = discountpoints != null ? discountpoints.toString() : "0.0";
            bean.setItemDiscount(discount);
            String partialCreditFlag = "FALSE";
            Boolean hasPartialCredit = itemfacade.getPartialCreditFlag();
            if (hasPartialCredit != null) {
                partialCreditFlag = hasPartialCredit.toString();
            }
            bean.setPartialCreditFlag(partialCreditFlag);
            if (itemfacade.getHasRationale() != null) {
                bean.setRationale(itemfacade.getHasRationale().toString());
            }
            if (itemfacade.getInstruction() != null) {
                bean.setInstruction(itemfacade.getInstruction());
            }
            if (itemfacade.getDuration() != null) {
                bean.setTimeAllowed(itemfacade.getDuration().toString());
            }
            if (itemfacade.getTriesAllowed() != null) {
                bean.setNumAttempts(itemfacade.getTriesAllowed().toString());
            }
            bean.setCorrFeedback(itemfacade.getCorrectItemFeedback());
            bean.setIncorrFeedback(itemfacade.getInCorrectItemFeedback());
            bean.setGeneralFeedback(itemfacade.getGeneralItemFeedback());
            this.populateMetaData(itemauthorbean, itemfacade, bean);
            if (new Long(itemauthorbean.getItemType()).equals(TypeFacade.MATCHING)) {
                this.populateItemTextForMatching(itemauthorbean, itemfacade, bean);
            } else if (new Long(itemauthorbean.getItemType()).equals(TypeFacade.MATRIX_CHOICES_SURVEY)) {
                this.populateItemTextForMatrix(itemauthorbean, itemfacade, bean);
            } else {
                this.populateItemText(itemauthorbean, itemfacade, bean);
            }
            List attachmentList = itemfacade.getData().getItemAttachmentList();
            itemauthorbean.setAttachmentList(attachmentList);
            itemauthorbean.setResourceHash(null);
            int itype = 0;
            if (itemauthorbean.getItemType() != null) {
                itype = new Integer(itemauthorbean.getItemType());
            }
            switch (itype) {
                case 1: {
                    itemauthorbean.setItemTypeString("Multiple Choice");
                    nextpage = "multipleChoiceItem";
                    break;
                }
                case 2: {
                    itemauthorbean.setItemTypeString("Multiple Choice");
                    nextpage = "multipleChoiceItem";
                    break;
                }
                case 12: {
                    itemauthorbean.setItemTypeString("Multiple Choice");
                    nextpage = "multipleChoiceItem";
                    break;
                }
                case 3: {
                    itemauthorbean.setItemTypeString("Survey");
                    nextpage = "surveyItem";
                    break;
                }
                case 4: {
                    itemauthorbean.setItemTypeString("True or False");
                    nextpage = "trueFalseItem";
                    break;
                }
                case 5: {
                    itemauthorbean.setItemTypeString("Short Answers/Essay");
                    nextpage = "shortAnswerItem";
                    break;
                }
                case 6: {
                    itemauthorbean.setItemTypeString("File Upload");
                    nextpage = "fileUploadItem";
                    break;
                }
                case 7: {
                    itemauthorbean.setItemTypeString("Audio Recording");
                    nextpage = "audioRecItem";
                    break;
                }
                case 8: {
                    itemauthorbean.setItemTypeString("Fill In the Blank");
                    nextpage = "fillInBlackItem";
                    break;
                }
                case 11: {
                    itemauthorbean.setItemTypeString("Fill In Numeric");
                    nextpage = "fillInNumericItem";
                    break;
                }
                case 9: {
                    itemauthorbean.setItemTypeString("Matching");
                    MatchItemBean matchitem = new MatchItemBean();
                    bean.setCurrentMatchPair(matchitem);
                    nextpage = "matchingItem";
                    break;
                }
                case 10: {
                    itemauthorbean.setItemTypeString("Importing from Question Pool");
                    nextpage = "poolList";
                    break;
                }
                case 13: {
                    itemauthorbean.setItemTypeString("Matrix Choices Survey");
                    nextpage = "matrixChoicesSurveyItem";
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
        if ("assessment".equals(itemauthorbean.getTarget())) {
            AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
            AssessmentIfc assessment = assessdelegate.getAssessment(Long.valueOf(assessmentBean.getAssessmentId()));
            itemauthorbean.setShowMetadata(assessment.getHasMetaDataForQuestions());
        } else {
            itemauthorbean.setShowMetadata("true");
        }
        itemauthorbean.setCurrentItem(bean);
        itemauthorbean.setOutcome(nextpage);
        return true;
    }

    private void populateItemText(ItemAuthorBean itemauthorbean, ItemFacade itemfacade, ItemBean bean) {
        Set itemtextSet = itemfacade.getItemTextSet();
        for (ItemTextIfc itemText : itemtextSet) {
            Iterator iter2;
            Long seq;
            String answer;
            String[] answerArray;
            Iterator iter1;
            Set answerSet;
            String replaced;
            String orig;
            Set answerSet2;
            bean.setItemText(itemText.getText());
            if (new Long(itemauthorbean.getItemType()).equals(TypeFacade.TRUE_FALSE)) {
                answerSet2 = itemText.getAnswerSet();
                for (AnswerIfc answer2 : answerSet2) {
                    if (answer2.getIsCorrect() == null || !answer2.getIsCorrect().booleanValue()) continue;
                    bean.setCorrAnswer(answer2.getText());
                }
            }
            if (new Long(itemauthorbean.getItemType()).equals(TypeFacade.ESSAY_QUESTION)) {
                answerSet2 = itemText.getAnswerSet();
                for (AnswerIfc answer2 : answerSet2) {
                    bean.setCorrAnswer(answer2.getText());
                    Set feedbackSet = answer2.getAnswerFeedbackSet();
                    Iterator iter22 = feedbackSet.iterator();
                    while (iter22.hasNext()) {
                        bean.setCorrFeedback(((AnswerFeedbackIfc)iter22.next()).getText());
                    }
                }
            }
            if (new Long(itemauthorbean.getItemType()).equals(TypeFacade.FILL_IN_BLANK)) {
                orig = itemText.getText();
                replaced = null;
                answerSet = itemText.getAnswerSet();
                iter1 = answerSet.iterator();
                int count = answerSet.size();
                answerArray = new String[count];
                while (iter1.hasNext()) {
                    AnswerIfc answerobj = (AnswerIfc)iter1.next();
                    answer = answerobj.getText();
                    seq = answerobj.getSequence();
                    if (answerArray[seq.intValue() - 1] == null || answerArray[seq.intValue() - 1].equals("")) {
                        answerArray[seq.intValue() - 1] = answer;
                        continue;
                    }
                    answerArray[seq.intValue() - 1] = answerArray[seq.intValue() - 1] + " | " + answer;
                }
                for (int i = 0; i < answerArray.length; ++i) {
                    orig = replaced = orig.replaceFirst("\\{\\}", Matcher.quoteReplacement("{" + answerArray[i] + "}"));
                }
                bean.setItemText(replaced);
            }
            if (new Long(itemauthorbean.getItemType()).equals(TypeFacade.FILL_IN_NUMERIC)) {
                orig = itemText.getText();
                replaced = null;
                answerSet = itemText.getAnswerSet();
                iter1 = answerSet.iterator();
                int count = answerSet.size();
                answerArray = new String[count];
                while (iter1.hasNext()) {
                    AnswerIfc answerobj = (AnswerIfc)iter1.next();
                    answer = answerobj.getText();
                    seq = answerobj.getSequence();
                    if (answerArray[seq.intValue() - 1] == null || answerArray[seq.intValue() - 1].equals("")) {
                        answerArray[seq.intValue() - 1] = answer;
                        continue;
                    }
                    answerArray[seq.intValue() - 1] = answerArray[seq.intValue() - 1] + " | " + answer;
                }
                for (int i = 0; i < answerArray.length; ++i) {
                    orig = replaced = orig.replaceFirst("\\{\\}", "{" + answerArray[i] + "}");
                }
                bean.setItemText(replaced);
            }
            if (!Long.valueOf(itemauthorbean.getItemType()).equals(TypeFacade.MULTIPLE_CHOICE) && !Long.valueOf(itemauthorbean.getItemType()).equals(TypeFacade.MULTIPLE_CORRECT) && !Long.valueOf(itemauthorbean.getItemType()).equals(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION)) continue;
            Set answerobjlist = itemText.getAnswerSet();
            String afeedback = "";
            Iterator iter12 = answerobjlist.iterator();
            ArrayList<AnswerBean> answerbeanlist = new ArrayList<AnswerBean>();
            ArrayList<AnswerBean> correctlist = new ArrayList<AnswerBean>();
            int count = answerobjlist.size();
            AnswerIfc[] answerArray2 = new AnswerIfc[count];
            while (iter12.hasNext()) {
                AnswerIfc answerobj = (AnswerIfc)iter12.next();
                seq = answerobj.getSequence();
                answerArray2[seq.intValue() - 1] = answerobj;
            }
            for (int i = 0; i < answerArray2.length; ++i) {
                Set feedbackSet = answerArray2[i].getAnswerFeedbackSet();
                if (feedbackSet.size() == 1) {
                    AnswerFeedbackIfc afbobj = (AnswerFeedbackIfc)feedbackSet.iterator().next();
                    afeedback = afbobj.getText();
                }
                AnswerBean answerbean = new AnswerBean();
                answerbean.setText(answerArray2[i].getText());
                answerbean.setSequence(answerArray2[i].getSequence());
                answerbean.setLabel(answerArray2[i].getLabel());
                answerbean.setFeedback(afeedback);
                answerbean.setIsCorrect(answerArray2[i].getIsCorrect());
                if (answerbean.getIsCorrect() != null && answerbean.getIsCorrect().booleanValue()) {
                    correctlist.add(answerbean);
                }
                if (Long.valueOf(itemauthorbean.getItemType()).equals(TypeFacade.MULTIPLE_CHOICE)) {
                    if (answerArray2[i].getPartialCredit() != null) {
                        answerbean.setPartialCredit(Integer.toString(answerArray2[i].getPartialCredit().intValue()));
                    } else {
                        answerbean.setPartialCredit("0");
                    }
                }
                answerbeanlist.add(answerbean);
            }
            if (Long.valueOf(itemauthorbean.getItemType()).equals(TypeFacade.MULTIPLE_CHOICE) && (iter2 = correctlist.iterator()).hasNext()) {
                AnswerBean corrbean = (AnswerBean)iter2.next();
                bean.setCorrAnswer(corrbean.getLabel());
            }
            if (Long.valueOf(itemauthorbean.getItemType()).equals(TypeFacade.MULTIPLE_CORRECT) || Long.valueOf(itemauthorbean.getItemType()).equals(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION)) {
                int corrsize = correctlist.size();
                String[] corrchoices = new String[corrsize];
                Iterator iter3 = correctlist.iterator();
                int counter = 0;
                while (iter3.hasNext()) {
                    corrchoices[counter] = ((AnswerBean)iter3.next()).getLabel();
                    ++counter;
                }
                bean.setCorrAnswers(corrchoices);
            }
            bean.setMultipleChoiceAnswers(answerbeanlist);
        }
    }

    private void populateItemTextForMatrix(ItemAuthorBean itemauthorbean, ItemFacade itemfacade, ItemBean bean) {
        Set itemtextSet = itemfacade.getItemTextSet();
        Iterator iter = itemtextSet.iterator();
        StringBuffer rowChoices = new StringBuffer();
        while (iter.hasNext()) {
            ItemTextIfc itemText = (ItemTextIfc)iter.next();
            if (!"".equals(itemText.getText())) {
                rowChoices = rowChoices.append(itemText.getText());
                rowChoices = rowChoices.append(System.getProperty("line.separator"));
            }
            Set answerSet = itemText.getAnswerSet();
            Iterator iter1 = answerSet.iterator();
            StringBuffer columnChoices = new StringBuffer();
            while (iter1.hasNext()) {
                AnswerIfc answer = (AnswerIfc)iter1.next();
                if ("".equals(answer.getText())) continue;
                columnChoices = columnChoices.append(answer.getText());
                columnChoices = columnChoices.append(System.getProperty("line.separator"));
            }
            bean.setColumnChoices(columnChoices.toString());
        }
        bean.setRowChoices(rowChoices.toString());
        bean.setItemText(itemfacade.getText());
    }

    private void populateItemTextForMatching(ItemAuthorBean itemauthorbean, ItemFacade itemfacade, ItemBean bean) {
        Set itemtextSet = itemfacade.getItemTextSet();
        Iterator iter = itemtextSet.iterator();
        ArrayList<MatchItemBean> matchItemBeanList = new ArrayList<MatchItemBean>();
        while (iter.hasNext()) {
            ItemTextIfc itemText = (ItemTextIfc)iter.next();
            MatchItemBean choicebean = new MatchItemBean();
            choicebean.setChoice(itemText.getText());
            choicebean.setSequence(itemText.getSequence());
            Set answerSet = itemText.getAnswerSet();
            for (AnswerIfc answer : answerSet) {
                if (answer.getIsCorrect() == null || !answer.getIsCorrect().booleanValue()) continue;
                choicebean.setMatch(answer.getText());
                choicebean.setIsCorrect(Boolean.TRUE);
                Set feedbackSet = answer.getAnswerFeedbackSet();
                for (AnswerFeedbackIfc feedback : feedbackSet) {
                    if (feedback.getTypeId().equals("Correct Feedback")) {
                        choicebean.setCorrMatchFeedback(feedback.getText());
                        continue;
                    }
                    if (!feedback.getTypeId().equals("InCorrect Feedback")) continue;
                    choicebean.setIncorrMatchFeedback(feedback.getText());
                }
            }
            matchItemBeanList.add(choicebean);
        }
        bean.setMatchItemBeanList(matchItemBeanList);
    }

    private void populateMetaData(ItemAuthorBean itemauthorbean, ItemFacade itemfacade, ItemBean bean) {
        Set itemtextSet = itemfacade.getItemMetaDataSet();
        for (ItemMetaDataIfc meta : itemtextSet) {
            if (meta.getLabel().equals("OBJECTIVE")) {
                bean.setObjective(FormattedText.convertFormattedTextToPlaintext((String)meta.getEntry()));
            }
            if (meta.getLabel().equals("KEYWORD")) {
                bean.setKeyword(FormattedText.convertFormattedTextToPlaintext((String)meta.getEntry()));
            }
            if (meta.getLabel().equals("RUBRIC")) {
                bean.setRubric(FormattedText.convertFormattedTextToPlaintext((String)meta.getEntry()));
            }
            if (meta.getLabel().equals("RANDOMIZE")) {
                bean.setRandomized(meta.getEntry());
            }
            if (meta.getLabel().equals("PREDEFINED_SCALE")) {
                bean.setScaleName(meta.getEntry());
            }
            if (meta.getLabel().equals("SCALENAME")) {
                bean.setScaleName(meta.getEntry());
                if ("YESNO".equals(meta.getEntry())) {
                    bean.setScaleName("YES");
                }
                if ("SCALEFIVE".equals(meta.getEntry())) {
                    bean.setScaleName("5");
                }
                if ("SCALETEN".equals(meta.getEntry())) {
                    bean.setScaleName("10");
                }
            }
            if (meta.getLabel().equals("CASE_SENSITIVE")) {
                bean.setCaseSensitiveForFib(Boolean.valueOf(meta.getEntry()).booleanValue());
            }
            if (meta.getLabel().equals("MUTUALLY_EXCLUSIVE")) {
                bean.setMutuallyExclusiveForFib(Boolean.valueOf(meta.getEntry()).booleanValue());
            }
            if (meta.getLabel().equals("MUTUALLY_EXCLUSIVE")) {
                bean.setMutuallyExclusiveForFib(Boolean.valueOf(meta.getEntry()).booleanValue());
            }
            if (meta.getLabel().equals("ADD_TO_FAVORITES")) {
                bean.setAddToFavorite(Boolean.valueOf(meta.getEntry()).booleanValue());
            }
            if (meta.getLabel().equals("ADD_COMMENT_MATRIX")) {
                bean.setAddComment(Boolean.valueOf(meta.getEntry()).booleanValue());
            }
            if (meta.getLabel().equals("FORCE_RANKING")) {
                bean.setForceRanking(Boolean.valueOf(meta.getEntry()).booleanValue());
            }
            if (meta.getLabel().equals("MX_SURVEY_QUESTION_COMMENTFIELD")) {
                bean.setCommentField(meta.getEntry());
            }
            if (meta.getLabel().equals("MX_SURVEY_RELATIVE_WIDTH")) {
                bean.setRelativeWidth(Integer.valueOf(meta.getEntry()).intValue());
            }
            if (meta.getLabel().equals("PARTID")) {
                if (itemfacade.getData().getSection() == null) {
                    bean.setSelectedSection("0");
                    bean.setOrigSection("0");
                } else {
                    bean.setSelectedSection(itemfacade.getData().getSection().getSectionId().toString());
                    bean.setOrigSection(itemfacade.getData().getSection().getSectionId().toString());
                }
            }
            if (meta.getLabel().equals("POOLID")) {
                bean.setSelectedPool(meta.getEntry());
                bean.setOrigPool(meta.getEntry());
            }
            if (meta.getLabel().equals("TIMEALLOWED")) {
                bean.setTimeAllowed(meta.getEntry());
            }
            if (!meta.getLabel().equals("NUMATTEMPTS")) continue;
            bean.setNumAttempts(meta.getEntry());
        }
    }
}

