/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.CalendarServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class RemovePublishedAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(RemovePublishedAssessmentListener.class);
    private static final GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
    private CalendarServiceHelper calendarService = IntegrationContextFactory.getInstance().getCalendarServiceHelper();

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        PublishedAssessmentBean pulishedAssessment = (PublishedAssessmentBean)ContextUtil.lookupBean((String)"publishedassessment");
        String assessmentId = pulishedAssessment.getAssessmentId();
        if (assessmentId != null) {
            log.debug((Object)("assessmentId = " + assessmentId));
            PublishedAssessmentService assessmentService = new PublishedAssessmentService();
            PublishedAssessmentFacade assessment = assessmentService.getPublishedAssessment(assessmentId.toString());
            assessmentService.removeAssessment(assessmentId, "remove");
            this.removeFromGradebook(assessmentId);
            String calendarDueDateEventId = assessment.getAssessmentMetaDataByLabel("CALENDAR_DUE_DATE_EVENT_ID");
            if (calendarDueDateEventId != null) {
                this.calendarService.removeCalendarEvent(AgentFacade.getCurrentSiteId(), calendarDueDateEventId);
            }
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubAssessment.remove", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", publisedAssessmentId=" + assessmentId), (boolean)true));
            AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
            ArrayList publishedAssessmentList = author.getPublishedAssessments();
            ArrayList<PublishedAssessmentFacade> list = new ArrayList<PublishedAssessmentFacade>();
            for (int i = 0; i < publishedAssessmentList.size(); ++i) {
                PublishedAssessmentFacade pa = (PublishedAssessmentFacade)publishedAssessmentList.get(i);
                if (assessmentId.equals(pa.getPublishedAssessmentId().toString())) continue;
                list.add(pa);
            }
            author.setPublishedAssessments(list);
            ArrayList inactivePublishedAssessmentList = author.getInactivePublishedAssessments();
            ArrayList<PublishedAssessmentFacade> inactiveList = new ArrayList<PublishedAssessmentFacade>();
            for (int i = 0; i < inactivePublishedAssessmentList.size(); ++i) {
                PublishedAssessmentFacade pa = (PublishedAssessmentFacade)inactivePublishedAssessmentList.get(i);
                if (assessmentId.equals(pa.getPublishedAssessmentId().toString())) continue;
                inactiveList.add(pa);
            }
            author.setInactivePublishedAssessments(inactiveList);
            boolean isAnyAssessmentRetractForEdit = false;
            for (PublishedAssessmentFacade publishedAssessmentFacade : inactiveList) {
                if (!Integer.valueOf(3).equals(publishedAssessmentFacade.getStatus())) continue;
                isAnyAssessmentRetractForEdit = true;
                break;
            }
            if (isAnyAssessmentRetractForEdit) {
                author.setIsAnyAssessmentRetractForEdit(true);
            } else {
                author.setIsAnyAssessmentRetractForEdit(false);
            }
        } else {
            log.warn((Object)"Could not remove published assessment - assessment id is null");
        }
    }

    private void removeFromGradebook(String assessmentId) {
        GradebookService g = null;
        if (integrated) {
            g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
        }
        try {
            log.debug((Object)"before gbsHelper.removeGradebook()");
            gbsHelper.removeExternalAssessment(GradebookFacade.getGradebookUId(), assessmentId, g);
        }
        catch (Exception e1) {
            log.info((Object)("Exception thrown in updateGB():" + e1.getMessage()));
        }
    }
}

