/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class ReorderQuestionsListener
implements ValueChangeListener {
    private static Log log = LogFactory.getLog(ReorderQuestionsListener.class);

    public void processValueChange(ValueChangeEvent ae) throws AbortProcessingException {
        log.info((Object)"ReorderQuestionsListener valueChangeLISTENER.");
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        FacesContext context = FacesContext.getCurrentInstance();
        String oldPos = ae.getOldValue().toString();
        String newPos = ae.getNewValue().toString();
        String pulldownId = ae.getComponent().getClientId(context);
        String itemParam = pulldownId.replaceFirst("number", "currItemId");
        String itemId = ContextUtil.lookupParam((String)itemParam);
        if (itemId != null) {
            ItemService delegate = new ItemService();
            ItemFacade itemf = delegate.getItem(Long.valueOf(itemId), AgentFacade.getAgentString());
            SectionFacade sectFacade = (SectionFacade)itemf.getSection();
            this.reorderSequences(sectFacade, Integer.valueOf(oldPos), Integer.valueOf(newPos));
            AssessmentService assessdelegate = new AssessmentService();
            AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
            AssessmentFacade assessment = assessdelegate.getAssessment(assessmentBean.getAssessmentId());
            assessmentBean.setAssessment((AssessmentIfc)assessment);
            itemauthorbean.setOutcome("editAssessment");
        }
    }

    private void reorderSequences(SectionFacade sectfacade, Integer oldPos, Integer newPos) {
        ItemService delegate = new ItemService();
        Set itemset = sectfacade.getItemFacadeSet();
        for (ItemFacade itemfacade : itemset) {
            Integer itemfacadeseq = itemfacade.getSequence();
            if (oldPos.compareTo(newPos) < 0 && itemfacadeseq.compareTo(oldPos) > 0 && itemfacadeseq.compareTo(newPos) <= 0) {
                itemfacade.setSequence(Integer.valueOf(itemfacadeseq - 1));
                delegate.saveItem(itemfacade);
            }
            if (oldPos.compareTo(newPos) > 0 && itemfacadeseq.compareTo(newPos) >= 0 && itemfacadeseq.compareTo(oldPos) < 0) {
                itemfacade.setSequence(Integer.valueOf(itemfacadeseq + 1));
                delegate.saveItem(itemfacade);
            }
            if (itemfacadeseq.compareTo(oldPos) != 0) continue;
            itemfacade.setSequence(newPos);
            delegate.saveItem(itemfacade);
        }
    }
}

