/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class ResetAssessmentAttachmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ResetAssessmentAttachmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AssessmentService assessmentService = new AssessmentService();
        AssessmentSettingsBean assessmentSettingsBean = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
        String assessmentId = assessmentSettingsBean.getAssessmentId().toString();
        log.debug((Object)("***assessmentId=" + assessmentId));
        if (assessmentId != null && !"".equals(assessmentId)) {
            AssessmentFacade assessment = assessmentService.getAssessment(assessmentId);
            this.resetAssessmentAttachment(assessment.getAssessmentAttachmentList(), assessmentService);
        } else {
            this.resetAssessmentAttachment(new ArrayList(), assessmentService);
        }
    }

    public void resetAssessmentAttachment(List attachmentList, AssessmentService assessmentService) {
        if (attachmentList != null) {
            for (int i = 0; i < attachmentList.size(); ++i) {
                AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
                try {
                    ContentResource cr = AssessmentService.getContentHostingService().getResource(attach.getResourceId());
                    continue;
                }
                catch (PermissionException e) {
                    log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
                    continue;
                }
                catch (IdUnusedException e) {
                    log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
                    log.warn((Object)("***removing an empty assessment attachment association, attachmentId=" + attach.getAttachmentId()));
                    assessmentService.removeAssessmentAttachment(attach.getAttachmentId().toString());
                    continue;
                }
                catch (TypeException e) {
                    log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
                }
            }
        }
    }
}

