/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PublishedItemService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class ResetItemAttachmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ResetItemAttachmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        ItemService itemService = null;
        AssessmentService assessmentService = null;
        if (isEditPendingAssessmentFlow) {
            itemService = new ItemService();
            assessmentService = new AssessmentService();
        } else {
            itemService = new PublishedItemService();
            assessmentService = new PublishedAssessmentService();
        }
        ItemAuthorBean itemauthorBean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        String itemId = itemauthorBean.getItemId();
        if (itemId != null && !"".equals(itemId)) {
            ItemFacade item = itemService.getItem(itemId);
            log.debug((Object)("*** item attachment=" + item.getItemAttachmentList()));
            this.resetItemAttachment(itemauthorBean.getResourceHash(), item.getItemAttachmentList(), assessmentService);
        } else {
            this.resetItemAttachment(itemauthorBean.getResourceHash(), new ArrayList(), assessmentService);
        }
    }

    private void resetItemAttachment(HashMap resourceHash, List attachmentList, AssessmentService service) {
        if (attachmentList != null) {
            for (int i = 0; i < attachmentList.size(); ++i) {
                AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
                try {
                    ContentResource cr = AssessmentService.getContentHostingService().getResource(attach.getResourceId());
                    continue;
                }
                catch (PermissionException e) {
                    log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
                    continue;
                }
                catch (IdUnusedException e) {
                    log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
                    log.warn((Object)("***2.removing an empty item attachment association, attachmentId=" + attach.getAttachmentId()));
                    service.removeItemAttachment(attach.getAttachmentId().toString());
                    continue;
                }
                catch (TypeException e) {
                    log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
                }
            }
        }
    }
}

