/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.SectionBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class ResetPartAttachmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ResetPartAttachmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        SectionBean sectionBean = (SectionBean)ContextUtil.lookupBean((String)"sectionBean");
        Object assessmentService = null;
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        assessmentService = isEditPendingAssessmentFlow ? new AssessmentService() : new PublishedAssessmentService();
        String sectionId = sectionBean.getSectionId();
        if (sectionId != null && !"".equals(sectionId)) {
            SectionFacade section = assessmentService.getSection(sectionId);
            this.resetSectionAttachment(assessmentService, sectionBean.getResourceHash(), section.getSectionAttachmentList());
        } else {
            this.resetSectionAttachment(assessmentService, sectionBean.getResourceHash(), new ArrayList());
        }
    }

    private void resetSectionAttachment(AssessmentService assessmentService, HashMap resourceHash, List attachmentList) {
        if (attachmentList != null) {
            for (int i = 0; i < attachmentList.size(); ++i) {
                AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
                try {
                    ContentResource cr = AssessmentService.getContentHostingService().getResource(attach.getResourceId());
                    continue;
                }
                catch (PermissionException e) {
                    log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
                    continue;
                }
                catch (IdUnusedException e) {
                    log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
                    log.warn((Object)("***removing an empty section attachment association, attachmentId=" + attach.getAttachmentId()));
                    assessmentService.removeSectionAttachment(attach.getAttachmentId().toString());
                    continue;
                }
                catch (TypeException e) {
                    log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
                }
            }
        }
    }
}

