/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.SecuredIPAddress;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ResourceLoader;

public class SaveAssessmentSettings {
    private static Log log = LogFactory.getLog(SaveAssessmentSettings.class);

    public AssessmentFacade save(AssessmentSettingsBean assessmentSettings, boolean isFromConfirmPublishAssessmentListener) {
        AssessmentFacade assessment;
        AssessmentService assessmentService;
        Long assessmentId;
        block42: {
            AuthzQueriesFacadeAPI authz;
            block41: {
                String firstTargetSelected;
                assessmentId = assessmentSettings.getAssessmentId();
                ItemAuthorBean iAuthor = new ItemAuthorBean();
                iAuthor.setShowFeedbackAuthoring(assessmentSettings.getFeedbackAuthoring());
                assessmentService = new AssessmentService();
                assessment = assessmentService.getAssessment(assessmentId.toString());
                assessment.setTitle(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getTitle()));
                assessment.setDescription(assessmentSettings.getDescription());
                assessment.updateAssessmentMetaData("ASSESSMENT_AUTHORS", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getAuthors()));
                AssessmentAccessControl control = (AssessmentAccessControl)assessment.getAssessmentAccessControl();
                if (control == null) {
                    control = new AssessmentAccessControl();
                    control.setAssessmentBase(assessment.getData());
                }
                if (isFromConfirmPublishAssessmentListener) {
                    if (assessmentSettings.getStartDate() != null) {
                        control.setStartDate(assessmentSettings.getStartDate());
                    } else {
                        control.setStartDate(new Date());
                    }
                } else {
                    control.setStartDate(assessmentSettings.getStartDate());
                }
                control.setDueDate(assessmentSettings.getDueDate());
                control.setRetractDate(assessmentSettings.getRetractDate());
                control.setFeedbackDate(assessmentSettings.getFeedbackDate());
                control.setReleaseTo(assessmentSettings.getReleaseTo());
                control.setTimeLimit(assessmentSettings.getTimeLimit());
                if (assessmentSettings.getTimedAssessment()) {
                    control.setTimedAssessment(AssessmentAccessControl.TIMED_ASSESSMENT);
                } else {
                    control.setTimedAssessment(AssessmentAccessControl.DO_NOT_TIMED_ASSESSMENT);
                }
                if (assessmentSettings.getItemNavigation() != null) {
                    String nav = assessmentSettings.getItemNavigation();
                    if ("1".equals(nav)) {
                        assessmentSettings.setAssessmentFormat("1");
                    }
                    control.setItemNavigation(Integer.valueOf(nav));
                }
                if (assessmentSettings.getItemNumbering() != null) {
                    control.setItemNumbering(new Integer(assessmentSettings.getItemNumbering()));
                }
                if (assessmentSettings.getAssessmentFormat() != null) {
                    control.setAssessmentFormat(new Integer(assessmentSettings.getAssessmentFormat()));
                }
                if (assessmentSettings.getIsMarkForReview()) {
                    control.setMarkForReview(AssessmentAccessControl.MARK_FOR_REVIEW);
                } else {
                    control.setMarkForReview(AssessmentAccessControl.NOT_MARK_FOR_REVIEW);
                }
                if (assessmentSettings.getUnlimitedSubmissions() != null) {
                    if (!assessmentSettings.getUnlimitedSubmissions().equals(AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS.toString())) {
                        control.setUnlimitedSubmissions(Boolean.FALSE);
                        if (assessmentSettings.getSubmissionsAllowed() != null) {
                            control.setSubmissionsAllowed(new Integer(assessmentSettings.getSubmissionsAllowed()));
                        } else {
                            control.setSubmissionsAllowed(Integer.valueOf("1"));
                        }
                    } else {
                        control.setUnlimitedSubmissions(Boolean.TRUE);
                        control.setSubmissionsAllowed(null);
                    }
                }
                if (assessmentSettings.getLateHandling() != null) {
                    control.setLateHandling(new Integer(assessmentSettings.getLateHandling()));
                }
                if (assessmentSettings.getSubmissionsSaved() != null) {
                    control.setSubmissionsSaved(new Integer(assessmentSettings.getSubmissionsSaved()));
                }
                if (assessmentSettings.getAutoSubmit()) {
                    control.setAutoSubmit(AssessmentAccessControl.AUTO_SUBMIT);
                } else {
                    control.setAutoSubmit(AssessmentAccessControl.DO_NOT_AUTO_SUBMIT);
                }
                assessment.setAssessmentAccessControl((AssessmentAccessControlIfc)control);
                control.setSubmissionMessage(assessmentSettings.getSubmissionMessage());
                control.setUsername(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getUsername()));
                control.setPassword(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getPassword()));
                String finalPageUrl = "";
                if (assessmentSettings.getFinalPageUrl() != null && (finalPageUrl = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getFinalPageUrl().trim())).length() != 0 && !finalPageUrl.toLowerCase().startsWith("http")) {
                    finalPageUrl = "http://" + finalPageUrl;
                }
                control.setFinalPageUrl(finalPageUrl);
                AssessmentFeedback feedback = (AssessmentFeedback)assessment.getAssessmentFeedback();
                if (feedback == null) {
                    feedback = new AssessmentFeedback();
                    feedback.setAssessmentBase(assessment.getData());
                }
                if (assessmentSettings.getFeedbackDelivery() != null) {
                    feedback.setFeedbackDelivery(new Integer(assessmentSettings.getFeedbackDelivery()));
                }
                if (assessmentSettings.getFeedbackComponentOption() != null) {
                    feedback.setFeedbackComponentOption(new Integer(assessmentSettings.getFeedbackComponentOption()));
                }
                if (assessmentSettings.getFeedbackAuthoring() != null) {
                    feedback.setFeedbackAuthoring(new Integer(assessmentSettings.getFeedbackAuthoring()));
                }
                feedback.setShowQuestionText(Boolean.valueOf(assessmentSettings.getShowQuestionText()));
                feedback.setShowStudentResponse(Boolean.valueOf(assessmentSettings.getShowStudentResponse()));
                feedback.setShowCorrectResponse(Boolean.valueOf(assessmentSettings.getShowCorrectResponse()));
                feedback.setShowStudentScore(Boolean.valueOf(assessmentSettings.getShowStudentScore()));
                feedback.setShowStudentQuestionScore(Boolean.valueOf(assessmentSettings.getShowStudentQuestionScore()));
                feedback.setShowQuestionLevelFeedback(Boolean.valueOf(assessmentSettings.getShowQuestionLevelFeedback()));
                feedback.setShowSelectionLevelFeedback(Boolean.valueOf(assessmentSettings.getShowSelectionLevelFeedback()));
                feedback.setShowGraderComments(Boolean.valueOf(assessmentSettings.getShowGraderComments()));
                feedback.setShowStatistics(Boolean.valueOf(assessmentSettings.getShowStatistics()));
                assessment.setAssessmentFeedback((AssessmentFeedbackIfc)feedback);
                EvaluationModel evaluation = (EvaluationModel)assessment.getEvaluationModel();
                if (evaluation == null) {
                    evaluation = new EvaluationModel();
                    evaluation.setAssessmentBase(assessment.getData());
                }
                if ("Anonymous Users".equals(firstTargetSelected = assessmentSettings.getFirstTargetSelected())) {
                    evaluation.setAnonymousGrading(Integer.valueOf("1"));
                    evaluation.setToGradeBook("2");
                } else {
                    if (assessmentSettings.getAnonymousGrading() != null) {
                        evaluation.setAnonymousGrading(Integer.valueOf(assessmentSettings.getAnonymousGrading()));
                    }
                    if (assessmentSettings.getToDefaultGradebook() != null) {
                        evaluation.setToGradeBook(assessmentSettings.getToDefaultGradebook());
                    }
                }
                if (assessmentSettings.getScoringType() != null) {
                    evaluation.setScoringType(new Integer(assessmentSettings.getScoringType()));
                }
                assessment.setEvaluationModel((EvaluationModelIfc)evaluation);
                HashMap h = assessmentSettings.getValueMap();
                this.updateMetaWithValueMap((AssessmentIfc)assessment, h);
                assessment.updateAssessmentMetaData("ASSESSMENT_BGCOLOR", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getBgColor()));
                assessment.updateAssessmentMetaData("ASSESSMENT_BGIMAGE", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getBgImage()));
                assessment.updateAssessmentMetaData("ASSESSMENT_KEYWORDS", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getKeywords()));
                assessment.updateAssessmentMetaData("ASSESSMENT_OBJECTIVES", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getObjectives()));
                assessment.updateAssessmentMetaData("ASSESSMENT_RUBRICS", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getRubrics()));
                assessmentService.saveAssessment(assessment);
                assessmentService.deleteAllSecuredIP((AssessmentIfc)assessment);
                HashSet<SecuredIPAddress> ipSet = new HashSet<SecuredIPAddress>();
                String ipAddresses = assessmentSettings.getIpAddresses();
                if (ipAddresses == null) {
                    ipAddresses = "";
                }
                String[] ip = ipAddresses.split("\\n");
                for (int j = 0; j < ip.length; ++j) {
                    if (ip[j] == null || ip[j].equals("\r")) continue;
                    ipSet.add(new SecuredIPAddress(assessment.getData(), null, ip[j]));
                }
                assessment.setSecuredIPAddressSet(ipSet);
                SecureDeliveryServiceAPI secureDeliveryService = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
                assessment.updateAssessmentMetaData("SECURE_DELIVERY_MODULE_KEY", assessmentSettings.getSecureDeliveryModule());
                String encryptedPassword = secureDeliveryService.encryptPassword(assessmentSettings.getSecureDeliveryModule(), assessmentSettings.getSecureDeliveryModuleExitPassword());
                assessment.updateAssessmentMetaData("SECURE_DELIVERY_EXITPWD_KEY", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)encryptedPassword));
                String titleDecoration = assessment.getAssessmentMetaDataByLabel("SECURE_DELIVERY_TITLE_DECORATION");
                String newTitle = titleDecoration != null ? assessment.getTitle().replace(titleDecoration, "") : assessment.getTitle();
                titleDecoration = secureDeliveryService.getTitleDecoration(assessmentSettings.getSecureDeliveryModule(), new ResourceLoader().getLocale());
                if (titleDecoration != null && !titleDecoration.trim().equals("")) {
                    newTitle = newTitle + " " + titleDecoration;
                }
                assessment.setTitle(newTitle);
                assessment.updateAssessmentMetaData("SECURE_DELIVERY_TITLE_DECORATION", titleDecoration);
                assessmentService.saveAssessment(assessment);
                this.updateAttachment(assessment.getAssessmentAttachmentList(), assessmentSettings.getAttachmentList(), (AssessmentIfc)assessment.getData(), true);
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.setting.edit", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", assessmentId=" + assessmentSettings.getAssessmentId()), (boolean)true));
                authz = PersistenceService.getInstance().getAuthzQueriesFacade();
                if (!assessmentSettings.getReleaseTo().equals("Selected Groups")) break block41;
                authz.removeAuthorizationByQualifierAndFunction(assessmentId.toString(), "TAKE_ASSESSMENT");
                String[] groupsAuthorized = assessmentSettings.getGroupsAuthorizedToSave();
                if (groupsAuthorized == null || groupsAuthorized.length <= 0) break block42;
                for (int i = 0; i < groupsAuthorized.length; ++i) {
                    authz.createAuthorization(groupsAuthorized[i], "TAKE_ASSESSMENT", assessmentId.toString());
                }
                PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
                TreeMap groupsForSite = publishedAssessmentService.getGroupsForSite();
                if (groupsForSite == null || groupsForSite.size() <= 0) break block42;
                String releaseToGroups = this.getReleaseToGroupsAsString(groupsForSite, groupsAuthorized);
                assessmentSettings.setReleaseToGroupsAsString(releaseToGroups);
                break block42;
            }
            Collection groups = null;
            try {
                Site site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
                groups = site.getGroups();
            }
            catch (IdUnusedException ex) {
                // empty catch block
            }
            if (groups != null && groups.size() > 0) {
                for (Group group : groups) {
                    authz.removeAuthorizationByAgentQualifierAndFunction(group.getId(), assessmentId.toString(), "TAKE_ASSESSMENT");
                }
            }
        }
        assessment = assessmentService.getAssessment(assessmentId.toString());
        return assessment;
    }

    public void updateMetaWithValueMap(AssessmentIfc assessment, HashMap map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String label = (String)entry.getKey();
                String value = "";
                Object valueo = entry.getValue();
                if (valueo != null) {
                    value = valueo.toString();
                }
                assessment.updateAssessmentMetaData(label, value);
            }
        }
    }

    public boolean isIpValid(String ipString) {
        if (ipString.endsWith(".")) {
            return false;
        }
        String[] parts = ipString.split("\\.");
        int l = parts.length;
        if (l != 4) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            int num;
            String s = parts[i];
            if (s.trim().equals("")) {
                return false;
            }
            for (int index = 0; index < s.length(); ++index) {
                char c = s.charAt(index);
                if (Character.isDigit(c) || Character.toString(c).equals("*")) continue;
                return false;
            }
            if (s.length() > 1 && s.indexOf("*") != -1) {
                return false;
            }
            if ("*".equals(s) || (num = Integer.parseInt(s)) <= 255 && num >= 0) continue;
            return false;
        }
        return true;
    }

    public void updateAttachment(List oldList, List newList, AssessmentIfc assessment, boolean isAuthorSettings) {
        if (!(oldList != null && oldList.size() != 0 || newList != null && newList.size() != 0)) {
            return;
        }
        ArrayList<AssessmentAttachmentIfc> list = new ArrayList<AssessmentAttachmentIfc>();
        HashMap map = this.getAttachmentIdHash(oldList);
        for (int i = 0; i < newList.size(); ++i) {
            AssessmentAttachmentIfc a = (AssessmentAttachmentIfc)newList.get(i);
            if (map.get(a.getAttachmentId()) != null) {
                map.remove(a.getAttachmentId());
                continue;
            }
            a.setAssessment(assessment);
            list.add(a);
        }
        Object assessmentService = null;
        assessmentService = isAuthorSettings ? new AssessmentService() : new PublishedAssessmentService();
        assessmentService.saveOrUpdateAttachments(list);
        Set set = map.keySet();
        for (Long attachmentId : set) {
            assessmentService.removeAssessmentAttachment(attachmentId.toString());
        }
    }

    private HashMap getAttachmentIdHash(List list) {
        HashMap<Long, AssessmentAttachmentIfc> map = new HashMap<Long, AssessmentAttachmentIfc>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentAttachmentIfc a = (AssessmentAttachmentIfc)list.get(i);
            map.put(a.getAttachmentId(), a);
        }
        return map;
    }

    private String getReleaseToGroupsAsString(TreeMap groupsForSiteMap, String[] groupsAuthorized) {
        ArrayList releaseToGroups = new ArrayList();
        for (int i = 0; i < groupsAuthorized.length; ++i) {
            if (!groupsForSiteMap.containsKey(groupsAuthorized[i])) continue;
            releaseToGroups.add(groupsForSiteMap.get(groupsAuthorized[i]));
        }
        Collections.sort(releaseToGroups);
        StringBuffer releaseToGroupsAsString = new StringBuffer();
        if (releaseToGroups != null && releaseToGroups.size() != 0) {
            String lastGroup = (String)releaseToGroups.get(releaseToGroups.size() - 1);
            for (String group : releaseToGroups) {
                releaseToGroupsAsString.append(group);
                if (group.equals(lastGroup)) continue;
                releaseToGroupsAsString.append(", ");
            }
        }
        return releaseToGroupsAsString.toString();
    }
}

