/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.SectionBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class SavePartListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SavePartListener.class);
    private boolean isEditPendingAssessmentFlow;

    /*
     * Enabled aggressive block sorting
     */
    public void processAction(ActionEvent ae) throws AbortProcessingException {
        int success;
        FacesContext context = FacesContext.getCurrentInstance();
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        String assessmentId = assessmentBean.getAssessmentId();
        SectionBean sectionBean = (SectionBean)ContextUtil.lookupBean((String)"sectionBean");
        String title = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)sectionBean.getSectionTitle()).trim();
        if (title == null || title.equals("")) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"empty_part_title_error");
            context.addMessage(null, new FacesMessage(err));
            sectionBean.setOutcome("editPart");
            return;
        }
        String description = sectionBean.getSectionDescription();
        String sectionId = sectionBean.getSectionId();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        this.isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        AssessmentService assessmentService = null;
        SectionFacade section = null;
        if (this.isEditPendingAssessmentFlow) {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", sectionId=" + sectionId), (boolean)true));
            assessmentService = new AssessmentService();
        } else {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubassessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", sectionId=" + sectionId), (boolean)true));
            assessmentService = new PublishedAssessmentService();
        }
        boolean addItemsFromPool = false;
        sectionBean.setOutcome("editAssessment");
        if (sectionBean.getType().equals("2") && sectionBean.getSelectedPool().equals("")) {
            String selectedPool_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"selectedPool_error");
            context.addMessage(null, new FacesMessage(selectedPool_err));
            sectionBean.setOutcome("editPart");
            return;
        }
        if (this.isEditPendingAssessmentFlow && !"".equals(sectionBean.getType()) && SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString().equals(sectionBean.getType())) {
            addItemsFromPool = true;
            if (!this.validateItemsDrawn(sectionBean)) {
                sectionBean.setOutcome("editPart");
                return;
            }
            section = this.getOrAddSection(assessmentService, assessmentId, sectionId);
        } else {
            section = this.getOrAddSection(assessmentService, assessmentId, sectionId);
        }
        if (section == null) {
            log.info((Object)"section == null - Should not come to here. Simply return.");
            log.info((Object)("assessmentId =" + assessmentId));
            log.info((Object)("sectionId =" + sectionId));
            return;
        }
        log.debug((Object)("**** section title =" + section.getTitle()));
        log.debug((Object)("**** title =" + title));
        if (title != null) {
            section.setTitle(title);
        }
        section.setDescription(description);
        if (!"".equals(sectionBean.getQuestionOrdering())) {
            section.addSectionMetaData("QUESTIONS_ORDERING", sectionBean.getQuestionOrdering());
        }
        if (this.isEditPendingAssessmentFlow) {
            if (!"".equals(sectionBean.getKeyword())) {
                section.addSectionMetaData("SECTION_KEYWORDS", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)sectionBean.getKeyword()));
            }
            if (!"".equals(sectionBean.getObjective())) {
                section.addSectionMetaData("SECTION_OBJECTIVES", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)sectionBean.getObjective()));
            }
            if (!"".equals(sectionBean.getRubric())) {
                section.addSectionMetaData("SECTION_RUBRICS", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)sectionBean.getRubric()));
            }
            if (!"".equals(sectionBean.getType())) {
                section.addSectionMetaData("AUTHOR_TYPE", sectionBean.getType());
                if (SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString().equals(sectionBean.getType())) {
                    if (sectionBean.getNumberSelected() != null && !"".equals(sectionBean.getNumberSelected())) {
                        section.addSectionMetaData("NUM_QUESTIONS_DRAWN", sectionBean.getNumberSelected());
                    }
                    if (!"".equals(sectionBean.getSelectedPool())) {
                        section.addSectionMetaData("POOLID_FOR_RANDOM_DRAW", sectionBean.getSelectedPool());
                        String poolname = "";
                        QuestionPoolService qpservice = new QuestionPoolService();
                        QuestionPoolFacade poolfacade = qpservice.getPool(new Long(sectionBean.getSelectedPool()), AgentFacade.getAgentString());
                        if (poolfacade != null) {
                            poolname = poolfacade.getTitle();
                        }
                        section.addSectionMetaData("POOLNAME_FOR_RANDOM_DRAW", poolname);
                    }
                    section.addSectionMetaData("RANDOMIZATION_TYPE", sectionBean.getRandomizationType());
                }
            }
            if (addItemsFromPool) {
                boolean hasRandomPartScore = false;
                Float score = null;
                String requestedScore = sectionBean.getRandomPartScore();
                if (requestedScore != null && !requestedScore.equals("")) {
                    hasRandomPartScore = true;
                    score = new Float(requestedScore);
                }
                boolean hasRandomPartDiscount = false;
                Float discount = null;
                String requestedDiscount = sectionBean.getRandomPartDiscount();
                if (requestedDiscount != null && !requestedDiscount.equals("")) {
                    hasRandomPartDiscount = true;
                    discount = new Float(requestedDiscount);
                }
                if (hasRandomPartScore && score != null) {
                    section.addSectionMetaData("POINT_VALUE_FOR_QUESTION", score.toString());
                } else {
                    section.addSectionMetaData("POINT_VALUE_FOR_QUESTION", "");
                }
                if (hasRandomPartDiscount && discount != null) {
                    section.addSectionMetaData("DISCOUNT_VALUE_FOR_QUESTION", discount.toString());
                } else {
                    section.addSectionMetaData("DISCOUNT_VALUE_FOR_QUESTION", "");
                }
            }
        }
        assessmentService.saveOrUpdateSection(section);
        if (addItemsFromPool && (success = assessmentService.updateRandomPoolQuestions(assessmentService.getSection(section.getSectionId().toString()))) != 0 && success == 1) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"qdrawn_error");
            context.addMessage(null, new FacesMessage(err + " " + section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN")));
        }
        this.updateAttachment(section.getSectionAttachmentList(), sectionBean.getAttachmentList(), section.getData());
        AssessmentIfc assessment = assessmentService.getAssessment(Long.valueOf(assessmentBean.getAssessmentId()));
        assessmentBean.setAssessment(assessment);
        assessmentService.updateAssessmentLastModifiedInfo(assessment);
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.revise", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", sectionId=" + section.getSectionId()), (boolean)true));
    }

    public SectionFacade addPart(String assessmentId) {
        AssessmentService assessmentService = new AssessmentService();
        SectionFacade section = assessmentService.addSection(assessmentId);
        return section;
    }

    private SectionFacade getOrAddSection(AssessmentService assessmentService, String assessmentId, String sectionId) {
        SectionFacade section;
        if ("".equals(sectionId)) {
            section = assessmentService.addSection(assessmentId);
            sectionId = section.getSectionId().toString();
        } else {
            section = assessmentService.getSection(sectionId);
        }
        return section;
    }

    public boolean validateItemsDrawn(SectionBean sectionBean) {
        String randomDiscount;
        FacesContext context = FacesContext.getCurrentInstance();
        String numberDrawn = sectionBean.getNumberSelected();
        QuestionPoolService qpservice = new QuestionPoolService();
        ArrayList itemlist = qpservice.getAllItems(Long.valueOf(sectionBean.getSelectedPool()));
        int itemcount = itemlist.size();
        String itemcountString = " " + Integer.toString(itemcount);
        try {
            int numberDrawnInt = Integer.parseInt(numberDrawn);
            if (numberDrawnInt <= 0 || numberDrawnInt > itemcount) {
                String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"qdrawn_error");
                context.addMessage(null, new FacesMessage(err + itemcountString));
                return false;
            }
        }
        catch (NumberFormatException e) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"qdrawn_error");
            context.addMessage(null, new FacesMessage(err + itemcountString));
            return false;
        }
        String randomScore = sectionBean.getRandomPartScore();
        if (randomScore != null && !randomScore.equals("")) {
            try {
                float randomScoreFloat = Float.parseFloat(randomScore);
                if ((double)randomScoreFloat < 0.0) {
                    String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"qdrawn_pt_error");
                    context.addMessage(null, new FacesMessage(err));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"qdrawn_pt_error");
                context.addMessage(null, new FacesMessage(err));
                return false;
            }
        }
        if ((randomDiscount = sectionBean.getRandomPartDiscount()) != null && !randomDiscount.equals("")) {
            try {
                float randomDiscountFloat = Float.parseFloat(randomDiscount);
                if ((double)randomDiscountFloat < 0.0) {
                    String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"qdrawn_pt_error");
                    context.addMessage(null, new FacesMessage(err));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"qdrawn_pt_error");
                context.addMessage(null, new FacesMessage(err));
                return false;
            }
        }
        return true;
    }

    private void updateAttachment(List oldList, List newList, SectionDataIfc section) {
        if (!(oldList != null && oldList.size() != 0 || newList != null && newList.size() != 0)) {
            return;
        }
        ArrayList<SectionAttachmentIfc> list = new ArrayList<SectionAttachmentIfc>();
        HashMap map = this.getAttachmentIdHash(oldList);
        for (int i = 0; i < newList.size(); ++i) {
            SectionAttachmentIfc a = (SectionAttachmentIfc)newList.get(i);
            if (map.get(a.getAttachmentId()) != null) {
                map.remove(a.getAttachmentId());
                continue;
            }
            a.setSection(section);
            list.add(a);
        }
        Object assessmentService = null;
        assessmentService = this.isEditPendingAssessmentFlow ? new AssessmentService() : new PublishedAssessmentService();
        assessmentService.saveOrUpdateAttachments(list);
        Set set = map.keySet();
        for (Long attachmentId : set) {
            assessmentService.removeSectionAttachment(attachmentId.toString());
        }
    }

    private HashMap getAttachmentIdHash(List list) {
        HashMap<Long, SectionAttachmentIfc> map = new HashMap<Long, SectionAttachmentIfc>();
        for (int i = 0; i < list.size(); ++i) {
            SectionAttachmentIfc a = (SectionAttachmentIfc)list.get(i);
            map.put(a.getAttachmentId(), a);
        }
        return map;
    }
}

