/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class SortCoreAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SortCoreAssessmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AssessmentService assessmentService = new AssessmentService();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        this.processSortInfo(author);
        ArrayList assessmentList = new ArrayList();
        assessmentList = assessmentService.getBasicInfoOfAllActiveAssessments(this.getCoreOrderBy(author), author.isCoreAscending());
        for (AssessmentFacade assessmentFacade : assessmentList) {
            assessmentFacade.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessmentFacade.getTitle()));
        }
        author.setAssessments(assessmentList);
        author.setJustPublishedAnAssessment(false);
    }

    private String getCoreOrderBy(AuthorBean author) {
        return "title";
    }

    private void processSortInfo(AuthorBean bean) {
        String coreOrder = ContextUtil.lookupParam((String)"coreSortType");
        String coreAscending = ContextUtil.lookupParam((String)"coreAscending");
        if (coreOrder != null && !coreOrder.trim().equals("")) {
            bean.setCoreAssessmentOrderBy(coreOrder);
        }
        if (coreAscending != null && !coreAscending.trim().equals("")) {
            try {
                bean.setCoreAscending(Boolean.valueOf(coreAscending).booleanValue());
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
            }
        } else {
            bean.setCoreAscending(true);
        }
    }
}

