/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemBean;
import org.sakaiproject.tool.assessment.ui.bean.author.MatchItemBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.SessionManager;

public class StartCreateItemListener
implements ValueChangeListener,
ActionListener {
    private static Log log = LogFactory.getLog(StartCreateItemListener.class);
    String currsection = null;

    public void processValueChange(ValueChangeEvent ae) throws AbortProcessingException {
        log.debug((Object)"StartCreateItemListener valueChangeLISTENER.");
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        String selectedvalue = (String)ae.getNewValue();
        if (selectedvalue != null && !selectedvalue.equals("")) {
            itemauthorbean.setItemType(selectedvalue);
            boolean update = false;
            String curritemid = null;
            ItemBean curritem = itemauthorbean.getCurrentItem();
            if (curritem != null) {
                curritemid = curritem.getItemId();
                this.currsection = curritem.getSelectedSection();
                update = true;
                log.debug((Object)"change question type , itemid is not null");
            } else {
                log.debug((Object)"didn't change question type, itemid is null");
            }
            if (!this.startCreateItem(itemauthorbean)) {
                throw new RuntimeException("failed to startCreatItem.");
            }
            if (update) {
                itemauthorbean.getCurrentItem().setItemId(curritemid);
            }
        }
    }

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"StartCreateItemListener actionLISTENER.");
        ItemAuthorBean itemauthorbean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        if (!this.startCreateItem(itemauthorbean)) {
            throw new RuntimeException("failed to startCreatItem.");
        }
    }

    public boolean startCreateItem(ItemAuthorBean itemauthorbean) {
        String nextpage = null;
        ItemBean item = new ItemBean();
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        try {
            itemauthorbean.setCurrentItem(item);
            item.setItemType(itemauthorbean.getItemType());
            itemauthorbean.setItemType("");
            itemauthorbean.setItemTypeString("");
            itemauthorbean.setAttachmentList(null);
            itemauthorbean.setResourceHash(null);
            int itype = 0;
            log.debug((Object)("item.getItemType() = " + item.getItemType()));
            if (item.getItemType() != null && !"".equals(item.getItemType())) {
                log.debug((Object)("item.getItemType() integer = " + item.getItemType()));
                itype = new Integer(item.getItemType());
            } else if ("".equals(item.getItemType())) {
                log.debug((Object)("item.getItemType() , use default type 1 = " + item.getItemType()));
                itype = 1;
            }
            log.debug((Object)"after getting item.getItemType() ");
            switch (itype) {
                case 1: {
                    nextpage = "multipleChoiceItem";
                    break;
                }
                case 2: {
                    nextpage = "multipleChoiceItem";
                    break;
                }
                case 12: {
                    nextpage = "multipleChoiceItem";
                    break;
                }
                case 3: {
                    nextpage = "surveyItem";
                    break;
                }
                case 4: {
                    nextpage = "trueFalseItem";
                    break;
                }
                case 5: {
                    nextpage = "shortAnswerItem";
                    break;
                }
                case 6: {
                    nextpage = "fileUploadItem";
                    break;
                }
                case 7: {
                    nextpage = "audioRecItem";
                    break;
                }
                case 8: {
                    nextpage = "fillInBlackItem";
                    break;
                }
                case 11: {
                    nextpage = "fillInNumericItem";
                    break;
                }
                case 13: {
                    nextpage = "matrixChoicesSurveyItem";
                    break;
                }
                case 9: {
                    MatchItemBean matchitem = new MatchItemBean();
                    item.setCurrentMatchPair(matchitem);
                    item.setMatchItemBeanList(new ArrayList());
                    nextpage = "matchingItem";
                    break;
                }
                case 10: {
                    QuestionPoolBean qpoolBean = (QuestionPoolBean)ContextUtil.lookupBean((String)"questionpool");
                    qpoolBean.setImportToAuthoring(true);
                    nextpage = "poolList";
                    break;
                }
                case 100: {
                    ToolSession currentToolSession = SessionManager.getCurrentToolSession();
                    currentToolSession.setAttribute("QB_insert_possition", (Object)itemauthorbean.getInsertPosition());
                    currentToolSession.setAttribute("QB_assessemnt_id", (Object)assessmentBean.getAssessmentId());
                    currentToolSession.setAttribute("QB_assessemnt_sections", (Object)itemauthorbean.getSectionList());
                    currentToolSession.setAttribute("QB_insert_section", (Object)itemauthorbean.getInsertToSection());
                    nextpage = "searchQuestionBank";
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        if ("assessment".equals(itemauthorbean.getTarget())) {
            AssessmentService assessdelegate = new AssessmentService();
            AssessmentFacade assessment = assessdelegate.getAssessment(assessmentBean.getAssessmentId());
            itemauthorbean.setShowMetadata(assessment.getHasMetaDataForQuestions());
            itemauthorbean.setShowFeedbackAuthoring(assessment.getShowFeedbackAuthoring());
            if (itemauthorbean.getInsertToSection() != null) {
                String sectionid = assessment.getSection(new Long(itemauthorbean.getInsertToSection())).getSectionId().toString();
                item.setSelectedSection(sectionid);
            } else {
                item.setSelectedSection(this.currsection);
            }
        } else {
            itemauthorbean.setShowMetadata("true");
        }
        itemauthorbean.setOutcome(nextpage);
        return true;
    }
}

