/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentTemplateData;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentTemplateIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.IndexBean;
import org.sakaiproject.tool.assessment.ui.bean.author.TemplateBean;
import org.sakaiproject.tool.assessment.ui.listener.author.TemplateBaseListener;
import org.sakaiproject.tool.assessment.ui.listener.author.TemplateListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class TemplateUpdateListener
extends TemplateBaseListener
implements ActionListener {
    private static Log log = LogFactory.getLog(TemplateUpdateListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        TemplateBean templateBean = this.lookupTemplateBean(context);
        IndexBean templateIndex = (IndexBean)ContextUtil.lookupBean((String)"templateIndex");
        String tempName = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)templateBean.getTemplateName());
        AssessmentService assessmentService = new AssessmentService();
        boolean isUnique = assessmentService.assessmentTitleIsUnique(templateBean.getIdString(), tempName, true);
        if (tempName != null && tempName.trim().equals("")) {
            String err1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.TemplateMessages", (String)"templateName_empty");
            context.addMessage(null, new FacesMessage(err1));
            templateIndex.setOutcome("editTemplate");
            return;
        }
        if (!isUnique) {
            String error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.TemplateMessages", (String)"duplicateName_error");
            context.addMessage(null, new FacesMessage(error));
            templateIndex.setOutcome("editTemplate");
            return;
        }
        if (templateBean.getValueMap().get("submissionModel_isInstructorEditable") != null && ((Boolean)templateBean.getValueMap().get("submissionModel_isInstructorEditable")).booleanValue() && templateBean.getSubmissionModel().equals(AssessmentAccessControlIfc.LIMITED_SUBMISSIONS.toString())) {
            try {
                String submissionsAllowed = templateBean.getSubmissionNumber().trim();
                int submissionAllowed = Integer.parseInt(submissionsAllowed);
                if (submissionAllowed < 1) {
                    throw new RuntimeException();
                }
            }
            catch (RuntimeException e) {
                String error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.TemplateMessages", (String)"submissions_allowed_error");
                context.addMessage(null, new FacesMessage(error));
                templateIndex.setOutcome("editTemplate");
                return;
            }
        }
        templateBean.setTemplateName(tempName);
        this.updateAssessment(templateBean);
        TemplateListener lis = new TemplateListener();
        lis.processAction(null);
        templateBean.setNewName(null);
        templateIndex.setOutcome("template");
    }

    public boolean updateAssessment(TemplateBean templateBean) {
        try {
            AssessmentFeedback feedback;
            AssessmentAccessControl aac;
            String templateIdString = templateBean.getIdString();
            AssessmentService delegate = new AssessmentService();
            AssessmentTemplateData template = null;
            if ("0".equals(templateIdString)) {
                template = new AssessmentTemplateData();
                template.setAssessmentBaseId(Long.valueOf(0L));
                aac = new AssessmentAccessControl();
                template.setAssessmentAccessControl((AssessmentAccessControlIfc)aac);
                aac.setAssessmentBase((AssessmentBaseIfc)template);
                EvaluationModel em = new EvaluationModel();
                template.setEvaluationModel((EvaluationModelIfc)em);
                em.setAssessmentBase((AssessmentBaseIfc)template);
                feedback = new AssessmentFeedback();
                template.setAssessmentFeedback((AssessmentFeedbackIfc)feedback);
                feedback.setAssessmentBase((AssessmentBaseIfc)template);
                template.setTypeId(TypeFacade.TEMPLATE_HOMEWORK);
                template.setStatus(AssessmentTemplateIfc.ACTIVE_STATUS);
                template.setParentId(Long.valueOf(0L));
                template.setComments("comments");
                template.setInstructorNotification(Integer.valueOf(1));
                template.setTesteeNotification(Integer.valueOf(1));
                template.setMultipartAllowed(Integer.valueOf(1));
            } else {
                template = delegate.getAssessmentTemplate(templateIdString).getData();
            }
            template.setTitle(templateBean.getTemplateName());
            if (templateBean.getTemplateAuthor() != null) {
                templateBean.getValueMap().put("author", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)templateBean.getTemplateAuthor()));
            }
            template.setDescription(templateBean.getTemplateDescription());
            aac = template.getAssessmentAccessControl();
            if (aac == null) {
                aac = new AssessmentAccessControl();
                template.setAssessmentAccessControl((AssessmentAccessControlIfc)aac);
                aac.setAssessmentBase((AssessmentBaseIfc)template);
            }
            aac.setItemNavigation(Integer.valueOf(templateBean.getItemAccessType()));
            aac.setAssessmentFormat(Integer.valueOf(templateBean.getDisplayChunking()));
            aac.setItemNumbering(Integer.valueOf(templateBean.getQuestionNumbering()));
            if (templateBean.getMarkForReview() != null && templateBean.getMarkForReview().equals(Boolean.TRUE)) {
                aac.setMarkForReview(Integer.valueOf(1));
            } else {
                aac.setMarkForReview(Integer.valueOf(0));
            }
            aac.setSubmissionsSaved(Integer.valueOf(templateBean.getSubmissionModel()));
            if (templateBean.getValueMap().get("submissionModel_isInstructorEditable") != null && ((Boolean)templateBean.getValueMap().get("submissionModel_isInstructorEditable")).booleanValue()) {
                if (templateBean.getSubmissionModel().equals(AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS.toString())) {
                    aac.setSubmissionsAllowed(null);
                    aac.setUnlimitedSubmissions(Boolean.TRUE);
                } else {
                    aac.setSubmissionsAllowed(Integer.valueOf(templateBean.getSubmissionNumber()));
                    aac.setUnlimitedSubmissions(Boolean.FALSE);
                }
            } else {
                aac.setSubmissionsAllowed(null);
                aac.setUnlimitedSubmissions(Boolean.TRUE);
            }
            aac.setLateHandling(Integer.valueOf(templateBean.getLateHandling()));
            if (templateBean.getValueMap().get("automaticSubmission_isInstructorEditable") == null) {
                templateBean.setValue("automaticSubmission_isInstructorEditable", (Object)"false");
            }
            if (templateBean.getAutomaticSubmission().booleanValue()) {
                aac.setAutoSubmit(Integer.valueOf("1"));
            } else {
                aac.setAutoSubmit(Integer.valueOf("0"));
            }
            EvaluationModelIfc model = template.getEvaluationModel();
            if (model == null) {
                model = new EvaluationModel();
                model.setAssessmentBase((AssessmentBaseIfc)template);
                template.setEvaluationModel(model);
            }
            model.setAssessmentBase((AssessmentBaseIfc)template);
            model.setAnonymousGrading(Integer.valueOf(templateBean.getAnonymousGrading()));
            model.setToGradeBook(templateBean.getToGradebook());
            model.setScoringType(Integer.valueOf(templateBean.getRecordedScore()));
            feedback = template.getAssessmentFeedback();
            if (feedback == null) {
                feedback = new AssessmentFeedback();
                feedback.setAssessmentBase((AssessmentBaseIfc)template);
                template.setAssessmentFeedback((AssessmentFeedbackIfc)feedback);
            }
            feedback.setFeedbackDelivery(Integer.valueOf(templateBean.getFeedbackType()));
            feedback.setFeedbackAuthoring(Integer.valueOf(templateBean.getFeedbackAuthoring()));
            Boolean canEditFeedbackComponent = (Boolean)templateBean.getValue("feedbackComponents_isInstructorEditable");
            if (canEditFeedbackComponent.booleanValue()) {
                feedback.setEditComponents(Integer.valueOf("1"));
            } else {
                feedback.setEditComponents(Integer.valueOf("0"));
            }
            feedback.setShowQuestionText(templateBean.getFeedbackComponent_QuestionText());
            feedback.setShowStudentResponse(templateBean.getFeedbackComponent_StudentResp());
            feedback.setShowCorrectResponse(templateBean.getFeedbackComponent_CorrectResp());
            feedback.setShowStudentScore(templateBean.getFeedbackComponent_StudentScore());
            feedback.setShowStudentQuestionScore(templateBean.getFeedbackComponent_StudentQuestionScore());
            feedback.setShowQuestionLevelFeedback(templateBean.getFeedbackComponent_QuestionLevel());
            feedback.setShowSelectionLevelFeedback(templateBean.getFeedbackComponent_SelectionLevel());
            feedback.setShowGraderComments(templateBean.getFeedbackComponent_GraderComments());
            feedback.setShowStatistics(templateBean.getFeedbackComponent_Statistics());
            if ("0".equals(templateIdString)) {
                template.setCreatedBy(AgentFacade.getAgentString());
                template.setCreatedDate(new Date());
            } else {
                template.setCreatedBy(ContextUtil.lookupParam((String)"createdBy"));
                SimpleDateFormat format = new SimpleDateFormat();
                template.setCreatedDate(format.parse(ContextUtil.lookupParam((String)"createdDate")));
            }
            template.setLastModifiedBy(AgentFacade.getAgentString());
            template.setLastModifiedDate(new Date());
            delegate.save(template);
            delegate.deleteAllMetaData((AssessmentBaseIfc)template);
            log.debug((Object)"**** after deletion of meta data");
            HashSet<AssessmentMetaData> set = new HashSet<AssessmentMetaData>();
            for (String label : templateBean.getValueMap().keySet()) {
                String value = templateBean.getValueMap().get(label).toString();
                AssessmentMetaData data = new AssessmentMetaData((AssessmentBaseIfc)template, label, value);
                set.add(data);
            }
            template.setAssessmentMetaDataSet(set);
            delegate.save(template);
        }
        catch (RuntimeException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

