/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.delivery;

import java.util.Date;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedFeedback;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.FeedbackComponent;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SettingsDeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.author.RemovePublishedAssessmentThread;
import org.sakaiproject.tool.assessment.ui.listener.delivery.ResetDeliveryListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class BeginDeliveryActionListener
implements ActionListener {
    private static Log log = LogFactory.getLog(BeginDeliveryActionListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"BeginDeliveryActionListener.processAction() ");
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        log.debug((Object)("****DeliveryBean= " + delivery));
        String actionString = ContextUtil.lookupParam((String)"actionString");
        if (actionString != null && !actionString.trim().equals("")) {
            delivery.setActionString(actionString);
        }
        delivery.setDisplayFormat();
        if ("previewAssessment".equals(delivery.getActionString()) || "editAssessment".equals(actionString)) {
            String isFromPrint = ContextUtil.lookupParam((String)"isFromPrint");
            if (isFromPrint != null && !isFromPrint.trim().equals("")) {
                delivery.setIsFromPrint(Boolean.parseBoolean(isFromPrint));
            }
        } else {
            delivery.setIsFromPrint(false);
        }
        int action = delivery.getActionMode();
        PublishedAssessmentFacade pub = this.getPublishedAssessmentBasedOnAction(action, delivery);
        if (pub == null) {
            delivery.setOutcome("poolUpdateError");
            throw new AbortProcessingException("pub is null");
        }
        if (3 == action && AssessmentIfc.RETRACT_FOR_EDIT_STATUS.equals(pub.getStatus())) {
            delivery.setAssessmentTitle(pub.getTitle());
            delivery.setOutcome("isRetractedForEdit2");
            return;
        }
        ResetDeliveryListener reset = new ResetDeliveryListener();
        reset.processAction(null);
        delivery.setBeginAssessment(true);
        delivery.setTimeStamp(new Date().getTime());
        delivery.setRedrawAnchorName("");
        delivery.setProtocol(ContextUtil.getProtocol());
        String paramValue = ServerConfigurationService.getString((String)"samigo.sizeMax");
        Long sizeMax = null;
        float sizeMax_float = 0.0f;
        if (paramValue != null) {
            sizeMax = Long.parseLong(paramValue);
            sizeMax_float = sizeMax.floatValue() / 1024.0f;
        }
        delivery.setFileUploadSizeMax(Math.round(sizeMax_float));
        delivery.setPublishedAssessment(pub);
        this.populateBeanFromPub(delivery, pub);
    }

    private PublishedAssessmentFacade lookupPublishedAssessment(String id, PublishedAssessmentService publishedAssessmentService) {
        PublishedAssessmentService assessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade pub = assessmentService.getPublishedAssessment(id);
        if (pub.getAssessmentFeedback() == null) {
            pub.setAssessmentFeedback((AssessmentFeedbackIfc)new PublishedFeedback());
        }
        return pub;
    }

    public void populateBeanFromPub(DeliveryBean delivery, PublishedAssessmentFacade pubAssessment) {
        AssessmentAccessControlIfc control = pubAssessment.getAssessmentAccessControl();
        this.populateDelivery(delivery, (PublishedAssessmentIfc)pubAssessment);
        SettingsDeliveryBean settings = this.populateSettings((PublishedAssessmentIfc)pubAssessment);
        delivery.setSettings(settings);
        FeedbackComponent component = this.populateFeedbackComponent(pubAssessment);
        delivery.setFeedbackComponent(component);
        if (pubAssessment.getFeedbackComponentOption() != null) {
            delivery.setFeedbackComponentOption(pubAssessment.getFeedbackComponentOption().toString());
        } else {
            delivery.setFeedbackComponentOption("1");
        }
        Date currentDate = new Date();
        if (component.getShowDateFeedback() && control.getFeedbackDate() != null && currentDate.after(control.getFeedbackDate())) {
            delivery.setFeedbackOnDate(true);
        }
        EvaluationModelIfc eval = pubAssessment.getEvaluationModel();
        delivery.setScoringType(eval.getScoringType());
        delivery.setAttachmentList(pubAssessment.getAssessmentAttachmentList());
    }

    private FeedbackComponent populateFeedbackComponent(PublishedAssessmentFacade pubAssessment) {
        FeedbackComponent component = new FeedbackComponent();
        AssessmentFeedbackIfc info = pubAssessment.getAssessmentFeedback();
        if (info != null) {
            component.setAssessmentFeedback(info);
        }
        return component;
    }

    private SettingsDeliveryBean populateSettings(PublishedAssessmentIfc pubAssessment) {
        SettingsDeliveryBean settings = new SettingsDeliveryBean();
        settings.setAssessmentAccessControl(pubAssessment);
        return settings;
    }

    private void populateDelivery(DeliveryBean delivery, PublishedAssessmentIfc pubAssessment) {
        Long publishedAssessmentId = pubAssessment.getPublishedAssessmentId();
        AssessmentAccessControlIfc control = pubAssessment.getAssessmentAccessControl();
        PublishedAssessmentService service = new PublishedAssessmentService();
        delivery.setAssessmentId(pubAssessment.getPublishedAssessmentId().toString());
        delivery.setAssessmentTitle(pubAssessment.getTitle());
        String instructorMessage = pubAssessment.getDescription();
        delivery.setInstructorMessage(instructorMessage);
        String ownerSiteId = service.getPublishedAssessmentOwner(pubAssessment.getPublishedAssessmentId());
        String ownerSiteName = AgentFacade.getSiteName((String)ownerSiteId);
        delivery.setCourseName(ownerSiteName);
        delivery.setCreatorName(AgentFacade.getDisplayNameByAgentId((String)pubAssessment.getCreatedBy()));
        delivery.setInstructorName(AgentFacade.getDisplayNameByAgentId((String)pubAssessment.getCreatedBy()));
        delivery.setSubmitted(false);
        delivery.setGraded(false);
        delivery.setPartIndex(0);
        delivery.setQuestionIndex(0);
        delivery.setBeginTime(null);
        delivery.setFeedbackOnDate(false);
        delivery.setDueDate(control.getDueDate());
        delivery.setRetractDate(control.getRetractDate());
        if (control.getMarkForReview() != null && Integer.valueOf(1).equals(control.getMarkForReview())) {
            delivery.setDisplayMardForReview(true);
        } else {
            delivery.setDisplayMardForReview(false);
        }
        int totalSubmissions = service.getTotalSubmission(AgentFacade.getAgentString(), publishedAssessmentId.toString());
        delivery.setTotalSubmissions(totalSubmissions);
        if (!Boolean.TRUE.equals(control.getUnlimitedSubmissions())) {
            int submissionsRemaining = control.getSubmissionsAllowed() - totalSubmissions;
            if (submissionsRemaining < 1) {
                submissionsRemaining = 1;
            }
            delivery.setSubmissionsRemaining(submissionsRemaining);
        }
        if (control.getItemNavigation() == null) {
            delivery.setNavigation(AssessmentAccessControl.RANDOM_ACCESS.toString());
        } else {
            delivery.setNavigation(control.getItemNavigation().toString());
        }
        this.setTimedAssessment(delivery, pubAssessment);
    }

    private void setTimedAssessment(DeliveryBean delivery, PublishedAssessmentIfc pubAssessment) {
        AssessmentAccessControlIfc control = pubAssessment.getAssessmentAccessControl();
        String hasTimeLimit = pubAssessment.getAssessmentMetaDataByLabel("hasTimeAssessment");
        if (hasTimeLimit != null && hasTimeLimit.equals("true")) {
            delivery.setHasTimeLimit(true);
            delivery.setTimerId(new Date().getTime() + "");
            try {
                if (control.getTimeLimit() != null) {
                    delivery.setTimeLimit(delivery.updateTimeLimit(control.getTimeLimit().toString()));
                    int seconds = control.getTimeLimit();
                    int hour = 0;
                    int minute = 0;
                    if (seconds >= 3600) {
                        hour = Math.abs(seconds / 3600);
                        minute = Math.abs((seconds - hour * 3600) / 60);
                    } else {
                        minute = Math.abs(seconds / 60);
                    }
                    delivery.setTimeLimit_hour(hour);
                    delivery.setTimeLimit_minute(minute);
                }
            }
            catch (RuntimeException e) {
                delivery.setTimeLimit("");
            }
        } else {
            delivery.setHasTimeLimit(false);
            delivery.setTimerId(null);
            delivery.setTimeLimit("0");
        }
    }

    private PublishedAssessmentFacade getPublishedAssessmentBasedOnAction(int action, DeliveryBean delivery) {
        AssessmentService assessmentService = new AssessmentService();
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade pub = null;
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        String assessmentId = ContextUtil.lookupParam((String)"assessmentId");
        if (assessmentId == null || "".equals(assessmentId)) {
            assessmentId = delivery.getAssessmentId();
        }
        switch (action) {
            case 2: {
                AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
                if (author.getIsEditPendingAssessmentFlow()) {
                    int success = this.updateQuestionPoolQuestions(assessmentId, assessmentService);
                    if (success == 0) {
                        AssessmentFacade assessment = assessmentService.getAssessment(assessmentId);
                        try {
                            PublishedAssessmentFacade tempPub = publishedAssessmentService.publishPreviewAssessment(assessment);
                            publishedId = tempPub.getPublishedAssessmentId().toString();
                            pub = tempPub.clonePublishedAssessment();
                            List resourceIdList = assessmentService.getAssessmentResourceIdList((AssessmentIfc)pub);
                            PersonBean personBean = (PersonBean)ContextUtil.lookupBean((String)"person");
                            personBean.setResourceIdListInPreview(resourceIdList);
                            RemovePublishedAssessmentThread thread = new RemovePublishedAssessmentThread(publishedId, "preview");
                            thread.start();
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                            e.printStackTrace();
                        }
                        break;
                    }
                    FacesContext context = FacesContext.getCurrentInstance();
                    if (success == 1) {
                        String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_size_too_large");
                        context.addMessage(null, new FacesMessage(err));
                    } else {
                        String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_unknown");
                        context.addMessage(null, new FacesMessage(err));
                    }
                    return null;
                }
                pub = publishedAssessmentService.getPublishedAssessment(assessmentId);
                break;
            }
            case 5: {
                pub = delivery.getPublishedAssessment();
                if (pub != null) break;
                throw new AbortProcessingException("taking: publishedAsessmentId null or blank");
            }
            case 1: 
            case 3: {
                pub = this.lookupPublishedAssessment(publishedId, publishedAssessmentService);
                break;
            }
        }
        return pub;
    }

    private int updateQuestionPoolQuestions(String assessmentId, AssessmentService assessmentService) {
        AssessmentBean assessmentBean;
        String fromEditStr;
        int success = assessmentService.updateAllRandomPoolQuestions(assessmentService.getAssessment(assessmentId));
        if (success == 0 && (fromEditStr = ContextUtil.lookupParam((String)"fromEdit")) != null && "true".equals(fromEditStr) && (assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean")) != null && assessmentBean.getSections() != null) {
            for (int i = 0; i < assessmentBean.getSections().size(); ++i) {
                SectionContentsBean sectionBean = (SectionContentsBean)assessmentBean.getSections().get(i);
                if (sectionBean.getSectionAuthorTypeString() == null || !sectionBean.getSectionAuthorTypeString().equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) continue;
                assessmentBean.getSections().set(i, new SectionContentsBean((SectionDataIfc)assessmentService.getSection(sectionBean.getSectionId().toString())));
            }
        }
        return success;
    }
}

