/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.delivery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ContentsDeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.FeedbackComponent;
import org.sakaiproject.tool.assessment.ui.bean.delivery.FibBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.FinBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.MatchingBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.MatrixSurveyBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SelectionBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.StudentScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.delivery.BeginDeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.ui.model.delivery.TimedAssessmentGradingModel;
import org.sakaiproject.tool.assessment.ui.queue.delivery.TimedAssessmentQueue;
import org.sakaiproject.tool.assessment.ui.web.session.SessionUtil;
import org.sakaiproject.tool.assessment.util.FormatException;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeliveryActionListener
implements ActionListener {
    static String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static Log log = LogFactory.getLog(DeliveryActionListener.class);
    private boolean resetPageContents = true;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"DeliveryActionListener.processAction() ");
        PersonBean person = (PersonBean)ContextUtil.lookupBean((String)"person");
        log.debug((Object)("**** MacNetscape=" + person.getIsMacNetscapeBrowser()));
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        String id = this.getPublishedAssessmentId(delivery);
        String agent = this.getAgentString();
        PublishedAssessmentFacade publishedAssessment = this.getPublishedAssessment(delivery, id);
        int action = delivery.getActionMode();
        if (3 == action && AssessmentIfc.RETRACT_FOR_EDIT_STATUS.equals(publishedAssessment.getStatus())) {
            return;
        }
        this.clearElapsedTime(delivery);
        this.setShowStudentScore(delivery, publishedAssessment);
        this.setShowStudentQuestionScore(delivery, publishedAssessment);
        this.setDeliverySettings(delivery, publishedAssessment);
        if (ae != null && ae.getComponent().getId().startsWith("beginAssessment")) {
            if (!delivery.getNavigation().equals("1")) {
                log.debug((Object)"From Begin Assessment button clicks");
                delivery.setPartIndex(0);
                delivery.setQuestionIndex(0);
            }
            delivery.setNoQuestions(false);
        } else if (!delivery.getFromTableOfContents()) {
            this.goToRightQuestionFromTOC(delivery);
        } else {
            delivery.setFromTableOfContents(false);
        }
        HashMap itemGradingHash = new HashMap();
        GradingService service = new GradingService();
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        AssessmentGradingData ag = null;
        boolean isFirstTimeBegin = false;
        switch (action) {
            case 2: {
                this.setFeedbackMode(delivery);
                break;
            }
            case 3: {
                String moduleId;
                this.setFeedbackMode(delivery);
                Integer scoringoption = publishedAssessment.getEvaluationModel().getScoringType();
                String assessmentGradingId = ContextUtil.lookupParam((String)"assessmentGradingId");
                if ("true".equals(delivery.getFeedback())) {
                    itemGradingHash = new HashMap();
                    if (delivery.getFeedbackComponent().getShowResponse() || delivery.getFeedbackComponent().getShowStudentQuestionScore()) {
                        itemGradingHash = service.getSubmitData(id, agent, scoringoption, assessmentGradingId);
                    }
                    ag = this.setAssessmentGradingFromItemData(delivery, itemGradingHash, false);
                    delivery.setAssessmentGrading(ag);
                }
                this.setDisplayByAssessment(delivery);
                FeedbackComponent component = new FeedbackComponent();
                AssessmentFeedbackIfc info = publishedAssessment.getAssessmentFeedback();
                if (info != null) {
                    component.setAssessmentFeedback(info);
                }
                delivery.setFeedbackComponent(component);
                AssessmentGradingData agData = null;
                agData = EvaluationModelIfc.LAST_SCORE.equals(scoringoption) ? service.getLastSubmittedAssessmentGradingByAgentId(id, agent, assessmentGradingId) : (AssessmentGradingData)service.getHighestSubmittedAssessmentGrading(id, agent, assessmentGradingId);
                if (agData == null) {
                    delivery.setOutcome("reviewAssessmentError");
                    return;
                }
                log.debug((Object)("GraderComments: getComments()" + agData.getComments()));
                delivery.setGraderComment(agData.getComments());
                delivery.setAssessmentGradingId(agData.getAssessmentGradingId());
                delivery.setOutcome("takeAssessment");
                delivery.setSecureDeliveryHTMLFragment("");
                delivery.setBlockDelivery(false);
                SecureDeliveryServiceAPI secureDelivery = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
                if (!secureDelivery.isSecureDeliveryAvaliable() || (moduleId = publishedAssessment.getAssessmentMetaDataByLabel("SECURE_DELIVERY_MODULE_KEY")) == null || "SECURE_DELIVERY_NONE_ID".equals(moduleId)) break;
                HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
                SecureDeliveryServiceAPI.PhaseStatus status = secureDelivery.validatePhase(moduleId, SecureDeliveryServiceAPI.Phase.ASSESSMENT_REVIEW, (PublishedAssessmentIfc)publishedAssessment, request);
                delivery.setSecureDeliveryHTMLFragment(secureDelivery.getHTMLFragment(moduleId, (PublishedAssessmentIfc)publishedAssessment, request, SecureDeliveryServiceAPI.Phase.ASSESSMENT_REVIEW, status, new ResourceLoader().getLocale()));
                if (SecureDeliveryServiceAPI.PhaseStatus.FAILURE != status) break;
                delivery.setOutcome("secureDeliveryError");
                delivery.setBlockDelivery(true);
                break;
            }
            case 4: {
                String gradingData = ContextUtil.lookupParam((String)"gradingData");
                itemGradingHash = service.getStudentGradingData(gradingData);
                delivery.setAssessmentGradingId(Long.valueOf(gradingData));
                ag = this.setAssessmentGradingFromItemData(delivery, itemGradingHash, false);
                delivery.setAssessmentGrading(ag);
                this.setDisplayByAssessment(delivery);
                this.setFeedbackMode(delivery);
                this.setDeliveryFeedbackOnforEvaluation(delivery);
                this.setGraderComment(delivery);
                break;
            }
            case 1: 
            case 5: {
                log.debug((Object)"**** DeliveryActionListener #0");
                if (ae != null && ae.getComponent().getId().startsWith("beginAssessment")) {
                    if (!delivery.getSettings().getUsername().equals("") && "passwordAccessError".equals(delivery.validatePassword())) {
                        return;
                    }
                    if (delivery.getSettings().getIpAddresses() != null && !delivery.getSettings().getIpAddresses().isEmpty() && "ipAccessError".equals(delivery.validateIP())) {
                        return;
                    }
                }
                if (delivery.getNavigation().equals("1") && ae != null && "showFeedback".equals(ae.getComponent().getId())) {
                    log.debug((Object)"Do not get data from db if it is linear access and the action is show feedback but...");
                    log.debug((Object)"except file upload and audio questions");
                    ag = delivery.getAssessmentGrading();
                    Set itemGradingSet = ag.getItemGradingSet();
                    for (ItemGradingData data : itemGradingSet) {
                        ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)itemGradingHash.get(data.getPublishedItemId());
                        if (thisone == null) {
                            thisone = new ArrayList<ItemGradingData>();
                        }
                        thisone.add(data);
                        itemGradingHash.put(data.getPublishedItemId(), thisone);
                    }
                    HashMap mediaItemGradingHash = service.getMediaItemGradingHash(ag.getAssessmentGradingId());
                    Set set = mediaItemGradingHash.entrySet();
                    for (Map.Entry me : set) {
                        Long publishedItemId = (Long)me.getKey();
                        ArrayList al = (ArrayList)me.getValue();
                        ArrayList itemGradingArray = (ArrayList)itemGradingHash.get(publishedItemId);
                        if (itemGradingArray != null) {
                            itemGradingArray.addAll(al);
                        } else {
                            itemGradingArray = new ArrayList();
                            itemGradingArray.addAll(al);
                        }
                        itemGradingHash.put(publishedItemId, itemGradingArray);
                        itemGradingSet.addAll(itemGradingArray);
                        ag.setItemGradingSet(itemGradingSet);
                    }
                } else {
                    log.debug((Object)"Get data from db otherwise");
                    itemGradingHash = service.getLastItemGradingData(id, agent);
                    log.debug((Object)"**** DeliveryActionListener #1");
                    if (itemGradingHash != null && itemGradingHash.size() > 0) {
                        log.debug((Object)"**** DeliveryActionListener #1a");
                        ag = this.setAssessmentGradingFromItemData(delivery, itemGradingHash, true);
                        this.setAttemptDateIfNull(ag);
                    } else {
                        ag = service.getLastSavedAssessmentGradingByAgentId(id, agent);
                        if (ag == null) {
                            ag = this.createAssessmentGrading(publishedAssessment);
                            isFirstTimeBegin = true;
                        } else {
                            this.setAttemptDateIfNull(ag);
                        }
                    }
                    delivery.setAssessmentGrading(ag);
                }
                log.debug((Object)("**** DeliveryAction, itemgrading size=" + ag.getItemGradingSet().size()));
                delivery.setAssessmentGradingId(delivery.getAssessmentGrading().getAssessmentGradingId());
                this.setFeedbackMode(delivery);
                if (ae != null && ae.getComponent().getId().startsWith("beginAssessment")) {
                    StringBuffer eventRef;
                    this.setTimer(delivery, publishedAssessment, true, isFirstTimeBegin);
                    this.setStatus(delivery, pubService, Long.valueOf(id));
                    if (action == 1) {
                        eventRef = new StringBuffer("publishedAssessmentId");
                        eventRef.append(delivery.getAssessmentId());
                        eventRef.append(", agentId=");
                        eventRef.append(this.getAgentString());
                        if (delivery.isTimeRunning()) {
                            eventRef.append(", elapsed=");
                            eventRef.append(delivery.getTimeElapse());
                            eventRef.append(", remaining=");
                            int timeRemaining = Integer.parseInt(delivery.getTimeLimit()) - Integer.parseInt(delivery.getTimeElapse());
                            eventRef.append(timeRemaining);
                        }
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.take", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", " + eventRef.toString()), (boolean)true));
                    } else if (action == 5) {
                        eventRef = new StringBuffer("publishedAssessmentId");
                        eventRef.append(delivery.getAssessmentId());
                        eventRef.append(", agentId=");
                        eventRef.append(this.getAgentString());
                        if (delivery.isTimeRunning()) {
                            eventRef.append(", elapsed=");
                            eventRef.append(delivery.getTimeElapse());
                            eventRef.append(", remaining=");
                            int timeRemaining = Integer.parseInt(delivery.getTimeLimit()) - Integer.parseInt(delivery.getTimeElapse());
                            eventRef.append(timeRemaining);
                        }
                        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
                        String siteId = publishedAssessmentService.getPublishedAssessmentOwner(Long.valueOf(delivery.getAssessmentId()));
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.take.via_url", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", " + eventRef.toString()), (String)siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
                    }
                } else {
                    this.setTimer(delivery, publishedAssessment, false, false);
                }
                SessionUtil.setSessionTimeout((FacesContext)FacesContext.getCurrentInstance(), (DeliveryBean)delivery, (boolean)true);
                log.debug((Object)("****Set begin time " + delivery.getBeginTime()));
                log.debug((Object)("****Set elapsed time " + delivery.getTimeElapse()));
                break;
            }
        }
        this.overloadItemData(delivery, itemGradingHash, publishedAssessment);
        HashMap publishedAnswerHash = pubService.preparePublishedAnswerHash((PublishedAssessmentIfc)publishedAssessment);
        delivery.setTableOfContents(this.getContents(publishedAssessment, itemGradingHash, delivery, publishedAnswerHash));
        log.debug((Object)("**** resetPageContents=" + this.resetPageContents));
        if (this.resetPageContents) {
            if (ae != null && ae.getComponent().getId().equals("showFeedback")) {
                delivery.setPageContents(this.getShowFeedbackPageContents(publishedAssessment, delivery, itemGradingHash, publishedAnswerHash));
            } else {
                delivery.setPageContents(this.getPageContents(publishedAssessment, delivery, itemGradingHash, publishedAnswerHash));
            }
        }
    }

    protected AssessmentGradingData setAssessmentGradingFromItemData(DeliveryBean delivery, HashMap itemGradingHash, boolean setNullOK) {
        AssessmentGradingData agrading = null;
        Iterator keys = itemGradingHash.keySet().iterator();
        GradingService gradingService = new GradingService();
        if (keys.hasNext()) {
            ItemGradingData igd = (ItemGradingData)((ArrayList)itemGradingHash.get(keys.next())).toArray()[0];
            AssessmentGradingData agd = gradingService.load(igd.getAssessmentGradingId().toString());
            agd.setItemGradingSet(gradingService.getItemGradingSet(agd.getAssessmentGradingId().toString()));
            if (!agd.getForGrade().booleanValue()) {
                log.debug((Object)("setAssessmentGradingFromItemData agd.getTimeElapsed(): " + agd.getTimeElapsed()));
                log.debug((Object)("setAssessmentGradingFromItemData delivery.getTimeElapse(): " + delivery.getTimeElapse()));
                agrading = agd;
            } else if (setNullOK) {
                agrading = null;
            }
        } else if (setNullOK) {
            agrading = null;
        }
        return agrading;
    }

    private void setDeliveryFeedbackOnforEvaluation(DeliveryBean delivery) {
        delivery.getFeedbackComponent().setShowCorrectResponse(true);
        delivery.getFeedbackComponent().setShowGraderComment(true);
        delivery.getFeedbackComponent().setShowItemLevel(true);
        delivery.getFeedbackComponent().setShowQuestion(true);
        delivery.getFeedbackComponent().setShowResponse(true);
        delivery.getFeedbackComponent().setShowSelectionLevel(true);
        delivery.getFeedbackComponent().setShowStats(true);
        delivery.getFeedbackComponent().setShowStudentScore(true);
        delivery.getFeedbackComponent().setShowStudentQuestionScore(true);
    }

    private void goToRightQuestionFromTOC(DeliveryBean delivery) throws NumberFormatException {
        if (ContextUtil.lookupParam((String)"partnumber") != null && !ContextUtil.lookupParam((String)"partnumber").trim().equals("") && ContextUtil.lookupParam((String)"questionnumber") != null && !ContextUtil.lookupParam((String)"questionnumber").trim().equals("")) {
            delivery.setPartIndex(Integer.valueOf(ContextUtil.lookupParam((String)"partnumber")) - 1);
            delivery.setQuestionIndex(Integer.valueOf(ContextUtil.lookupParam((String)"questionnumber")) - 1);
        }
    }

    protected ContentsDeliveryBean getContents(PublishedAssessmentFacade publishedAssessment, HashMap itemGradingHash, DeliveryBean delivery, HashMap publishedAnswerHash) {
        ContentsDeliveryBean contents = new ContentsDeliveryBean();
        float currentScore = 0.0f;
        float maxScore = 0.0f;
        ArrayList partSet = publishedAssessment.getSectionArraySorted();
        Iterator iter = partSet.iterator();
        ArrayList<SectionContentsBean> partsContents = new ArrayList<SectionContentsBean>();
        while (iter.hasNext()) {
            SectionContentsBean partBean = this.getPartBean((SectionDataIfc)iter.next(), itemGradingHash, delivery, publishedAnswerHash);
            partBean.setNumParts(Integer.toString(partSet.size()));
            currentScore += partBean.getPoints();
            maxScore += partBean.getMaxPoints();
            partsContents.add(partBean);
        }
        contents.setCurrentScore(currentScore);
        contents.setMaxScore(maxScore);
        contents.setPartsContents(partsContents);
        return contents;
    }

    public ContentsDeliveryBean getPageContents(PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery, HashMap itemGradingHash, HashMap publishedAnswerHash) {
        if (delivery.getSettings().isFormatByAssessment()) {
            return this.getPageContentsByAssessment(publishedAssessment, itemGradingHash, delivery, publishedAnswerHash);
        }
        int itemIndex = delivery.getQuestionIndex();
        int sectionIndex = delivery.getPartIndex();
        if (delivery.getSettings().isFormatByPart()) {
            return this.getPageContentsByPart(publishedAssessment, itemIndex, sectionIndex, itemGradingHash, delivery, publishedAnswerHash);
        }
        if (delivery.getSettings().isFormatByQuestion()) {
            return this.getPageContentsByQuestion(publishedAssessment, itemIndex, sectionIndex, itemGradingHash, delivery, publishedAnswerHash);
        }
        log.warn((Object)"delivery.getSettings().isFormatBy... is NOT set!");
        return this.getPageContentsByAssessment(publishedAssessment, itemGradingHash, delivery, publishedAnswerHash);
    }

    public ContentsDeliveryBean getShowFeedbackPageContents(PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery, HashMap itemGradingHash, HashMap publishedAnswerHash) {
        if (delivery.getSettings().isFormatByAssessment()) {
            delivery.setPartIndex(0);
            delivery.setQuestionIndex(0);
            return this.getPageContentsByAssessment(publishedAssessment, itemGradingHash, delivery, publishedAnswerHash);
        }
        if (delivery.getSettings().isFormatByPart()) {
            delivery.setQuestionIndex(0);
            return this.getPageContentsByPart(publishedAssessment, delivery.getQuestionIndex(), delivery.getPartIndex(), itemGradingHash, delivery, publishedAnswerHash);
        }
        if (delivery.getSettings().isFormatByQuestion()) {
            return this.getPageContentsByQuestion(publishedAssessment, delivery.getQuestionIndex(), delivery.getPartIndex(), itemGradingHash, delivery, publishedAnswerHash);
        }
        log.warn((Object)"delivery.getSettings().isFormatBy... is NOT set!");
        delivery.setPartIndex(0);
        delivery.setQuestionIndex(0);
        return this.getPageContentsByAssessment(publishedAssessment, itemGradingHash, delivery, publishedAnswerHash);
    }

    private ContentsDeliveryBean getPageContentsByAssessment(PublishedAssessmentFacade publishedAssessment, HashMap itemGradingHash, DeliveryBean delivery, HashMap publishedAnswerHash) {
        ContentsDeliveryBean contents = new ContentsDeliveryBean();
        float currentScore = 0.0f;
        float maxScore = 0.0f;
        ArrayList partSet = publishedAssessment.getSectionArraySorted();
        Iterator iter = partSet.iterator();
        ArrayList<SectionContentsBean> partsContents = new ArrayList<SectionContentsBean>();
        while (iter.hasNext()) {
            SectionContentsBean partBean = this.getPartBean((SectionDataIfc)iter.next(), itemGradingHash, delivery, publishedAnswerHash);
            partBean.setNumParts(Integer.toString(partSet.size()));
            if (partBean.getItemContentsSize().equals("0")) {
                log.debug((Object)"getPageContentsByAssessment(): no question");
                partBean.setNoQuestions(true);
            }
            currentScore += partBean.getPoints();
            maxScore += partBean.getMaxPoints();
            partsContents.add(partBean);
        }
        delivery.setPrevious(false);
        delivery.setContinue(false);
        contents.setCurrentScore(currentScore);
        contents.setMaxScore(maxScore);
        contents.setPartsContents(partsContents);
        contents.setShowStudentScore(delivery.isShowStudentScore());
        return contents;
    }

    private ContentsDeliveryBean getPageContentsByPart(PublishedAssessmentFacade publishedAssessment, int itemIndex, int sectionIndex, HashMap itemGradingHash, DeliveryBean delivery, HashMap publishedAnswerHash) {
        ContentsDeliveryBean contents = new ContentsDeliveryBean();
        float currentScore = 0.0f;
        float maxScore = 0.0f;
        int sectionCount = 0;
        ArrayList partSet = publishedAssessment.getSectionArraySorted();
        Iterator iter = partSet.iterator();
        ArrayList<SectionContentsBean> partsContents = new ArrayList<SectionContentsBean>();
        while (iter.hasNext()) {
            SectionContentsBean partBean = this.getPartBean((SectionDataIfc)iter.next(), itemGradingHash, delivery, publishedAnswerHash);
            partBean.setNumParts(Integer.toString(partSet.size()));
            if (partBean.getItemContentsSize().equals("0")) {
                log.debug((Object)"getPageContentsByPart(): no question");
                partBean.setNoQuestions(true);
            }
            currentScore += partBean.getPoints();
            maxScore += partBean.getMaxPoints();
            if (sectionCount++ != sectionIndex) continue;
            partsContents.add(partBean);
            if (iter.hasNext()) {
                delivery.setContinue(true);
            } else {
                delivery.setContinue(false);
            }
            if (sectionCount > 1) {
                delivery.setPrevious(true);
                continue;
            }
            delivery.setPrevious(false);
        }
        contents.setCurrentScore(currentScore);
        contents.setMaxScore(maxScore);
        contents.setPartsContents(partsContents);
        contents.setShowStudentScore(delivery.isShowStudentScore());
        return contents;
    }

    private ContentsDeliveryBean getPageContentsByQuestion(PublishedAssessmentFacade publishedAssessment, int itemIndex, int sectionIndex, HashMap itemGradingHash, DeliveryBean delivery, HashMap publishedAnswerHash) {
        ContentsDeliveryBean contents = new ContentsDeliveryBean();
        float currentScore = 0.0f;
        float maxScore = 0.0f;
        int sectionCount = 0;
        int questionCount = 0;
        ArrayList partSet = publishedAssessment.getSectionArraySorted();
        Iterator iter = partSet.iterator();
        ArrayList<SectionContentsBean> partsContents = new ArrayList<SectionContentsBean>();
        if (itemIndex < 0) {
            delivery.setPartIndex(--sectionIndex);
        }
        while (iter.hasNext()) {
            SectionDataIfc secFacade = (SectionDataIfc)iter.next();
            SectionContentsBean partBean = this.getPartBean(secFacade, itemGradingHash, delivery, publishedAnswerHash);
            partBean.setNumParts(Integer.toString(partSet.size()));
            currentScore += partBean.getPoints();
            maxScore += partBean.getMaxPoints();
            ArrayList itemlist = secFacade.getItemArray();
            long seed = this.getSeed(secFacade, delivery, (long)AgentFacade.getAgentString().hashCode());
            ArrayList sortedlist = this.getItemArraySortedWithRandom(secFacade, itemlist, seed);
            questionCount = sortedlist.size();
            if ((delivery.getNoQuestions() || questionCount != 0) && itemIndex > questionCount - 1 && sectionCount == sectionIndex) {
                delivery.setPartIndex(++sectionIndex);
                itemIndex = 0;
                delivery.setQuestionIndex(itemIndex);
                delivery.setNoQuestions(false);
            }
            if (itemIndex < 0 && sectionCount == sectionIndex) {
                itemIndex = questionCount - 1;
                delivery.setQuestionIndex(itemIndex);
            }
            if (sectionCount++ != sectionIndex) continue;
            SectionContentsBean partBeanWithQuestion = this.getPartBeanWithOneQuestion(secFacade, itemIndex, itemGradingHash, delivery, publishedAnswerHash);
            partBeanWithQuestion.setNumParts(Integer.toString(partSet.size()));
            partsContents.add(partBeanWithQuestion);
            if (questionCount == 0) {
                partBeanWithQuestion.setNoQuestions(true);
                delivery.setNoQuestions(true);
            } else {
                partBeanWithQuestion.setNoQuestions(false);
                delivery.setNoQuestions(false);
            }
            if (iter.hasNext() || itemIndex < questionCount - 1) {
                delivery.setContinue(true);
            } else {
                delivery.setContinue(false);
            }
            if (itemIndex > 0 || sectionIndex > 0) {
                delivery.setPrevious(true);
                continue;
            }
            delivery.setPrevious(false);
        }
        contents.setCurrentScore(currentScore);
        contents.setMaxScore(maxScore);
        contents.setPartsContents(partsContents);
        contents.setShowStudentScore(delivery.isShowStudentScore());
        return contents;
    }

    private SectionContentsBean getPartBean(SectionDataIfc part, HashMap itemGradingHash, DeliveryBean delivery, HashMap publishedAnswerHash) {
        float maxPoints = 0.0f;
        float points = 0.0f;
        int unansweredQuestions = 0;
        SectionContentsBean sec = new SectionContentsBean(part);
        ArrayList itemSet = null;
        ArrayList itemlist = part.getItemArray();
        long seed = 0L;
        if (delivery.getActionMode() == 4) {
            StudentScoresBean studentscorebean = (StudentScoresBean)ContextUtil.lookupBean((String)"studentScores");
            seed = this.getSeed(part, delivery, (long)studentscorebean.getStudentId().hashCode());
        } else {
            seed = this.getSeed(part, delivery, (long)AgentFacade.getAgentString().hashCode());
        }
        itemSet = this.getItemArraySortedWithRandom(part, itemlist, seed);
        sec.setQuestions(itemSet.size());
        if (delivery.getSettings().getItemNumbering().equals(AssessmentAccessControl.RESTART_NUMBERING_BY_PART.toString())) {
            sec.setNumbering(itemSet.size());
        } else {
            sec.setNumbering(((Long)itemGradingHash.get("items")).intValue());
        }
        sec.setText(part.getTitle());
        sec.setDescription(part.getDescription());
        sec.setNumber("" + part.getSequence());
        sec.setMetaData(part);
        Iterator iter = itemSet.iterator();
        ArrayList<ItemContentsBean> itemContents = new ArrayList<ItemContentsBean>();
        int i = 0;
        while (iter.hasNext()) {
            ItemDataIfc thisitem = (ItemDataIfc)iter.next();
            ItemContentsBean itemBean = this.getQuestionBean(thisitem, itemGradingHash, delivery, publishedAnswerHash);
            itemBean.setNumber(++i);
            if (delivery.getSettings().getItemNumbering().equals(AssessmentAccessControl.RESTART_NUMBERING_BY_PART.toString())) {
                itemBean.setSequence(Integer.toString(itemBean.getNumber()));
            } else {
                itemBean.setSequence(((Integer)itemGradingHash.get("sequence" + thisitem.getItemId().toString())).toString());
            }
            maxPoints += itemBean.getMaxPoints();
            points += itemBean.getExactPoints();
            itemBean.setShowStudentScore(delivery.isShowStudentScore());
            itemBean.setShowStudentQuestionScore(delivery.isShowStudentQuestionScore());
            if (itemBean.isUnanswered()) {
                ++unansweredQuestions;
            }
            itemContents.add(itemBean);
        }
        sec.setMaxPoints(maxPoints);
        sec.setPoints(points);
        sec.setShowStudentQuestionScore(delivery.isShowStudentQuestionScore());
        sec.setUnansweredQuestions(unansweredQuestions);
        sec.setItemContents(itemContents);
        sec.setAttachmentList(part.getSectionAttachmentList());
        return sec;
    }

    private SectionContentsBean getPartBeanWithOneQuestion(SectionDataIfc part, int itemIndex, HashMap itemGradingHash, DeliveryBean delivery, HashMap publishedAnswerHash) {
        float maxPoints = 0.0f;
        float points = 0.0f;
        int unansweredQuestions = 0;
        int itemCount = 0;
        SectionContentsBean sec = new SectionContentsBean(part);
        ArrayList itemlist = part.getItemArray();
        long seed = this.getSeed(part, delivery, (long)AgentFacade.getAgentString().hashCode());
        ArrayList itemSet = this.getItemArraySortedWithRandom(part, itemlist, seed);
        sec.setQuestions(itemSet.size());
        if (delivery.getSettings().getItemNumbering().equals(AssessmentAccessControl.RESTART_NUMBERING_BY_PART.toString())) {
            sec.setNumbering(itemSet.size());
        } else {
            sec.setNumbering(((Long)itemGradingHash.get("items")).intValue());
        }
        sec.setText(part.getTitle());
        sec.setDescription(part.getDescription());
        sec.setNumber("" + part.getSequence());
        Iterator iter = itemSet.iterator();
        ArrayList<ItemContentsBean> itemContents = new ArrayList<ItemContentsBean>();
        int i = 0;
        while (iter.hasNext()) {
            ItemDataIfc thisitem = (ItemDataIfc)iter.next();
            ItemContentsBean itemBean = this.getQuestionBean(thisitem, itemGradingHash, delivery, publishedAnswerHash);
            itemBean.setNumber(++i);
            if (delivery.getSettings().getItemNumbering().equals(AssessmentAccessControl.RESTART_NUMBERING_BY_PART.toString())) {
                itemBean.setSequence(Integer.toString(itemBean.getNumber()));
            } else {
                itemBean.setSequence(((Integer)itemGradingHash.get("sequence" + thisitem.getItemId().toString())).toString());
            }
            maxPoints += itemBean.getMaxPoints();
            points += itemBean.getExactPoints();
            itemBean.setShowStudentScore(delivery.isShowStudentScore());
            itemBean.setShowStudentQuestionScore(delivery.isShowStudentQuestionScore());
            if (itemBean.isUnanswered()) {
                ++unansweredQuestions;
            }
            if (itemCount++ != itemIndex) continue;
            itemContents.add(itemBean);
        }
        sec.setMaxPoints(maxPoints);
        sec.setPoints(points);
        sec.setShowStudentQuestionScore(delivery.isShowStudentQuestionScore());
        sec.setUnansweredQuestions(unansweredQuestions);
        sec.setItemContents(itemContents);
        return sec;
    }

    private ItemContentsBean getQuestionBean(ItemDataIfc item, HashMap itemGradingHash, DeliveryBean delivery, HashMap publishedAnswerHash) {
        ItemContentsBean itemBean = new ItemContentsBean();
        itemBean.setItemData(item);
        itemBean.setMaxPoints(item.getScore().floatValue());
        itemBean.setPoints(0.0f);
        if (item.getTriesAllowed() != null) {
            itemBean.setTriesAllowed(item.getTriesAllowed());
        }
        if (item.getDuration() != null) {
            itemBean.setDuration(item.getDuration());
        }
        itemBean.setItemGradingDataArray((ArrayList)itemGradingHash.get(item.getItemId()));
        if (itemBean.getItemGradingDataArray().size() > 0) {
            itemBean.setItemGradingIdForFilePicker(((ItemGradingData)itemBean.getItemGradingDataArray().get(0)).getItemGradingId());
        }
        Iterator i = itemBean.getItemGradingDataArray().iterator();
        ArrayList itemGradingAttachmentList = new ArrayList();
        while (i.hasNext()) {
            ItemGradingData data = (ItemGradingData)i.next();
            itemBean.setGradingComment(data.getComments());
            if (data.getAutoScore() != null) {
                itemBean.setPoints(itemBean.getExactPoints() + data.getAutoScore().floatValue());
            }
            if (data.getAttemptsRemaining() != null) {
                itemBean.setAttemptsRemaining(data.getAttemptsRemaining());
            }
            itemGradingAttachmentList.addAll(data.getItemGradingAttachmentList());
        }
        itemBean.setItemGradingAttachmentList(itemGradingAttachmentList);
        if (item.getTypeId().equals(TypeIfc.ESSAY_QUESTION) || item.getTypeId().equals(TypeIfc.FILE_UPLOAD) || item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE_SURVEY) || item.getTypeId().equals(TypeIfc.AUDIO_RECORDING) || item.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY)) {
            itemBean.setFeedback(item.getGeneralItemFeedback());
        } else if (itemBean.getMaxPoints() > 0.0f) {
            if (itemBean.getExactPoints() >= itemBean.getMaxPoints()) {
                itemBean.setFeedback(item.getCorrectItemFeedback());
            } else {
                itemBean.setFeedback(item.getInCorrectItemFeedback());
            }
        } else {
            ArrayList itemgradingList = itemBean.getItemGradingDataArray();
            Iterator iterAnswer = itemgradingList.iterator();
            boolean haswronganswer = true;
            HashMap fibmap = new HashMap();
            int mcmc_match_counter = 0;
            if (iterAnswer.hasNext()) {
                haswronganswer = false;
            }
            int correctAnswers = 0;
            if (item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) || item.getTypeId().equals(TypeIfc.MATCHING)) {
                for (ItemTextIfc itemText : item.getItemTextArray()) {
                    ArrayList answerArray = itemText.getAnswerArray();
                    if (answerArray == null) continue;
                    for (int indexAnswer = 0; indexAnswer < answerArray.size(); ++indexAnswer) {
                        AnswerIfc a = (AnswerIfc)answerArray.get(indexAnswer);
                        if (!a.getIsCorrect().booleanValue()) continue;
                        ++correctAnswers;
                    }
                }
            }
            while (iterAnswer.hasNext()) {
                GradingService gs;
                ItemGradingIfc data = (ItemGradingIfc)iterAnswer.next();
                AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
                if (item.getTypeId().equals(TypeIfc.FILL_IN_BLANK)) {
                    gs = new GradingService();
                    boolean correctanswer = gs.getFIBResult(data, fibmap, item, publishedAnswerHash);
                    if (correctanswer) continue;
                    haswronganswer = true;
                    break;
                }
                if (item.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC)) {
                    gs = new GradingService();
                    try {
                        boolean correctanswer = gs.getFINResult(data, item, publishedAnswerHash);
                        if (correctanswer) continue;
                        haswronganswer = true;
                        break;
                    }
                    catch (FormatException e) {
                        log.debug((Object)"should not come to here");
                        continue;
                    }
                }
                if (item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) || item.getTypeId().equals(TypeIfc.MATCHING)) {
                    if (!(answer == null || answer.getIsCorrect() != null && answer.getIsCorrect().booleanValue())) {
                        haswronganswer = true;
                        break;
                    }
                    if (answer == null) continue;
                    ++mcmc_match_counter;
                    continue;
                }
                if (answer == null || answer.getIsCorrect() != null && answer.getIsCorrect().booleanValue()) continue;
                haswronganswer = true;
                break;
            }
            if (item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MATCHING)) {
                haswronganswer = mcmc_match_counter != correctAnswers;
            }
            if (haswronganswer) {
                itemBean.setFeedback(item.getInCorrectItemFeedback());
            } else {
                itemBean.setFeedback(item.getCorrectItemFeedback());
            }
        }
        boolean randomize = false;
        for (ItemMetaDataIfc meta : item.getItemMetaDataSet()) {
            if (!meta.getLabel().equals("RANDOMIZE") || !meta.getEntry().equals("true")) continue;
            randomize = true;
            break;
        }
        ArrayList<AnswerIfc> myanswers = new ArrayList<AnswerIfc>();
        ResourceLoader rb = null;
        String key = "";
        Iterator key1 = item.getItemTextArraySorted().iterator();
        int j = 1;
        while (key1.hasNext()) {
            myanswers = new ArrayList();
            ItemTextIfc text = (ItemTextIfc)key1.next();
            Iterator key2 = null;
            if (randomize && !item.getTypeId().equals(TypeIfc.FILL_IN_BLANK) && !item.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC) && !item.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY) || item.getTypeId().equals(TypeIfc.MATCHING)) {
                ArrayList shuffled = new ArrayList();
                Iterator i1 = text.getAnswerArraySorted().iterator();
                while (i1.hasNext()) {
                    shuffled.add(i1.next());
                }
                String agentString = "";
                if (delivery.getActionMode() == 4) {
                    StudentScoresBean studentscorebean = (StudentScoresBean)ContextUtil.lookupBean((String)"studentScores");
                    agentString = studentscorebean.getStudentId();
                } else {
                    agentString = this.getAgentString();
                }
                Collections.shuffle(shuffled, new Random((long)item.getText().hashCode() + (long)(this.getAgentString() + "_" + item.getItemId().toString()).hashCode()));
                key2 = shuffled.iterator();
            } else {
                key2 = text.getAnswerArraySorted().iterator();
            }
            int k = 0;
            while (key2.hasNext()) {
                AnswerIfc answer = (AnswerIfc)key2.next();
                if ((answer.getText() == null || answer.getText().trim().equals("")) && (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) || item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE_SURVEY) || item.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY))) continue;
                if (!item.getPartialCreditFlag().booleanValue() && item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) || item.getTypeId().equals(TypeIfc.MATCHING)) {
                    answer.setLabel(Character.toString(alphabet.charAt(k++)));
                    if (answer.getIsCorrect() != null && answer.getIsCorrect().booleanValue()) {
                        String addition = "";
                        if (item.getTypeId().equals(TypeIfc.MATCHING)) {
                            addition = Integer.toString(j++) + ":";
                        }
                        key = "".equals(key) ? key + addition + answer.getLabel() : key + ", " + addition + answer.getLabel();
                    }
                }
                if (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) && item.getPartialCreditFlag().booleanValue()) {
                    Float pc = Float.valueOf(answer.getPartialCredit().floatValue());
                    if (pc == null) {
                        pc = Float.valueOf(0.0f);
                    }
                    if (pc.floatValue() > 0.0f) {
                        if (rb == null) {
                            rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.DeliveryMessages");
                        }
                        String correct = rb.getString("alt_correct");
                        key = "".equals(key) ? answer.getLabel() + "&nbsp;<span style='color: green'>(" + pc + "%&nbsp;" + correct + ")</span>" : key + ",&nbsp;" + answer.getLabel() + "&nbsp;<span style='color: green'>(" + pc + "%&nbsp;" + correct + ")</span>";
                    }
                }
                if (item.getTypeId().equals(TypeIfc.TRUE_FALSE) && answer.getIsCorrect() != null && answer.getIsCorrect().booleanValue()) {
                    if (rb == null) {
                        rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.DeliveryMessages");
                    }
                    key = answer.getText().equalsIgnoreCase("true") || answer.getText().equalsIgnoreCase(rb.getString("true_msg")) ? rb.getString("true_msg") : rb.getString("false_msg");
                }
                if (item.getTypeId().equals(TypeIfc.FILE_UPLOAD) || item.getTypeId().equals(TypeIfc.ESSAY_QUESTION) || item.getTypeId().equals(TypeIfc.AUDIO_RECORDING)) {
                    key = key + answer.getText();
                }
                if (item.getTypeId().equals(TypeIfc.FILL_IN_BLANK) || item.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC)) {
                    key = "".equals(key) ? key + answer.getText() : key + ", " + answer.getText();
                }
                myanswers.add(answer);
            }
        }
        itemBean.setKey(key);
        itemBean.setShuffledAnswers(myanswers);
        ArrayList<Object> answers = new ArrayList<Object>();
        if (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) || item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE_SURVEY) || item.getTypeId().equals(TypeIfc.TRUE_FALSE) || item.getTypeId().equals(TypeIfc.MATCHING)) {
            Iterator iter = myanswers.iterator();
            while (iter.hasNext()) {
                SelectionBean selectionBean = new SelectionBean();
                selectionBean.setItemContentsBean(itemBean);
                AnswerIfc answer = (AnswerIfc)iter.next();
                selectionBean.setAnswer(answer);
                if (item.getTypeId().equals(TypeIfc.TRUE_FALSE) && answer.getText().equals("true")) {
                    answer.setText(rb.getString("true_msg"));
                }
                if (item.getTypeId().equals(TypeIfc.TRUE_FALSE) && answer.getText().equals("false")) {
                    answer.setText(rb.getString("false_msg"));
                }
                String label = "";
                if (answer.getLabel() == null) {
                    answer.setLabel("");
                }
                label = !answer.getLabel().equals("") ? label + answer.getLabel() + ". " + answer.getText() : answer.getText();
                selectionBean.setResponse(false);
                for (ItemGradingData data : itemBean.getItemGradingDataArray()) {
                    AnswerIfc pubAnswer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
                    if (pubAnswer == null || !pubAnswer.equals(answer) && !data.getPublishedAnswerId().equals(answer.getId())) continue;
                    selectionBean.setItemGradingData(data);
                    selectionBean.setResponse(true);
                }
                if (delivery.getFeedbackComponent() != null && delivery.getFeedback().equals("true") && delivery.getFeedbackComponent().getShowSelectionLevel()) {
                    if (answer.getIsCorrect() == null) {
                        selectionBean.setFeedback(answer.getGeneralAnswerFeedback());
                    } else if (selectionBean.getResponse() && answer.getIsCorrect().booleanValue() || !selectionBean.getResponse() && !answer.getIsCorrect().booleanValue()) {
                        selectionBean.setFeedback(answer.getCorrectAnswerFeedback());
                    } else {
                        selectionBean.setFeedback(answer.getInCorrectAnswerFeedback());
                    }
                }
                String description = "";
                if (delivery.getFeedback().equals("true") && delivery.getFeedbackComponent().getShowCorrectResponse() && answer.getIsCorrect() != null) {
                    description = answer.getIsCorrect().toString();
                }
                SelectItem newItem = new SelectItem((Object)answer.getId().toString(), label, description);
                if (item.getTypeId().equals(TypeIfc.TRUE_FALSE)) {
                    answers.add(newItem);
                    continue;
                }
                answers.add(selectionBean);
            }
        }
        itemBean.setAnswers(answers);
        itemBean.setSelectionArray(answers);
        if (item.getTypeId().equals(TypeIfc.MATCHING)) {
            this.populateMatching(item, itemBean, publishedAnswerHash);
        } else if (item.getTypeId().equals(TypeIfc.FILL_IN_BLANK)) {
            this.populateFib(item, itemBean);
        } else if (item.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC)) {
            this.populateFin(item, itemBean);
        } else if (item.getTypeId().equals(TypeIfc.ESSAY_QUESTION)) {
            String responseText = itemBean.getResponseText();
            itemBean.setResponseText(ContextUtil.stringWYSIWYG((String)responseText));
        } else if (item.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY)) {
            this.populateMatrixChoices(item, itemBean, publishedAnswerHash);
        }
        return itemBean;
    }

    public void populateMatching(ItemDataIfc item, ItemContentsBean bean, HashMap publishedAnswerHash) {
        Iterator iter = item.getItemTextArraySorted().iterator();
        int j = 1;
        ArrayList<MatchingBean> beans = new ArrayList<MatchingBean>();
        ArrayList<String> newAnswers = null;
        while (iter.hasNext()) {
            ItemTextIfc text = (ItemTextIfc)iter.next();
            MatchingBean mbean = new MatchingBean();
            newAnswers = new ArrayList<String>();
            mbean.setText(Integer.toString(j++) + ". " + text.getText());
            mbean.setItemText(text);
            mbean.setItemContentsBean(bean);
            ArrayList<SelectItem> choices = new ArrayList<SelectItem>();
            ArrayList shuffled = new ArrayList();
            Iterator iter2 = text.getAnswerArraySorted().iterator();
            while (iter2.hasNext()) {
                shuffled.add(iter2.next());
            }
            Collections.shuffle(shuffled, new Random((long)item.getText().hashCode() + (long)(this.getAgentString() + "_" + item.getItemId().toString()).hashCode()));
            iter2 = shuffled.iterator();
            int i = 0;
            ResourceLoader rb = null;
            if (rb == null) {
                rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.DeliveryMessages");
            }
            choices.add(new SelectItem((Object)"0", rb.getString("matching_select"), ""));
            while (iter2.hasNext()) {
                AnswerIfc answer = (AnswerIfc)iter2.next();
                newAnswers.add(Character.toString(alphabet.charAt(i)) + ". " + answer.getText());
                choices.add(new SelectItem((Object)answer.getId().toString(), Character.toString(alphabet.charAt(i++)), ""));
            }
            mbean.setChoices(choices);
            for (ItemGradingData data : bean.getItemGradingDataArray()) {
                if (!data.getPublishedItemTextId().equals(text.getId())) continue;
                mbean.setItemGradingData(data);
                AnswerIfc pubAnswer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
                if (pubAnswer == null) break;
                mbean.setAnswer(pubAnswer);
                mbean.setResponse(data.getPublishedAnswerId().toString());
                if (pubAnswer.getIsCorrect() != null && pubAnswer.getIsCorrect().booleanValue()) {
                    mbean.setFeedback(pubAnswer.getCorrectAnswerFeedback());
                    mbean.setIsCorrect(true);
                    break;
                }
                mbean.setFeedback(pubAnswer.getInCorrectAnswerFeedback());
                mbean.setIsCorrect(false);
                break;
            }
            beans.add(mbean);
        }
        bean.setMatchingArray(beans);
        bean.setAnswers(newAnswers);
    }

    public void populateFib(ItemDataIfc item, ItemContentsBean bean) {
        ItemTextIfc text = (ItemTextIfc)item.getItemTextArraySorted().toArray()[0];
        ArrayList<FibBean> fibs = new ArrayList<FibBean>();
        String alltext = text.getText();
        ArrayList texts = DeliveryActionListener.extractFIBFINTextArray((String)alltext);
        int i = 0;
        for (AnswerIfc answer : text.getAnswerArraySorted()) {
            FibBean fbean = new FibBean();
            fbean.setItemContentsBean(bean);
            fbean.setAnswer(answer);
            if (texts.toArray().length > i) {
                fbean.setText((String)texts.toArray()[i++]);
            } else {
                fbean.setText("");
            }
            fbean.setHasInput(true);
            ArrayList datas = bean.getItemGradingDataArray();
            if (datas == null || datas.isEmpty()) {
                fbean.setIsCorrect(false);
            } else {
                for (ItemGradingData data : datas) {
                    if (data.getPublishedAnswerId() == null || !data.getPublishedAnswerId().equals(answer.getId())) continue;
                    fbean.setItemGradingData(data);
                    fbean.setResponse(FormattedText.convertFormattedTextToPlaintext((String)data.getAnswerText()));
                    fbean.setIsCorrect(false);
                    if (answer.getText() == null) {
                        answer.setText("");
                    }
                    StringTokenizer st2 = new StringTokenizer(answer.getText(), "|");
                    while (st2.hasMoreTokens()) {
                        String nextT = st2.nextToken();
                        log.debug((Object)("nextT = " + nextT));
                        if (data.getAutoScore() == null || !((double)data.getAutoScore().floatValue() > 0.0)) continue;
                        fbean.setIsCorrect(true);
                    }
                }
            }
            fibs.add(fbean);
        }
        FibBean fbean = new FibBean();
        if (texts.toArray().length > i) {
            fbean.setText((String)texts.toArray()[i]);
        } else {
            fbean.setText("");
        }
        fbean.setHasInput(false);
        fibs.add(fbean);
        bean.setFibArray(fibs);
    }

    private static ArrayList extractFIBFINTextArray(String alltext) {
        ArrayList<String> texts = new ArrayList<String>();
        while (alltext.indexOf("{}") > -1) {
            int alltextLeftIndex = alltext.indexOf("{}");
            String tmp = alltext.substring(0, alltextLeftIndex);
            alltext = alltext.substring(alltextLeftIndex + 2);
            texts.add(tmp);
            if (alltextLeftIndex != -1) continue;
            break;
        }
        texts.add(alltext);
        return texts;
    }

    public void populateFin(ItemDataIfc item, ItemContentsBean bean) {
        ItemTextIfc text = (ItemTextIfc)item.getItemTextArraySorted().toArray()[0];
        ArrayList<FinBean> fins = new ArrayList<FinBean>();
        String alltext = text.getText();
        ArrayList texts = DeliveryActionListener.extractFIBFINTextArray((String)alltext);
        int i = 0;
        for (AnswerIfc answer : text.getAnswerArraySorted()) {
            FinBean fbean = new FinBean();
            fbean.setItemContentsBean(bean);
            fbean.setAnswer(answer);
            if (texts.toArray().length > i) {
                fbean.setText((String)texts.toArray()[i++]);
            } else {
                fbean.setText("");
            }
            fbean.setHasInput(true);
            ArrayList datas = bean.getItemGradingDataArray();
            if (datas == null || datas.isEmpty()) {
                fbean.setIsCorrect(false);
            } else {
                for (ItemGradingData data : datas) {
                    log.debug((Object)(" " + data.getPublishedAnswerId() + " = " + answer.getId()));
                    if (data.getPublishedAnswerId() == null || !data.getPublishedAnswerId().equals(answer.getId())) continue;
                    fbean.setItemGradingData(data);
                    fbean.setResponse(FormattedText.convertFormattedTextToPlaintext((String)data.getAnswerText()));
                    fbean.setIsCorrect(false);
                    if (answer.getText() == null) {
                        answer.setText("");
                    }
                    StringTokenizer st2 = new StringTokenizer(answer.getText(), "|");
                    while (st2.hasMoreTokens()) {
                        String nextT = st2.nextToken();
                        log.debug((Object)("nextT = " + nextT));
                        if (data.getAutoScore() == null || !((double)data.getAutoScore().floatValue() > 0.0)) continue;
                        fbean.setIsCorrect(true);
                    }
                }
            }
            fins.add(fbean);
        }
        FinBean fbean = new FinBean();
        if (texts.toArray().length > i) {
            fbean.setText((String)texts.toArray()[i]);
        } else {
            fbean.setText("");
        }
        fbean.setHasInput(false);
        fins.add(fbean);
        bean.setFinArray(fins);
    }

    public void populateMatrixChoices(ItemDataIfc item, ItemContentsBean bean, HashMap publishedAnswerHash) {
        int i;
        ArrayList<MatrixSurveyBean> matrixArray = new ArrayList<MatrixSurveyBean>();
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        ArrayList itemTextArray = item.getItemTextArraySorted();
        ArrayList answerArray = ((ItemTextIfc)itemTextArray.get(0)).getAnswerArraySorted();
        MatrixSurveyBean mbean = null;
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i2 = 0; i2 < answerArray.size(); ++i2) {
            String str = ((AnswerIfc)answerArray.get(i2)).getText();
            if (str == null || str.trim().length() <= 0) continue;
            stringList.add(str);
        }
        for (int k = 0; k < stringList.size(); ++k) {
            columnIndexList.add(new Integer(k));
        }
        String[] columnChoices = stringList.toArray(new String[stringList.size()]);
        ArrayList<ItemTextIfc> iList = new ArrayList<ItemTextIfc>();
        for (i = 0; i < itemTextArray.size(); ++i) {
            String str = ((ItemTextIfc)itemTextArray.get(i)).getText();
            if (str == null || str.trim().length() <= 0) continue;
            iList.add((ItemTextIfc)itemTextArray.get(i));
        }
        for (i = 0; i < iList.size(); ++i) {
            ItemTextIfc text = (ItemTextIfc)iList.get(i);
            ArrayList answers = ((ItemTextIfc)itemTextArray.get(i)).getAnswerArraySorted();
            ArrayList<AnswerIfc> alist = new ArrayList<AnswerIfc>();
            ArrayList<String> slist = new ArrayList<String>();
            for (int j = 0; j < answers.size(); ++j) {
                if ((AnswerIfc)answers.get(j) == null || "".equals(((AnswerIfc)answers.get(j)).getText().trim())) continue;
                alist.add((AnswerIfc)answers.get(j));
                slist.add(((AnswerIfc)answers.get(j)).getId().toString());
            }
            AnswerIfc[] answerIfcs = alist.toArray(new AnswerIfc[alist.size()]);
            String[] answerSid = slist.toArray(new String[slist.size()]);
            mbean = new MatrixSurveyBean();
            mbean.setItemText(text);
            mbean.setItemContentsBean(bean);
            mbean.setAnswerArray(answerIfcs);
            mbean.setAnswerSid(answerSid);
            ArrayList itemGradingArray = bean.getItemGradingDataArray();
            for (int k = 0; k < itemGradingArray.size(); ++k) {
                ItemGradingData data = (ItemGradingData)itemGradingArray.get(k);
                if (data.getPublishedItemTextId().longValue() != text.getId().longValue()) continue;
                mbean.setItemGradingData(data);
                if (data.getPublishedAnswerId() == null) break;
                mbean.setResponseId(data.getPublishedAnswerId().toString());
                break;
            }
            matrixArray.add(mbean);
        }
        bean.setColumnArray(columnChoices);
        bean.setColumnIndexList(columnIndexList);
        bean.setMatrixArray(matrixArray);
        bean.setForceRanking(Boolean.parseBoolean(item.getItemMetaDataByLabel("FORCE_RANKING")));
        if (item.getItemMetaDataByLabel("MX_SURVEY_RELATIVE_WIDTH") != null) {
            bean.setRelativeWidth(Integer.parseInt(item.getItemMetaDataByLabel("MX_SURVEY_RELATIVE_WIDTH")));
        }
        bean.setAddComment(Boolean.parseBoolean(item.getItemMetaDataByLabel("ADD_COMMENT_MATRIX")));
        bean.setCommentField(item.getItemMetaDataByLabel("MX_SURVEY_QUESTION_COMMENTFIELD"));
    }

    public String getAgentString() {
        PersonBean person = (PersonBean)ContextUtil.lookupBean((String)"person");
        String agentString = person.getId();
        return agentString;
    }

    public void processAction(ActionEvent ae, boolean resetPageContents) throws AbortProcessingException {
        this.resetPageContents = resetPageContents;
        this.processAction(null);
    }

    public String getPublishedAssessmentId(DeliveryBean delivery) {
        String id = ContextUtil.lookupParam((String)"publishedId");
        if (id == null || id.equals("")) {
            id = delivery.getAssessmentId();
        }
        return id;
    }

    protected void clearElapsedTime(DeliveryBean delivery) {
        if (!delivery.isTimeRunning()) {
            delivery.setTimeElapse(null);
        }
        delivery.setTimeOutSubmission("false");
        if (delivery.getTimeElapse() == null) {
            delivery.setTimeElapse("0");
        }
    }

    protected void setFeedbackMode(DeliveryBean delivery) {
        int action = delivery.getActionMode();
        String showfeedbacknow = ContextUtil.lookupParam((String)"showfeedbacknow");
        delivery.setFeedback("false");
        delivery.setNoFeedback("false");
        switch (action) {
            case 1: 
            case 2: 
            case 5: {
                if (showfeedbacknow == null || !showfeedbacknow.equals("true")) break;
                delivery.setFeedback("true");
                break;
            }
            case 3: {
                if (delivery.getFeedbackComponent() == null || !delivery.getFeedbackComponent().getShowImmediate() && !delivery.getFeedbackComponent().getShowOnSubmission() && (!delivery.getFeedbackComponent().getShowDateFeedback() || delivery.getSettings() == null || delivery.getSettings().getFeedbackDate() == null || !delivery.getSettings().getFeedbackDate().before(new Date()))) break;
                delivery.setFeedback("true");
                break;
            }
            case 4: {
                delivery.setFeedback("true");
                break;
            }
        }
        String nofeedback = ContextUtil.lookupParam((String)"nofeedback");
        if (nofeedback != null && nofeedback.equals("true")) {
            delivery.setNoFeedback("true");
        }
    }

    public PublishedAssessmentFacade getPublishedAssessment(DeliveryBean delivery, String id) {
        PublishedAssessmentFacade publishedAssessment = null;
        if (delivery.getPublishedAssessment() != null && delivery.getPublishedAssessment().getPublishedAssessmentId().toString().equals(id)) {
            publishedAssessment = delivery.getPublishedAssessment();
        } else {
            try {
                publishedAssessment = new PublishedAssessmentService().getPublishedAssessment(id);
                delivery.setPublishedAssessment(publishedAssessment);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        return publishedAssessment;
    }

    public void setShowStudentScore(DeliveryBean delivery, PublishedAssessmentFacade publishedAssessment) {
        if (Boolean.TRUE.equals(publishedAssessment.getAssessmentFeedback().getShowStudentScore())) {
            if (delivery.getFeedbackComponent() != null && delivery.getFeedbackComponent().getShowDateFeedback() && !delivery.getFeedbackOnDate()) {
                delivery.setShowStudentScore(false);
            } else {
                delivery.setShowStudentScore(true);
            }
        } else {
            delivery.setShowStudentScore(false);
        }
    }

    public void setShowStudentQuestionScore(DeliveryBean delivery, PublishedAssessmentFacade publishedAssessment) {
        int action = delivery.getActionMode();
        if (4 == action) {
            delivery.setShowStudentQuestionScore(true);
        } else if (Boolean.TRUE.equals(publishedAssessment.getAssessmentFeedback().getShowStudentQuestionScore())) {
            if (delivery.getFeedbackComponent() != null && (delivery.getFeedbackComponent().getShowDateFeedback() && !delivery.getFeedbackOnDate() || (1 == action || 5 == action) && delivery.getFeedbackComponent().getShowOnSubmission())) {
                delivery.setShowStudentQuestionScore(false);
            } else {
                delivery.setShowStudentQuestionScore(true);
            }
        } else {
            delivery.setShowStudentQuestionScore(false);
        }
    }

    private void setDisplayByAssessment(DeliveryBean delivery) {
        delivery.getSettings().setFormatByAssessment(true);
        delivery.getSettings().setFormatByPart(false);
        delivery.getSettings().setFormatByQuestion(false);
    }

    protected void setDeliverySettings(DeliveryBean delivery, PublishedAssessmentFacade publishedAssessment) {
        if (delivery.getSettings() == null) {
            BeginDeliveryActionListener listener = new BeginDeliveryActionListener();
            listener.populateBeanFromPub(delivery, publishedAssessment);
        }
    }

    public void overloadItemData(DeliveryBean delivery, HashMap itemGradingHash, PublishedAssessmentFacade publishedAssessment) {
        itemGradingHash.put("sequence", 0L);
        long items = 0L;
        int sequenceno = 1;
        if (publishedAssessment != null && publishedAssessment.getSectionArraySorted() != null) {
            for (SectionDataIfc section : publishedAssessment.getSectionArraySorted()) {
                Iterator i2 = null;
                ArrayList itemlist = section.getItemArray();
                long seed = 0L;
                if (delivery.getActionMode() == 4) {
                    StudentScoresBean studentscorebean = (StudentScoresBean)ContextUtil.lookupBean((String)"studentScores");
                    seed = this.getSeed(section, delivery, (long)studentscorebean.getStudentId().hashCode());
                } else {
                    seed = this.getSeed(section, delivery, (long)AgentFacade.getAgentString().hashCode());
                }
                ArrayList sortedlist = this.getItemArraySortedWithRandom(section, itemlist, seed);
                i2 = sortedlist.iterator();
                while (i2.hasNext()) {
                    ++items;
                    ItemDataIfc item = (ItemDataIfc)i2.next();
                    itemGradingHash.put("sequence" + item.getItemId().toString(), sequenceno++);
                }
            }
        }
        itemGradingHash.put("items", items);
    }

    private void setGraderComment(DeliveryBean delivery) {
        if (delivery.getAssessmentGrading() != null) {
            delivery.setGraderComment(delivery.getAssessmentGrading().getComments());
        } else {
            delivery.setGraderComment(null);
        }
    }

    protected void setTimer(DeliveryBean delivery, PublishedAssessmentFacade publishedAssessment, boolean fromBeginAssessment, boolean isFirstTimeBegin) {
        int timeLimit = 0;
        AssessmentAccessControlIfc control = publishedAssessment.getAssessmentAccessControl();
        AssessmentGradingData ag = delivery.getAssessmentGrading();
        delivery.setBeginTime(ag.getAttemptDate());
        if (delivery.getHasTimeLimit() && control != null && control.getTimeLimit() != null) {
            if (fromBeginAssessment) {
                timeLimit = Integer.parseInt(delivery.updateTimeLimit(publishedAssessment.getAssessmentAccessControl().getTimeLimit().toString()));
            } else if (delivery.getTimeLimit() != null) {
                timeLimit = Integer.parseInt(delivery.getTimeLimit());
            }
        }
        if (timeLimit == 0) {
            delivery.setTimeRunning(false);
        } else {
            delivery.setTimeRunning(true);
            delivery.setTimeLimit(timeLimit + "");
            if (delivery.isTimeRunning() && delivery.getBeginAssessment()) {
                this.queueTimedAssessment(delivery, timeLimit, fromBeginAssessment, publishedAssessment, isFirstTimeBegin);
                delivery.setBeginAssessment(false);
            } else {
                TimedAssessmentQueue queue = TimedAssessmentQueue.getInstance();
                TimedAssessmentGradingModel timedAG = queue.get(ag.getAssessmentGradingId());
                if (timedAG != null) {
                    this.syncTimeElapsedWithServer(timedAG, delivery, isFirstTimeBegin);
                }
            }
            if (delivery.getLastTimer() == 0L) {
                delivery.setLastTimer(new Date().getTime());
            }
        }
    }

    private void queueTimedAssessment(DeliveryBean delivery, int timeLimit, boolean fromBeginAssessment, PublishedAssessmentFacade publishedAssessment, boolean isFirstTimeBegin) {
        AssessmentGradingData ag = delivery.getAssessmentGrading();
        TimedAssessmentQueue queue = TimedAssessmentQueue.getInstance();
        TimedAssessmentGradingModel timedAG = queue.get(ag.getAssessmentGradingId());
        if (isFirstTimeBegin) {
            timedAG = new TimedAssessmentGradingModel(ag.getAssessmentGradingId(), timeLimit, timeLimit, new Date(), new Date(), false, this.getTimerId(delivery), publishedAssessment);
            queue.add(timedAG);
            delivery.setTimeElapse("0");
        } else if (timedAG == null) {
            int timeElapsed = Math.round((float)(new Date().getTime() - ag.getAttemptDate().getTime()) / 1000.0f);
            timedAG = new TimedAssessmentGradingModel(ag.getAssessmentGradingId(), timeLimit, timeLimit - timeElapsed, new Date(), new Date(), false, this.getTimerId(delivery), publishedAssessment);
            queue.add(timedAG);
            delivery.setTimeElapse(String.valueOf(timeElapsed));
        } else {
            this.syncTimeElapsedWithServer(timedAG, delivery, false);
        }
    }

    private void syncTimeElapsedWithServer(TimedAssessmentGradingModel timedAG, DeliveryBean delivery, boolean isFirstTimeBegin) {
        AssessmentGradingData ag = delivery.getAssessmentGrading();
        int timeElapsed = Math.round((float)(new Date().getTime() - ag.getAttemptDate().getTime()) / 1000.0f);
        log.debug((Object)("***setTimeElapsed=" + timeElapsed));
        ag.setTimeElapsed(Integer.valueOf(timeElapsed));
        ag.setIsLate(Boolean.FALSE);
        GradingService gradingService = new GradingService();
        gradingService.saveOrUpdateAssessmentGradingOnly((AssessmentGradingIfc)ag);
        delivery.setTimeElapse(ag.getTimeElapsed().toString());
    }

    protected AssessmentGradingData createAssessmentGrading(PublishedAssessmentFacade publishedAssessment) {
        AssessmentGradingData adata = new AssessmentGradingData();
        adata.setAgentId(this.getAgentString());
        adata.setPublishedAssessmentId(publishedAssessment.getPublishedAssessmentId());
        adata.setForGrade(Boolean.FALSE);
        adata.setAttemptDate(new Date());
        adata.setIsLate(Boolean.FALSE);
        adata.setStatus(Integer.valueOf(0));
        adata.setTotalOverrideScore(Float.valueOf(0.0f));
        adata.setTimeElapsed(Integer.valueOf("0"));
        GradingService gradingService = new GradingService();
        gradingService.saveOrUpdateAssessmentGrading((AssessmentGradingIfc)adata);
        return adata;
    }

    protected void setAttemptDateIfNull(AssessmentGradingData ag) {
        if (ag.getAttemptDate() == null) {
            ag.setAttemptDate(new Date());
            GradingService gradingService = new GradingService();
            gradingService.saveOrUpdateAssessmentGrading((AssessmentGradingIfc)ag);
        }
    }

    private ArrayList getItemArraySortedWithRandom(SectionDataIfc part, ArrayList list, long seed) {
        Integer numberToBeDrawn = null;
        if (part.getSectionMetaDataByLabel("AUTHOR_TYPE") != null && part.getSectionMetaDataByLabel("AUTHOR_TYPE").equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
            ArrayList randomsample = new ArrayList();
            Collections.shuffle(list, new Random(seed));
            if (part.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                numberToBeDrawn = Integer.valueOf(part.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
            }
            int samplesize = 0;
            if (numberToBeDrawn != null) {
                samplesize = numberToBeDrawn;
            }
            for (int i = 0; i < samplesize; ++i) {
                randomsample.add(list.get(i));
            }
            return randomsample;
        }
        if (part.getSectionMetaDataByLabel("QUESTIONS_ORDERING") != null && part.getSectionMetaDataByLabel("QUESTIONS_ORDERING").equals(SectionDataIfc.RANDOM_WITHIN_PART.toString())) {
            Collections.shuffle(list, new Random(seed));
            return list;
        }
        Collections.sort(list);
        return list;
    }

    private String getTimerId(DeliveryBean delivery) {
        String timerId = ContextUtil.lookupParam((String)"timerId");
        log.debug((Object)("***timerId=" + timerId));
        return timerId;
    }

    private long getSeed(SectionDataIfc sectionData, DeliveryBean delivery, long userSeed) {
        long seed = userSeed;
        log.debug((Object)("input seed = " + seed));
        if (sectionData.getSectionMetaDataByLabel("RANDOMIZATION_TYPE") != null && sectionData.getSectionMetaDataByLabel("RANDOMIZATION_TYPE").equals("1")) {
            Long id = delivery.getAssessmentGradingId();
            log.debug((Object)("assessmentGradingId = " + id));
            if (delivery.getActionMode() == 2) {
                log.debug((Object)("preview assessment: seed = " + seed));
            } else if (id != null) {
                seed = (id.toString() + "_" + sectionData.getSectionId().toString()).hashCode();
                log.debug((Object)("seed = " + seed));
            } else {
                log.error((Object)"assessmentGradingId is null");
            }
        }
        return seed;
    }

    protected void setStatus(DeliveryBean delivery, PublishedAssessmentService pubService, Long publishedAssessmentId) {
        Integer status = pubService.getPublishedAssessmentStatus(publishedAssessmentId);
        delivery.getPublishedAssessment().setStatus(status);
    }
}

