/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.delivery;

import java.util.ArrayList;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.listener.delivery.DeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.ui.web.session.SessionUtil;

public class LinearAccessDeliveryActionListener
extends DeliveryActionListener
implements ActionListener {
    private static Log log = LogFactory.getLog(LinearAccessDeliveryActionListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"LinearAccessDeliveryActionListener.processAction() ");
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        String id = this.getPublishedAssessmentId(delivery);
        String agent = this.getAgentString();
        this.clearElapsedTime(delivery);
        PublishedAssessmentFacade publishedAssessment = this.getPublishedAssessment(delivery, id);
        this.setShowStudentScore(delivery, publishedAssessment);
        this.setShowStudentQuestionScore(delivery, publishedAssessment);
        this.setDeliverySettings(delivery, publishedAssessment);
        if (ae != null && ae.getComponent().getId().startsWith("beginAssessment")) {
            if (!delivery.getSettings().getUsername().equals("") && "passwordAccessError".equals(delivery.validatePassword())) {
                return;
            }
            if (delivery.getSettings().getIpAddresses() != null && !delivery.getSettings().getIpAddresses().isEmpty() && "ipAccessError".equals(delivery.validateIP())) {
                return;
            }
        }
        GradingService service = new GradingService();
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        AssessmentGradingData ag = null;
        HashMap itemGradingHash = service.getLastItemGradingData(id, agent);
        boolean isFirstTimeBegin = false;
        if (itemGradingHash != null && itemGradingHash.size() > 0) {
            log.debug((Object)"itemGradingHash!=null && itemGradingHash.size()>0");
            ag = this.setAssessmentGradingFromItemData(delivery, itemGradingHash, true);
            this.setAttemptDateIfNull(ag);
        } else {
            ag = service.getLastSavedAssessmentGradingByAgentId(id, agent);
            if (ag == null) {
                ag = this.createAssessmentGrading(publishedAssessment);
                isFirstTimeBegin = true;
            } else {
                this.setAttemptDateIfNull(ag);
            }
        }
        delivery.setAssessmentGrading(ag);
        log.debug((Object)("itemgrading size = " + ag.getItemGradingSet().size()));
        delivery.setAssessmentGradingId(delivery.getAssessmentGrading().getAssessmentGradingId());
        this.setFeedbackMode(delivery);
        if (ae != null && ae.getComponent().getId().startsWith("beginAssessment")) {
            this.setTimer(delivery, publishedAssessment, true, isFirstTimeBegin);
            this.setStatus(delivery, pubService, Long.valueOf(id));
            delivery.setNoQuestions(false);
            int action = delivery.getActionMode();
            if (action == 1) {
                StringBuffer eventRef = new StringBuffer("publishedAssessmentId");
                eventRef.append(delivery.getAssessmentId());
                eventRef.append(", agentId=");
                eventRef.append(this.getAgentString());
                if (delivery.isTimeRunning()) {
                    eventRef.append(", elapsed=");
                    eventRef.append(delivery.getTimeElapse());
                    eventRef.append(", remaining=");
                    int timeRemaining = Integer.parseInt(delivery.getTimeLimit()) - Integer.parseInt(delivery.getTimeElapse());
                    eventRef.append(timeRemaining);
                }
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.take", (String)eventRef.toString(), (boolean)true));
            } else if (action == 5) {
                StringBuffer eventRef = new StringBuffer("publishedAssessmentId");
                eventRef.append(delivery.getAssessmentId());
                eventRef.append(", agentId=");
                eventRef.append(this.getAgentString());
                if (delivery.isTimeRunning()) {
                    eventRef.append(", elapsed=");
                    eventRef.append(delivery.getTimeElapse());
                    eventRef.append(", remaining=");
                    int timeRemaining = Integer.parseInt(delivery.getTimeLimit()) - Integer.parseInt(delivery.getTimeElapse());
                    eventRef.append(timeRemaining);
                }
                PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
                String siteId = publishedAssessmentService.getPublishedAssessmentOwner(Long.valueOf(delivery.getAssessmentId()));
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.take.via_url", (String)eventRef.toString(), (String)siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
            }
        } else {
            this.setTimer(delivery, publishedAssessment, false, false);
        }
        SessionUtil.setSessionTimeout((FacesContext)FacesContext.getCurrentInstance(), (DeliveryBean)delivery, (boolean)true);
        log.debug((Object)("Set begin time " + delivery.getBeginTime()));
        log.debug((Object)("Set elapsed time " + delivery.getTimeElapse()));
        this.overloadItemData(delivery, itemGradingHash, publishedAssessment);
        log.debug((Object)("before partIndex = " + delivery.getPartIndex()));
        log.debug((Object)("before questionIndex = " + delivery.getQuestionIndex()));
        this.setPosition(delivery);
        log.debug((Object)("after partIndex = " + delivery.getPartIndex()));
        log.debug((Object)("after questionIndex = " + delivery.getQuestionIndex()));
        HashMap publishedAnswerHash = pubService.preparePublishedAnswerHash((PublishedAssessmentIfc)publishedAssessment);
        delivery.setPageContents(this.getPageContents(publishedAssessment, delivery, itemGradingHash, publishedAnswerHash));
    }

    private void setPosition(DeliveryBean delivery) {
        GradingService gradingService = new GradingService();
        AssessmentGradingData assessmentGradingData = delivery.getAssessmentGrading();
        log.debug((Object)("assessmentGradingData.getAssessmentGradingId() = " + assessmentGradingData.getAssessmentGradingId()));
        if (assessmentGradingData.getLastVisitedPart() != null && assessmentGradingData.getLastVisitedQuestion() != null) {
            delivery.setPartIndex(assessmentGradingData.getLastVisitedPart().intValue());
            delivery.setQuestionIndex(assessmentGradingData.getLastVisitedQuestion().intValue());
        } else {
            ArrayList alist = gradingService.getLastItemGradingDataPosition(assessmentGradingData.getAssessmentGradingId(), assessmentGradingData.getAgentId());
            int partIndex = (Integer)alist.get(0);
            if (partIndex == 0) {
                delivery.setPartIndex(0);
            } else {
                delivery.setPartIndex(partIndex - 1);
            }
            delivery.setQuestionIndex(((Integer)alist.get(1)).intValue());
        }
    }

    public void saveLastVisitedPosition(DeliveryBean delivery, int partNumber, int questionNumber) {
        GradingService gradingService = new GradingService();
        AssessmentGradingData assessmentGradingData = delivery.getAssessmentGrading();
        assessmentGradingData.setStatus(Integer.valueOf(2));
        assessmentGradingData.setLastVisitedPart(Integer.valueOf(partNumber));
        assessmentGradingData.setLastVisitedQuestion(Integer.valueOf(questionNumber));
        gradingService.saveOrUpdateAssessmentGradingOnly((AssessmentGradingIfc)assessmentGradingData);
    }
}

