/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.FinFormatException;
import org.sakaiproject.tool.assessment.services.GradebookServiceException;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.SaLengthException;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.FinBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class SubmitToGradingActionListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SubmitToGradingActionListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException, FinFormatException, SaLengthException {
        try {
            log.debug((Object)"SubmitToGradingActionListener.processAction() ");
            DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
            if (ContextUtil.lookupParam((String)"showfeedbacknow") != null && "true".equals(ContextUtil.lookupParam((String)"showfeedbacknow")) || delivery.getActionMode() == 2) {
                delivery.setForGrade(false);
            }
            PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
            PublishedAssessmentFacade publishedAssessment = null;
            if (delivery.getPublishedAssessment() != null) {
                publishedAssessment = delivery.getPublishedAssessment();
            } else {
                publishedAssessment = publishedAssessmentService.getPublishedAssessment(delivery.getAssessmentId());
                delivery.setPublishedAssessment(publishedAssessment);
            }
            HashMap invalidFINMap = new HashMap();
            ArrayList invalidSALengthList = new ArrayList();
            AssessmentGradingData adata = this.submitToGradingService(ae, publishedAssessment, delivery, invalidFINMap, invalidSALengthList);
            delivery.setAssessmentGrading(adata);
            if (adata != null && delivery.getForGrade()) {
                this.setConfirmation(adata, publishedAssessment, delivery);
            }
            if (this.isForGrade(adata) && !this.isUnlimited(publishedAssessment)) {
                delivery.setSubmissionsRemaining(delivery.getSubmissionsRemaining() - 1);
            }
            if (invalidFINMap.size() != 0) {
                delivery.setIsAnyInvalidFinInput(true);
                throw new FinFormatException("Not a valid FIN input");
            }
            if (invalidSALengthList.size() != 0) {
                delivery.setIsAnyInvalidFinInput(true);
                throw new SaLengthException("Short Answer input is too long");
            }
            delivery.setIsAnyInvalidFinInput(false);
        }
        catch (GradebookServiceException ge) {
            ge.printStackTrace();
            FacesContext context = FacesContext.getCurrentInstance();
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_error");
            context.addMessage(null, new FacesMessage(err));
            return;
        }
    }

    private boolean isForGrade(AssessmentGradingData aData) {
        if (aData != null) {
            return Boolean.TRUE.equals(aData.getForGrade());
        }
        return false;
    }

    private boolean isUnlimited(PublishedAssessmentFacade publishedAssessment) {
        return Boolean.TRUE.equals(publishedAssessment.getAssessmentAccessControl().getUnlimitedSubmissions());
    }

    private void setConfirmation(AssessmentGradingData adata, PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery) {
        if (publishedAssessment.getAssessmentAccessControl() != null) {
            this.setFinalPage(publishedAssessment, delivery);
            this.setSubmissionMessage(publishedAssessment, delivery);
        }
        this.setConfirmationId(adata, publishedAssessment, delivery);
    }

    private void setConfirmationId(AssessmentGradingData adata, PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery) {
        delivery.setConfirmation(adata.getAssessmentGradingId() + "-" + publishedAssessment.getPublishedAssessmentId() + "-" + adata.getAgentId() + "-" + adata.getSubmittedDate().toString());
    }

    private void setSubmissionMessage(PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery) {
        String submissionMessage = publishedAssessment.getAssessmentAccessControl().getSubmissionMessage();
        if (submissionMessage != null) {
            delivery.setSubmissionMessage(submissionMessage);
        }
    }

    private void setFinalPage(PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery) {
        String url = publishedAssessment.getAssessmentAccessControl().getFinalPageUrl();
        if (url != null) {
            url = url.trim();
        }
        delivery.setUrl(url);
    }

    private synchronized AssessmentGradingData submitToGradingService(ActionEvent ae, PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery, HashMap invalidFINMap, ArrayList invalidSALengthList) throws FinFormatException {
        log.debug((Object)"****1a. inside submitToGradingService ");
        String submissionId = "";
        HashSet itemGradingHash = new HashSet();
        Iterator iter = delivery.getPageContents().getPartsContents().iterator();
        log.debug((Object)("****1b. inside submitToGradingService, iter= " + iter));
        HashSet adds = new HashSet();
        HashSet removes = new HashSet();
        while (iter.hasNext()) {
            SectionContentsBean part = (SectionContentsBean)iter.next();
            log.debug((Object)("****1c. inside submitToGradingService, part " + part));
            for (ItemContentsBean item : part.getItemContents()) {
                log.debug((Object)"****** before prepareItemGradingPerItem");
                this.prepareItemGradingPerItem(ae, delivery, item, adds, removes);
                log.debug((Object)"****** after prepareItemGradingPerItem");
            }
        }
        AssessmentGradingData adata = this.persistAssessmentGrading(ae, delivery, itemGradingHash, publishedAssessment, adds, removes, invalidFINMap, invalidSALengthList);
        StringBuffer redrawAnchorName = new StringBuffer("p");
        String tmpAnchorName = "";
        for (SectionContentsBean part : delivery.getPageContents().getPartsContents()) {
            String partSeq = part.getNumber();
            for (ItemContentsBean item : part.getItemContents()) {
                String itemSeq = item.getSequence();
                Long itemId = item.getItemData().getItemId();
                if (item.getItemData().getTypeId() == 5L) {
                    if (invalidSALengthList.contains(itemId)) {
                        item.setIsInvalidSALengthInput(true);
                        redrawAnchorName.append(partSeq);
                        redrawAnchorName.append("q");
                        redrawAnchorName.append(itemSeq);
                        if (!tmpAnchorName.equals("") && tmpAnchorName.compareToIgnoreCase(redrawAnchorName.toString()) <= 0) continue;
                        tmpAnchorName = redrawAnchorName.toString();
                        continue;
                    }
                    item.setIsInvalidSALengthInput(false);
                    continue;
                }
                if (item.getItemData().getTypeId() != 11L) continue;
                if (invalidFINMap.containsKey(itemId)) {
                    item.setIsInvalidFinInput(true);
                    redrawAnchorName.append(partSeq);
                    redrawAnchorName.append("q");
                    redrawAnchorName.append(itemSeq);
                    if (tmpAnchorName.equals("") || tmpAnchorName.compareToIgnoreCase(redrawAnchorName.toString()) > 0) {
                        tmpAnchorName = redrawAnchorName.toString();
                    }
                    ArrayList list = (ArrayList)invalidFINMap.get(itemId);
                    ArrayList finArray = item.getFinArray();
                    for (FinBean finBean : finArray) {
                        Long itemGradingId;
                        if (finBean.getItemGradingData() == null || !list.contains(itemGradingId = finBean.getItemGradingData().getItemGradingId())) continue;
                        finBean.setIsCorrect(false);
                    }
                    continue;
                }
                item.setIsInvalidFinInput(false);
            }
        }
        if (tmpAnchorName != null && !tmpAnchorName.equals("")) {
            delivery.setRedrawAnchorName(tmpAnchorName.toString());
        } else {
            delivery.setRedrawAnchorName("");
        }
        delivery.setSubmissionId(submissionId);
        delivery.setSubmissionTicket(submissionId);
        delivery.setSubmissionDate(new Date());
        delivery.setSubmitted(true);
        return adata;
    }

    private AssessmentGradingData persistAssessmentGrading(ActionEvent ae, DeliveryBean delivery, HashSet itemGradingHash, PublishedAssessmentFacade publishedAssessment, HashSet adds, HashSet removes, HashMap invalidFINMap, ArrayList invalidSALengthList) throws FinFormatException {
        HashMap publishedAnswerHash;
        HashMap publishedItemTextHash;
        HashMap publishedItemHash;
        AssessmentGradingData adata = null;
        if (delivery.getAssessmentGrading() != null) {
            adata = delivery.getAssessmentGrading();
        }
        GradingService service = new GradingService();
        log.debug((Object)("**adata=" + adata));
        if (adata == null) {
            adata = this.makeNewAssessmentGrading(publishedAssessment, delivery, itemGradingHash);
            delivery.setAssessmentGrading(adata);
        } else {
            HashMap fibMap = this.getFIBMap((PublishedAssessmentIfc)publishedAssessment);
            HashMap finMap = this.getFINMap((PublishedAssessmentIfc)publishedAssessment);
            HashMap mcmrMap = this.getMCMRMap((PublishedAssessmentIfc)publishedAssessment);
            Set itemGradingSet = adata.getItemGradingSet();
            log.debug((Object)("*** 2a. before removal & addition " + new Date()));
            if (itemGradingSet != null) {
                log.debug((Object)("*** 2aa. removing old itemGrading " + new Date()));
                itemGradingSet.removeAll(removes);
                service.deleteAll((Collection)removes);
                log.debug((Object)("*** 2ab. reload itemGradingSet " + new Date()));
                itemGradingSet = service.getItemGradingSet(adata.getAssessmentGradingId().toString());
                log.debug((Object)("*** 2ac. load assessmentGarding " + new Date()));
                adata = service.load(adata.getAssessmentGradingId().toString());
                Iterator iter = adds.iterator();
                while (iter.hasNext()) {
                    ((ItemGradingIfc)iter.next()).setAssessmentGradingId(adata.getAssessmentGradingId());
                }
                log.debug((Object)("*** 2ad. set assessmentGrading with new/updated itemGrading " + new Date()));
                log.debug((Object)("Submitforgrading: before calling .....................oldItemGradingSet.size = " + itemGradingSet.size()));
                log.debug((Object)("Submitforgrading: newItemGradingSet.size = " + adds.size()));
                HashSet updateItemGradingSet = this.getUpdateItemGradingSet(itemGradingSet, (Set)adds, fibMap, finMap, mcmrMap, adata);
                adata.setItemGradingSet((Set)updateItemGradingSet);
            }
        }
        adata.setIsLate(this.isLate((PublishedAssessmentIfc)publishedAssessment));
        adata.setForGrade(Boolean.valueOf(delivery.getForGrade()));
        if (AssessmentGradingIfc.ASSESSMENT_UPDATED_NEED_RESUBMIT.equals(adata.getStatus()) || AssessmentGradingIfc.ASSESSMENT_UPDATED.equals(adata.getStatus())) {
            adata.setStatus(Integer.valueOf(0));
            adata.setGradedBy(null);
            adata.setGradedDate(null);
            adata.setComments(null);
            adata.setTotalOverrideScore(Float.valueOf(0.0f));
        }
        log.debug((Object)("*** 2b. before storingGrades, did all the removes and adds " + new Date()));
        if (delivery.getNavigation().equals("1") && ae != null && "showFeedback".equals(ae.getComponent().getId())) {
            log.debug((Object)"Do not persist to db if it is linear access and the action is show feedback");
            publishedItemHash = delivery.getPublishedItemHash();
            publishedItemTextHash = delivery.getPublishedItemTextHash();
            publishedAnswerHash = delivery.getPublishedAnswerHash();
            service.storeGrades((AssessmentGradingIfc)adata, (PublishedAssessmentIfc)publishedAssessment, publishedItemHash, publishedItemTextHash, publishedAnswerHash, false, invalidFINMap, invalidSALengthList);
        } else {
            log.debug((Object)"Persist to db otherwise");
            log.debug((Object)("*** 3. before storingGrades, did all the removes and adds " + new Date()));
            publishedItemHash = delivery.getPublishedItemHash();
            publishedItemTextHash = delivery.getPublishedItemTextHash();
            publishedAnswerHash = delivery.getPublishedAnswerHash();
            service.storeGrades((AssessmentGradingIfc)adata, (PublishedAssessmentIfc)publishedAssessment, publishedItemHash, publishedItemTextHash, publishedAnswerHash, invalidFINMap, invalidSALengthList);
        }
        return adata;
    }

    private HashMap getFIBMap(PublishedAssessmentIfc publishedAssessment) {
        PublishedAssessmentService s = new PublishedAssessmentService();
        return s.prepareFIBItemHash(publishedAssessment);
    }

    private HashMap getFINMap(PublishedAssessmentIfc publishedAssessment) {
        PublishedAssessmentService s = new PublishedAssessmentService();
        return s.prepareFINItemHash(publishedAssessment);
    }

    private HashMap getMCMRMap(PublishedAssessmentIfc publishedAssessment) {
        PublishedAssessmentService s = new PublishedAssessmentService();
        return s.prepareMCMRItemHash(publishedAssessment);
    }

    private HashSet getUpdateItemGradingSet(Set oldItemGradingSet, Set newItemGradingSet, HashMap fibMap, HashMap finMap, HashMap mcmrMap, AssessmentGradingData adata) {
        log.debug((Object)("Submitforgrading: oldItemGradingSet.size = " + oldItemGradingSet.size()));
        log.debug((Object)("Submitforgrading: newItemGradingSet.size = " + newItemGradingSet.size()));
        HashSet<ItemGradingIfc> updateItemGradingSet = new HashSet<ItemGradingIfc>();
        Iterator iter = oldItemGradingSet.iterator();
        HashMap<Long, ItemGradingIfc> map = new HashMap<Long, ItemGradingIfc>();
        while (iter.hasNext()) {
            ItemGradingIfc item = (ItemGradingIfc)iter.next();
            map.put(item.getItemGradingId(), item);
        }
        for (ItemGradingIfc newItem : newItemGradingSet) {
            ItemGradingIfc oldItem = (ItemGradingIfc)map.get(newItem.getItemGradingId());
            if (oldItem != null) {
                Boolean oldReview = oldItem.getReview();
                Boolean newReview = newItem.getReview();
                Long oldAnswerId = oldItem.getPublishedAnswerId();
                Long newAnswerId = newItem.getPublishedAnswerId();
                String oldRationale = oldItem.getRationale();
                String newRationale = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)newItem.getRationale());
                String oldAnswerText = oldItem.getAnswerText();
                String newAnswerText = ContextUtil.stringWYSIWYG((String)newItem.getAnswerText());
                if (!(oldReview != null && !oldReview.equals(newReview) || newReview != null && !newReview.equals(oldReview) || oldAnswerId != null && !oldAnswerId.equals(newAnswerId) || newAnswerId != null && !newAnswerId.equals(oldAnswerId) || oldRationale != null && !oldRationale.equals(newRationale) || newRationale != null && !newRationale.equals(oldRationale) || oldAnswerText != null && !oldAnswerText.equals(newAnswerText) || newAnswerText != null && !newAnswerText.equals(oldAnswerText) || fibMap.get(oldItem.getPublishedItemId()) != null || finMap.get(oldItem.getPublishedItemId()) != null) && mcmrMap.get(oldItem.getPublishedItemId()) == null) continue;
                oldItem.setReview(newItem.getReview());
                oldItem.setPublishedAnswerId(newItem.getPublishedAnswerId());
                oldItem.setRationale(newRationale);
                oldItem.setAnswerText(newAnswerText);
                oldItem.setSubmittedDate(new Date());
                oldItem.setAutoScore(newItem.getAutoScore());
                oldItem.setOverrideScore(newItem.getOverrideScore());
                updateItemGradingSet.add(oldItem);
                continue;
            }
            newItem.setAgentId(adata.getAgentId());
            updateItemGradingSet.add(newItem);
        }
        return updateItemGradingSet;
    }

    private AssessmentGradingData makeNewAssessmentGrading(PublishedAssessmentFacade publishedAssessment, DeliveryBean delivery, HashSet itemGradingHash) {
        PersonBean person = (PersonBean)ContextUtil.lookupBean((String)"person");
        AssessmentGradingData adata = new AssessmentGradingData();
        adata.setAgentId(person.getId());
        adata.setPublishedAssessmentId(publishedAssessment.getPublishedAssessmentId());
        adata.setForGrade(Boolean.valueOf(delivery.getForGrade()));
        adata.setItemGradingSet((Set)itemGradingHash);
        adata.setAttemptDate(new Date());
        adata.setIsLate(Boolean.FALSE);
        adata.setStatus(Integer.valueOf(0));
        adata.setTotalOverrideScore(Float.valueOf(0.0f));
        adata.setTimeElapsed(Integer.valueOf("0"));
        return adata;
    }

    private void prepareItemGradingPerItem(ActionEvent ae, DeliveryBean delivery, ItemContentsBean item, HashSet adds, HashSet removes) {
        ArrayList grading = item.getItemGradingDataArray();
        int typeId = item.getItemData().getTypeId().intValue();
        for (int m = 0; m < grading.size(); ++m) {
            ItemGradingData itemgrading = (ItemGradingData)grading.get(m);
            if (itemgrading.getItemGradingId() != null || !(itemgrading.getReview() != null && itemgrading.getReview() != false)) continue;
            adds.addAll(grading);
            break;
        }
        block0 : switch (typeId) {
            case 1: 
            case 3: 
            case 12: {
                ItemGradingData itemgrading;
                int m;
                boolean answerModified = false;
                for (m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    if (itemgrading.getItemGradingId() != null && itemgrading.getItemGradingId().intValue() > 0 || itemgrading.getPublishedAnswerId() == null && (itemgrading.getRationale() == null || itemgrading.getRationale().trim().equals(""))) continue;
                    answerModified = true;
                    break;
                }
                if (item.getUnanswered()) {
                    answerModified = true;
                }
                if (answerModified) {
                    for (m = 0; m < grading.size(); ++m) {
                        itemgrading = (ItemGradingData)grading.get(m);
                        if (itemgrading.getItemGradingId() != null && itemgrading.getItemGradingId().intValue() > 0) {
                            removes.add(itemgrading);
                            continue;
                        }
                        if (itemgrading.getPublishedAnswerId() == null && itemgrading.getAnswerText() == null && (itemgrading.getRationale() == null || itemgrading.getRationale().trim().equals(""))) continue;
                        itemgrading.setAgentId(AgentFacade.getAgentString());
                        itemgrading.setSubmittedDate(new Date());
                        if (itemgrading.getRationale() != null && itemgrading.getRationale().length() > 0) {
                            itemgrading.setRationale(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)itemgrading.getRationale()));
                        }
                        adds.add(itemgrading);
                    }
                    break;
                }
                this.handleMarkForReview(grading, adds);
                break;
            }
            case 4: 
            case 9: {
                ItemGradingData itemgrading;
                int m;
                for (m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    itemgrading.setAgentId(AgentFacade.getAgentString());
                    itemgrading.setSubmittedDate(new Date());
                }
                for (m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    if ((itemgrading.getItemGradingId() == null || itemgrading.getItemGradingId().intValue() <= 0) && itemgrading.getPublishedAnswerId() == null && itemgrading.getAnswerText() == null && (itemgrading.getRationale() == null || itemgrading.getRationale().trim().equals(""))) continue;
                    adds.addAll(grading);
                    break block0;
                }
                break;
            }
            case 5: {
                ItemGradingData itemgrading;
                int m;
                for (m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    itemgrading.setAgentId(AgentFacade.getAgentString());
                    itemgrading.setSubmittedDate(new Date());
                }
                for (m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    if (itemgrading.getItemGradingId() != null && itemgrading.getItemGradingId().intValue() > 0) {
                        adds.addAll(grading);
                        break block0;
                    }
                    if (itemgrading.getAnswerText() == null || itemgrading.getAnswerText().equals("")) continue;
                    itemgrading.setAnswerText(ContextUtil.stringWYSIWYG((String)itemgrading.getAnswerText()));
                    adds.addAll(grading);
                    break block0;
                }
                break;
            }
            case 8: 
            case 11: {
                ItemGradingData itemgrading;
                int m;
                boolean addedToAdds = false;
                for (m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    itemgrading.setAgentId(AgentFacade.getAgentString());
                    itemgrading.setSubmittedDate(new Date());
                }
                for (m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    if (itemgrading.getItemGradingId() != null && itemgrading.getItemGradingId().intValue() > 0) {
                        adds.addAll(grading);
                        break block0;
                    }
                    if (itemgrading.getAnswerText() == null || itemgrading.getAnswerText().equals("")) continue;
                    String s = itemgrading.getAnswerText();
                    log.debug((Object)("s = " + s));
                    itemgrading.setAnswerText(ContextUtil.stringWYSIWYG((String)s));
                    adds.addAll(grading);
                    if (addedToAdds) continue;
                    adds.addAll(grading);
                    addedToAdds = true;
                }
                break;
            }
            case 2: {
                ItemGradingData itemgrading;
                for (int m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    if (itemgrading.getItemGradingId() != null && itemgrading.getItemGradingId().intValue() > 0) {
                        if (itemgrading.getPublishedAnswerId() != null || itemgrading.getRationale() != null && !itemgrading.getRationale().trim().equals("")) {
                            itemgrading.setAgentId(AgentFacade.getAgentString());
                            itemgrading.setSubmittedDate(new Date());
                            adds.add(itemgrading);
                            continue;
                        }
                        removes.add(itemgrading);
                        continue;
                    }
                    if (itemgrading.getPublishedAnswerId() == null && (itemgrading.getRationale() == null || itemgrading.getRationale().trim().equals(""))) continue;
                    itemgrading.setAgentId(AgentFacade.getAgentString());
                    itemgrading.setSubmittedDate(new Date());
                    adds.add(itemgrading);
                }
                break;
            }
            case 6: 
            case 7: {
                this.handleMarkForReview(grading, adds);
                break;
            }
            case 13: {
                ItemGradingData itemgrading;
                boolean answerModified = false;
                for (int m = 0; m < grading.size(); ++m) {
                    itemgrading = (ItemGradingData)grading.get(m);
                    if (itemgrading == null) continue;
                    log.debug((Object)("\n:ItemId>>itemTextId>>answerId " + itemgrading.getPublishedItemId() + itemgrading.getPublishedItemTextId() + itemgrading.getPublishedAnswerId() + "\n"));
                    itemgrading.setAgentId(AgentFacade.getAgentString());
                    itemgrading.setSubmittedDate(new Date());
                    if (itemgrading.getRationale() != null && itemgrading.getRationale().length() > 0) {
                        itemgrading.setRationale(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)itemgrading.getRationale()));
                    }
                    adds.add(itemgrading);
                }
                break;
            }
        }
        String actionCommand = "";
        if (ae != null) {
            actionCommand = ae.getComponent().getId();
            log.debug((Object)("ae is not null, getActionCommand() = " + actionCommand));
        } else {
            log.debug((Object)"ae is null");
        }
        if (delivery.getNavigation().equals("1") && adds.size() == 0 && !"showFeedback".equals(actionCommand)) {
            log.debug((Object)"enter here");
            Long assessmentGradingId = delivery.getAssessmentGrading().getAssessmentGradingId();
            Long publishedItemId = item.getItemData().getItemId();
            log.debug((Object)("assessmentGradingId = " + assessmentGradingId));
            log.debug((Object)("publishedItemId = " + publishedItemId));
            GradingService gradingService = new GradingService();
            if (gradingService.getItemGradingData(assessmentGradingId.toString(), publishedItemId.toString()) == null) {
                log.debug((Object)"Create a new (fake) ItemGradingData");
                ItemGradingData itemGrading = new ItemGradingData();
                itemGrading.setAssessmentGradingId(assessmentGradingId);
                itemGrading.setAgentId(AgentFacade.getAgentString());
                itemGrading.setPublishedItemId(publishedItemId);
                ItemService itemService = new ItemService();
                Long itemTextId = itemService.getItemTextId(publishedItemId);
                log.debug((Object)("itemTextId = " + itemTextId));
                itemGrading.setPublishedItemTextId(itemTextId);
                adds.add(itemGrading);
            } else if (typeId == 6 || typeId == 7) {
                log.debug((Object)"File Upload or Audio! Do not create empty ItemGradingData if there exists one");
            }
        }
    }

    private void handleMarkForReview(ArrayList grading, HashSet adds) {
        for (int m = 0; m < grading.size(); ++m) {
            ItemGradingData itemgrading = (ItemGradingData)grading.get(m);
            if (itemgrading.getItemGradingId() == null || itemgrading.getItemGradingId().intValue() <= 0 || itemgrading.getReview() == null) continue;
            adds.add(itemgrading);
        }
    }

    private Boolean isLate(PublishedAssessmentIfc pub) {
        AssessmentAccessControlIfc a = pub.getAssessmentAccessControl();
        if (a.getDueDate() != null && a.getDueDate().before(new Date())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

